/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapdump.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.application.jvm.Jvm;
import org.graalvm.visualvm.application.jvm.JvmFactory;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshot;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.DataSourceRepository;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.DataChangeEvent;
import org.graalvm.visualvm.core.datasupport.DataChangeListener;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceWindowManager;
import org.graalvm.visualvm.coredump.CoreDump;
import org.graalvm.visualvm.heapdump.HeapDumpSupport;
import org.graalvm.visualvm.heapdump.impl.HeapDumpImpl;
import org.graalvm.visualvm.tools.jmx.JmxModel;
import org.graalvm.visualvm.tools.jmx.JmxModelFactory;
import org.graalvm.visualvm.tools.sa.SaModel;
import org.graalvm.visualvm.tools.sa.SaModelFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class HeapDumpProvider {
    private static final Logger LOGGER = Logger.getLogger(HeapDumpProvider.class.getName());

    public void createHeapDump(final Application application, final boolean openView) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle pHandleF;
                Jvm jvm = JvmFactory.getJVMFor((Application)application);
                if (!jvm.isTakeHeapDumpSupported()) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)(NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Cannot_take_heap_dump") + DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName()), 0));
                    return;
                }
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(HeapDumpProvider.class, (String)"LBL_Creating_Heap_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    try {
                        File snapshotDir = application.getStorage().getDirectory();
                        String name = HeapDumpSupport.getInstance().getCategory().createFileName();
                        File file = new File(snapshotDir, name);
                        if (jvm.takeHeapDump(file) && file.isFile()) {
                            final HeapDumpImpl heapDump = new HeapDumpImpl(file, (DataSource)application);
                            application.getRepository().addDataSource((DataSource)heapDump);
                            if (openView) {
                                DataSource.EVENT_QUEUE.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)heapDump);
                                    }
                                });
                            }
                        } else {
                            HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)application);
                        }
                    }
                    catch (IOException ex) {
                        LOGGER.log(Level.INFO, "createHeapDump-Application", ex);
                        HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)application);
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        @Override
                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void createRemoteHeapDump(final Application application, final String dumpFile, final boolean customizeDumpFile) {
        VisualVM.getInstance().runTask(new Runnable(){

            @Override
            public void run() {
                JmxModel model = JmxModelFactory.getJmxModelFor((Application)application);
                if (model == null || !model.isTakeHeapDumpSupported()) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Dump_failed"), 0));
                    return;
                }
                String file = dumpFile;
                if (file == null) {
                    file = HeapDumpProvider.defineRemoteFile(model, customizeDumpFile);
                }
                if (file == null) {
                    return;
                }
                if (model.takeHeapDump(file)) {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Dump_ok", (Object)file), 1));
                } else {
                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Dump_save_failed", (Object)file), 0));
                }
            }
        });
    }

    private static String defineRemoteFile(JmxModel model, boolean customizeDumpFile) {
        final String[] path = new String[]{HeapDumpProvider.defaultHeapDumpPath(model)};
        if (customizeDumpFile) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JLabel label = new JLabel();
                        Mnemonics.setLocalizedText((JLabel)label, (String)NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Remote_heap_dump"));
                        label.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
                        JTextField field = new JTextField();
                        label.setLabelFor(field);
                        field.setText(path[0]);
                        Dimension dim = field.getPreferredSize();
                        dim.width = 350;
                        field.setPreferredSize(dim);
                        field.selectAll();
                        JPanel selector = new JPanel(new BorderLayout());
                        selector.setBorder(BorderFactory.createEmptyBorder(15, 10, 5, 10));
                        selector.add((Component)label, "North");
                        selector.add((Component)field, "South");
                        DialogDescriptor dd = new DialogDescriptor((Object)selector, NbBundle.getMessage(HeapDumpProvider.class, (String)"CAPTION_Remote_heap_dump"), true, null);
                        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                        d.pack();
                        d.setVisible(true);
                        path[0] = dd.getValue() == DialogDescriptor.OK_OPTION ? field.getText() : null;
                    }
                });
            }
            catch (Throwable t) {
                path[0] = null;
            }
        }
        return path[0];
    }

    private static String defaultHeapDumpPath(JmxModel model) {
        String fileName = HeapDumpSupport.getInstance().getCategory().createFileName();
        Properties sysprops = model.getSystemProperties();
        if (sysprops == null) {
            return fileName;
        }
        String heapDumpTarget = HeapDumpProvider.getHeapDumpTarget(sysprops);
        if (heapDumpTarget == null || heapDumpTarget.isEmpty()) {
            return fileName;
        }
        String pathsep = sysprops.getProperty("file.separator");
        if (!heapDumpTarget.endsWith(pathsep)) {
            heapDumpTarget = heapDumpTarget + pathsep;
        }
        return heapDumpTarget + fileName;
    }

    private static String getHeapDumpTarget(Properties sysprops) {
        String targetDir = null;
        String osName = sysprops.getProperty("os.name");
        if (osName != null) {
            if (osName.equals("Solaris") || osName.startsWith("SunOS")) {
                targetDir = sysprops.getProperty("user.home");
            }
            targetDir = sysprops.getProperty("java.io.tmpdir");
        }
        if (targetDir == null) {
            targetDir = sysprops.getProperty("user.dir");
        }
        return targetDir;
    }

    public void createHeapDump(final CoreDump coreDump, final boolean openView) {
        VisualVM.getInstance().runTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProgressHandle pHandleF;
                ProgressHandle pHandle = null;
                try {
                    pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(HeapDumpProvider.class, (String)"LBL_Creating_Heap_Dump"));
                    pHandle.setInitialDelay(0);
                    pHandle.start();
                    File snapshotDir = coreDump.getStorage().getDirectory();
                    String name = HeapDumpSupport.getInstance().getCategory().createFileName();
                    File dumpFile = new File(snapshotDir, name);
                    SaModel saAget = SaModelFactory.getSAAgentFor((DataSource)coreDump);
                    try {
                        if (saAget.takeHeapDump(dumpFile.getAbsolutePath())) {
                            final HeapDumpImpl heapDump = new HeapDumpImpl(dumpFile, (DataSource)coreDump);
                            coreDump.getRepository().addDataSource((DataSource)heapDump);
                            if (openView) {
                                DataSource.EVENT_QUEUE.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataSourceWindowManager.sharedInstance().openDataSource((DataSource)heapDump);
                                    }
                                });
                            }
                        } else {
                            HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)coreDump);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, "createHeapDump-CoreDump", ex);
                        HeapDumpProvider.this.notifyHeapDumpFailed((DataSource)coreDump);
                    }
                    pHandleF = pHandle;
                }
                catch (Throwable throwable) {
                    ProgressHandle pHandleF2 = pHandle;
                    SwingUtilities.invokeLater(new Runnable(pHandleF2){
                        final /* synthetic */ ProgressHandle val$pHandleF;
                        {
                            this.val$pHandleF = progressHandle;
                        }

                        @Override
                        public void run() {
                            if (this.val$pHandleF != null) {
                                this.val$pHandleF.finish();
                            }
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        });
    }

    public void initialize() {
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new SnapshotListener(), Snapshot.class);
        DataSourceRepository.sharedInstance().addDataChangeListener((DataChangeListener)new ApplicationListener(), Application.class);
    }

    private void processNewSnapshot(Snapshot snapshot) {
        if (snapshot instanceof HeapDumpImpl) {
            return;
        }
        boolean appSnapshot = snapshot instanceof ApplicationSnapshot;
        File snapshotFile = snapshot.getFile();
        if (snapshotFile != null && snapshotFile.isDirectory()) {
            File[] files = snapshotFile.listFiles(HeapDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<HeapDumpImpl> heapDumps = new HashSet<HeapDumpImpl>();
            for (File file : files) {
                HeapDumpImpl heapDump = new HeapDumpImpl(file, (DataSource)snapshot);
                if (appSnapshot) {
                    heapDump.forceViewClosable(true);
                }
                heapDumps.add(heapDump);
            }
            snapshot.getRepository().addDataSources(heapDumps);
        }
    }

    private void processNewApplication(Application application) {
        Storage storage = application.getStorage();
        if (storage.directoryExists()) {
            File[] files = storage.getDirectory().listFiles(HeapDumpSupport.getInstance().getCategory().getFilenameFilter());
            if (files == null) {
                return;
            }
            HashSet<HeapDumpImpl> heapDumps = new HashSet<HeapDumpImpl>();
            for (File file : files) {
                heapDumps.add(new HeapDumpImpl(file, (DataSource)application));
            }
            application.getRepository().addDataSources(heapDumps);
        }
    }

    private void notifyHeapDumpFailed(DataSource dataSource) {
        String displayName = DataSourceDescriptorFactory.getDescriptor((DataSource)dataSource).getName();
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)(NbBundle.getMessage(HeapDumpProvider.class, (String)"MSG_Cannot_take_heap_dump") + displayName), 0));
    }

    private class ApplicationListener
    implements DataChangeListener<Application> {
        private ApplicationListener() {
        }

        public void dataChanged(DataChangeEvent<Application> event) {
            final Set applications = event.getAdded();
            if (!applications.isEmpty()) {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Application application : applications) {
                            HeapDumpProvider.this.processNewApplication(application);
                        }
                    }
                });
            }
        }
    }

    private class SnapshotListener
    implements DataChangeListener<Snapshot> {
        private SnapshotListener() {
        }

        public void dataChanged(DataChangeEvent<Snapshot> event) {
            final Set snapshots = event.getAdded();
            if (!snapshots.isEmpty()) {
                VisualVM.getInstance().runTask(new Runnable(){

                    @Override
                    public void run() {
                        for (Snapshot snapshot : snapshots) {
                            HeapDumpProvider.this.processNewSnapshot(snapshot);
                        }
                    }
                });
            }
        }
    }
}

