/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.Ice;

import com.zeroc.Ice.InputStream;
import com.zeroc.Ice.ObjectPrx;
import com.zeroc.Ice.OptionalFormat;
import com.zeroc.Ice.OutputStream;
import java.util.Optional;

public final class ObjectProxySeqHelper {
    public static void write(OutputStream ostr, ObjectPrx[] v) {
        if (v == null) {
            ostr.writeSize(0);
        } else {
            ostr.writeSize(v.length);
            for (int i0 = 0; i0 < v.length; ++i0) {
                ostr.writeProxy(v[i0]);
            }
        }
    }

    public static ObjectPrx[] read(InputStream istr) {
        int len0 = istr.readAndCheckSeqSize(2);
        ObjectPrx[] v = new ObjectPrx[len0];
        for (int i0 = 0; i0 < len0; ++i0) {
            v[i0] = istr.readProxy();
        }
        return v;
    }

    public static void write(OutputStream ostr, int tag, Optional<ObjectPrx[]> v) {
        if (v != null && v.isPresent()) {
            ObjectProxySeqHelper.write(ostr, tag, v.get());
        }
    }

    public static void write(OutputStream ostr, int tag, ObjectPrx[] v) {
        if (ostr.writeOptional(tag, OptionalFormat.FSize)) {
            int pos = ostr.startSize();
            ObjectProxySeqHelper.write(ostr, v);
            ostr.endSize(pos);
        }
    }

    public static Optional<ObjectPrx[]> read(InputStream istr, int tag) {
        if (istr.readOptional(tag, OptionalFormat.FSize)) {
            istr.skip(4);
            ObjectPrx[] v = ObjectProxySeqHelper.read(istr);
            return Optional.of(v);
        }
        return Optional.empty();
    }
}

