"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MongoCryptContextCtor = exports.MongoCrypt = exports.cryptoCallbacks = void 0;
const crypto_callbacks_1 = require("./crypto_callbacks");
Object.defineProperty(exports, "cryptoCallbacks", { enumerable: true, get: function () { return crypto_callbacks_1.cryptoCallbacks; } });
function load() {
    try {
        return require('../build/Release/mongocrypt.node');
    }
    catch {
        // Webpack will fail when just returning the require, so we need to wrap
        // in a try/catch and rethrow.
        /* eslint no-useless-catch: 0 */
        try {
            return require('../build/Debug/mongocrypt.node');
        }
        catch (error) {
            throw error;
        }
    }
}
const mc = load();
const MongoCrypt = class MongoCrypt extends mc.MongoCrypt {
    constructor(options) {
        // Pass in JS cryptoCallbacks implementation by default.
        // If the Node.js openssl version is supported this will be ignored.
        super(
        // @ts-expect-error: intentionally passing in an argument that will throw to preserve existing behavior
        options == null || typeof options !== 'object' ? undefined : { cryptoCallbacks: crypto_callbacks_1.cryptoCallbacks, ...options });
    }
};
exports.MongoCrypt = MongoCrypt;
exports.MongoCryptContextCtor = mc.MongoCryptContextCtor;
//# sourceMappingURL=index.js.map