/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserModuleNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.SimpleChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.StaticFilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsImplUtil;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0015\u0016B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0002H\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy;", "Lcom/intellij/openapi/vcs/changes/ui/SimpleChangesGroupingPolicy;", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljavax/swing/tree/DefaultTreeModel;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "Lorg/jetbrains/annotations/NotNull;", "getGroupRootValueFor", "nodePath", "Lcom/intellij/openapi/vcs/changes/ui/StaticFilePath;", "node", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "createGroupRootNode", "value", "Factory", "Companion", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
public final class ModuleChangesGroupingPolicy
extends SimpleChangesGroupingPolicy<Module> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ProjectFileIndex myIndex;
    private static final boolean HIDE_EXCLUDED_FILES = Registry.Companion.is("ide.hide.excluded.files");

    public ModuleChangesGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(model);
        this.project = project;
        ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
        this.myIndex = projectFileIndex;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @Nullable
    protected Module getGroupRootValueFor(@NotNull StaticFilePath nodePath, @NotNull ChangesBrowserNode<?> node) {
        Intrinsics.checkNotNullParameter((Object)nodePath, (String)"nodePath");
        Intrinsics.checkNotNullParameter(node, (String)"node");
        VirtualFile virtualFile = VcsImplUtil.findValidParentAccurately(nodePath.getFilePath());
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        Module module = this.myIndex.getModuleForFile(file, HIDE_EXCLUDED_FILES);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        if (ModuleType.isInternal((Module)module2)) {
            return null;
        }
        return module2;
    }

    @Override
    @Nullable
    protected ChangesBrowserNode<?> createGroupRootNode(@NotNull Module value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ChangesBrowserModuleNode changesBrowserModuleNode = ChangesBrowserModuleNode.create(value);
        if (changesBrowserModuleNode == null) {
            return null;
        }
        ChangesBrowserModuleNode moduleNode = changesBrowserModuleNode;
        moduleNode.markAsHelperNode();
        return moduleNode;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy$Companion;", "", "<init>", "()V", "HIDE_EXCLUDED_FILES", "", "intellij.platform.vcs.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy$Factory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "<init>", "()V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ModuleChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl"})
    public static final class Factory
    extends ChangesGroupingPolicyFactory {
        @Override
        @NotNull
        public ModuleChangesGroupingPolicy createGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            return new ModuleChangesGroupingPolicy(project, model);
        }
    }
}

