"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHighlightedSeriesSelector = void 0;
var create_selector_1 = require("../../../../state/create_selector");
var compute_legend_1 = require("./compute_legend");
var getHighlightedLegendPath = function (state) { return state.interactions.highlightedLegendPath; };
exports.getHighlightedSeriesSelector = create_selector_1.createCustomCachedSelector([getHighlightedLegendPath, compute_legend_1.computeLegendSelector], function (highlightedLegendPaths, legendItems) {
    if (highlightedLegendPaths.length === 0) {
        return;
    }
    var highlightedSeriesKeys = highlightedLegendPaths.map(function (_a) {
        var value = _a.value;
        return value;
    });
    return legendItems.find(function (_a) {
        var seriesIdentifiers = _a.seriesIdentifiers;
        return seriesIdentifiers.some(function (_a) {
            var key = _a.key;
            return highlightedSeriesKeys.some(function (hKey) { return hKey === key; });
        });
    });
});
//# sourceMappingURL=get_highlighted_series.js.map