/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import reactor.netty.http.logging.AbstractHttpMessageArgProvider;
import reactor.netty.http.logging.HttpMessageType;

final class HttpRequestArgProvider
extends AbstractHttpMessageArgProvider {
    final HttpHeaders httpHeaders;
    final String method;
    final String protocol;
    final String uri;

    HttpRequestArgProvider(HttpRequest httpRequest) {
        super(httpRequest.decoderResult());
        this.httpHeaders = httpRequest.headers();
        this.method = httpRequest.method().name();
        this.protocol = httpRequest.protocolVersion().text();
        this.uri = httpRequest.uri();
    }

    @Override
    public HttpHeaders headers() {
        return this.httpHeaders;
    }

    @Override
    public HttpMessageType httpMessageType() {
        return HttpMessageType.REQUEST;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String uri() {
        return this.uri;
    }
}

