# ![icon](http://hydrogen-music.org/images/favicon.png) Hydrogen
[![AppVeyor Build Status](https://ci.appveyor.com/api/projects/status/32r7s2skrgm9ubva?svg=true)](https://ci.appveyor.com/api/projects/status/32r7s2skrgm9ubva?svg=true)
[![Packaging status](https://repology.org/badge/tiny-repos/hydrogen-drum-machine.svg)](https://repology.org/project/hydrogen-drum-machine/versions)

The advanced drum machine for Linux, macOS, and Windows.

![screenshot](http://hydrogen-music.org/images/screenshots/main-window.png)

## Features
* First-class MIDI support
* Highly customizable
* Stable and performant
* Loads of drumkits to choose from
* In-depth control of instrument, sample, and note properties
* High quality time-stretching and pitch shifting
* Automate it using MIDI or OSC API

Hydrogen is both a drum sequencer for pattern-based programming and a drum synth. Its simple yet feature-rich design makes it a versatile companion, be it for quick practice at home, professional usage as fully-fledged drum machine in your studio, or drum looper on steroids for your live performance.

## Download

* **[Windows (64bit) (>=Vista)](https://github.com/hydrogen-music/hydrogen/releases/download/1.2.4/Hydrogen-1.2.4-win64.exe)**
* **[macOS (>=10.14)](https://github.com/hydrogen-music/hydrogen/releases/download/1.2.4/Hydrogen-1.2.4.dmg)**
* **[Linux](https://github.com/hydrogen-music/hydrogen/releases/download/1.2.4/Hydrogen-1.2.4-x86_64.AppImage)** <details>
   <summary>or check you distribution's repo</summary>
  
   [![Packaging status](https://repology.org/badge/vertical-allrepos/hydrogen-drum-machine.svg?header=Hydrogen)](https://repology.org/project/hydrogen-drum-machine/versions)

 </details>

Binaries for older OS versions can be found in the [Download section of our homepage](http://hydrogen-music.org/downloads/).

## Building

If your particular OS is not supported or you want to use the latest developing version, you can build Hydrogen yourself. We provide step-by-step guides for the following platforms:

* **[Linux](https://github.com/hydrogen-music/hydrogen/blob/main/INSTALL.md)**
* **[macOS](https://github.com/hydrogen-music/hydrogen/wiki/Building-Hydrogen-from-Source-(macOS))**
* **[Windows](https://github.com/hydrogen-music/hydrogen/wiki/Building-Hydrogen-from-source-(Windows))**

## Usage

The main entry point for learning how to use Hydrogen is our [manual](http://hydrogen-music.org/documentation/manual/manual_en.html).

Further info can be found in our [FAQ](http://hydrogen-music.org/faq/) and [Wiki](https://github.com/hydrogen-music/hydrogen/wiki).

## Contributing

You want to contribute to Hydrogen?

How about making/improving a [translation](data/i18n)? You can also
check out our (ancient) [How to
contribute](http://hydrogen-music.org/contribution/) guide or get in
touch with us on our [mailing
list](http://lists.sourceforge.net/mailman/listinfo/hydrogen-devel).

## License

Hydrogen is distributed under [GPLv2+](./COPYING).
