/**
* This file is part of the "libunicode" project
*   Copyright (c) 2020-2021 Christian Parpart <christian@parpart.family>
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
#pragma once

#include <cstdint>

namespace unicode
{

enum class Plane: uint8_t
{
    Basic_Multilingual_Plane = 0,
    Supplementary_Ideographic_Plane = 1,
    Supplementary_Multilingual_Plane = 2,
    Supplementary_Private_Use_Area_Plane = 3,
    Supplementary_Special_purpose_Plane = 4,
    Tertiary_Ideographic_Plane = 5,
    Unassigned = 6,
};

enum class Age: uint8_t
{
    Unassigned = 0,
    V10_0 = 1,
    V11_0 = 2,
    V12_0 = 3,
    V12_1 = 4,
    V13_0 = 5,
    V14_0 = 6,
    V15_0 = 7,
    V15_1 = 8,
    V16_0 = 9,
    V1_1 = 10,
    V2_0 = 11,
    V2_1 = 12,
    V3_0 = 13,
    V3_1 = 14,
    V3_2 = 15,
    V4_0 = 16,
    V4_1 = 17,
    V5_0 = 18,
    V5_1 = 19,
    V5_2 = 20,
    V6_0 = 21,
    V6_1 = 22,
    V6_2 = 23,
    V6_3 = 24,
    V7_0 = 25,
    V8_0 = 26,
    V9_0 = 27,
};

enum class Bidi_Class: uint8_t
{
    Arabic_Letter = 0,
    Arabic_Number = 1,
    Boundary_Neutral = 2,
    Common_Separator = 3,
    European_Number = 4,
    European_Separator = 5,
    European_Terminator = 6,
    First_Strong_Isolate = 7,
    Left_To_Right = 8,
    Left_To_Right_Embedding = 9,
    Left_To_Right_Isolate = 10,
    Left_To_Right_Override = 11,
    Nonspacing_Mark = 12,
    Other_Neutral = 13,
    Paragraph_Separator = 14,
    Pop_Directional_Format = 15,
    Pop_Directional_Isolate = 16,
    Right_To_Left = 17,
    Right_To_Left_Embedding = 18,
    Right_To_Left_Isolate = 19,
    Right_To_Left_Override = 20,
    Segment_Separator = 21,
    White_Space = 22,
};

enum class Bidi_Paired_Bracket_Type: uint8_t
{
    Close = 0,
    None = 1,
    Open = 2,
};

enum class Canonical_Combining_Class: uint8_t
{
    A = 0,
    AL = 1,
    AR = 2,
    ATA = 3,
    ATAR = 4,
    ATB = 5,
    ATBL = 6,
    B = 7,
    BL = 8,
    BR = 9,
    CCC10 = 10,
    CCC103 = 11,
    CCC107 = 12,
    CCC11 = 13,
    CCC118 = 14,
    CCC12 = 15,
    CCC122 = 16,
    CCC129 = 17,
    CCC13 = 18,
    CCC130 = 19,
    CCC132 = 20,
    CCC133 = 21,
    CCC14 = 22,
    CCC15 = 23,
    CCC16 = 24,
    CCC17 = 25,
    CCC18 = 26,
    CCC19 = 27,
    CCC20 = 28,
    CCC21 = 29,
    CCC22 = 30,
    CCC23 = 31,
    CCC24 = 32,
    CCC25 = 33,
    CCC26 = 34,
    CCC27 = 35,
    CCC28 = 36,
    CCC29 = 37,
    CCC30 = 38,
    CCC31 = 39,
    CCC32 = 40,
    CCC33 = 41,
    CCC34 = 42,
    CCC35 = 43,
    CCC36 = 44,
    CCC84 = 45,
    CCC91 = 46,
    DA = 47,
    DB = 48,
    HANR = 49,
    IS = 50,
    KV = 51,
    L = 52,
    NK = 53,
    NR = 54,
    OV = 55,
    R = 56,
    VR = 57,
};

enum class Decomposition_Type: uint8_t
{
    Canonical = 0,
    Circle = 1,
    Compat = 2,
    Final = 3,
    Font = 4,
    Fraction = 5,
    Initial = 6,
    Isolated = 7,
    Medial = 8,
    Narrow = 9,
    Nobreak = 10,
    None = 11,
    Small = 12,
    Square = 13,
    Sub = 14,
    Super = 15,
    Vertical = 16,
    Wide = 17,
};

enum class East_Asian_Width: uint8_t
{
    Ambiguous = 0,
    Fullwidth = 1,
    Halfwidth = 2,
    Narrow = 3,
    Neutral = 4,
    Wide = 5,
};

enum class Grapheme_Cluster_Break: uint8_t
{
    Undefined = 0,
    CR = 1,
    Control = 2,
    E_Base = 3,
    E_Base_GAZ = 4,
    E_Modifier = 5,
    Extend = 6,
    Glue_After_Zwj = 7,
    L = 8,
    LF = 9,
    LV = 10,
    LVT = 11,
    Other = 12,
    Prepend = 13,
    Regional_Indicator = 14,
    SpacingMark = 15,
    T = 16,
    V = 17,
    ZWJ = 18,
};

enum class Hangul_Syllable_Type: uint8_t
{
    LVT_Syllable = 0,
    LV_Syllable = 1,
    Leading_Jamo = 2,
    Not_Applicable = 3,
    Trailing_Jamo = 4,
    Vowel_Jamo = 5,
};

enum class Indic_Conjunct_Break: uint8_t
{
    Consonant = 0,
    Extend = 1,
    Linker = 2,
    None = 3,
};

enum class Indic_Positional_Category: uint8_t
{
    Bottom = 0,
    Bottom_And_Left = 1,
    Bottom_And_Right = 2,
    Left = 3,
    Left_And_Right = 4,
    NA = 5,
    Overstruck = 6,
    Right = 7,
    Top = 8,
    Top_And_Bottom = 9,
    Top_And_Bottom_And_Left = 10,
    Top_And_Bottom_And_Right = 11,
    Top_And_Left = 12,
    Top_And_Left_And_Right = 13,
    Top_And_Right = 14,
    Visual_Order_Left = 15,
};

enum class Indic_Syllabic_Category: uint8_t
{
    Avagraha = 0,
    Bindu = 1,
    Brahmi_Joining_Number = 2,
    Cantillation_Mark = 3,
    Consonant = 4,
    Consonant_Dead = 5,
    Consonant_Final = 6,
    Consonant_Head_Letter = 7,
    Consonant_Initial_Postfixed = 8,
    Consonant_Killer = 9,
    Consonant_Medial = 10,
    Consonant_Placeholder = 11,
    Consonant_Preceding_Repha = 12,
    Consonant_Prefixed = 13,
    Consonant_Subjoined = 14,
    Consonant_Succeeding_Repha = 15,
    Consonant_With_Stacker = 16,
    Gemination_Mark = 17,
    Invisible_Stacker = 18,
    Joiner = 19,
    Modifying_Letter = 20,
    Non_Joiner = 21,
    Nukta = 22,
    Number = 23,
    Number_Joiner = 24,
    Other = 25,
    Pure_Killer = 26,
    Register_Shifter = 27,
    Reordering_Killer = 28,
    Syllable_Modifier = 29,
    Tone_Letter = 30,
    Tone_Mark = 31,
    Virama = 32,
    Visarga = 33,
    Vowel = 34,
    Vowel_Dependent = 35,
    Vowel_Independent = 36,
};

enum class Jamo_Short_Name: uint8_t
{
    A = 0,
    AE = 1,
    B = 2,
    BB = 3,
    BS = 4,
    C = 5,
    D = 6,
    DD = 7,
    E = 8,
    EO = 9,
    EU = 10,
    G = 11,
    GG = 12,
    GS = 13,
    H = 14,
    I = 15,
    J = 16,
    JJ = 17,
    K = 18,
    L = 19,
    LB = 20,
    LG = 21,
    LH = 22,
    LM = 23,
    LP = 24,
    LS = 25,
    LT = 26,
    M = 27,
    N = 28,
    NG = 29,
    NH = 30,
    NJ = 31,
    O = 32,
    OE = 33,
    P = 34,
    R = 35,
    S = 36,
    SS = 37,
    T = 38,
    U = 39,
    WA = 40,
    WAE = 41,
    WE = 42,
    WEO = 43,
    WI = 44,
    YA = 45,
    YAE = 46,
    YE = 47,
    YEO = 48,
    YI = 49,
    YO = 50,
    YU = 51,
};

enum class Joining_Group: uint8_t
{
    African_Feh = 0,
    African_Noon = 1,
    African_Qaf = 2,
    Ain = 3,
    Alaph = 4,
    Alef = 5,
    Beh = 6,
    Beth = 7,
    Burushaski_Yeh_Barree = 8,
    Dal = 9,
    Dalath_Rish = 10,
    E = 11,
    Farsi_Yeh = 12,
    Fe = 13,
    Feh = 14,
    Final_Semkath = 15,
    Gaf = 16,
    Gamal = 17,
    Hah = 18,
    Hanifi_Rohingya_Kinna_Ya = 19,
    Hanifi_Rohingya_Pa = 20,
    He = 21,
    Heh = 22,
    Heh_Goal = 23,
    Heth = 24,
    Kaf = 25,
    Kaph = 26,
    Kashmiri_Yeh = 27,
    Khaph = 28,
    Knotted_Heh = 29,
    Lam = 30,
    Lamadh = 31,
    Malayalam_Bha = 32,
    Malayalam_Ja = 33,
    Malayalam_Lla = 34,
    Malayalam_Llla = 35,
    Malayalam_Nga = 36,
    Malayalam_Nna = 37,
    Malayalam_Nnna = 38,
    Malayalam_Nya = 39,
    Malayalam_Ra = 40,
    Malayalam_Ssa = 41,
    Malayalam_Tta = 42,
    Manichaean_Aleph = 43,
    Manichaean_Ayin = 44,
    Manichaean_Beth = 45,
    Manichaean_Daleth = 46,
    Manichaean_Dhamedh = 47,
    Manichaean_Five = 48,
    Manichaean_Gimel = 49,
    Manichaean_Heth = 50,
    Manichaean_Hundred = 51,
    Manichaean_Kaph = 52,
    Manichaean_Lamedh = 53,
    Manichaean_Mem = 54,
    Manichaean_Nun = 55,
    Manichaean_One = 56,
    Manichaean_Pe = 57,
    Manichaean_Qoph = 58,
    Manichaean_Resh = 59,
    Manichaean_Sadhe = 60,
    Manichaean_Samekh = 61,
    Manichaean_Taw = 62,
    Manichaean_Ten = 63,
    Manichaean_Teth = 64,
    Manichaean_Thamedh = 65,
    Manichaean_Twenty = 66,
    Manichaean_Waw = 67,
    Manichaean_Yodh = 68,
    Manichaean_Zayin = 69,
    Meem = 70,
    Mim = 71,
    No_Joining_Group = 72,
    Noon = 73,
    Nun = 74,
    Nya = 75,
    Pe = 76,
    Qaf = 77,
    Qaph = 78,
    Reh = 79,
    Reversed_Pe = 80,
    Rohingya_Yeh = 81,
    Sad = 82,
    Sadhe = 83,
    Seen = 84,
    Semkath = 85,
    Shin = 86,
    Straight_Waw = 87,
    Swash_Kaf = 88,
    Syriac_Waw = 89,
    Tah = 90,
    Taw = 91,
    Teh_Marbuta = 92,
    Teh_Marbuta_Goal = 93,
    Teth = 94,
    Thin_Yeh = 95,
    Vertical_Tail = 96,
    Waw = 97,
    Yeh = 98,
    Yeh_Barree = 99,
    Yeh_With_Tail = 100,
    Yudh = 101,
    Yudh_He = 102,
    Zain = 103,
    Zhain = 104,
};

enum class Joining_Type: uint8_t
{
    Dual_Joining = 0,
    Join_Causing = 1,
    Left_Joining = 2,
    Non_Joining = 3,
    Right_Joining = 4,
    Transparent = 5,
};

enum class Line_Break: uint8_t
{
    Aksara = 0,
    Aksara_Prebase = 1,
    Aksara_Start = 2,
    Alphabetic = 3,
    Ambiguous = 4,
    Break_After = 5,
    Break_Before = 6,
    Break_Both = 7,
    Break_Symbols = 8,
    Carriage_Return = 9,
    Close_Parenthesis = 10,
    Close_Punctuation = 11,
    Combining_Mark = 12,
    Complex_Context = 13,
    Conditional_Japanese_Starter = 14,
    Contingent_Break = 15,
    E_Base = 16,
    E_Modifier = 17,
    Exclamation = 18,
    Glue = 19,
    H2 = 20,
    H3 = 21,
    Hebrew_Letter = 22,
    Hyphen = 23,
    Ideographic = 24,
    Infix_Numeric = 25,
    Inseparable = 26,
    JL = 27,
    JT = 28,
    JV = 29,
    Line_Feed = 30,
    Mandatory_Break = 31,
    Next_Line = 32,
    Nonstarter = 33,
    Numeric = 34,
    Open_Punctuation = 35,
    Postfix_Numeric = 36,
    Prefix_Numeric = 37,
    Quotation = 38,
    Regional_Indicator = 39,
    Space = 40,
    Surrogate = 41,
    Unknown = 42,
    Virama = 43,
    Virama_Final = 44,
    Word_Joiner = 45,
    ZWJ = 46,
    ZWSpace = 47,
};

enum class NFC_Quick_Check: uint8_t
{
    Maybe = 0,
    No = 1,
    Yes = 2,
};

enum class NFKC_Quick_Check: uint8_t
{
    Maybe = 0,
    No = 1,
    Yes = 2,
};

enum class Numeric_Type: uint8_t
{
    Decimal = 0,
    Digit = 1,
    None = 2,
    Numeric = 3,
};

enum class Sentence_Break: uint8_t
{
    ATerm = 0,
    CR = 1,
    Close = 2,
    Extend = 3,
    Format = 4,
    LF = 5,
    Lower = 6,
    Numeric = 7,
    OLetter = 8,
    Other = 9,
    SContinue = 10,
    STerm = 11,
    Sep = 12,
    Sp = 13,
    Upper = 14,
};

enum class Vertical_Orientation: uint8_t
{
    Rotated = 0,
    Transformed_Rotated = 1,
    Transformed_Upright = 2,
    Upright = 3,
};

enum class Word_Break: uint8_t
{
    ALetter = 0,
    CR = 1,
    Double_Quote = 2,
    E_Base = 3,
    E_Base_GAZ = 4,
    E_Modifier = 5,
    Extend = 6,
    ExtendNumLet = 7,
    Format = 8,
    Glue_After_Zwj = 9,
    Hebrew_Letter = 10,
    Katakana = 11,
    LF = 12,
    MidLetter = 13,
    MidNum = 14,
    MidNumLet = 15,
    Newline = 16,
    Numeric = 17,
    Other = 18,
    Regional_Indicator = 19,
    Single_Quote = 20,
    WSegSpace = 21,
    ZWJ = 22,
};

enum class Core_Property: uint8_t
{
    Alphabetic = 0,
    Case_Ignorable = 1,
    Cased = 2,
    Changes_When_Casefolded = 3,
    Changes_When_Casemapped = 4,
    Changes_When_Lowercased = 5,
    Changes_When_Titlecased = 6,
    Changes_When_Uppercased = 7,
    Default_Ignorable_Code_Point = 8,
    Grapheme_Base = 9,
    Grapheme_Extend = 10,
    Grapheme_Link = 11,
    ID_Continue = 12,
    ID_Start = 13,
    Lowercase = 14,
    Math = 15,
    Uppercase = 16,
    XID_Continue = 17,
    XID_Start = 18,
};

enum class General_Category: uint8_t
{
    Unspecified = 0,
    Close_Punctuation = 1,
    Connector_Punctuation = 2,
    Control = 3,
    Currency_Symbol = 4,
    Dash_Punctuation = 5,
    Decimal_Number = 6,
    Enclosing_Mark = 7,
    Final_Punctuation = 8,
    Format = 9,
    Initial_Punctuation = 10,
    Letter_Number = 11,
    Line_Separator = 12,
    Lowercase_Letter = 13,
    Math_Symbol = 14,
    Modifier_Letter = 15,
    Modifier_Symbol = 16,
    Nonspacing_Mark = 17,
    Open_Punctuation = 18,
    Other_Letter = 19,
    Other_Number = 20,
    Other_Punctuation = 21,
    Other_Symbol = 22,
    Paragraph_Separator = 23,
    Private_Use = 24,
    Space_Separator = 25,
    Spacing_Mark = 26,
    Surrogate = 27,
    Titlecase_Letter = 28,
    Unassigned = 29,
    Uppercase_Letter = 30,
};

enum class Script: uint8_t
{
    Invalid = 0,
    Unknown = 1,
    Common = 2,
    Adlam = 3,
    Ahom = 4,
    Anatolian_Hieroglyphs = 5,
    Arabic = 6,
    Armenian = 7,
    Avestan = 8,
    Balinese = 9,
    Bamum = 10,
    Bassa_Vah = 11,
    Batak = 12,
    Bengali = 13,
    Bhaiksuki = 14,
    Bopomofo = 15,
    Brahmi = 16,
    Braille = 17,
    Buginese = 18,
    Buhid = 19,
    Canadian_Aboriginal = 20,
    Carian = 21,
    Caucasian_Albanian = 22,
    Chakma = 23,
    Cham = 24,
    Cherokee = 25,
    Chorasmian = 26,
    Coptic = 27,
    Cuneiform = 28,
    Cypriot = 29,
    Cypro_Minoan = 30,
    Cyrillic = 31,
    Deseret = 32,
    Devanagari = 33,
    Dives_Akuru = 34,
    Dogra = 35,
    Duployan = 36,
    Egyptian_Hieroglyphs = 37,
    Elbasan = 38,
    Elymaic = 39,
    Ethiopic = 40,
    Garay = 41,
    Georgian = 42,
    Glagolitic = 43,
    Gothic = 44,
    Grantha = 45,
    Greek = 46,
    Gujarati = 47,
    Gunjala_Gondi = 48,
    Gurmukhi = 49,
    Gurung_Khema = 50,
    Han = 51,
    Hangul = 52,
    Hanifi_Rohingya = 53,
    Hanunoo = 54,
    Hatran = 55,
    Hebrew = 56,
    Hiragana = 57,
    Imperial_Aramaic = 58,
    Inherited = 59,
    Inscriptional_Pahlavi = 60,
    Inscriptional_Parthian = 61,
    Javanese = 62,
    Kaithi = 63,
    Kannada = 64,
    Katakana = 65,
    Kawi = 66,
    Kayah_Li = 67,
    Kharoshthi = 68,
    Khitan_Small_Script = 69,
    Khmer = 70,
    Khojki = 71,
    Khudawadi = 72,
    Kirat_Rai = 73,
    Lao = 74,
    Latin = 75,
    Lepcha = 76,
    Limbu = 77,
    Linear_A = 78,
    Linear_B = 79,
    Lisu = 80,
    Lycian = 81,
    Lydian = 82,
    Mahajani = 83,
    Makasar = 84,
    Malayalam = 85,
    Mandaic = 86,
    Manichaean = 87,
    Marchen = 88,
    Masaram_Gondi = 89,
    Medefaidrin = 90,
    Meetei_Mayek = 91,
    Mende_Kikakui = 92,
    Meroitic_Cursive = 93,
    Meroitic_Hieroglyphs = 94,
    Miao = 95,
    Modi = 96,
    Mongolian = 97,
    Mro = 98,
    Multani = 99,
    Myanmar = 100,
    Nabataean = 101,
    Nag_Mundari = 102,
    Nandinagari = 103,
    New_Tai_Lue = 104,
    Newa = 105,
    Nko = 106,
    Nushu = 107,
    Nyiakeng_Puachue_Hmong = 108,
    Ogham = 109,
    Ol_Chiki = 110,
    Ol_Onal = 111,
    Old_Hungarian = 112,
    Old_Italic = 113,
    Old_North_Arabian = 114,
    Old_Permic = 115,
    Old_Persian = 116,
    Old_Sogdian = 117,
    Old_South_Arabian = 118,
    Old_Turkic = 119,
    Old_Uyghur = 120,
    Oriya = 121,
    Osage = 122,
    Osmanya = 123,
    Pahawh_Hmong = 124,
    Palmyrene = 125,
    Pau_Cin_Hau = 126,
    Phags_Pa = 127,
    Phoenician = 128,
    Psalter_Pahlavi = 129,
    Rejang = 130,
    Runic = 131,
    Samaritan = 132,
    Saurashtra = 133,
    Sharada = 134,
    Shavian = 135,
    Siddham = 136,
    SignWriting = 137,
    Sinhala = 138,
    Sogdian = 139,
    Sora_Sompeng = 140,
    Soyombo = 141,
    Sundanese = 142,
    Sunuwar = 143,
    Syloti_Nagri = 144,
    Syriac = 145,
    Tagalog = 146,
    Tagbanwa = 147,
    Tai_Le = 148,
    Tai_Tham = 149,
    Tai_Viet = 150,
    Takri = 151,
    Tamil = 152,
    Tangsa = 153,
    Tangut = 154,
    Telugu = 155,
    Thaana = 156,
    Thai = 157,
    Tibetan = 158,
    Tifinagh = 159,
    Tirhuta = 160,
    Todhri = 161,
    Toto = 162,
    Tulu_Tigalari = 163,
    Ugaritic = 164,
    Vai = 165,
    Vithkuqi = 166,
    Wancho = 167,
    Warang_Citi = 168,
    Yezidi = 169,
    Yi = 170,
    Zanabazar_Square = 171,
};

enum class Block: uint16_t
{
    Unspecified = 0,
    Adlam = 1,
    Aegean_Numbers = 2,
    Ahom = 3,
    Alchemical_Symbols = 4,
    Alphabetic_Presentation_Forms = 5,
    Anatolian_Hieroglyphs = 6,
    Ancient_Greek_Musical_Notation = 7,
    Ancient_Greek_Numbers = 8,
    Ancient_Symbols = 9,
    Arabic = 10,
    Arabic_Extended_A = 11,
    Arabic_Extended_B = 12,
    Arabic_Extended_C = 13,
    Arabic_Mathematical_Alphabetic_Symbols = 14,
    Arabic_Presentation_Forms_A = 15,
    Arabic_Presentation_Forms_B = 16,
    Arabic_Supplement = 17,
    Armenian = 18,
    Arrows = 19,
    Avestan = 20,
    Balinese = 21,
    Bamum = 22,
    Bamum_Supplement = 23,
    Basic_Latin = 24,
    Bassa_Vah = 25,
    Batak = 26,
    Bengali = 27,
    Bhaiksuki = 28,
    Block_Elements = 29,
    Bopomofo = 30,
    Bopomofo_Extended = 31,
    Box_Drawing = 32,
    Brahmi = 33,
    Braille_Patterns = 34,
    Buginese = 35,
    Buhid = 36,
    Byzantine_Musical_Symbols = 37,
    CJK_Compatibility = 38,
    CJK_Compatibility_Forms = 39,
    CJK_Compatibility_Ideographs = 40,
    CJK_Compatibility_Ideographs_Supplement = 41,
    CJK_Radicals_Supplement = 42,
    CJK_Strokes = 43,
    CJK_Symbols_and_Punctuation = 44,
    CJK_Unified_Ideographs = 45,
    CJK_Unified_Ideographs_Extension_A = 46,
    CJK_Unified_Ideographs_Extension_B = 47,
    CJK_Unified_Ideographs_Extension_C = 48,
    CJK_Unified_Ideographs_Extension_D = 49,
    CJK_Unified_Ideographs_Extension_E = 50,
    CJK_Unified_Ideographs_Extension_F = 51,
    CJK_Unified_Ideographs_Extension_G = 52,
    CJK_Unified_Ideographs_Extension_H = 53,
    CJK_Unified_Ideographs_Extension_I = 54,
    Carian = 55,
    Caucasian_Albanian = 56,
    Chakma = 57,
    Cham = 58,
    Cherokee = 59,
    Cherokee_Supplement = 60,
    Chess_Symbols = 61,
    Chorasmian = 62,
    Combining_Diacritical_Marks = 63,
    Combining_Diacritical_Marks_Extended = 64,
    Combining_Diacritical_Marks_Supplement = 65,
    Combining_Diacritical_Marks_for_Symbols = 66,
    Combining_Half_Marks = 67,
    Common_Indic_Number_Forms = 68,
    Control_Pictures = 69,
    Coptic = 70,
    Coptic_Epact_Numbers = 71,
    Counting_Rod_Numerals = 72,
    Cuneiform = 73,
    Cuneiform_Numbers_and_Punctuation = 74,
    Currency_Symbols = 75,
    Cypriot_Syllabary = 76,
    Cypro_Minoan = 77,
    Cyrillic = 78,
    Cyrillic_Extended_A = 79,
    Cyrillic_Extended_B = 80,
    Cyrillic_Extended_C = 81,
    Cyrillic_Extended_D = 82,
    Cyrillic_Supplement = 83,
    Deseret = 84,
    Devanagari = 85,
    Devanagari_Extended = 86,
    Devanagari_Extended_A = 87,
    Dingbats = 88,
    Dives_Akuru = 89,
    Dogra = 90,
    Domino_Tiles = 91,
    Duployan = 92,
    Early_Dynastic_Cuneiform = 93,
    Egyptian_Hieroglyph_Format_Controls = 94,
    Egyptian_Hieroglyphs = 95,
    Egyptian_Hieroglyphs_Extended_A = 96,
    Elbasan = 97,
    Elymaic = 98,
    Emoticons = 99,
    Enclosed_Alphanumeric_Supplement = 100,
    Enclosed_Alphanumerics = 101,
    Enclosed_CJK_Letters_and_Months = 102,
    Enclosed_Ideographic_Supplement = 103,
    Ethiopic = 104,
    Ethiopic_Extended = 105,
    Ethiopic_Extended_A = 106,
    Ethiopic_Extended_B = 107,
    Ethiopic_Supplement = 108,
    Garay = 109,
    General_Punctuation = 110,
    Geometric_Shapes = 111,
    Geometric_Shapes_Extended = 112,
    Georgian = 113,
    Georgian_Extended = 114,
    Georgian_Supplement = 115,
    Glagolitic = 116,
    Glagolitic_Supplement = 117,
    Gothic = 118,
    Grantha = 119,
    Greek_Extended = 120,
    Greek_and_Coptic = 121,
    Gujarati = 122,
    Gunjala_Gondi = 123,
    Gurmukhi = 124,
    Gurung_Khema = 125,
    Halfwidth_and_Fullwidth_Forms = 126,
    Hangul_Compatibility_Jamo = 127,
    Hangul_Jamo = 128,
    Hangul_Jamo_Extended_A = 129,
    Hangul_Jamo_Extended_B = 130,
    Hangul_Syllables = 131,
    Hanifi_Rohingya = 132,
    Hanunoo = 133,
    Hatran = 134,
    Hebrew = 135,
    High_Private_Use_Surrogates = 136,
    High_Surrogates = 137,
    Hiragana = 138,
    IPA_Extensions = 139,
    Ideographic_Description_Characters = 140,
    Ideographic_Symbols_and_Punctuation = 141,
    Imperial_Aramaic = 142,
    Indic_Siyaq_Numbers = 143,
    Inscriptional_Pahlavi = 144,
    Inscriptional_Parthian = 145,
    Javanese = 146,
    Kaithi = 147,
    Kaktovik_Numerals = 148,
    Kana_Extended_A = 149,
    Kana_Extended_B = 150,
    Kana_Supplement = 151,
    Kanbun = 152,
    Kangxi_Radicals = 153,
    Kannada = 154,
    Katakana = 155,
    Katakana_Phonetic_Extensions = 156,
    Kawi = 157,
    Kayah_Li = 158,
    Kharoshthi = 159,
    Khitan_Small_Script = 160,
    Khmer = 161,
    Khmer_Symbols = 162,
    Khojki = 163,
    Khudawadi = 164,
    Kirat_Rai = 165,
    Lao = 166,
    Latin_Extended_Additional = 167,
    Latin_Extended_A = 168,
    Latin_Extended_B = 169,
    Latin_Extended_C = 170,
    Latin_Extended_D = 171,
    Latin_Extended_E = 172,
    Latin_Extended_F = 173,
    Latin_Extended_G = 174,
    Latin_1_Supplement = 175,
    Lepcha = 176,
    Letterlike_Symbols = 177,
    Limbu = 178,
    Linear_A = 179,
    Linear_B_Ideograms = 180,
    Linear_B_Syllabary = 181,
    Lisu = 182,
    Lisu_Supplement = 183,
    Low_Surrogates = 184,
    Lycian = 185,
    Lydian = 186,
    Mahajani = 187,
    Mahjong_Tiles = 188,
    Makasar = 189,
    Malayalam = 190,
    Mandaic = 191,
    Manichaean = 192,
    Marchen = 193,
    Masaram_Gondi = 194,
    Mathematical_Alphanumeric_Symbols = 195,
    Mathematical_Operators = 196,
    Mayan_Numerals = 197,
    Medefaidrin = 198,
    Meetei_Mayek = 199,
    Meetei_Mayek_Extensions = 200,
    Mende_Kikakui = 201,
    Meroitic_Cursive = 202,
    Meroitic_Hieroglyphs = 203,
    Miao = 204,
    Miscellaneous_Mathematical_Symbols_A = 205,
    Miscellaneous_Mathematical_Symbols_B = 206,
    Miscellaneous_Symbols = 207,
    Miscellaneous_Symbols_and_Arrows = 208,
    Miscellaneous_Symbols_and_Pictographs = 209,
    Miscellaneous_Technical = 210,
    Modi = 211,
    Modifier_Tone_Letters = 212,
    Mongolian = 213,
    Mongolian_Supplement = 214,
    Mro = 215,
    Multani = 216,
    Musical_Symbols = 217,
    Myanmar = 218,
    Myanmar_Extended_A = 219,
    Myanmar_Extended_B = 220,
    Myanmar_Extended_C = 221,
    NKo = 222,
    Nabataean = 223,
    Nag_Mundari = 224,
    Nandinagari = 225,
    New_Tai_Lue = 226,
    Newa = 227,
    Number_Forms = 228,
    Nushu = 229,
    Nyiakeng_Puachue_Hmong = 230,
    Ogham = 231,
    Ol_Chiki = 232,
    Ol_Onal = 233,
    Old_Hungarian = 234,
    Old_Italic = 235,
    Old_North_Arabian = 236,
    Old_Permic = 237,
    Old_Persian = 238,
    Old_Sogdian = 239,
    Old_South_Arabian = 240,
    Old_Turkic = 241,
    Old_Uyghur = 242,
    Optical_Character_Recognition = 243,
    Oriya = 244,
    Ornamental_Dingbats = 245,
    Osage = 246,
    Osmanya = 247,
    Ottoman_Siyaq_Numbers = 248,
    Pahawh_Hmong = 249,
    Palmyrene = 250,
    Pau_Cin_Hau = 251,
    Phags_pa = 252,
    Phaistos_Disc = 253,
    Phoenician = 254,
    Phonetic_Extensions = 255,
    Phonetic_Extensions_Supplement = 256,
    Playing_Cards = 257,
    Private_Use_Area = 258,
    Psalter_Pahlavi = 259,
    Rejang = 260,
    Rumi_Numeral_Symbols = 261,
    Runic = 262,
    Samaritan = 263,
    Saurashtra = 264,
    Sharada = 265,
    Shavian = 266,
    Shorthand_Format_Controls = 267,
    Siddham = 268,
    Sinhala = 269,
    Sinhala_Archaic_Numbers = 270,
    Small_Form_Variants = 271,
    Small_Kana_Extension = 272,
    Sogdian = 273,
    Sora_Sompeng = 274,
    Soyombo = 275,
    Spacing_Modifier_Letters = 276,
    Specials = 277,
    Sundanese = 278,
    Sundanese_Supplement = 279,
    Sunuwar = 280,
    Superscripts_and_Subscripts = 281,
    Supplemental_Arrows_A = 282,
    Supplemental_Arrows_B = 283,
    Supplemental_Arrows_C = 284,
    Supplemental_Mathematical_Operators = 285,
    Supplemental_Punctuation = 286,
    Supplemental_Symbols_and_Pictographs = 287,
    Supplementary_Private_Use_Area_A = 288,
    Supplementary_Private_Use_Area_B = 289,
    Sutton_SignWriting = 290,
    Syloti_Nagri = 291,
    Symbols_and_Pictographs_Extended_A = 292,
    Symbols_for_Legacy_Computing = 293,
    Symbols_for_Legacy_Computing_Supplement = 294,
    Syriac = 295,
    Syriac_Supplement = 296,
    Tagalog = 297,
    Tagbanwa = 298,
    Tags = 299,
    Tai_Le = 300,
    Tai_Tham = 301,
    Tai_Viet = 302,
    Tai_Xuan_Jing_Symbols = 303,
    Takri = 304,
    Tamil = 305,
    Tamil_Supplement = 306,
    Tangsa = 307,
    Tangut = 308,
    Tangut_Components = 309,
    Tangut_Supplement = 310,
    Telugu = 311,
    Thaana = 312,
    Thai = 313,
    Tibetan = 314,
    Tifinagh = 315,
    Tirhuta = 316,
    Todhri = 317,
    Toto = 318,
    Transport_and_Map_Symbols = 319,
    Tulu_Tigalari = 320,
    Ugaritic = 321,
    Unified_Canadian_Aboriginal_Syllabics = 322,
    Unified_Canadian_Aboriginal_Syllabics_Extended = 323,
    Unified_Canadian_Aboriginal_Syllabics_Extended_A = 324,
    Vai = 325,
    Variation_Selectors = 326,
    Variation_Selectors_Supplement = 327,
    Vedic_Extensions = 328,
    Vertical_Forms = 329,
    Vithkuqi = 330,
    Wancho = 331,
    Warang_Citi = 332,
    Yezidi = 333,
    Yi_Radicals = 334,
    Yi_Syllables = 335,
    Yijing_Hexagram_Symbols = 336,
    Zanabazar_Square = 337,
    Znamenny_Musical_Notation = 338,
};

enum class EastAsianWidth: uint8_t
{
    Ambiguous = 0,
    FullWidth = 1,
    HalfWidth = 2,
    Neutral = 3,
    Narrow = 4,
    Wide = 5,
    Unspecified = 6,
};

} // namespace unicode
