/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.MultiBucketAggregateBase;

public abstract class TermsAggregateBase<TBucket>
extends MultiBucketAggregateBase<TBucket> {
    @Nullable
    private final Long docCountErrorUpperBound;
    @Nullable
    private final Long sumOtherDocCount;

    protected TermsAggregateBase(AbstractBuilder<TBucket, ?> builder) {
        super(builder);
        this.docCountErrorUpperBound = ((AbstractBuilder)builder).docCountErrorUpperBound;
        this.sumOtherDocCount = ((AbstractBuilder)builder).sumOtherDocCount;
    }

    @Nullable
    public final Long docCountErrorUpperBound() {
        return this.docCountErrorUpperBound;
    }

    @Nullable
    public final Long sumOtherDocCount() {
        return this.sumOtherDocCount;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.docCountErrorUpperBound != null) {
            generator.writeKey("doc_count_error_upper_bound");
            generator.write(this.docCountErrorUpperBound.longValue());
        }
        if (this.sumOtherDocCount != null) {
            generator.writeKey("sum_other_doc_count");
            generator.write(this.sumOtherDocCount.longValue());
        }
    }

    protected static <TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>> void setupTermsAggregateBaseDeserializer(ObjectDeserializer<BuilderT> op, JsonpDeserializer<TBucket> tBucketDeserializer) {
        TermsAggregateBase.setupMultiBucketAggregateBaseDeserializer(op, tBucketDeserializer);
        op.add(AbstractBuilder::docCountErrorUpperBound, JsonpDeserializer.longDeserializer(), "doc_count_error_upper_bound");
        op.add(AbstractBuilder::sumOtherDocCount, JsonpDeserializer.longDeserializer(), "sum_other_doc_count");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.docCountErrorUpperBound);
        result = 31 * result + Objects.hashCode(this.sumOtherDocCount);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermsAggregateBase other = (TermsAggregateBase)o;
        return Objects.equals(this.docCountErrorUpperBound, other.docCountErrorUpperBound) && Objects.equals(this.sumOtherDocCount, other.sumOtherDocCount);
    }

    public static abstract class AbstractBuilder<TBucket, BuilderT extends AbstractBuilder<TBucket, BuilderT>>
    extends MultiBucketAggregateBase.AbstractBuilder<TBucket, BuilderT> {
        @Nullable
        private Long docCountErrorUpperBound;
        @Nullable
        private Long sumOtherDocCount;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(TermsAggregateBase<TBucket> o) {
            super(o);
            this.docCountErrorUpperBound = ((TermsAggregateBase)o).docCountErrorUpperBound;
            this.sumOtherDocCount = ((TermsAggregateBase)o).sumOtherDocCount;
        }

        protected AbstractBuilder(AbstractBuilder<TBucket, BuilderT> o) {
            super(o);
            this.docCountErrorUpperBound = o.docCountErrorUpperBound;
            this.sumOtherDocCount = o.sumOtherDocCount;
        }

        @Nonnull
        public final BuilderT docCountErrorUpperBound(@Nullable Long value) {
            this.docCountErrorUpperBound = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT sumOtherDocCount(@Nullable Long value) {
            this.sumOtherDocCount = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

