/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.internal.crt;

import java.util.Iterator;
import java.util.NoSuchElementException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.listener.PublisherListener;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.services.s3.internal.multipart.SdkPojoConversionUtils;
import software.amazon.awssdk.services.s3.model.CopyObjectRequest;
import software.amazon.awssdk.services.s3.model.UploadPartCopyRequest;
import software.amazon.awssdk.services.s3.multipart.S3MultipartExecutionAttribute;

@SdkInternalApi
public final class UploadPartCopyRequestIterable
implements SdkIterable<UploadPartCopyRequest> {
    private final String uploadId;
    private final long optimalPartSize;
    private final CopyObjectRequest copyObjectRequest;
    private final PublisherListener<Long> progressListener;
    private final long numberOfParts;
    private long remainingBytes;
    private int partNumber = 1;
    private long offset = 0L;
    private long progressUpdaterRemainingBytes = 10000L;
    private long scaledPartValue;

    public UploadPartCopyRequestIterable(String uploadId, long partSize, CopyObjectRequest copyObjectRequest, long remainingBytes) {
        this.uploadId = uploadId;
        this.optimalPartSize = partSize;
        this.copyObjectRequest = copyObjectRequest;
        this.numberOfParts = (long)Math.ceil((double)remainingBytes / (double)partSize);
        double partPercentage = 1.0 / (double)this.numberOfParts;
        this.scaledPartValue = (long)(partPercentage * 10000.0);
        this.remainingBytes = remainingBytes;
        this.progressListener = copyObjectRequest.overrideConfiguration().map(c -> (PublisherListener)c.executionAttributes().getAttribute(S3MultipartExecutionAttribute.JAVA_PROGRESS_LISTENER)).orElseGet(PublisherListener::noOp);
    }

    public Iterator<UploadPartCopyRequest> iterator() {
        return new UploadPartCopyRequestIterator();
    }

    private class UploadPartCopyRequestIterator
    implements Iterator<UploadPartCopyRequest> {
        private UploadPartCopyRequestIterator() {
        }

        @Override
        public boolean hasNext() {
            return UploadPartCopyRequestIterable.this.remainingBytes > 0L;
        }

        @Override
        public UploadPartCopyRequest next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No UploadPartCopyRequest available");
            }
            long partSize = Math.min(UploadPartCopyRequestIterable.this.optimalPartSize, UploadPartCopyRequestIterable.this.remainingBytes);
            String range = this.range(partSize);
            UploadPartCopyRequest uploadPartCopyRequest = SdkPojoConversionUtils.toUploadPartCopyRequest(UploadPartCopyRequestIterable.this.copyObjectRequest, UploadPartCopyRequestIterable.this.partNumber, UploadPartCopyRequestIterable.this.uploadId, range);
            this.updateProgressListener();
            UploadPartCopyRequestIterable.this.partNumber++;
            UploadPartCopyRequestIterable.this.offset += partSize;
            UploadPartCopyRequestIterable.this.remainingBytes -= partSize;
            return uploadPartCopyRequest;
        }

        private void updateProgressListener() {
            if ((long)UploadPartCopyRequestIterable.this.partNumber == UploadPartCopyRequestIterable.this.numberOfParts) {
                UploadPartCopyRequestIterable.this.progressListener.subscriberOnNext((Object)UploadPartCopyRequestIterable.this.progressUpdaterRemainingBytes);
                UploadPartCopyRequestIterable.this.progressUpdaterRemainingBytes = 0L;
            } else {
                UploadPartCopyRequestIterable.this.progressListener.subscriberOnNext((Object)UploadPartCopyRequestIterable.this.scaledPartValue);
                UploadPartCopyRequestIterable.this.progressUpdaterRemainingBytes -= UploadPartCopyRequestIterable.this.scaledPartValue;
            }
        }

        private String range(long partSize) {
            return "bytes=" + UploadPartCopyRequestIterable.this.offset + "-" + (UploadPartCopyRequestIterable.this.offset + partSize - 1L);
        }
    }
}

