
use builtin;
use str;

set edit:completion:arg-completer[satty] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'satty'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'satty'= {
            cand -c 'Path to the config file. Otherwise will be read from XDG_CONFIG_DIR/satty/config.toml'
            cand --config 'Path to the config file. Otherwise will be read from XDG_CONFIG_DIR/satty/config.toml'
            cand -f 'Path to input image or ''-'' to read from stdin'
            cand --filename 'Path to input image or ''-'' to read from stdin'
            cand -o 'Filename to use for saving action or ''-'' to print to stdout. Omit to disable saving to file. Might contain format specifiers: <https://docs.rs/chrono/latest/chrono/format/strftime/index.html>'
            cand --output-filename 'Filename to use for saving action or ''-'' to print to stdout. Omit to disable saving to file. Might contain format specifiers: <https://docs.rs/chrono/latest/chrono/format/strftime/index.html>'
            cand --corner-roundness 'Draw corners of rectangles round if the value is greater than 0 (Defaults to 12) (0 disables rounded corners)'
            cand --initial-tool 'Select the tool on startup'
            cand --init-tool 'Select the tool on startup'
            cand --copy-command 'Configure the command to be called on copy, for example `wl-copy`'
            cand --annotation-size-factor 'Increase or decrease the size of the annotations'
            cand --actions-on-enter 'Actions to perform when pressing Enter'
            cand --actions-on-escape 'Actions to perform when pressing Escape'
            cand --actions-on-right-click 'Actions to perform when hitting the copy Button'
            cand --font-family 'Font family to use for text annotations'
            cand --font-style 'Font style to use for text annotations'
            cand --primary-highlighter 'The primary highlighter to use, secondary is accessible with CTRL'
            cand --brush-smooth-history-size 'Experimental feature: How many points to use for the brush smoothing algorithm. 0 disables smoothing. The default value is 0 (disabled)'
            cand --action-on-enter 'Action to perform when pressing Enter. Preferably use the `actions_on_enter` option instead'
            cand --fullscreen 'Start Satty in fullscreen mode'
            cand --early-exit 'Exit directly after copy/save action'
            cand --save-after-copy 'After copying the screenshot, save it to a file as well Preferably use the `action_on_copy` option instead'
            cand -d 'Hide toolbars by default'
            cand --default-hide-toolbars 'Hide toolbars by default'
            cand --focus-toggles-toolbars 'Experimental: Whether to toggle toolbars based on focus. Doesn''t affect initial state'
            cand --default-fill-shapes 'Experimental feature: Fill shapes by default'
            cand --disable-notifications 'Disable notifications'
            cand --profile-startup 'Print profiling'
            cand --no-window-decoration 'Disable the window decoration (title bar, borders, etc.) Please note that the compositor has the final say in this. Requires xdg-decoration-unstable-v1'
            cand --right-click-copy 'Right click to copy. Preferably use the `action_on_right_click` option instead'
            cand -h 'Print help'
            cand --help 'Print help'
            cand -V 'Print version'
            cand --version 'Print version'
        }
    ]
    $completions[$command]
}
