﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/omics/Omics_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace Omics {
namespace Model {

/**
 * <p>A run group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/RunGroupListItem">AWS
 * API Reference</a></p>
 */
class RunGroupListItem {
 public:
  AWS_OMICS_API RunGroupListItem() = default;
  AWS_OMICS_API RunGroupListItem(Aws::Utils::Json::JsonView jsonValue);
  AWS_OMICS_API RunGroupListItem& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_OMICS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The group's ARN.</p>
   */
  inline const Aws::String& GetArn() const { return m_arn; }
  inline bool ArnHasBeenSet() const { return m_arnHasBeenSet; }
  template <typename ArnT = Aws::String>
  void SetArn(ArnT&& value) {
    m_arnHasBeenSet = true;
    m_arn = std::forward<ArnT>(value);
  }
  template <typename ArnT = Aws::String>
  RunGroupListItem& WithArn(ArnT&& value) {
    SetArn(std::forward<ArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's ID.</p>
   */
  inline const Aws::String& GetId() const { return m_id; }
  inline bool IdHasBeenSet() const { return m_idHasBeenSet; }
  template <typename IdT = Aws::String>
  void SetId(IdT&& value) {
    m_idHasBeenSet = true;
    m_id = std::forward<IdT>(value);
  }
  template <typename IdT = Aws::String>
  RunGroupListItem& WithId(IdT&& value) {
    SetId(std::forward<IdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's name.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  RunGroupListItem& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's maximum CPU count setting.</p>
   */
  inline int GetMaxCpus() const { return m_maxCpus; }
  inline bool MaxCpusHasBeenSet() const { return m_maxCpusHasBeenSet; }
  inline void SetMaxCpus(int value) {
    m_maxCpusHasBeenSet = true;
    m_maxCpus = value;
  }
  inline RunGroupListItem& WithMaxCpus(int value) {
    SetMaxCpus(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's maximum concurrent run setting.</p>
   */
  inline int GetMaxRuns() const { return m_maxRuns; }
  inline bool MaxRunsHasBeenSet() const { return m_maxRunsHasBeenSet; }
  inline void SetMaxRuns(int value) {
    m_maxRunsHasBeenSet = true;
    m_maxRuns = value;
  }
  inline RunGroupListItem& WithMaxRuns(int value) {
    SetMaxRuns(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The group's maximum duration setting in minutes.</p>
   */
  inline int GetMaxDuration() const { return m_maxDuration; }
  inline bool MaxDurationHasBeenSet() const { return m_maxDurationHasBeenSet; }
  inline void SetMaxDuration(int value) {
    m_maxDurationHasBeenSet = true;
    m_maxDuration = value;
  }
  inline RunGroupListItem& WithMaxDuration(int value) {
    SetMaxDuration(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>When the group was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  inline bool CreationTimeHasBeenSet() const { return m_creationTimeHasBeenSet; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  RunGroupListItem& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The maximum GPUs that can be used by a run group. </p>
   */
  inline int GetMaxGpus() const { return m_maxGpus; }
  inline bool MaxGpusHasBeenSet() const { return m_maxGpusHasBeenSet; }
  inline void SetMaxGpus(int value) {
    m_maxGpusHasBeenSet = true;
    m_maxGpus = value;
  }
  inline RunGroupListItem& WithMaxGpus(int value) {
    SetMaxGpus(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_arn;
  bool m_arnHasBeenSet = false;

  Aws::String m_id;
  bool m_idHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  int m_maxCpus{0};
  bool m_maxCpusHasBeenSet = false;

  int m_maxRuns{0};
  bool m_maxRunsHasBeenSet = false;

  int m_maxDuration{0};
  bool m_maxDurationHasBeenSet = false;

  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  int m_maxGpus{0};
  bool m_maxGpusHasBeenSet = false;
};

}  // namespace Model
}  // namespace Omics
}  // namespace Aws
