/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.asynchronous.context;

import java.util.function.LongSupplier;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.Nullable;
import org.opensearch.commons.authuser.User;
import org.opensearch.search.asynchronous.context.AsynchronousSearchContextId;
import org.opensearch.search.asynchronous.context.state.AsynchronousSearchState;
import org.opensearch.search.asynchronous.listener.AsynchronousSearchProgressListener;
import org.opensearch.search.asynchronous.response.AsynchronousSearchResponse;

public abstract class AsynchronousSearchContext {
    protected final AsynchronousSearchContextId asynchronousSearchContextId;
    protected final LongSupplier currentTimeSupplier;
    protected volatile AsynchronousSearchState currentStage = AsynchronousSearchState.INIT;
    protected volatile AsynchronousSearchProgressListener asynchronousSearchProgressListener;

    public AsynchronousSearchContext(AsynchronousSearchContextId asynchronousSearchContextId, LongSupplier currentTimeSupplier) {
        this.asynchronousSearchContextId = asynchronousSearchContextId;
        this.currentTimeSupplier = currentTimeSupplier;
    }

    @Nullable
    public AsynchronousSearchProgressListener getAsynchronousSearchProgressListener() {
        return this.asynchronousSearchProgressListener;
    }

    public AsynchronousSearchState getAsynchronousSearchState() {
        return this.currentStage;
    }

    public boolean isRunning() {
        return this.getAsynchronousSearchState() == AsynchronousSearchState.RUNNING;
    }

    public AsynchronousSearchContextId getContextId() {
        return this.asynchronousSearchContextId;
    }

    public abstract String getAsynchronousSearchId();

    public abstract long getExpirationTimeMillis();

    public abstract long getStartTimeMillis();

    @Nullable
    public abstract SearchResponse getSearchResponse();

    @Nullable
    public abstract Exception getSearchError();

    @Nullable
    public abstract User getUser();

    public boolean isExpired() {
        return this.getExpirationTimeMillis() < this.currentTimeSupplier.getAsLong();
    }

    public AsynchronousSearchResponse getAsynchronousSearchResponse() {
        return new AsynchronousSearchResponse(this.getAsynchronousSearchId(), this.getAsynchronousSearchState(), this.getStartTimeMillis(), this.getExpirationTimeMillis(), this.getSearchResponse(), this.getSearchError());
    }

    public void setState(AsynchronousSearchState targetState) {
        this.currentStage = targetState;
    }
}

