/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTransitGatewayPolicyTablesResponse;
import software.amazon.awssdk.services.ec2.model.TransitGatewayPolicyTable;

public class DescribeTransitGatewayPolicyTablesIterable
implements SdkIterable<DescribeTransitGatewayPolicyTablesResponse> {
    private final Ec2Client client;
    private final DescribeTransitGatewayPolicyTablesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeTransitGatewayPolicyTablesIterable(Ec2Client client, DescribeTransitGatewayPolicyTablesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeTransitGatewayPolicyTablesResponseFetcher();
    }

    public Iterator<DescribeTransitGatewayPolicyTablesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayPolicyTable> transitGatewayPolicyTables() {
        Function<DescribeTransitGatewayPolicyTablesResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayPolicyTables() != null) {
                return response.transitGatewayPolicyTables().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeTransitGatewayPolicyTablesResponseFetcher
    implements SyncPageFetcher<DescribeTransitGatewayPolicyTablesResponse> {
        private DescribeTransitGatewayPolicyTablesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeTransitGatewayPolicyTablesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeTransitGatewayPolicyTablesResponse nextPage(DescribeTransitGatewayPolicyTablesResponse previousPage) {
            if (previousPage == null) {
                return DescribeTransitGatewayPolicyTablesIterable.this.client.describeTransitGatewayPolicyTables(DescribeTransitGatewayPolicyTablesIterable.this.firstRequest);
            }
            return DescribeTransitGatewayPolicyTablesIterable.this.client.describeTransitGatewayPolicyTables((DescribeTransitGatewayPolicyTablesRequest)((Object)DescribeTransitGatewayPolicyTablesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

