/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.quantizationservice;

import java.io.IOException;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.knn.index.engine.faiss.QFrameBitEncoder;
import org.opensearch.knn.index.vectorvalues.KNNVectorValues;
import org.opensearch.knn.quantization.models.requests.TrainingRequest;

final class KNNVectorQuantizationTrainingRequest<T>
extends TrainingRequest<T> {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNVectorQuantizationTrainingRequest.class);
    private final Supplier<KNNVectorValues<T>> knnVectorValuesSupplier;
    private KNNVectorValues<T> knnVectorValues;
    private int lastIndex;

    KNNVectorQuantizationTrainingRequest(Supplier<KNNVectorValues<T>> knnVectorValuesSupplier, long liveDocs) {
        this(knnVectorValuesSupplier, liveDocs, QFrameBitEncoder.DEFAULT_ENABLE_RANDOM_ROTATION);
    }

    KNNVectorQuantizationTrainingRequest(Supplier<KNNVectorValues<T>> knnVectorValuesSupplier, long liveDocs, boolean doRandomRotation) {
        super((int)liveDocs, doRandomRotation);
        this.knnVectorValuesSupplier = knnVectorValuesSupplier;
        this.resetVectorValues();
    }

    @Override
    public T getVectorAtThePosition(int position) throws IOException {
        while (this.lastIndex <= position) {
            ++this.lastIndex;
            if (this.knnVectorValues.docId() == Integer.MAX_VALUE) {
                return null;
            }
            this.knnVectorValues.nextDoc();
        }
        return this.knnVectorValues.getVector();
    }

    @Override
    public void resetVectorValues() {
        this.knnVectorValues = this.knnVectorValuesSupplier.get();
        this.lastIndex = 0;
    }
}

