/*
// $Id: //open/dev/farrago/src/net/sf/farrago/runtime/FarragoGeneratedCodeExamples.java#12 $
// Farrago is an extensible data management system.
// Copyright (C) 2005-2009 The Eigenbase Project
// Copyright (C) 2005-2009 SQLstream, Inc.
// Copyright (C) 2005-2009 LucidEra, Inc.
// Portions Copyright (C) 2003-2009 John V. Sichi
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the Free
// Software Foundation; either version 2 of the License, or (at your option)
// any later version approved by The Eigenbase Project.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
package net.sf.farrago.runtime;

import java.nio.*;


/**
 * Sandbox for experiments in code generation.
 *
 * <p>THIS IS NOT A TEST! (Well not as such.)
 *
 * <p>This code fragments in this class serves two purposes:
 *
 * <ul>
 * <li>As an example of the code produced by a code-generator (cross-referenced
 * by javadoc comments in the code-generator); and</li>
 * <li>To help analyse the impact of changing runtime data structures. Suppose
 * we were to rename the {@link
 * FarragoRuntimeContext#newFennelTransformTupleIter} method. Then the {@link
 * #exampleFarragoTransform()} method would fail to compile. We can find the
 * generator of this code by finding all javadoc references to the {@link
 * #exampleFarragoTransform()} method.
 * </ul>
 *
 * @author Julian Hyde
 * @version $Id: //open/dev/farrago/src/net/sf/farrago/runtime/FarragoGeneratedCodeExamples.java#12 $
 */
public class FarragoGeneratedCodeExamples
{
    //~ Methods ----------------------------------------------------------------

    public void exampleFarragoTransform()
    {
        FarragoRuntimeContext connection = null;
        ByteBuffer outputBuffer = ByteBuffer.allocate(1);
        String farragoTransformStreamName =
            "JavaTransformExecStream global name";

        FarragoTransform.InputBinding [] inputBindings =
            new FarragoTransform.InputBinding[] {
                new FarragoTransform.InputBinding("SomeExecStream#1:100", 0),
            };

        // Constructed by JavaTransformExecStream
        FarragoTransform transform = new ExampleGeneratedFarragoTransform();

        // To initialize, JavaTransformExecStream calls:
        transform.init(connection, farragoTransformStreamName, inputBindings);

        // then to perform work it repeatedly calls:
        transform.execute(outputBuffer, 1000);
    }

    //~ Inner Classes ----------------------------------------------------------

    /**
     * ExampleGeneratedFarragoTransform an example of what a generated
     * FarragoTransform looks like. See {@link
     * FarragoGeneratedCodeExamples#exampleFarragoTransform()}.
     */
    public class ExampleGeneratedFarragoTransform
        extends FarragoTransformImpl
        implements FarragoTransform
    {
        public void init(
            FarragoRuntimeContext connection,
            String farragoTransformStreamName,
            FarragoTransform.InputBinding [] inputBindings)
        {
            super.init(

                // tuple writer generated by IteratorToFennelConverter
                new FennelTupleWriter() {
                    protected void marshalTupleOrThrow(
                        ByteBuffer sliceBuffer,
                        Object object)
                    {
                        // ...
                    }
                },

                // To do any actual work, this TupleIter is wrapped in
                // another TupleIter, such as a CalcTupleIter,
                // generated by one or more JavaRels.  There may be
                // multiple newFennelTransformTupleIter calls and an
                // iterator-based join here.
                connection.newFennelTransformTupleIter(

                    // tuple reader generated by FennelToIteratorConverter
                    new FennelTupleReader() {
                        public Object unmarshalTuple(
                            ByteBuffer byteBuffer,
                            byte [] byteArray,
                            ByteBuffer sliceBuffer)
                        {
                            return null;
                        }
                    },
                    farragoTransformStreamName,
                    "SomeExecStream#1:100", // the input ExecStream's name
                    inputBindings,
                    null));
        }
    }
}

// End FarragoGeneratedCodeExamples.java
