//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridnetwork

const (
	moduleName    = "armhybridnetwork"
	moduleVersion = "v2.0.0-beta.1"
)

// ActionType - Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
type ActionType string

const (
	ActionTypeInternal ActionType = "Internal"
)

// PossibleActionTypeValues returns the possible values for the ActionType const type.
func PossibleActionTypeValues() []ActionType {
	return []ActionType{
		ActionTypeInternal,
	}
}

// CreatedByType - The type of identity that created the resource.
type CreatedByType string

const (
	CreatedByTypeApplication     CreatedByType = "Application"
	CreatedByTypeKey             CreatedByType = "Key"
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	CreatedByTypeUser            CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns the possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{
		CreatedByTypeApplication,
		CreatedByTypeKey,
		CreatedByTypeManagedIdentity,
		CreatedByTypeUser,
	}
}

// DeviceType - The type of the device.
type DeviceType string

const (
	DeviceTypeAzureStackEdge DeviceType = "AzureStackEdge"
	DeviceTypeUnknown        DeviceType = "Unknown"
)

// PossibleDeviceTypeValues returns the possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{
		DeviceTypeAzureStackEdge,
		DeviceTypeUnknown,
	}
}

// DiskCreateOptionTypes - Specifies how the virtual machine should be created.
type DiskCreateOptionTypes string

const (
	DiskCreateOptionTypesEmpty   DiskCreateOptionTypes = "Empty"
	DiskCreateOptionTypesUnknown DiskCreateOptionTypes = "Unknown"
)

// PossibleDiskCreateOptionTypesValues returns the possible values for the DiskCreateOptionTypes const type.
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return []DiskCreateOptionTypes{
		DiskCreateOptionTypesEmpty,
		DiskCreateOptionTypesUnknown,
	}
}

// HTTPMethod - The http method of the request.
type HTTPMethod string

const (
	HTTPMethodDelete  HTTPMethod = "Delete"
	HTTPMethodGet     HTTPMethod = "Get"
	HTTPMethodPatch   HTTPMethod = "Patch"
	HTTPMethodPost    HTTPMethod = "Post"
	HTTPMethodPut     HTTPMethod = "Put"
	HTTPMethodUnknown HTTPMethod = "Unknown"
)

// PossibleHTTPMethodValues returns the possible values for the HTTPMethod const type.
func PossibleHTTPMethodValues() []HTTPMethod {
	return []HTTPMethod{
		HTTPMethodDelete,
		HTTPMethodGet,
		HTTPMethodPatch,
		HTTPMethodPost,
		HTTPMethodPut,
		HTTPMethodUnknown,
	}
}

// IPAllocationMethod - IP address allocation method.
type IPAllocationMethod string

const (
	IPAllocationMethodDynamic IPAllocationMethod = "Dynamic"
	IPAllocationMethodStatic  IPAllocationMethod = "Static"
	IPAllocationMethodUnknown IPAllocationMethod = "Unknown"
)

// PossibleIPAllocationMethodValues returns the possible values for the IPAllocationMethod const type.
func PossibleIPAllocationMethodValues() []IPAllocationMethod {
	return []IPAllocationMethod{
		IPAllocationMethodDynamic,
		IPAllocationMethodStatic,
		IPAllocationMethodUnknown,
	}
}

// IPVersion - IP address version.
type IPVersion string

const (
	IPVersionIPv4    IPVersion = "IPv4"
	IPVersionUnknown IPVersion = "Unknown"
)

// PossibleIPVersionValues returns the possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{
		IPVersionIPv4,
		IPVersionUnknown,
	}
}

// NetworkFunctionRoleConfigurationType - Role type.
type NetworkFunctionRoleConfigurationType string

const (
	NetworkFunctionRoleConfigurationTypeUnknown        NetworkFunctionRoleConfigurationType = "Unknown"
	NetworkFunctionRoleConfigurationTypeVirtualMachine NetworkFunctionRoleConfigurationType = "VirtualMachine"
)

// PossibleNetworkFunctionRoleConfigurationTypeValues returns the possible values for the NetworkFunctionRoleConfigurationType const type.
func PossibleNetworkFunctionRoleConfigurationTypeValues() []NetworkFunctionRoleConfigurationType {
	return []NetworkFunctionRoleConfigurationType{
		NetworkFunctionRoleConfigurationTypeUnknown,
		NetworkFunctionRoleConfigurationTypeVirtualMachine,
	}
}

// NetworkFunctionType - The network function type.
type NetworkFunctionType string

const (
	NetworkFunctionTypeContainerizedNetworkFunction NetworkFunctionType = "ContainerizedNetworkFunction"
	NetworkFunctionTypeUnknown                      NetworkFunctionType = "Unknown"
	NetworkFunctionTypeVirtualNetworkFunction       NetworkFunctionType = "VirtualNetworkFunction"
)

// PossibleNetworkFunctionTypeValues returns the possible values for the NetworkFunctionType const type.
func PossibleNetworkFunctionTypeValues() []NetworkFunctionType {
	return []NetworkFunctionType{
		NetworkFunctionTypeContainerizedNetworkFunction,
		NetworkFunctionTypeUnknown,
		NetworkFunctionTypeVirtualNetworkFunction,
	}
}

// OperatingSystemTypes - The OS type.
type OperatingSystemTypes string

const (
	OperatingSystemTypesLinux   OperatingSystemTypes = "Linux"
	OperatingSystemTypesUnknown OperatingSystemTypes = "Unknown"
	OperatingSystemTypesWindows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns the possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{
		OperatingSystemTypesLinux,
		OperatingSystemTypesUnknown,
		OperatingSystemTypesWindows,
	}
}

// OperationalState - The operational state of the role instance.
type OperationalState string

const (
	OperationalStateRunning  OperationalState = "Running"
	OperationalStateStarting OperationalState = "Starting"
	OperationalStateStopped  OperationalState = "Stopped"
	OperationalStateStopping OperationalState = "Stopping"
	OperationalStateUnknown  OperationalState = "Unknown"
)

// PossibleOperationalStateValues returns the possible values for the OperationalState const type.
func PossibleOperationalStateValues() []OperationalState {
	return []OperationalState{
		OperationalStateRunning,
		OperationalStateStarting,
		OperationalStateStopped,
		OperationalStateStopping,
		OperationalStateUnknown,
	}
}

// Origin - The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
// value is "user,system"
type Origin string

const (
	OriginSystem     Origin = "system"
	OriginUser       Origin = "user"
	OriginUserSystem Origin = "user,system"
)

// PossibleOriginValues returns the possible values for the Origin const type.
func PossibleOriginValues() []Origin {
	return []Origin{
		OriginSystem,
		OriginUser,
		OriginUserSystem,
	}
}

// ProvisioningState - The current provisioning state.
type ProvisioningState string

const (
	ProvisioningStateAccepted  ProvisioningState = "Accepted"
	ProvisioningStateCanceled  ProvisioningState = "Canceled"
	ProvisioningStateDeleted   ProvisioningState = "Deleted"
	ProvisioningStateDeleting  ProvisioningState = "Deleting"
	ProvisioningStateFailed    ProvisioningState = "Failed"
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
	ProvisioningStateUnknown   ProvisioningState = "Unknown"
)

// PossibleProvisioningStateValues returns the possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{
		ProvisioningStateAccepted,
		ProvisioningStateCanceled,
		ProvisioningStateDeleted,
		ProvisioningStateDeleting,
		ProvisioningStateFailed,
		ProvisioningStateSucceeded,
		ProvisioningStateUnknown,
	}
}

// SKUDeploymentMode - The sku deployment mode.
type SKUDeploymentMode string

const (
	SKUDeploymentModeAzure           SKUDeploymentMode = "Azure"
	SKUDeploymentModePrivateEdgeZone SKUDeploymentMode = "PrivateEdgeZone"
	SKUDeploymentModeUnknown         SKUDeploymentMode = "Unknown"
)

// PossibleSKUDeploymentModeValues returns the possible values for the SKUDeploymentMode const type.
func PossibleSKUDeploymentModeValues() []SKUDeploymentMode {
	return []SKUDeploymentMode{
		SKUDeploymentModeAzure,
		SKUDeploymentModePrivateEdgeZone,
		SKUDeploymentModeUnknown,
	}
}

// SKUType - Sku type.
type SKUType string

const (
	SKUTypeEvolvedPacketCore SKUType = "EvolvedPacketCore"
	SKUTypeFirewall          SKUType = "Firewall"
	SKUTypeSDWAN             SKUType = "SDWAN"
	SKUTypeUnknown           SKUType = "Unknown"
)

// PossibleSKUTypeValues returns the possible values for the SKUType const type.
func PossibleSKUTypeValues() []SKUType {
	return []SKUType{
		SKUTypeEvolvedPacketCore,
		SKUTypeFirewall,
		SKUTypeSDWAN,
		SKUTypeUnknown,
	}
}

// Status - The current device status.
type Status string

const (
	StatusDeleted       Status = "Deleted"
	StatusNotRegistered Status = "NotRegistered"
	StatusRegistered    Status = "Registered"
	StatusUnknown       Status = "Unknown"
)

// PossibleStatusValues returns the possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{
		StatusDeleted,
		StatusNotRegistered,
		StatusRegistered,
		StatusUnknown,
	}
}

// VMSwitchType - The type of the VM switch.
type VMSwitchType string

const (
	VMSwitchTypeLan        VMSwitchType = "Lan"
	VMSwitchTypeManagement VMSwitchType = "Management"
	VMSwitchTypeUnknown    VMSwitchType = "Unknown"
	VMSwitchTypeWan        VMSwitchType = "Wan"
)

// PossibleVMSwitchTypeValues returns the possible values for the VMSwitchType const type.
func PossibleVMSwitchTypeValues() []VMSwitchType {
	return []VMSwitchType{
		VMSwitchTypeLan,
		VMSwitchTypeManagement,
		VMSwitchTypeUnknown,
		VMSwitchTypeWan,
	}
}

// VendorProvisioningState - The current vendor provisioning state.
type VendorProvisioningState string

const (
	VendorProvisioningStateDeprovisioned            VendorProvisioningState = "Deprovisioned"
	VendorProvisioningStateNotProvisioned           VendorProvisioningState = "NotProvisioned"
	VendorProvisioningStateProvisioned              VendorProvisioningState = "Provisioned"
	VendorProvisioningStateProvisioning             VendorProvisioningState = "Provisioning"
	VendorProvisioningStateUnknown                  VendorProvisioningState = "Unknown"
	VendorProvisioningStateUserDataValidationFailed VendorProvisioningState = "UserDataValidationFailed"
)

// PossibleVendorProvisioningStateValues returns the possible values for the VendorProvisioningState const type.
func PossibleVendorProvisioningStateValues() []VendorProvisioningState {
	return []VendorProvisioningState{
		VendorProvisioningStateDeprovisioned,
		VendorProvisioningStateNotProvisioned,
		VendorProvisioningStateProvisioned,
		VendorProvisioningStateProvisioning,
		VendorProvisioningStateUnknown,
		VendorProvisioningStateUserDataValidationFailed,
	}
}

// VirtualMachineSizeTypes - The size of the virtual machine.
type VirtualMachineSizeTypes string

const (
	VirtualMachineSizeTypesStandardD11V2  VirtualMachineSizeTypes = "Standard_D11_v2"
	VirtualMachineSizeTypesStandardD12V2  VirtualMachineSizeTypes = "Standard_D12_v2"
	VirtualMachineSizeTypesStandardD13V2  VirtualMachineSizeTypes = "Standard_D13_v2"
	VirtualMachineSizeTypesStandardD1V2   VirtualMachineSizeTypes = "Standard_D1_v2"
	VirtualMachineSizeTypesStandardD2V2   VirtualMachineSizeTypes = "Standard_D2_v2"
	VirtualMachineSizeTypesStandardD3V2   VirtualMachineSizeTypes = "Standard_D3_v2"
	VirtualMachineSizeTypesStandardD4V2   VirtualMachineSizeTypes = "Standard_D4_v2"
	VirtualMachineSizeTypesStandardD5V2   VirtualMachineSizeTypes = "Standard_D5_v2"
	VirtualMachineSizeTypesStandardDS11V2 VirtualMachineSizeTypes = "Standard_DS11_v2"
	VirtualMachineSizeTypesStandardDS12V2 VirtualMachineSizeTypes = "Standard_DS12_v2"
	VirtualMachineSizeTypesStandardDS13V2 VirtualMachineSizeTypes = "Standard_DS13_v2"
	VirtualMachineSizeTypesStandardDS1V2  VirtualMachineSizeTypes = "Standard_DS1_v2"
	VirtualMachineSizeTypesStandardDS2V2  VirtualMachineSizeTypes = "Standard_DS2_v2"
	VirtualMachineSizeTypesStandardDS3V2  VirtualMachineSizeTypes = "Standard_DS3_v2"
	VirtualMachineSizeTypesStandardDS4V2  VirtualMachineSizeTypes = "Standard_DS4_v2"
	VirtualMachineSizeTypesStandardDS5V2  VirtualMachineSizeTypes = "Standard_DS5_v2"
	VirtualMachineSizeTypesStandardF1     VirtualMachineSizeTypes = "Standard_F1"
	VirtualMachineSizeTypesStandardF16    VirtualMachineSizeTypes = "Standard_F16"
	VirtualMachineSizeTypesStandardF16S   VirtualMachineSizeTypes = "Standard_F16s"
	VirtualMachineSizeTypesStandardF1S    VirtualMachineSizeTypes = "Standard_F1s"
	VirtualMachineSizeTypesStandardF2     VirtualMachineSizeTypes = "Standard_F2"
	VirtualMachineSizeTypesStandardF2S    VirtualMachineSizeTypes = "Standard_F2s"
	VirtualMachineSizeTypesStandardF4     VirtualMachineSizeTypes = "Standard_F4"
	VirtualMachineSizeTypesStandardF4S    VirtualMachineSizeTypes = "Standard_F4s"
	VirtualMachineSizeTypesStandardF8     VirtualMachineSizeTypes = "Standard_F8"
	VirtualMachineSizeTypesStandardF8S    VirtualMachineSizeTypes = "Standard_F8s"
	VirtualMachineSizeTypesUnknown        VirtualMachineSizeTypes = "Unknown"
)

// PossibleVirtualMachineSizeTypesValues returns the possible values for the VirtualMachineSizeTypes const type.
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return []VirtualMachineSizeTypes{
		VirtualMachineSizeTypesStandardD11V2,
		VirtualMachineSizeTypesStandardD12V2,
		VirtualMachineSizeTypesStandardD13V2,
		VirtualMachineSizeTypesStandardD1V2,
		VirtualMachineSizeTypesStandardD2V2,
		VirtualMachineSizeTypesStandardD3V2,
		VirtualMachineSizeTypesStandardD4V2,
		VirtualMachineSizeTypesStandardD5V2,
		VirtualMachineSizeTypesStandardDS11V2,
		VirtualMachineSizeTypesStandardDS12V2,
		VirtualMachineSizeTypesStandardDS13V2,
		VirtualMachineSizeTypesStandardDS1V2,
		VirtualMachineSizeTypesStandardDS2V2,
		VirtualMachineSizeTypesStandardDS3V2,
		VirtualMachineSizeTypesStandardDS4V2,
		VirtualMachineSizeTypesStandardDS5V2,
		VirtualMachineSizeTypesStandardF1,
		VirtualMachineSizeTypesStandardF16,
		VirtualMachineSizeTypesStandardF16S,
		VirtualMachineSizeTypesStandardF1S,
		VirtualMachineSizeTypesStandardF2,
		VirtualMachineSizeTypesStandardF2S,
		VirtualMachineSizeTypesStandardF4,
		VirtualMachineSizeTypesStandardF4S,
		VirtualMachineSizeTypesStandardF8,
		VirtualMachineSizeTypesStandardF8S,
		VirtualMachineSizeTypesUnknown,
	}
}
