//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdatashare

import "time"

// ADLSGen1FileDataSet - An ADLS Gen 1 file data set.
type ADLSGen1FileDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen 1 file data set properties.
	Properties *ADLSGen1FileProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen1FileDataSet.
func (a *ADLSGen1FileDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen1FileProperties - Properties of the ADLS Gen1 file data set.
type ADLSGen1FileProperties struct {
	// REQUIRED; The ADLS account name.
	AccountName *string `json:"accountName,omitempty"`

	// REQUIRED; The file name in the ADLS account.
	FileName *string `json:"fileName,omitempty"`

	// REQUIRED; The folder path within the ADLS account.
	FolderPath *string `json:"folderPath,omitempty"`

	// REQUIRED; Resource group of ADLS account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Subscription id of ADLS account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// ADLSGen1FolderDataSet - An ADLS Gen 1 folder data set.
type ADLSGen1FolderDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen 1 folder data set properties.
	Properties *ADLSGen1FolderProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen1FolderDataSet.
func (a *ADLSGen1FolderDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen1FolderProperties - Properties of the ADLS Gen1 folder data set.
type ADLSGen1FolderProperties struct {
	// REQUIRED; The ADLS account name.
	AccountName *string `json:"accountName,omitempty"`

	// REQUIRED; The folder path within the ADLS account.
	FolderPath *string `json:"folderPath,omitempty"`

	// REQUIRED; Resource group of ADLS account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Subscription id of ADLS account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// ADLSGen2FileDataSet - An ADLS Gen 2 file data set.
type ADLSGen2FileDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen 2 file data set properties.
	Properties *ADLSGen2FileProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen2FileDataSet.
func (a *ADLSGen2FileDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileDataSetMapping - An ADLS Gen2 file data set mapping.
type ADLSGen2FileDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen2 file data set mapping properties.
	Properties *ADLSGen2FileDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type ADLSGen2FileDataSetMapping.
func (a *ADLSGen2FileDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileDataSetMappingProperties - ADLS Gen 2 file data set mapping property bag.
type ADLSGen2FileDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; File path within the file system.
	FilePath *string `json:"filePath,omitempty"`

	// REQUIRED; File system to which the file belongs.
	FileSystem *string `json:"fileSystem,omitempty"`

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// Type of output file
	OutputType *OutputType `json:"outputType,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ADLSGen2FileProperties - Properties of the ADLS Gen2 file data set.
type ADLSGen2FileProperties struct {
	// REQUIRED; File path within the file system.
	FilePath *string `json:"filePath,omitempty"`

	// REQUIRED; File system to which the file belongs.
	FileSystem *string `json:"fileSystem,omitempty"`

	// REQUIRED; Resource group of storage account
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// ADLSGen2FileSystemDataSet - An ADLS Gen 2 file system data set.
type ADLSGen2FileSystemDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen 2 file system data set properties.
	Properties *ADLSGen2FileSystemProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen2FileSystemDataSet.
func (a *ADLSGen2FileSystemDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileSystemDataSetMapping - An ADLS Gen2 file system data set mapping.
type ADLSGen2FileSystemDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen2 file system data set mapping properties.
	Properties *ADLSGen2FileSystemDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type ADLSGen2FileSystemDataSetMapping.
func (a *ADLSGen2FileSystemDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FileSystemDataSetMappingProperties - ADLS Gen 2 file system data set mapping property bag.
type ADLSGen2FileSystemDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; The file system name.
	FileSystem *string `json:"fileSystem,omitempty"`

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ADLSGen2FileSystemProperties - Properties of the ADLS Gen2 file system data set.
type ADLSGen2FileSystemProperties struct {
	// REQUIRED; The file system name.
	FileSystem *string `json:"fileSystem,omitempty"`

	// REQUIRED; Resource group of storage account
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// ADLSGen2FolderDataSet - An ADLS Gen 2 folder data set.
type ADLSGen2FolderDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen 2 folder data set properties.
	Properties *ADLSGen2FolderProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type ADLSGen2FolderDataSet.
func (a *ADLSGen2FolderDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FolderDataSetMapping - An ADLS Gen2 folder data set mapping.
type ADLSGen2FolderDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; ADLS Gen2 folder data set mapping properties.
	Properties *ADLSGen2FolderDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type ADLSGen2FolderDataSetMapping.
func (a *ADLSGen2FolderDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       a.Kind,
		ID:         a.ID,
		Name:       a.Name,
		SystemData: a.SystemData,
		Type:       a.Type,
	}
}

// ADLSGen2FolderDataSetMappingProperties - ADLS Gen 2 folder data set mapping property bag.
type ADLSGen2FolderDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; File system to which the folder belongs.
	FileSystem *string `json:"fileSystem,omitempty"`

	// REQUIRED; Folder path within the file system.
	FolderPath *string `json:"folderPath,omitempty"`

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ADLSGen2FolderProperties - Properties of the ADLS Gen2 folder data set.
type ADLSGen2FolderProperties struct {
	// REQUIRED; File system to which the folder belongs.
	FileSystem *string `json:"fileSystem,omitempty"`

	// REQUIRED; Folder path within the file system.
	FolderPath *string `json:"folderPath,omitempty"`

	// REQUIRED; Resource group of storage account
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// Account - An account data transfer object.
type Account struct {
	// REQUIRED; Identity Info on the Account
	Identity *Identity `json:"identity,omitempty"`

	// Location of the azure resource.
	Location *string `json:"location,omitempty"`

	// Properties on the account
	Properties *AccountProperties `json:"properties,omitempty"`

	// Tags on the azure resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AccountList - List response for get Accounts.
type AccountList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*Account `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// AccountProperties - Account property bag.
type AccountProperties struct {
	// READ-ONLY; Time at which the account was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the Account
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string `json:"userEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user who created the resource
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// AccountUpdateParameters - Update parameters for accounts
type AccountUpdateParameters struct {
	// Tags on the azure resource.
	Tags map[string]*string `json:"tags,omitempty"`
}

// AccountsClientBeginCreateOptions contains the optional parameters for the AccountsClient.BeginCreate method.
type AccountsClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientBeginDeleteOptions contains the optional parameters for the AccountsClient.BeginDelete method.
type AccountsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AccountsClientGetOptions contains the optional parameters for the AccountsClient.Get method.
type AccountsClientGetOptions struct {
	// placeholder for future optional parameters
}

// AccountsClientListByResourceGroupOptions contains the optional parameters for the AccountsClient.ListByResourceGroup method.
type AccountsClientListByResourceGroupOptions struct {
	// Continuation token
	SkipToken *string
}

// AccountsClientListBySubscriptionOptions contains the optional parameters for the AccountsClient.ListBySubscription method.
type AccountsClientListBySubscriptionOptions struct {
	// Continuation token
	SkipToken *string
}

// AccountsClientUpdateOptions contains the optional parameters for the AccountsClient.Update method.
type AccountsClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// BlobContainerDataSet - An Azure storage blob container data set.
type BlobContainerDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; Blob container data set properties.
	Properties *BlobContainerProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type BlobContainerDataSet.
func (b *BlobContainerDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       b.Kind,
		ID:         b.ID,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobContainerDataSetMapping - A Blob container data set mapping.
type BlobContainerDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; Blob container data set mapping properties.
	Properties *BlobContainerMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type BlobContainerDataSetMapping.
func (b *BlobContainerDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       b.Kind,
		ID:         b.ID,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobContainerMappingProperties - Azure storage Blob container data set mapping property bag.
type BlobContainerMappingProperties struct {
	// REQUIRED; BLOB Container name.
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BlobContainerProperties - Properties of the BLOB container data set.
type BlobContainerProperties struct {
	// REQUIRED; BLOB Container name.
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; Resource group of storage account
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// BlobDataSet - An Azure storage blob data set.
type BlobDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; Blob data set properties.
	Properties *BlobProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type BlobDataSet.
func (b *BlobDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       b.Kind,
		ID:         b.ID,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobDataSetMapping - A Blob data set mapping.
type BlobDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; Blob data set mapping properties.
	Properties *BlobMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type BlobDataSetMapping.
func (b *BlobDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       b.Kind,
		ID:         b.ID,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobFolderDataSet - An Azure storage blob folder data set.
type BlobFolderDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; Blob folder data set properties.
	Properties *BlobFolderProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type BlobFolderDataSet.
func (b *BlobFolderDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       b.Kind,
		ID:         b.ID,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobFolderDataSetMapping - A Blob folder data set mapping.
type BlobFolderDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; Blob folder data set mapping properties.
	Properties *BlobFolderMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type BlobFolderDataSetMapping.
func (b *BlobFolderDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       b.Kind,
		ID:         b.ID,
		Name:       b.Name,
		SystemData: b.SystemData,
		Type:       b.Type,
	}
}

// BlobFolderMappingProperties - Azure storage Blob folder data set mapping property bag.
type BlobFolderMappingProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; Prefix for blob folder
	Prefix *string `json:"prefix,omitempty"`

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BlobFolderProperties - Properties of the blob folder data set.
type BlobFolderProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; Prefix for blob folder
	Prefix *string `json:"prefix,omitempty"`

	// REQUIRED; Resource group of storage account
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// BlobMappingProperties - Azure storage Blob data set mapping property bag.
type BlobMappingProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; File path within the source data set
	FilePath *string `json:"filePath,omitempty"`

	// REQUIRED; Resource group of storage account.
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set.
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account.
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// File output type
	OutputType *OutputType `json:"outputType,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// BlobProperties - Properties of the blob data set.
type BlobProperties struct {
	// REQUIRED; Container that has the file path.
	ContainerName *string `json:"containerName,omitempty"`

	// REQUIRED; File path within the source data set
	FilePath *string `json:"filePath,omitempty"`

	// REQUIRED; Resource group of storage account
	ResourceGroup *string `json:"resourceGroup,omitempty"`

	// REQUIRED; Storage account name of the source data set
	StorageAccountName *string `json:"storageAccountName,omitempty"`

	// REQUIRED; Subscription id of storage account
	SubscriptionID *string `json:"subscriptionId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// ConsumerInvitation - A consumer Invitation data transfer object.
type ConsumerInvitation struct {
	// REQUIRED; Properties on the account
	Properties *ConsumerInvitationProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConsumerInvitationList - List response for get InvitationList
type ConsumerInvitationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ConsumerInvitation `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConsumerInvitationProperties - Properties of consumer invitation
type ConsumerInvitationProperties struct {
	// REQUIRED; Unique id of the invitation.
	InvitationID *string `json:"invitationId,omitempty"`

	// READ-ONLY; Number of data sets in a share
	DataSetCount *int32 `json:"dataSetCount,omitempty" azure:"ro"`

	// READ-ONLY; Description shared when the invitation was created
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The expiration date for the share subscription created by accepting the invitation.
	ExpirationDate *time.Time `json:"expirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The status of the invitation.
	InvitationStatus *InvitationStatus `json:"invitationStatus,omitempty" azure:"ro"`

	// READ-ONLY; invitation location
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Email of the provider who created the resource
	ProviderEmail *string `json:"providerEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the provider who created the resource
	ProviderName *string `json:"providerName,omitempty" azure:"ro"`

	// READ-ONLY; Tenant name of the provider who created the resource
	ProviderTenantName *string `json:"providerTenantName,omitempty" azure:"ro"`

	// READ-ONLY; The time the recipient responded to the invitation.
	RespondedAt *time.Time `json:"respondedAt,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time at which the invitation was sent.
	SentAt *time.Time `json:"sentAt,omitempty" azure:"ro"`

	// READ-ONLY; Gets the source share Name.
	ShareName *string `json:"shareName,omitempty" azure:"ro"`

	// READ-ONLY; Terms of use shared when the invitation was created
	TermsOfUse *string `json:"termsOfUse,omitempty" azure:"ro"`

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string `json:"userEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user who created the resource
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// ConsumerInvitationsClientGetOptions contains the optional parameters for the ConsumerInvitationsClient.Get method.
type ConsumerInvitationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ConsumerInvitationsClientListInvitationsOptions contains the optional parameters for the ConsumerInvitationsClient.ListInvitations
// method.
type ConsumerInvitationsClientListInvitationsOptions struct {
	// The continuation token
	SkipToken *string
}

// ConsumerInvitationsClientRejectInvitationOptions contains the optional parameters for the ConsumerInvitationsClient.RejectInvitation
// method.
type ConsumerInvitationsClientRejectInvitationOptions struct {
	// placeholder for future optional parameters
}

// ConsumerSourceDataSet - A consumer side dataSet data transfer object.
type ConsumerSourceDataSet struct {
	// source dataSet properties
	Properties *ConsumerSourceDataSetProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ConsumerSourceDataSetList - A consumer side list of source dataSets
type ConsumerSourceDataSetList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ConsumerSourceDataSet `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ConsumerSourceDataSetProperties - Properties of consumer source dataSet
type ConsumerSourceDataSetProperties struct {
	// READ-ONLY; DataSet Id
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`

	// READ-ONLY; Location of the data set.
	DataSetLocation *string `json:"dataSetLocation,omitempty" azure:"ro"`

	// READ-ONLY; DataSet name
	DataSetName *string `json:"dataSetName,omitempty" azure:"ro"`

	// READ-ONLY; DataSet path
	DataSetPath *string `json:"dataSetPath,omitempty" azure:"ro"`

	// READ-ONLY; Type of data set
	DataSetType *DataSetType `json:"dataSetType,omitempty" azure:"ro"`
}

// ConsumerSourceDataSetsClientListByShareSubscriptionOptions contains the optional parameters for the ConsumerSourceDataSetsClient.ListByShareSubscription
// method.
type ConsumerSourceDataSetsClientListByShareSubscriptionOptions struct {
	// Continuation token
	SkipToken *string
}

// DataSetClassification provides polymorphic access to related types.
// Call the interface's GetDataSet() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ADLSGen1FileDataSet, *ADLSGen1FolderDataSet, *ADLSGen2FileDataSet, *ADLSGen2FileSystemDataSet, *ADLSGen2FolderDataSet,
// - *BlobContainerDataSet, *BlobDataSet, *BlobFolderDataSet, *DataSet, *KustoClusterDataSet, *KustoDatabaseDataSet, *SQLDBTableDataSet,
// - *SQLDWTableDataSet, *SynapseWorkspaceSQLPoolTableDataSet
type DataSetClassification interface {
	// GetDataSet returns the DataSet content of the underlying type.
	GetDataSet() *DataSet
}

// DataSet - A DataSet data transfer object.
type DataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type DataSet.
func (d *DataSet) GetDataSet() *DataSet { return d }

// DataSetList - List response for get DataSets
type DataSetList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []DataSetClassification `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataSetMappingClassification provides polymorphic access to related types.
// Call the interface's GetDataSetMapping() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ADLSGen2FileDataSetMapping, *ADLSGen2FileSystemDataSetMapping, *ADLSGen2FolderDataSetMapping, *BlobContainerDataSetMapping,
// - *BlobDataSetMapping, *BlobFolderDataSetMapping, *DataSetMapping, *KustoClusterDataSetMapping, *KustoDatabaseDataSetMapping,
// - *SQLDBTableDataSetMapping, *SQLDWTableDataSetMapping, *SynapseWorkspaceSQLPoolTableDataSetMapping
type DataSetMappingClassification interface {
	// GetDataSetMapping returns the DataSetMapping content of the underlying type.
	GetDataSetMapping() *DataSetMapping
}

// DataSetMapping - A data set mapping data transfer object.
type DataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type DataSetMapping.
func (d *DataSetMapping) GetDataSetMapping() *DataSetMapping { return d }

// DataSetMappingList - List response for get DataSetMappings
type DataSetMappingList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []DataSetMappingClassification `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// DataSetMappingsClientCreateOptions contains the optional parameters for the DataSetMappingsClient.Create method.
type DataSetMappingsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// DataSetMappingsClientDeleteOptions contains the optional parameters for the DataSetMappingsClient.Delete method.
type DataSetMappingsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// DataSetMappingsClientGetOptions contains the optional parameters for the DataSetMappingsClient.Get method.
type DataSetMappingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataSetMappingsClientListByShareSubscriptionOptions contains the optional parameters for the DataSetMappingsClient.ListByShareSubscription
// method.
type DataSetMappingsClientListByShareSubscriptionOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// Continuation token
	SkipToken *string
}

// DataSetsClientBeginDeleteOptions contains the optional parameters for the DataSetsClient.BeginDelete method.
type DataSetsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// DataSetsClientCreateOptions contains the optional parameters for the DataSetsClient.Create method.
type DataSetsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// DataSetsClientGetOptions contains the optional parameters for the DataSetsClient.Get method.
type DataSetsClientGetOptions struct {
	// placeholder for future optional parameters
}

// DataSetsClientListByShareOptions contains the optional parameters for the DataSetsClient.ListByShare method.
type DataSetsClientListByShareOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// continuation token
	SkipToken *string
}

// DefaultDto - Base data transfer object implementation for default resources.
type DefaultDto struct {
	// Location of the azure resource.
	Location *string `json:"location,omitempty"`

	// Tags on the azure resource.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// DimensionProperties - properties for dimension
type DimensionProperties struct {
	// localized display name of the dimension to customer
	DisplayName *string `json:"displayName,omitempty"`

	// dimension name
	Name *string `json:"name,omitempty"`
}

// EmailRegistration - Dto for tenant domain registration
type EmailRegistration struct {
	// Activation code for the registration
	ActivationCode *string `json:"activationCode,omitempty"`

	// READ-ONLY; Date of the activation expiration
	ActivationExpirationDate *time.Time `json:"activationExpirationDate,omitempty" azure:"ro"`

	// READ-ONLY; The email to register
	Email *string `json:"email,omitempty" azure:"ro"`

	// READ-ONLY; Registration status
	RegistrationStatus *RegistrationStatus `json:"registrationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The tenant to register
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// EmailRegistrationsClientActivateEmailOptions contains the optional parameters for the EmailRegistrationsClient.ActivateEmail
// method.
type EmailRegistrationsClientActivateEmailOptions struct {
	// placeholder for future optional parameters
}

// EmailRegistrationsClientRegisterEmailOptions contains the optional parameters for the EmailRegistrationsClient.RegisterEmail
// method.
type EmailRegistrationsClientRegisterEmailOptions struct {
	// placeholder for future optional parameters
}

// Error - The data share error model.
type Error struct {
	// REQUIRED; The data share error body
	Error *ErrorInfo `json:"error,omitempty"`
}

// ErrorInfo - The data share error body model.
type ErrorInfo struct {
	// REQUIRED; Code of the error
	Code *string `json:"code,omitempty"`

	// REQUIRED; Message of the error
	Message *string `json:"message,omitempty"`

	// Nested details of the error model
	Details []*ErrorInfo `json:"details,omitempty"`

	// Target of the error
	Target *string `json:"target,omitempty"`
}

// Identity of resource
type Identity struct {
	// Identity Type
	Type *Type `json:"type,omitempty"`

	// READ-ONLY; service principal Id
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; Tenant Id
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// Invitation - A Invitation data transfer object.
type Invitation struct {
	// Properties on the Invitation
	Properties *InvitationProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// InvitationList - List response for get InvitationList
type InvitationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*Invitation `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// InvitationProperties - Invitation property bag.
type InvitationProperties struct {
	// The expiration date for the invitation and share subscription.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// The target Azure AD Id. Can't be combined with email.
	TargetActiveDirectoryID *string `json:"targetActiveDirectoryId,omitempty"`

	// The email the invitation is directed to.
	TargetEmail *string `json:"targetEmail,omitempty"`

	// The target user or application Id that invitation is being sent to. Must be specified along TargetActiveDirectoryId. This
	// enables sending invitations to specific users or applications in an AD tenant.
	TargetObjectID *string `json:"targetObjectId,omitempty"`

	// READ-ONLY; unique invitation id
	InvitationID *string `json:"invitationId,omitempty" azure:"ro"`

	// READ-ONLY; The status of the invitation.
	InvitationStatus *InvitationStatus `json:"invitationStatus,omitempty" azure:"ro"`

	// READ-ONLY; The time the recipient responded to the invitation.
	RespondedAt *time.Time `json:"respondedAt,omitempty" azure:"ro"`

	// READ-ONLY; Gets the time at which the invitation was sent.
	SentAt *time.Time `json:"sentAt,omitempty" azure:"ro"`

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string `json:"userEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user who created the resource
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// InvitationsClientCreateOptions contains the optional parameters for the InvitationsClient.Create method.
type InvitationsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// InvitationsClientDeleteOptions contains the optional parameters for the InvitationsClient.Delete method.
type InvitationsClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// InvitationsClientGetOptions contains the optional parameters for the InvitationsClient.Get method.
type InvitationsClientGetOptions struct {
	// placeholder for future optional parameters
}

// InvitationsClientListByShareOptions contains the optional parameters for the InvitationsClient.ListByShare method.
type InvitationsClientListByShareOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// The continuation token
	SkipToken *string
}

// KustoClusterDataSet - A kusto cluster data set.
type KustoClusterDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; Kusto cluster data set properties.
	Properties *KustoClusterDataSetProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type KustoClusterDataSet.
func (k *KustoClusterDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       k.Kind,
		ID:         k.ID,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoClusterDataSetMapping - A Kusto cluster data set mapping
type KustoClusterDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; Kusto cluster data set mapping properties.
	Properties *KustoClusterDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type KustoClusterDataSetMapping.
func (k *KustoClusterDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       k.Kind,
		ID:         k.ID,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoClusterDataSetMappingProperties - Properties of the Kusto cluster data set mapping
type KustoClusterDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; Resource id of the sink kusto cluster.
	KustoClusterResourceID *string `json:"kustoClusterResourceId,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Location of the sink kusto cluster.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// KustoClusterDataSetProperties - Properties of the kusto cluster data set.
type KustoClusterDataSetProperties struct {
	// REQUIRED; Resource id of the kusto cluster.
	KustoClusterResourceID *string `json:"kustoClusterResourceId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`

	// READ-ONLY; Location of the kusto cluster.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the kusto cluster data set.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// KustoDatabaseDataSet - A kusto database data set.
type KustoDatabaseDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; Kusto database data set properties.
	Properties *KustoDatabaseDataSetProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type KustoDatabaseDataSet.
func (k *KustoDatabaseDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       k.Kind,
		ID:         k.ID,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoDatabaseDataSetMapping - A Kusto database data set mapping
type KustoDatabaseDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; Kusto database data set mapping properties.
	Properties *KustoDatabaseDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type KustoDatabaseDataSetMapping.
func (k *KustoDatabaseDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       k.Kind,
		ID:         k.ID,
		Name:       k.Name,
		SystemData: k.SystemData,
		Type:       k.Type,
	}
}

// KustoDatabaseDataSetMappingProperties - Properties of the Kusto database data set mapping
type KustoDatabaseDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; Resource id of the sink kusto cluster.
	KustoClusterResourceID *string `json:"kustoClusterResourceId,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Location of the sink kusto cluster.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// KustoDatabaseDataSetProperties - Properties of the kusto database data set.
type KustoDatabaseDataSetProperties struct {
	// REQUIRED; Resource id of the kusto database.
	KustoDatabaseResourceID *string `json:"kustoDatabaseResourceId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`

	// READ-ONLY; Location of the kusto cluster.
	Location *string `json:"location,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the kusto database data set.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// OperationList - List response for get operations.
type OperationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*OperationModel `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationMetaLogSpecification - log specifications for operation api
type OperationMetaLogSpecification struct {
	// blob duration of the log
	BlobDuration *string `json:"blobDuration,omitempty"`

	// localized name of the log category
	DisplayName *string `json:"displayName,omitempty"`

	// name of the log category
	Name *string `json:"name,omitempty"`
}

// OperationMetaMetricSpecification - metric specifications for the operation
type OperationMetaMetricSpecification struct {
	// aggregation type of metric
	AggregationType *string `json:"aggregationType,omitempty"`

	// properties for dimension
	Dimensions []*DimensionProperties `json:"dimensions,omitempty"`

	// description of the metric
	DisplayDescription *string `json:"displayDescription,omitempty"`

	// localized name of the metric
	DisplayName *string `json:"displayName,omitempty"`

	// enable regional mdm account
	EnableRegionalMdmAccount *string `json:"enableRegionalMdmAccount,omitempty"`

	// fill gap with zero
	FillGapWithZero *bool `json:"fillGapWithZero,omitempty"`

	// internal metric name
	InternalMetricName *string `json:"internalMetricName,omitempty"`

	// name of the metric
	Name *string `json:"name,omitempty"`

	// dimension name use to replace resource id if specified
	ResourceIDDimensionNameOverride *string `json:"resourceIdDimensionNameOverride,omitempty"`

	// supported aggregation types
	SupportedAggregationTypes []*string `json:"supportedAggregationTypes,omitempty"`

	// supported time grain types
	SupportedTimeGrainTypes []*string `json:"supportedTimeGrainTypes,omitempty"`

	// units for the metric
	Unit *string `json:"unit,omitempty"`
}

// OperationMetaPropertyInfo - properties on meta info
type OperationMetaPropertyInfo struct {
	// meta service specification
	ServiceSpecification *OperationMetaServiceSpecification `json:"serviceSpecification,omitempty"`
}

// OperationMetaServiceSpecification - The operation meta service specification
type OperationMetaServiceSpecification struct {
	// log specifications for the operation
	LogSpecifications []*OperationMetaLogSpecification `json:"logSpecifications,omitempty"`

	// metric specifications for the operation
	MetricSpecifications []*OperationMetaMetricSpecification `json:"metricSpecifications,omitempty"`
}

// OperationModel - The response model for get operations
type OperationModel struct {
	// Properties on the operation
	Display *OperationModelProperties `json:"display,omitempty"`

	// Operation name for display purposes
	Name *string `json:"name,omitempty"`

	// origin of the operation
	Origin *string `json:"origin,omitempty"`

	// properties for the operation meta info
	Properties *OperationMetaPropertyInfo `json:"properties,omitempty"`
}

// OperationModelProperties - Properties on operations
type OperationModelProperties struct {
	// Description of the operation for display purposes
	Description *string `json:"description,omitempty"`

	// Name of the operation for display purposes
	Operation *string `json:"operation,omitempty"`

	// Name of the provider for display purposes
	Provider *string `json:"provider,omitempty"`

	// Name of the resource type for display purposes
	Resource *string `json:"resource,omitempty"`
}

// OperationResponse - Response for long running operation
type OperationResponse struct {
	// REQUIRED; Operation state of the long running operation.
	Status *Status `json:"status,omitempty"`

	// start time
	EndTime *time.Time `json:"endTime,omitempty"`

	// The error property when status is failed.
	Error *ErrorInfo `json:"error,omitempty"`

	// start time
	StartTime *time.Time `json:"startTime,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProviderShareSubscription - A provider side share subscription data transfer object.
type ProviderShareSubscription struct {
	// properties of providerShareSubscription
	Properties *ProviderShareSubscriptionProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ProviderShareSubscriptionList - List response for get ShareSubscription.
type ProviderShareSubscriptionList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ProviderShareSubscription `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProviderShareSubscriptionProperties - Provider share subscription properties
type ProviderShareSubscriptionProperties struct {
	// Expiration date of the share subscription in UTC format
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// READ-ONLY; Email of the consumer who created the share subscription
	ConsumerEmail *string `json:"consumerEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the consumer who created the share subscription
	ConsumerName *string `json:"consumerName,omitempty" azure:"ro"`

	// READ-ONLY; Tenant name of the consumer who created the share subscription
	ConsumerTenantName *string `json:"consumerTenantName,omitempty" azure:"ro"`

	// READ-ONLY; created at
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Email of the provider who created the share
	ProviderEmail *string `json:"providerEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the provider who created the share
	ProviderName *string `json:"providerName,omitempty" azure:"ro"`

	// READ-ONLY; share Subscription Object Id
	ShareSubscriptionObjectID *string `json:"shareSubscriptionObjectId,omitempty" azure:"ro"`

	// READ-ONLY; Gets the status of share subscription
	ShareSubscriptionStatus *ShareSubscriptionStatus `json:"shareSubscriptionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Shared at
	SharedAt *time.Time `json:"sharedAt,omitempty" azure:"ro"`
}

// ProviderShareSubscriptionsClientAdjustOptions contains the optional parameters for the ProviderShareSubscriptionsClient.Adjust
// method.
type ProviderShareSubscriptionsClientAdjustOptions struct {
	// placeholder for future optional parameters
}

// ProviderShareSubscriptionsClientBeginRevokeOptions contains the optional parameters for the ProviderShareSubscriptionsClient.BeginRevoke
// method.
type ProviderShareSubscriptionsClientBeginRevokeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ProviderShareSubscriptionsClientGetByShareOptions contains the optional parameters for the ProviderShareSubscriptionsClient.GetByShare
// method.
type ProviderShareSubscriptionsClientGetByShareOptions struct {
	// placeholder for future optional parameters
}

// ProviderShareSubscriptionsClientListByShareOptions contains the optional parameters for the ProviderShareSubscriptionsClient.ListByShare
// method.
type ProviderShareSubscriptionsClientListByShareOptions struct {
	// Continuation Token
	SkipToken *string
}

// ProviderShareSubscriptionsClientReinstateOptions contains the optional parameters for the ProviderShareSubscriptionsClient.Reinstate
// method.
type ProviderShareSubscriptionsClientReinstateOptions struct {
	// placeholder for future optional parameters
}

// ProxyDto - Base data transfer object implementation for proxy resources.
type ProxyDto struct {
	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLDBTableDataSet - A SQL DB table data set.
type SQLDBTableDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// SQL DB table data set properties.
	Properties *SQLDBTableProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type SQLDBTableDataSet.
func (s *SQLDBTableDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDBTableDataSetMapping - A SQL DB Table data set mapping.
type SQLDBTableDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; Sql DB data set mapping properties.
	Properties *SQLDBTableDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type SQLDBTableDataSetMapping.
func (s *SQLDBTableDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDBTableDataSetMappingProperties - Properties of the SQL DB table data set mapping.
type SQLDBTableDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; DatabaseName name of the sink data set
	DatabaseName *string `json:"databaseName,omitempty"`

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string `json:"sqlServerResourceId,omitempty"`

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string `json:"schemaName,omitempty"`

	// REQUIRED; SQL DB table name.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SQLDBTableProperties - Properties of the SQL DB table data set.
type SQLDBTableProperties struct {
	// REQUIRED; Database name of the source data set
	DatabaseName *string `json:"databaseName,omitempty"`

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string `json:"sqlServerResourceId,omitempty"`

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string `json:"schemaName,omitempty"`

	// REQUIRED; SQL DB table name.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// SQLDWTableDataSet - A SQL DW table data set.
type SQLDWTableDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// SQL DW table data set properties.
	Properties *SQLDWTableProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type SQLDWTableDataSet.
func (s *SQLDWTableDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDWTableDataSetMapping - A SQL DW Table data set mapping.
type SQLDWTableDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; Sql DW data set mapping properties.
	Properties *SQLDWTableDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type SQLDWTableDataSetMapping.
func (s *SQLDWTableDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SQLDWTableDataSetMappingProperties - Properties of the SQL DW table data set mapping.
type SQLDWTableDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; DataWarehouse name of the source data set
	DataWarehouseName *string `json:"dataWarehouseName,omitempty"`

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string `json:"sqlServerResourceId,omitempty"`

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string `json:"schemaName,omitempty"`

	// REQUIRED; SQL DW table name.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SQLDWTableProperties - Properties of the SQL DW table data set.
type SQLDWTableProperties struct {
	// REQUIRED; DataWarehouse name of the source data set
	DataWarehouseName *string `json:"dataWarehouseName,omitempty"`

	// REQUIRED; Resource id of SQL server
	SQLServerResourceID *string `json:"sqlServerResourceId,omitempty"`

	// REQUIRED; Schema of the table. Default value is dbo.
	SchemaName *string `json:"schemaName,omitempty"`

	// REQUIRED; SQL DW table name.
	TableName *string `json:"tableName,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// ScheduledSourceShareSynchronizationSettingProperties - A Scheduled source synchronization setting data transfer object.
type ScheduledSourceShareSynchronizationSettingProperties struct {
	// Recurrence Interval
	RecurrenceInterval *RecurrenceInterval `json:"recurrenceInterval,omitempty"`

	// Synchronization time
	SynchronizationTime *time.Time `json:"synchronizationTime,omitempty"`
}

// ScheduledSourceSynchronizationSetting - A type of synchronization setting based on schedule
type ScheduledSourceSynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting on share.
	Kind *SourceShareSynchronizationSettingKind `json:"kind,omitempty"`

	// Properties of scheduled synchronization
	Properties *ScheduledSourceShareSynchronizationSettingProperties `json:"properties,omitempty"`
}

// GetSourceShareSynchronizationSetting implements the SourceShareSynchronizationSettingClassification interface for type
// ScheduledSourceSynchronizationSetting.
func (s *ScheduledSourceSynchronizationSetting) GetSourceShareSynchronizationSetting() *SourceShareSynchronizationSetting {
	return &SourceShareSynchronizationSetting{
		Kind: s.Kind,
	}
}

// ScheduledSynchronizationSetting - A type of synchronization setting based on schedule
type ScheduledSynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting.
	Kind *SynchronizationSettingKind `json:"kind,omitempty"`

	// REQUIRED; Properties of scheduled synchronization
	Properties *ScheduledSynchronizationSettingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetSynchronizationSetting implements the SynchronizationSettingClassification interface for type ScheduledSynchronizationSetting.
func (s *ScheduledSynchronizationSetting) GetSynchronizationSetting() *SynchronizationSetting {
	return &SynchronizationSetting{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// ScheduledSynchronizationSettingProperties - A Scheduled synchronization setting data transfer object.
type ScheduledSynchronizationSettingProperties struct {
	// REQUIRED; Recurrence Interval
	RecurrenceInterval *RecurrenceInterval `json:"recurrenceInterval,omitempty"`

	// REQUIRED; Synchronization time
	SynchronizationTime *time.Time `json:"synchronizationTime,omitempty"`

	// READ-ONLY; Time at which the synchronization setting was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user who created the synchronization setting.
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// ScheduledTrigger - A type of trigger based on schedule
type ScheduledTrigger struct {
	// REQUIRED; Kind of synchronization on trigger.
	Kind *TriggerKind `json:"kind,omitempty"`

	// REQUIRED; Properties of scheduled synchronization
	Properties *ScheduledTriggerProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type ScheduledTrigger.
func (s *ScheduledTrigger) GetTrigger() *Trigger {
	return &Trigger{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// ScheduledTriggerProperties - A Scheduled trigger data transfer object.
type ScheduledTriggerProperties struct {
	// REQUIRED; Recurrence Interval
	RecurrenceInterval *RecurrenceInterval `json:"recurrenceInterval,omitempty"`

	// REQUIRED; Synchronization time
	SynchronizationTime *time.Time `json:"synchronizationTime,omitempty"`

	// Synchronization mode
	SynchronizationMode *SynchronizationMode `json:"synchronizationMode,omitempty"`

	// READ-ONLY; Time at which the trigger was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Gets the provisioning state
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Gets the trigger state
	TriggerStatus *TriggerStatus `json:"triggerStatus,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user who created the trigger.
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// Share - A share data transfer object.
type Share struct {
	// Properties on the share
	Properties *ShareProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ShareList - List response for get Shares.
type ShareList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*Share `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ShareProperties - Share property bag.
type ShareProperties struct {
	// Share description.
	Description *string `json:"description,omitempty"`

	// Share kind.
	ShareKind *ShareKind `json:"shareKind,omitempty"`

	// Share terms.
	Terms *string `json:"terms,omitempty"`

	// READ-ONLY; Time at which the share was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Gets or sets the provisioning state
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string `json:"userEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user who created the resource
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// ShareSubscription - A share subscription data transfer object.
type ShareSubscription struct {
	// REQUIRED; Properties on the share subscription
	Properties *ShareSubscriptionProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ShareSubscriptionList - List response for get ShareSubscription.
type ShareSubscriptionList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ShareSubscription `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ShareSubscriptionProperties - Share subscription property bag.
type ShareSubscriptionProperties struct {
	// REQUIRED; The invitation id.
	InvitationID *string `json:"invitationId,omitempty"`

	// REQUIRED; Source share location.
	SourceShareLocation *string `json:"sourceShareLocation,omitempty"`

	// The expiration date of the share subscription.
	ExpirationDate *time.Time `json:"expirationDate,omitempty"`

	// READ-ONLY; Time at which the share subscription was created.
	CreatedAt *time.Time `json:"createdAt,omitempty" azure:"ro"`

	// READ-ONLY; Email of the provider who created the resource
	ProviderEmail *string `json:"providerEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the provider who created the resource
	ProviderName *string `json:"providerName,omitempty" azure:"ro"`

	// READ-ONLY; Tenant name of the provider who created the resource
	ProviderTenantName *string `json:"providerTenantName,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the share subscription
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Description of share
	ShareDescription *string `json:"shareDescription,omitempty" azure:"ro"`

	// READ-ONLY; Kind of share
	ShareKind *ShareKind `json:"shareKind,omitempty" azure:"ro"`

	// READ-ONLY; Name of the share
	ShareName *string `json:"shareName,omitempty" azure:"ro"`

	// READ-ONLY; Gets the current status of share subscription.
	ShareSubscriptionStatus *ShareSubscriptionStatus `json:"shareSubscriptionStatus,omitempty" azure:"ro"`

	// READ-ONLY; Terms of a share
	ShareTerms *string `json:"shareTerms,omitempty" azure:"ro"`

	// READ-ONLY; Email of the user who created the resource
	UserEmail *string `json:"userEmail,omitempty" azure:"ro"`

	// READ-ONLY; Name of the user who created the resource
	UserName *string `json:"userName,omitempty" azure:"ro"`
}

// ShareSubscriptionSynchronization - A ShareSubscriptionSynchronization data transfer object.
type ShareSubscriptionSynchronization struct {
	// REQUIRED; Synchronization id
	SynchronizationID *string `json:"synchronizationId,omitempty"`

	// READ-ONLY; Synchronization duration
	DurationMs *int32 `json:"durationMs,omitempty" azure:"ro"`

	// READ-ONLY; End time of synchronization
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; message of Synchronization
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; start time of synchronization
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Raw Status
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; Synchronization Mode
	SynchronizationMode *SynchronizationMode `json:"synchronizationMode,omitempty" azure:"ro"`
}

// ShareSubscriptionSynchronizationList - A consumer side list of share subscription synchronizations
type ShareSubscriptionSynchronizationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ShareSubscriptionSynchronization `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// ShareSubscriptionsClientBeginCancelSynchronizationOptions contains the optional parameters for the ShareSubscriptionsClient.BeginCancelSynchronization
// method.
type ShareSubscriptionsClientBeginCancelSynchronizationOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ShareSubscriptionsClientBeginDeleteOptions contains the optional parameters for the ShareSubscriptionsClient.BeginDelete
// method.
type ShareSubscriptionsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ShareSubscriptionsClientBeginSynchronizeOptions contains the optional parameters for the ShareSubscriptionsClient.BeginSynchronize
// method.
type ShareSubscriptionsClientBeginSynchronizeOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// ShareSubscriptionsClientCreateOptions contains the optional parameters for the ShareSubscriptionsClient.Create method.
type ShareSubscriptionsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// ShareSubscriptionsClientGetOptions contains the optional parameters for the ShareSubscriptionsClient.Get method.
type ShareSubscriptionsClientGetOptions struct {
	// placeholder for future optional parameters
}

// ShareSubscriptionsClientListByAccountOptions contains the optional parameters for the ShareSubscriptionsClient.ListByAccount
// method.
type ShareSubscriptionsClientListByAccountOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// Continuation Token
	SkipToken *string
}

// ShareSubscriptionsClientListSourceShareSynchronizationSettingsOptions contains the optional parameters for the ShareSubscriptionsClient.ListSourceShareSynchronizationSettings
// method.
type ShareSubscriptionsClientListSourceShareSynchronizationSettingsOptions struct {
	// Continuation token
	SkipToken *string
}

// ShareSubscriptionsClientListSynchronizationDetailsOptions contains the optional parameters for the ShareSubscriptionsClient.ListSynchronizationDetails
// method.
type ShareSubscriptionsClientListSynchronizationDetailsOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// Continuation token
	SkipToken *string
}

// ShareSubscriptionsClientListSynchronizationsOptions contains the optional parameters for the ShareSubscriptionsClient.ListSynchronizations
// method.
type ShareSubscriptionsClientListSynchronizationsOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// Continuation token
	SkipToken *string
}

// ShareSynchronization - A ShareSynchronization data transfer object.
type ShareSynchronization struct {
	// Email of the user who created the synchronization
	ConsumerEmail *string `json:"consumerEmail,omitempty"`

	// Name of the user who created the synchronization
	ConsumerName *string `json:"consumerName,omitempty"`

	// Tenant name of the consumer who created the synchronization
	ConsumerTenantName *string `json:"consumerTenantName,omitempty"`

	// synchronization duration
	DurationMs *int32 `json:"durationMs,omitempty"`

	// End time of synchronization
	EndTime *time.Time `json:"endTime,omitempty"`

	// message of synchronization
	Message *string `json:"message,omitempty"`

	// start time of synchronization
	StartTime *time.Time `json:"startTime,omitempty"`

	// Raw Status
	Status *string `json:"status,omitempty"`

	// Synchronization id
	SynchronizationID *string `json:"synchronizationId,omitempty"`

	// READ-ONLY; Synchronization mode
	SynchronizationMode *SynchronizationMode `json:"synchronizationMode,omitempty" azure:"ro"`
}

// ShareSynchronizationList - List response for get ShareSynchronization.
type ShareSynchronizationList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*ShareSynchronization `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SharesClientBeginDeleteOptions contains the optional parameters for the SharesClient.BeginDelete method.
type SharesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SharesClientCreateOptions contains the optional parameters for the SharesClient.Create method.
type SharesClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SharesClientGetOptions contains the optional parameters for the SharesClient.Get method.
type SharesClientGetOptions struct {
	// placeholder for future optional parameters
}

// SharesClientListByAccountOptions contains the optional parameters for the SharesClient.ListByAccount method.
type SharesClientListByAccountOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// Continuation Token
	SkipToken *string
}

// SharesClientListSynchronizationDetailsOptions contains the optional parameters for the SharesClient.ListSynchronizationDetails
// method.
type SharesClientListSynchronizationDetailsOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// Continuation token
	SkipToken *string
}

// SharesClientListSynchronizationsOptions contains the optional parameters for the SharesClient.ListSynchronizations method.
type SharesClientListSynchronizationsOptions struct {
	// Filters the results using OData syntax.
	Filter *string
	// Sorts the results using OData syntax.
	Orderby *string
	// Continuation token
	SkipToken *string
}

// SourceShareSynchronizationSettingClassification provides polymorphic access to related types.
// Call the interface's GetSourceShareSynchronizationSetting() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ScheduledSourceSynchronizationSetting, *SourceShareSynchronizationSetting
type SourceShareSynchronizationSettingClassification interface {
	// GetSourceShareSynchronizationSetting returns the SourceShareSynchronizationSetting content of the underlying type.
	GetSourceShareSynchronizationSetting() *SourceShareSynchronizationSetting
}

// SourceShareSynchronizationSetting - A view of synchronization setting added by the provider
type SourceShareSynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting on share.
	Kind *SourceShareSynchronizationSettingKind `json:"kind,omitempty"`
}

// GetSourceShareSynchronizationSetting implements the SourceShareSynchronizationSettingClassification interface for type
// SourceShareSynchronizationSetting.
func (s *SourceShareSynchronizationSetting) GetSourceShareSynchronizationSetting() *SourceShareSynchronizationSetting {
	return s
}

// SourceShareSynchronizationSettingList - List response for get source share Synchronization settings
type SourceShareSynchronizationSettingList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []SourceShareSynchronizationSettingClassification `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SynapseWorkspaceSQLPoolTableDataSet - A Synapse Workspace Sql Pool Table data set.
type SynapseWorkspaceSQLPoolTableDataSet struct {
	// REQUIRED; Kind of data set.
	Kind *DataSetKind `json:"kind,omitempty"`

	// REQUIRED; Synapse Workspace Sql Pool Table data set properties.
	Properties *SynapseWorkspaceSQLPoolTableDataSetProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSet implements the DataSetClassification interface for type SynapseWorkspaceSQLPoolTableDataSet.
func (s *SynapseWorkspaceSQLPoolTableDataSet) GetDataSet() *DataSet {
	return &DataSet{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SynapseWorkspaceSQLPoolTableDataSetMapping - A Synapse Workspace Sql Pool Table data set mapping
type SynapseWorkspaceSQLPoolTableDataSetMapping struct {
	// REQUIRED; Kind of data set mapping.
	Kind *DataSetMappingKind `json:"kind,omitempty"`

	// REQUIRED; A Synapse Workspace Sql Pool Table data set mapping properties.
	Properties *SynapseWorkspaceSQLPoolTableDataSetMappingProperties `json:"properties,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetDataSetMapping implements the DataSetMappingClassification interface for type SynapseWorkspaceSQLPoolTableDataSetMapping.
func (s *SynapseWorkspaceSQLPoolTableDataSetMapping) GetDataSetMapping() *DataSetMapping {
	return &DataSetMapping{
		Kind:       s.Kind,
		ID:         s.ID,
		Name:       s.Name,
		SystemData: s.SystemData,
		Type:       s.Type,
	}
}

// SynapseWorkspaceSQLPoolTableDataSetMappingProperties - Properties of the Synapse Workspace SQL Pool Table data set mapping
type SynapseWorkspaceSQLPoolTableDataSetMappingProperties struct {
	// REQUIRED; The id of the source data set.
	DataSetID *string `json:"dataSetId,omitempty"`

	// REQUIRED; Resource id of the Synapse Workspace SQL Pool Table
	SynapseWorkspaceSQLPoolTableResourceID *string `json:"synapseWorkspaceSqlPoolTableResourceId,omitempty"`

	// READ-ONLY; Gets the status of the data set mapping.
	DataSetMappingStatus *DataSetMappingStatus `json:"dataSetMappingStatus,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state of the data set mapping.
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// SynapseWorkspaceSQLPoolTableDataSetProperties - Properties of the Synapse Workspace SQL Pool Table data set.
type SynapseWorkspaceSQLPoolTableDataSetProperties struct {
	// REQUIRED; Resource id of the Synapse Workspace SQL Pool Table
	SynapseWorkspaceSQLPoolTableResourceID *string `json:"synapseWorkspaceSqlPoolTableResourceId,omitempty"`

	// READ-ONLY; Unique id for identifying a data set resource
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`
}

// SynchronizationDetails - Synchronization details at data set level
type SynchronizationDetails struct {
	// READ-ONLY; Id of data set
	DataSetID *string `json:"dataSetId,omitempty" azure:"ro"`

	// READ-ONLY; Type of the data set
	DataSetType *DataSetType `json:"dataSetType,omitempty" azure:"ro"`

	// READ-ONLY; Duration of data set level copy
	DurationMs *int32 `json:"durationMs,omitempty" azure:"ro"`

	// READ-ONLY; End time of data set level copy
	EndTime *time.Time `json:"endTime,omitempty" azure:"ro"`

	// READ-ONLY; The number of files read from the source data set
	FilesRead *int64 `json:"filesRead,omitempty" azure:"ro"`

	// READ-ONLY; The number of files written into the sink data set
	FilesWritten *int64 `json:"filesWritten,omitempty" azure:"ro"`

	// READ-ONLY; Error message if any
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; Name of the data set
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The number of files copied into the sink data set
	RowsCopied *int64 `json:"rowsCopied,omitempty" azure:"ro"`

	// READ-ONLY; The number of rows read from the source data set.
	RowsRead *int64 `json:"rowsRead,omitempty" azure:"ro"`

	// READ-ONLY; The size of the data read from the source data set in bytes
	SizeRead *int64 `json:"sizeRead,omitempty" azure:"ro"`

	// READ-ONLY; The size of the data written into the sink data set in bytes
	SizeWritten *int64 `json:"sizeWritten,omitempty" azure:"ro"`

	// READ-ONLY; Start time of data set level copy
	StartTime *time.Time `json:"startTime,omitempty" azure:"ro"`

	// READ-ONLY; Raw Status
	Status *string `json:"status,omitempty" azure:"ro"`

	// READ-ONLY; The vCore units consumed for the data set synchronization
	VCore *int64 `json:"vCore,omitempty" azure:"ro"`
}

// SynchronizationDetailsList - details of synchronization
type SynchronizationDetailsList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []*SynchronizationDetails `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SynchronizationSettingClassification provides polymorphic access to related types.
// Call the interface's GetSynchronizationSetting() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ScheduledSynchronizationSetting, *SynchronizationSetting
type SynchronizationSettingClassification interface {
	// GetSynchronizationSetting returns the SynchronizationSetting content of the underlying type.
	GetSynchronizationSetting() *SynchronizationSetting
}

// SynchronizationSetting - A Synchronization Setting data transfer object.
type SynchronizationSetting struct {
	// REQUIRED; Kind of synchronization setting.
	Kind *SynchronizationSettingKind `json:"kind,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetSynchronizationSetting implements the SynchronizationSettingClassification interface for type SynchronizationSetting.
func (s *SynchronizationSetting) GetSynchronizationSetting() *SynchronizationSetting { return s }

// SynchronizationSettingList - List response for get Synchronization settings
type SynchronizationSettingList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []SynchronizationSettingClassification `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// SynchronizationSettingsClientBeginDeleteOptions contains the optional parameters for the SynchronizationSettingsClient.BeginDelete
// method.
type SynchronizationSettingsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SynchronizationSettingsClientCreateOptions contains the optional parameters for the SynchronizationSettingsClient.Create
// method.
type SynchronizationSettingsClientCreateOptions struct {
	// placeholder for future optional parameters
}

// SynchronizationSettingsClientGetOptions contains the optional parameters for the SynchronizationSettingsClient.Get method.
type SynchronizationSettingsClientGetOptions struct {
	// placeholder for future optional parameters
}

// SynchronizationSettingsClientListByShareOptions contains the optional parameters for the SynchronizationSettingsClient.ListByShare
// method.
type SynchronizationSettingsClientListByShareOptions struct {
	// continuation token
	SkipToken *string
}

// Synchronize - Payload for the synchronizing the data.
type Synchronize struct {
	// Mode of synchronization used in triggers and snapshot sync. Incremental by default
	SynchronizationMode *SynchronizationMode `json:"synchronizationMode,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *LastModifiedByType `json:"lastModifiedByType,omitempty"`
}

// TriggerClassification provides polymorphic access to related types.
// Call the interface's GetTrigger() method to access the common type.
// Use a type switch to determine the concrete type.  The possible types are:
// - *ScheduledTrigger, *Trigger
type TriggerClassification interface {
	// GetTrigger returns the Trigger content of the underlying type.
	GetTrigger() *Trigger
}

// Trigger - A Trigger data transfer object.
type Trigger struct {
	// REQUIRED; Kind of synchronization on trigger.
	Kind *TriggerKind `json:"kind,omitempty"`

	// READ-ONLY; The resource id of the azure resource
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Name of the azure resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System Data of the Azure resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Type of the azure resource
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GetTrigger implements the TriggerClassification interface for type Trigger.
func (t *Trigger) GetTrigger() *Trigger { return t }

// TriggerList - List response for get triggers
type TriggerList struct {
	// REQUIRED; Collection of items of type DataTransferObjects.
	Value []TriggerClassification `json:"value,omitempty"`

	// The Url of next result page.
	NextLink *string `json:"nextLink,omitempty"`
}

// TriggersClientBeginCreateOptions contains the optional parameters for the TriggersClient.BeginCreate method.
type TriggersClientBeginCreateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TriggersClientBeginDeleteOptions contains the optional parameters for the TriggersClient.BeginDelete method.
type TriggersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// TriggersClientGetOptions contains the optional parameters for the TriggersClient.Get method.
type TriggersClientGetOptions struct {
	// placeholder for future optional parameters
}

// TriggersClientListByShareSubscriptionOptions contains the optional parameters for the TriggersClient.ListByShareSubscription
// method.
type TriggersClientListByShareSubscriptionOptions struct {
	// Continuation token
	SkipToken *string
}
