# frozen_string_literal: true

class DropIdxVulnerabilityOccurrencesDedup < Gitlab::Database::Migration[2.2]
  milestone '17.4'

  disable_ddl_transaction!

  TABLE = :vulnerability_occurrences
  INDEX_NAME = 'index_vulnerability_occurrences_deduplication'
  COLUMNS = %i[project_id report_type project_fingerprint]

  def up
    remove_concurrent_index TABLE, COLUMNS, name: INDEX_NAME
  end

  def down
    add_concurrent_index TABLE, COLUMNS, name: INDEX_NAME
  end
end
