// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesisanalyticsv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesisanalyticsv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates and returns a URL that you can use to connect to an application's
// extension.
//
// The IAM role or user used to call this API defines the permissions to access
// the extension. After the presigned URL is created, no additional permission is
// required to access this URL. IAM authorization policies for this API are also
// enforced for every HTTP request that attempts to connect to the extension.
//
// You control the amount of time that the URL will be valid using the
// SessionExpirationDurationInSeconds parameter. If you do not provide this
// parameter, the returned URL is valid for twelve hours.
//
// The URL that you get from a call to CreateApplicationPresignedUrl must be used
// within 3 minutes to be valid. If you first try to use the URL after the 3-minute
// limit expires, the service returns an HTTP 403 Forbidden error.
func (c *Client) CreateApplicationPresignedUrl(ctx context.Context, params *CreateApplicationPresignedUrlInput, optFns ...func(*Options)) (*CreateApplicationPresignedUrlOutput, error) {
	if params == nil {
		params = &CreateApplicationPresignedUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateApplicationPresignedUrl", params, optFns, c.addOperationCreateApplicationPresignedUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateApplicationPresignedUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateApplicationPresignedUrlInput struct {

	// The name of the application.
	//
	// This member is required.
	ApplicationName *string

	// The type of the extension for which to create and return a URL. Currently, the
	// only valid extension URL type is FLINK_DASHBOARD_URL .
	//
	// This member is required.
	UrlType types.UrlType

	// The duration in seconds for which the returned URL will be valid.
	SessionExpirationDurationInSeconds *int64

	noSmithyDocumentSerde
}

type CreateApplicationPresignedUrlOutput struct {

	// The URL of the extension.
	AuthorizedUrl *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateApplicationPresignedUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateApplicationPresignedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateApplicationPresignedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateApplicationPresignedUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateApplicationPresignedUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateApplicationPresignedUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateApplicationPresignedUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateApplicationPresignedUrl",
	}
}
