// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/api/resource.proto

package com.google.api;

/**
 * <pre>
 * A simple descriptor of a resource type.
 * ResourceDescriptor annotates a resource message (either by means of a
 * protobuf annotation or use in the service config), and associates the
 * resource's schema, the resource type, and the pattern of the resource name.
 * Example:
 *   message Topic {
 *     // Indicates this message defines a resource schema.
 *     // Declares the resource type in the format of {service}/{kind}.
 *     // For Kubernetes resources, the format is {api group}/{kind}.
 *     option (google.api.resource) = {
 *       type: "pubsub.googleapis.com/Topic"
 *       pattern: "projects/{project}/topics/{topic}"
 *     };
 *   }
 * Sometimes, resources have multiple patterns, typically because they can
 * live under multiple parents.
 * Example:
 *   message LogEntry {
 *     option (google.api.resource) = {
 *       type: "logging.googleapis.com/LogEntry"
 *       pattern: "projects/{project}/logs/{log}"
 *       pattern: "organizations/{organization}/logs/{log}"
 *       pattern: "folders/{folder}/logs/{log}"
 *       pattern: "billingAccounts/{billing_account}/logs/{log}"
 *     };
 *   }
 * </pre>
 *
 * Protobuf type {@code google.api.ResourceDescriptor}
 */
public  final class ResourceDescriptor extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.api.ResourceDescriptor)
    ResourceDescriptorOrBuilder {
private static final long serialVersionUID = 0L;
  // Use ResourceDescriptor.newBuilder() to construct.
  private ResourceDescriptor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private ResourceDescriptor() {
    type_ = "";
    pattern_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    nameField_ = "";
    history_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet
  getUnknownFields() {
    return this.unknownFields;
  }
  private ResourceDescriptor(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10: {
            java.lang.String s = input.readStringRequireUtf8();

            type_ = s;
            break;
          }
          case 18: {
            java.lang.String s = input.readStringRequireUtf8();
            if (!((mutable_bitField0_ & 0x00000002) != 0)) {
              pattern_ = new com.google.protobuf.LazyStringArrayList();
              mutable_bitField0_ |= 0x00000002;
            }
            pattern_.add(s);
            break;
          }
          case 26: {
            java.lang.String s = input.readStringRequireUtf8();

            nameField_ = s;
            break;
          }
          case 32: {
            int rawValue = input.readEnum();

            history_ = rawValue;
            break;
          }
          default: {
            if (!parseUnknownField(
                input, unknownFields, extensionRegistry, tag)) {
              done = true;
            }
            break;
          }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(
          e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        pattern_ = pattern_.getUnmodifiableView();
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }
  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.api.ResourceProto.internal_static_google_api_ResourceDescriptor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.api.ResourceProto.internal_static_google_api_ResourceDescriptor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.api.ResourceDescriptor.class, com.google.api.ResourceDescriptor.Builder.class);
  }

  /**
   * <pre>
   * A description of the historical or future-looking state of the
   * resource pattern.
   * </pre>
   *
   * Protobuf enum {@code google.api.ResourceDescriptor.History}
   */
  public enum History
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <pre>
     * The "unset" value.
     * </pre>
     *
     * <code>HISTORY_UNSPECIFIED = 0;</code>
     */
    HISTORY_UNSPECIFIED(0),
    /**
     * <pre>
     * The resource originally had one pattern and launched as such, and
     * additional patterns were added later.
     * </pre>
     *
     * <code>ORIGINALLY_SINGLE_PATTERN = 1;</code>
     */
    ORIGINALLY_SINGLE_PATTERN(1),
    /**
     * <pre>
     * The resource has one pattern, but the API owner expects to add more
     * later. (This is the inverse of ORIGINALLY_SINGLE_PATTERN, and prevents
     * that from being necessary once there are multiple patterns.)
     * </pre>
     *
     * <code>FUTURE_MULTI_PATTERN = 2;</code>
     */
    FUTURE_MULTI_PATTERN(2),
    UNRECOGNIZED(-1),
    ;

    /**
     * <pre>
     * The "unset" value.
     * </pre>
     *
     * <code>HISTORY_UNSPECIFIED = 0;</code>
     */
    public static final int HISTORY_UNSPECIFIED_VALUE = 0;
    /**
     * <pre>
     * The resource originally had one pattern and launched as such, and
     * additional patterns were added later.
     * </pre>
     *
     * <code>ORIGINALLY_SINGLE_PATTERN = 1;</code>
     */
    public static final int ORIGINALLY_SINGLE_PATTERN_VALUE = 1;
    /**
     * <pre>
     * The resource has one pattern, but the API owner expects to add more
     * later. (This is the inverse of ORIGINALLY_SINGLE_PATTERN, and prevents
     * that from being necessary once there are multiple patterns.)
     * </pre>
     *
     * <code>FUTURE_MULTI_PATTERN = 2;</code>
     */
    public static final int FUTURE_MULTI_PATTERN_VALUE = 2;


    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static History valueOf(int value) {
      return forNumber(value);
    }

    public static History forNumber(int value) {
      switch (value) {
        case 0: return HISTORY_UNSPECIFIED;
        case 1: return ORIGINALLY_SINGLE_PATTERN;
        case 2: return FUTURE_MULTI_PATTERN;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<History>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static final com.google.protobuf.Internal.EnumLiteMap<
        History> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<History>() {
            public History findValueByNumber(int number) {
              return History.forNumber(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return com.google.api.ResourceDescriptor.getDescriptor().getEnumTypes().get(0);
    }

    private static final History[] VALUES = values();

    public static History valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private History(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.api.ResourceDescriptor.History)
  }

  private int bitField0_;
  public static final int TYPE_FIELD_NUMBER = 1;
  private volatile java.lang.Object type_;
  /**
   * <pre>
   * The full name of the resource type. It must be in the format of
   * {service_name}/{resource_type_kind}. The resource type names are
   * singular and do not contain version numbers.
   * For example: `storage.googleapis.com/Bucket`
   * The value of the resource_type_kind must follow the regular expression
   * /[A-Z][a-zA-Z0-9]+/. It must start with upper case character and
   * recommended to use PascalCase (UpperCamelCase). The maximum number of
   * characters allowed for the resource_type_kind is 100.
   * </pre>
   *
   * <code>string type = 1;</code>
   */
  public java.lang.String getType() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      type_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * The full name of the resource type. It must be in the format of
   * {service_name}/{resource_type_kind}. The resource type names are
   * singular and do not contain version numbers.
   * For example: `storage.googleapis.com/Bucket`
   * The value of the resource_type_kind must follow the regular expression
   * /[A-Z][a-zA-Z0-9]+/. It must start with upper case character and
   * recommended to use PascalCase (UpperCamelCase). The maximum number of
   * characters allowed for the resource_type_kind is 100.
   * </pre>
   *
   * <code>string type = 1;</code>
   */
  public com.google.protobuf.ByteString
      getTypeBytes() {
    java.lang.Object ref = type_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      type_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PATTERN_FIELD_NUMBER = 2;
  private com.google.protobuf.LazyStringList pattern_;
  /**
   * <pre>
   * Required. The valid pattern or patterns for this resource's names.
   * Examples:
   *   - "projects/{project}/topics/{topic}"
   *   - "projects/{project}/knowledgeBases/{knowledge_base}"
   * The components in braces correspond to the IDs for each resource in the
   * hierarchy. It is expected that, if multiple patterns are provided,
   * the same component name (e.g. "project") refers to IDs of the same
   * type of resource.
   * </pre>
   *
   * <code>repeated string pattern = 2;</code>
   */
  public com.google.protobuf.ProtocolStringList
      getPatternList() {
    return pattern_;
  }
  /**
   * <pre>
   * Required. The valid pattern or patterns for this resource's names.
   * Examples:
   *   - "projects/{project}/topics/{topic}"
   *   - "projects/{project}/knowledgeBases/{knowledge_base}"
   * The components in braces correspond to the IDs for each resource in the
   * hierarchy. It is expected that, if multiple patterns are provided,
   * the same component name (e.g. "project") refers to IDs of the same
   * type of resource.
   * </pre>
   *
   * <code>repeated string pattern = 2;</code>
   */
  public int getPatternCount() {
    return pattern_.size();
  }
  /**
   * <pre>
   * Required. The valid pattern or patterns for this resource's names.
   * Examples:
   *   - "projects/{project}/topics/{topic}"
   *   - "projects/{project}/knowledgeBases/{knowledge_base}"
   * The components in braces correspond to the IDs for each resource in the
   * hierarchy. It is expected that, if multiple patterns are provided,
   * the same component name (e.g. "project") refers to IDs of the same
   * type of resource.
   * </pre>
   *
   * <code>repeated string pattern = 2;</code>
   */
  public java.lang.String getPattern(int index) {
    return pattern_.get(index);
  }
  /**
   * <pre>
   * Required. The valid pattern or patterns for this resource's names.
   * Examples:
   *   - "projects/{project}/topics/{topic}"
   *   - "projects/{project}/knowledgeBases/{knowledge_base}"
   * The components in braces correspond to the IDs for each resource in the
   * hierarchy. It is expected that, if multiple patterns are provided,
   * the same component name (e.g. "project") refers to IDs of the same
   * type of resource.
   * </pre>
   *
   * <code>repeated string pattern = 2;</code>
   */
  public com.google.protobuf.ByteString
      getPatternBytes(int index) {
    return pattern_.getByteString(index);
  }

  public static final int NAME_FIELD_FIELD_NUMBER = 3;
  private volatile java.lang.Object nameField_;
  /**
   * <pre>
   * Optional. The field on the resource that designates the resource name
   * field. If omitted, this is assumed to be "name".
   * </pre>
   *
   * <code>string name_field = 3;</code>
   */
  public java.lang.String getNameField() {
    java.lang.Object ref = nameField_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nameField_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Optional. The field on the resource that designates the resource name
   * field. If omitted, this is assumed to be "name".
   * </pre>
   *
   * <code>string name_field = 3;</code>
   */
  public com.google.protobuf.ByteString
      getNameFieldBytes() {
    java.lang.Object ref = nameField_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      nameField_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HISTORY_FIELD_NUMBER = 4;
  private int history_;
  /**
   * <pre>
   * Optional. The historical or future-looking state of the resource pattern.
   * Example:
   *   // The InspectTemplate message originally only supported resource
   *   // names with organization, and project was added later.
   *   message InspectTemplate {
   *     option (google.api.resource) = {
   *       type: "dlp.googleapis.com/InspectTemplate"
   *       pattern: "organizations/{organization}/inspectTemplates/{inspect_template}"
   *       pattern: "projects/{project}/inspectTemplates/{inspect_template}"
   *       history: ORIGINALLY_SINGLE_PATTERN
   *     };
   *   }
   * </pre>
   *
   * <code>.google.api.ResourceDescriptor.History history = 4;</code>
   */
  public int getHistoryValue() {
    return history_;
  }
  /**
   * <pre>
   * Optional. The historical or future-looking state of the resource pattern.
   * Example:
   *   // The InspectTemplate message originally only supported resource
   *   // names with organization, and project was added later.
   *   message InspectTemplate {
   *     option (google.api.resource) = {
   *       type: "dlp.googleapis.com/InspectTemplate"
   *       pattern: "organizations/{organization}/inspectTemplates/{inspect_template}"
   *       pattern: "projects/{project}/inspectTemplates/{inspect_template}"
   *       history: ORIGINALLY_SINGLE_PATTERN
   *     };
   *   }
   * </pre>
   *
   * <code>.google.api.ResourceDescriptor.History history = 4;</code>
   */
  public com.google.api.ResourceDescriptor.History getHistory() {
    @SuppressWarnings("deprecation")
    com.google.api.ResourceDescriptor.History result = com.google.api.ResourceDescriptor.History.valueOf(history_);
    return result == null ? com.google.api.ResourceDescriptor.History.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!getTypeBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, type_);
    }
    for (int i = 0; i < pattern_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pattern_.getRaw(i));
    }
    if (!getNameFieldBytes().isEmpty()) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, nameField_);
    }
    if (history_ != com.google.api.ResourceDescriptor.History.HISTORY_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, history_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!getTypeBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, type_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < pattern_.size(); i++) {
        dataSize += computeStringSizeNoTag(pattern_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getPatternList().size();
    }
    if (!getNameFieldBytes().isEmpty()) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, nameField_);
    }
    if (history_ != com.google.api.ResourceDescriptor.History.HISTORY_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(4, history_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.api.ResourceDescriptor)) {
      return super.equals(obj);
    }
    com.google.api.ResourceDescriptor other = (com.google.api.ResourceDescriptor) obj;

    if (!getType()
        .equals(other.getType())) return false;
    if (!getPatternList()
        .equals(other.getPatternList())) return false;
    if (!getNameField()
        .equals(other.getNameField())) return false;
    if (history_ != other.history_) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + getType().hashCode();
    if (getPatternCount() > 0) {
      hash = (37 * hash) + PATTERN_FIELD_NUMBER;
      hash = (53 * hash) + getPatternList().hashCode();
    }
    hash = (37 * hash) + NAME_FIELD_FIELD_NUMBER;
    hash = (53 * hash) + getNameField().hashCode();
    hash = (37 * hash) + HISTORY_FIELD_NUMBER;
    hash = (53 * hash) + history_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.api.ResourceDescriptor parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.ResourceDescriptor parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.ResourceDescriptor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.ResourceDescriptor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.ResourceDescriptor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.api.ResourceDescriptor parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.api.ResourceDescriptor parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.ResourceDescriptor parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.ResourceDescriptor parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }
  public static com.google.api.ResourceDescriptor parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.api.ResourceDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.api.ResourceDescriptor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.api.ResourceDescriptor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A simple descriptor of a resource type.
   * ResourceDescriptor annotates a resource message (either by means of a
   * protobuf annotation or use in the service config), and associates the
   * resource's schema, the resource type, and the pattern of the resource name.
   * Example:
   *   message Topic {
   *     // Indicates this message defines a resource schema.
   *     // Declares the resource type in the format of {service}/{kind}.
   *     // For Kubernetes resources, the format is {api group}/{kind}.
   *     option (google.api.resource) = {
   *       type: "pubsub.googleapis.com/Topic"
   *       pattern: "projects/{project}/topics/{topic}"
   *     };
   *   }
   * Sometimes, resources have multiple patterns, typically because they can
   * live under multiple parents.
   * Example:
   *   message LogEntry {
   *     option (google.api.resource) = {
   *       type: "logging.googleapis.com/LogEntry"
   *       pattern: "projects/{project}/logs/{log}"
   *       pattern: "organizations/{organization}/logs/{log}"
   *       pattern: "folders/{folder}/logs/{log}"
   *       pattern: "billingAccounts/{billing_account}/logs/{log}"
   *     };
   *   }
   * </pre>
   *
   * Protobuf type {@code google.api.ResourceDescriptor}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.api.ResourceDescriptor)
      com.google.api.ResourceDescriptorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.api.ResourceProto.internal_static_google_api_ResourceDescriptor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.api.ResourceProto.internal_static_google_api_ResourceDescriptor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.api.ResourceDescriptor.class, com.google.api.ResourceDescriptor.Builder.class);
    }

    // Construct using com.google.api.ResourceDescriptor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }
    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3
              .alwaysUseFieldBuilders) {
      }
    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      type_ = "";

      pattern_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      nameField_ = "";

      history_ = 0;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.api.ResourceProto.internal_static_google_api_ResourceDescriptor_descriptor;
    }

    @java.lang.Override
    public com.google.api.ResourceDescriptor getDefaultInstanceForType() {
      return com.google.api.ResourceDescriptor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.api.ResourceDescriptor build() {
      com.google.api.ResourceDescriptor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.api.ResourceDescriptor buildPartial() {
      com.google.api.ResourceDescriptor result = new com.google.api.ResourceDescriptor(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      result.type_ = type_;
      if (((bitField0_ & 0x00000002) != 0)) {
        pattern_ = pattern_.getUnmodifiableView();
        bitField0_ = (bitField0_ & ~0x00000002);
      }
      result.pattern_ = pattern_;
      result.nameField_ = nameField_;
      result.history_ = history_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.api.ResourceDescriptor) {
        return mergeFrom((com.google.api.ResourceDescriptor)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.api.ResourceDescriptor other) {
      if (other == com.google.api.ResourceDescriptor.getDefaultInstance()) return this;
      if (!other.getType().isEmpty()) {
        type_ = other.type_;
        onChanged();
      }
      if (!other.pattern_.isEmpty()) {
        if (pattern_.isEmpty()) {
          pattern_ = other.pattern_;
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          ensurePatternIsMutable();
          pattern_.addAll(other.pattern_);
        }
        onChanged();
      }
      if (!other.getNameField().isEmpty()) {
        nameField_ = other.nameField_;
        onChanged();
      }
      if (other.history_ != 0) {
        setHistoryValue(other.getHistoryValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.api.ResourceDescriptor parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.api.ResourceDescriptor) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }
    private int bitField0_;

    private java.lang.Object type_ = "";
    /**
     * <pre>
     * The full name of the resource type. It must be in the format of
     * {service_name}/{resource_type_kind}. The resource type names are
     * singular and do not contain version numbers.
     * For example: `storage.googleapis.com/Bucket`
     * The value of the resource_type_kind must follow the regular expression
     * /[A-Z][a-zA-Z0-9]+/. It must start with upper case character and
     * recommended to use PascalCase (UpperCamelCase). The maximum number of
     * characters allowed for the resource_type_kind is 100.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public java.lang.String getType() {
      java.lang.Object ref = type_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        type_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * The full name of the resource type. It must be in the format of
     * {service_name}/{resource_type_kind}. The resource type names are
     * singular and do not contain version numbers.
     * For example: `storage.googleapis.com/Bucket`
     * The value of the resource_type_kind must follow the regular expression
     * /[A-Z][a-zA-Z0-9]+/. It must start with upper case character and
     * recommended to use PascalCase (UpperCamelCase). The maximum number of
     * characters allowed for the resource_type_kind is 100.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public com.google.protobuf.ByteString
        getTypeBytes() {
      java.lang.Object ref = type_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        type_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * The full name of the resource type. It must be in the format of
     * {service_name}/{resource_type_kind}. The resource type names are
     * singular and do not contain version numbers.
     * For example: `storage.googleapis.com/Bucket`
     * The value of the resource_type_kind must follow the regular expression
     * /[A-Z][a-zA-Z0-9]+/. It must start with upper case character and
     * recommended to use PascalCase (UpperCamelCase). The maximum number of
     * characters allowed for the resource_type_kind is 100.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public Builder setType(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      type_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The full name of the resource type. It must be in the format of
     * {service_name}/{resource_type_kind}. The resource type names are
     * singular and do not contain version numbers.
     * For example: `storage.googleapis.com/Bucket`
     * The value of the resource_type_kind must follow the regular expression
     * /[A-Z][a-zA-Z0-9]+/. It must start with upper case character and
     * recommended to use PascalCase (UpperCamelCase). The maximum number of
     * characters allowed for the resource_type_kind is 100.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public Builder clearType() {
      
      type_ = getDefaultInstance().getType();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The full name of the resource type. It must be in the format of
     * {service_name}/{resource_type_kind}. The resource type names are
     * singular and do not contain version numbers.
     * For example: `storage.googleapis.com/Bucket`
     * The value of the resource_type_kind must follow the regular expression
     * /[A-Z][a-zA-Z0-9]+/. It must start with upper case character and
     * recommended to use PascalCase (UpperCamelCase). The maximum number of
     * characters allowed for the resource_type_kind is 100.
     * </pre>
     *
     * <code>string type = 1;</code>
     */
    public Builder setTypeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      type_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringList pattern_ = com.google.protobuf.LazyStringArrayList.EMPTY;
    private void ensurePatternIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        pattern_ = new com.google.protobuf.LazyStringArrayList(pattern_);
        bitField0_ |= 0x00000002;
       }
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public com.google.protobuf.ProtocolStringList
        getPatternList() {
      return pattern_.getUnmodifiableView();
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public int getPatternCount() {
      return pattern_.size();
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public java.lang.String getPattern(int index) {
      return pattern_.get(index);
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public com.google.protobuf.ByteString
        getPatternBytes(int index) {
      return pattern_.getByteString(index);
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public Builder setPattern(
        int index, java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensurePatternIsMutable();
      pattern_.set(index, value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public Builder addPattern(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  ensurePatternIsMutable();
      pattern_.add(value);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public Builder addAllPattern(
        java.lang.Iterable<java.lang.String> values) {
      ensurePatternIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, pattern_);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public Builder clearPattern() {
      pattern_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Required. The valid pattern or patterns for this resource's names.
     * Examples:
     *   - "projects/{project}/topics/{topic}"
     *   - "projects/{project}/knowledgeBases/{knowledge_base}"
     * The components in braces correspond to the IDs for each resource in the
     * hierarchy. It is expected that, if multiple patterns are provided,
     * the same component name (e.g. "project") refers to IDs of the same
     * type of resource.
     * </pre>
     *
     * <code>repeated string pattern = 2;</code>
     */
    public Builder addPatternBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      ensurePatternIsMutable();
      pattern_.add(value);
      onChanged();
      return this;
    }

    private java.lang.Object nameField_ = "";
    /**
     * <pre>
     * Optional. The field on the resource that designates the resource name
     * field. If omitted, this is assumed to be "name".
     * </pre>
     *
     * <code>string name_field = 3;</code>
     */
    public java.lang.String getNameField() {
      java.lang.Object ref = nameField_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nameField_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Optional. The field on the resource that designates the resource name
     * field. If omitted, this is assumed to be "name".
     * </pre>
     *
     * <code>string name_field = 3;</code>
     */
    public com.google.protobuf.ByteString
        getNameFieldBytes() {
      java.lang.Object ref = nameField_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        nameField_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Optional. The field on the resource that designates the resource name
     * field. If omitted, this is assumed to be "name".
     * </pre>
     *
     * <code>string name_field = 3;</code>
     */
    public Builder setNameField(
        java.lang.String value) {
      if (value == null) {
    throw new NullPointerException();
  }
  
      nameField_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The field on the resource that designates the resource name
     * field. If omitted, this is assumed to be "name".
     * </pre>
     *
     * <code>string name_field = 3;</code>
     */
    public Builder clearNameField() {
      
      nameField_ = getDefaultInstance().getNameField();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The field on the resource that designates the resource name
     * field. If omitted, this is assumed to be "name".
     * </pre>
     *
     * <code>string name_field = 3;</code>
     */
    public Builder setNameFieldBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) {
    throw new NullPointerException();
  }
  checkByteStringIsUtf8(value);
      
      nameField_ = value;
      onChanged();
      return this;
    }

    private int history_ = 0;
    /**
     * <pre>
     * Optional. The historical or future-looking state of the resource pattern.
     * Example:
     *   // The InspectTemplate message originally only supported resource
     *   // names with organization, and project was added later.
     *   message InspectTemplate {
     *     option (google.api.resource) = {
     *       type: "dlp.googleapis.com/InspectTemplate"
     *       pattern: "organizations/{organization}/inspectTemplates/{inspect_template}"
     *       pattern: "projects/{project}/inspectTemplates/{inspect_template}"
     *       history: ORIGINALLY_SINGLE_PATTERN
     *     };
     *   }
     * </pre>
     *
     * <code>.google.api.ResourceDescriptor.History history = 4;</code>
     */
    public int getHistoryValue() {
      return history_;
    }
    /**
     * <pre>
     * Optional. The historical or future-looking state of the resource pattern.
     * Example:
     *   // The InspectTemplate message originally only supported resource
     *   // names with organization, and project was added later.
     *   message InspectTemplate {
     *     option (google.api.resource) = {
     *       type: "dlp.googleapis.com/InspectTemplate"
     *       pattern: "organizations/{organization}/inspectTemplates/{inspect_template}"
     *       pattern: "projects/{project}/inspectTemplates/{inspect_template}"
     *       history: ORIGINALLY_SINGLE_PATTERN
     *     };
     *   }
     * </pre>
     *
     * <code>.google.api.ResourceDescriptor.History history = 4;</code>
     */
    public Builder setHistoryValue(int value) {
      history_ = value;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The historical or future-looking state of the resource pattern.
     * Example:
     *   // The InspectTemplate message originally only supported resource
     *   // names with organization, and project was added later.
     *   message InspectTemplate {
     *     option (google.api.resource) = {
     *       type: "dlp.googleapis.com/InspectTemplate"
     *       pattern: "organizations/{organization}/inspectTemplates/{inspect_template}"
     *       pattern: "projects/{project}/inspectTemplates/{inspect_template}"
     *       history: ORIGINALLY_SINGLE_PATTERN
     *     };
     *   }
     * </pre>
     *
     * <code>.google.api.ResourceDescriptor.History history = 4;</code>
     */
    public com.google.api.ResourceDescriptor.History getHistory() {
      @SuppressWarnings("deprecation")
      com.google.api.ResourceDescriptor.History result = com.google.api.ResourceDescriptor.History.valueOf(history_);
      return result == null ? com.google.api.ResourceDescriptor.History.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Optional. The historical or future-looking state of the resource pattern.
     * Example:
     *   // The InspectTemplate message originally only supported resource
     *   // names with organization, and project was added later.
     *   message InspectTemplate {
     *     option (google.api.resource) = {
     *       type: "dlp.googleapis.com/InspectTemplate"
     *       pattern: "organizations/{organization}/inspectTemplates/{inspect_template}"
     *       pattern: "projects/{project}/inspectTemplates/{inspect_template}"
     *       history: ORIGINALLY_SINGLE_PATTERN
     *     };
     *   }
     * </pre>
     *
     * <code>.google.api.ResourceDescriptor.History history = 4;</code>
     */
    public Builder setHistory(com.google.api.ResourceDescriptor.History value) {
      if (value == null) {
        throw new NullPointerException();
      }
      
      history_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Optional. The historical or future-looking state of the resource pattern.
     * Example:
     *   // The InspectTemplate message originally only supported resource
     *   // names with organization, and project was added later.
     *   message InspectTemplate {
     *     option (google.api.resource) = {
     *       type: "dlp.googleapis.com/InspectTemplate"
     *       pattern: "organizations/{organization}/inspectTemplates/{inspect_template}"
     *       pattern: "projects/{project}/inspectTemplates/{inspect_template}"
     *       history: ORIGINALLY_SINGLE_PATTERN
     *     };
     *   }
     * </pre>
     *
     * <code>.google.api.ResourceDescriptor.History history = 4;</code>
     */
    public Builder clearHistory() {
      
      history_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.api.ResourceDescriptor)
  }

  // @@protoc_insertion_point(class_scope:google.api.ResourceDescriptor)
  private static final com.google.api.ResourceDescriptor DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.api.ResourceDescriptor();
  }

  public static com.google.api.ResourceDescriptor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResourceDescriptor>
      PARSER = new com.google.protobuf.AbstractParser<ResourceDescriptor>() {
    @java.lang.Override
    public ResourceDescriptor parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return new ResourceDescriptor(input, extensionRegistry);
    }
  };

  public static com.google.protobuf.Parser<ResourceDescriptor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResourceDescriptor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.api.ResourceDescriptor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

