/*
 * Copyright (c) 2005 Stefan Walter
 * Copyright (c) 2011 Collabora Ltd.
 * Copyright (c) 2013 Red Hat Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions of source code must retain the above
 *       copyright notice, this list of conditions and the
 *       following disclaimer.
 *     * Redistributions in binary form must reproduce the
 *       above copyright notice, this list of conditions and
 *       the following disclaimer in the documentation and/or
 *       other materials provided with the distribution.
 *     * The names of contributors to this software may not be
 *       used to endorse or promote products derived from this
 *       software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
 * THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Author: Stef Walter <stefw@redhat.com>
 */

#ifndef P11_LEXER_H__
#define P11_LEXER_H__

#include "compat.h"

typedef enum _p11_lexer_token_type {
	TOK_EOF,
	TOK_SECTION,
	TOK_FIELD,
	TOK_PEM,
} p11_lexer_token_type;

typedef struct {
	char *filename;
	size_t line;
	const char *at;
	size_t remaining;
	bool complained;

	p11_lexer_token_type tok_type;
	union {
		struct {
			char *name;
		} section;
		struct {
			char *name;
			char *value;
		} field;
		struct {
			const char *begin;
			size_t length;
		} pem;
	} tok;
} p11_lexer;

void             p11_lexer_init               (p11_lexer *lexer,
                                               const char *filename,
                                               const char *data,
                                               size_t length);

bool             p11_lexer_next               (p11_lexer *lexer,
                                               bool *failed);

void             p11_lexer_done               (p11_lexer *lexer);

void             p11_lexer_msg                (p11_lexer *lexer,
                                               const char *msg);

#endif /* P11_LEXER_H__ */
