package picard.util.help;

import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.help.DocWorkUnit;
import org.broadinstitute.barclay.help.HelpDoclet;

import javax.lang.model.element.Element;
import java.util.Map;

/**
 * Custom Barclay-based Javadoc Doclet used for generating Picard help/documentation.
 *
 * NOTE: Methods in this class are intended to be called by Gradle/Javadoc only, and should not be called
 * by methods that are used by the Picard runtime. This class has a dependency on com.sun.javadoc classes,
 * which may not be present since they're not provided as part of the normal Picard runtime classpath.
 */
public class PicardHelpDoclet extends HelpDoclet {

    private final static String PICARD_FREEMARKER_INDEX_TEMPLATE_NAME = "generic.index.template.html";

    /**
     * Return the name of the freemarker template to be used for the index generated by Barclay.
     * Must reside in the folder passed to the Barclay Javadc Doclet via the "-settings-dir" parameter.
     * @return name of freemarker index template
     */
    @Override
    public String getIndexTemplateName() {
        return PICARD_FREEMARKER_INDEX_TEMPLATE_NAME;
    }

    @Override
    public DocWorkUnit createWorkUnit(
            final Element classElement,
            final Class<?> clazz,
            final DocumentedFeature documentedFeature)
    {
        return new DocWorkUnit(
                new PicardHelpDocWorkUnitHandler(this),
                classElement,
                clazz,
                documentedFeature);
    }

    /**
     * Adds a super-category so that we can custom-order the categories in the doc index
     *
     * @param docWorkUnit
     * @return root Map after having added the super-category
     */
    @Override
    protected final Map<String, String> getGroupMap(final DocWorkUnit docWorkUnit) {
        final Map<String, String> root = super.getGroupMap(docWorkUnit);

        /**
         * Add-on super-category definitions. The super-category and spark value strings need to be the
         * same as used in the Freemarker template.
         */
        root.put("supercat", HelpConstants.getSuperCategoryProperty(docWorkUnit.getGroupName()));

        return root;
    }

}
