# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.workloadorchestration import WorkloadOrchestrationMgmtClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-workloadorchestration
# USAGE
    python workflow_versions_update_maximum_set_gen.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = WorkloadOrchestrationMgmtClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.workflow_versions.begin_update(
        resource_group_name="rgconfigurationmanager",
        context_name="testname",
        workflow_name="testname",
        version_name="testname",
        properties={
            "properties": {
                "specification": {},
                "stageSpec": [
                    {
                        "name": "amrbjd",
                        "specification": {},
                        "taskOption": {
                            "concurrency": 3,
                            "errorAction": {"maxToleratedFailures": 0, "mode": "stopOnAnyFailure"},
                        },
                        "tasks": [
                            {
                                "name": "xxmeyvmgydbcwxqwjhadjxjod",
                                "specification": {},
                                "targetId": "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}",
                            }
                        ],
                    }
                ],
            }
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-06-01/WorkflowVersions_Update_MaximumSet_Gen.json
if __name__ == "__main__":
    main()
