# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.authorization.aio import AuthorizationManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAuthorizationManagementScopeAccessReviewDefaultSettingsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(AuthorizationManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_scope_access_review_default_settings_get(self, resource_group):
        response = await self.client.scope_access_review_default_settings.get(
            scope="str",
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_scope_access_review_default_settings_put(self, resource_group):
        response = await self.client.scope_access_review_default_settings.put(
            scope="str",
            properties={
                "autoApplyDecisionsEnabled": bool,
                "defaultDecision": "str",
                "defaultDecisionEnabled": bool,
                "endDate": "2020-02-20 00:00:00",
                "instanceDurationInDays": 0,
                "interval": 0,
                "justificationRequiredOnApproval": bool,
                "mailNotificationsEnabled": bool,
                "numberOfOccurrences": 0,
                "recommendationLookBackDuration": "1 day, 0:00:00",
                "recommendationsEnabled": bool,
                "reminderNotificationsEnabled": bool,
                "startDate": "2020-02-20 00:00:00",
                "type": "str",
            },
            api_version="2021-12-01-preview",
        )

        # please add some check logic here by yourself
        # ...
