
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Quantity_Color.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <XSControl_WorkSession.hxx>
#include <TDocStd_Document.hxx>

// module includes
#include <IGESCAFControl.hxx>
#include <IGESCAFControl_ConfigurationNode.hxx>
#include <IGESCAFControl_Provider.hxx>
#include <IGESCAFControl_Reader.hxx>
#include <IGESCAFControl_Writer.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <DE_ConfigurationContext.hxx>

// Module definiiton
void register_IGESCAFControl(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("IGESCAFControl"));
py::object klass;

//Python trampoline classes

// classes

    // Class IGESCAFControl from ./opencascade/IGESCAFControl.hxx
    klass = m.attr("IGESCAFControl");

    // default constructor
    register_default_constructor<IGESCAFControl , shared_ptr<IGESCAFControl>>(m,"IGESCAFControl");

    // nested enums

    static_cast<py::class_<IGESCAFControl , shared_ptr<IGESCAFControl>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DecodeColor_s",
                    (Quantity_Color (*)( const Standard_Integer  ) ) static_cast<Quantity_Color (*)( const Standard_Integer  ) >(&IGESCAFControl::DecodeColor),
                    R"#(Provides a tool for writing IGES file Converts IGES color index to CASCADE color)#"  , py::arg("col")
          )
        .def_static("EncodeColor_s",
                    (Standard_Integer (*)( const Quantity_Color &  ) ) static_cast<Standard_Integer (*)( const Quantity_Color &  ) >(&IGESCAFControl::EncodeColor),
                    R"#(Tries to Convert CASCADE color to IGES color index If no corresponding color defined in IGES, returns 0)#"  , py::arg("col")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IGESCAFControl_ConfigurationNode from ./opencascade/IGESCAFControl_ConfigurationNode.hxx
    klass = m.attr("IGESCAFControl_ConfigurationNode");


    // nested enums
        py::enum_<IGESCAFControl_ConfigurationNode::ReadMode_BSplineContinuity>(klass, "ReadMode_BSplineContinuity_e", R"#(None)#")
            .value("ReadMode_BSplineContinuity_C0", IGESCAFControl_ConfigurationNode::ReadMode_BSplineContinuity::ReadMode_BSplineContinuity_C0)
            .value("ReadMode_BSplineContinuity_C1", IGESCAFControl_ConfigurationNode::ReadMode_BSplineContinuity::ReadMode_BSplineContinuity_C1)
            .value("ReadMode_BSplineContinuity_C2", IGESCAFControl_ConfigurationNode::ReadMode_BSplineContinuity::ReadMode_BSplineContinuity_C2).export_values();
        py::enum_<IGESCAFControl_ConfigurationNode::ReadMode_Precision>(klass, "ReadMode_Precision_e", R"#(None)#")
            .value("ReadMode_Precision_File", IGESCAFControl_ConfigurationNode::ReadMode_Precision::ReadMode_Precision_File)
            .value("ReadMode_Precision_User", IGESCAFControl_ConfigurationNode::ReadMode_Precision::ReadMode_Precision_User).export_values();
        py::enum_<IGESCAFControl_ConfigurationNode::ReadMode_MaxPrecision>(klass, "ReadMode_MaxPrecision_e", R"#(None)#")
            .value("ReadMode_MaxPrecision_Preferred", IGESCAFControl_ConfigurationNode::ReadMode_MaxPrecision::ReadMode_MaxPrecision_Preferred)
            .value("ReadMode_MaxPrecision_Forced", IGESCAFControl_ConfigurationNode::ReadMode_MaxPrecision::ReadMode_MaxPrecision_Forced).export_values();
        py::enum_<IGESCAFControl_ConfigurationNode::ReadMode_SurfaceCurve>(klass, "ReadMode_SurfaceCurve_e", R"#(None)#")
            .value("ReadMode_SurfaceCurve_Default", IGESCAFControl_ConfigurationNode::ReadMode_SurfaceCurve::ReadMode_SurfaceCurve_Default)
            .value("ReadMode_SurfaceCurve_2DUse_Preferred", IGESCAFControl_ConfigurationNode::ReadMode_SurfaceCurve::ReadMode_SurfaceCurve_2DUse_Preferred)
            .value("ReadMode_SurfaceCurve_2DUse_Forced", IGESCAFControl_ConfigurationNode::ReadMode_SurfaceCurve::ReadMode_SurfaceCurve_2DUse_Forced)
            .value("ReadMode_SurfaceCurve_3DUse_Preferred", IGESCAFControl_ConfigurationNode::ReadMode_SurfaceCurve::ReadMode_SurfaceCurve_3DUse_Preferred)
            .value("ReadMode_SurfaceCurve_3DUse_Forced", IGESCAFControl_ConfigurationNode::ReadMode_SurfaceCurve::ReadMode_SurfaceCurve_3DUse_Forced).export_values();
        py::enum_<IGESCAFControl_ConfigurationNode::WriteMode_BRep>(klass, "WriteMode_BRep_e", R"#(None)#")
            .value("WriteMode_BRep_Faces", IGESCAFControl_ConfigurationNode::WriteMode_BRep::WriteMode_BRep_Faces)
            .value("WriteMode_BRep_BRep", IGESCAFControl_ConfigurationNode::WriteMode_BRep::WriteMode_BRep_BRep).export_values();
        py::enum_<IGESCAFControl_ConfigurationNode::WriteMode_ConvertSurface>(klass, "WriteMode_ConvertSurface_e", R"#(None)#")
            .value("WriteMode_ConvertSurface_Off", IGESCAFControl_ConfigurationNode::WriteMode_ConvertSurface::WriteMode_ConvertSurface_Off)
            .value("WriteMode_ConvertSurface_On", IGESCAFControl_ConfigurationNode::WriteMode_ConvertSurface::WriteMode_ConvertSurface_On).export_values();
        py::enum_<IGESCAFControl_ConfigurationNode::WriteMode_PrecisionMode>(klass, "WriteMode_PrecisionMode_e", R"#(None)#")
            .value("WriteMode_PrecisionMode_Least", IGESCAFControl_ConfigurationNode::WriteMode_PrecisionMode::WriteMode_PrecisionMode_Least)
            .value("WriteMode_PrecisionMode_Average", IGESCAFControl_ConfigurationNode::WriteMode_PrecisionMode::WriteMode_PrecisionMode_Average)
            .value("WriteMode_PrecisionMode_Greatest", IGESCAFControl_ConfigurationNode::WriteMode_PrecisionMode::WriteMode_PrecisionMode_Greatest)
            .value("WriteMode_PrecisionMode_Session", IGESCAFControl_ConfigurationNode::WriteMode_PrecisionMode::WriteMode_PrecisionMode_Session).export_values();
        py::enum_<IGESCAFControl_ConfigurationNode::WriteMode_PlaneMode>(klass, "WriteMode_PlaneMode_e", R"#(None)#")
            .value("WriteMode_PlaneMode_Plane", IGESCAFControl_ConfigurationNode::WriteMode_PlaneMode::WriteMode_PlaneMode_Plane)
            .value("WriteMode_PlaneMode_BSpline", IGESCAFControl_ConfigurationNode::WriteMode_PlaneMode::WriteMode_PlaneMode_BSpline).export_values();

    static_cast<py::class_<IGESCAFControl_ConfigurationNode ,opencascade::handle<IGESCAFControl_ConfigurationNode>  , DE_ConfigurationNode >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<IGESCAFControl_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Load",
             (bool (IGESCAFControl_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) ) static_cast<bool (IGESCAFControl_ConfigurationNode::*)( const opencascade::handle<DE_ConfigurationContext> &  ) >(&IGESCAFControl_ConfigurationNode::Load),
             R"#(Updates values according the resource)#"  , py::arg("theResource")
          )
        .def("Save",
             (TCollection_AsciiString (IGESCAFControl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::Save),
             R"#(Writes configuration to the string)#" 
          )
        .def("Copy",
             (opencascade::handle<DE_ConfigurationNode> (IGESCAFControl_ConfigurationNode::*)() const) static_cast<opencascade::handle<DE_ConfigurationNode> (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::Copy),
             R"#(Copies values of all fields)#" 
          )
        .def("BuildProvider",
             (opencascade::handle<DE_Provider> (IGESCAFControl_ConfigurationNode::*)() ) static_cast<opencascade::handle<DE_Provider> (IGESCAFControl_ConfigurationNode::*)() >(&IGESCAFControl_ConfigurationNode::BuildProvider),
             R"#(Creates new provider for the own format)#" 
          )
        .def("IsImportSupported",
             (bool (IGESCAFControl_ConfigurationNode::*)() const) static_cast<bool (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::IsImportSupported),
             R"#(Checks the import supporting)#" 
          )
        .def("IsExportSupported",
             (bool (IGESCAFControl_ConfigurationNode::*)() const) static_cast<bool (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::IsExportSupported),
             R"#(Checks the export supporting)#" 
          )
        .def("GetFormat",
             (TCollection_AsciiString (IGESCAFControl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (IGESCAFControl_ConfigurationNode::*)() const) static_cast<TCollection_AsciiString (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
        .def("GetExtensions",
             (TColStd_ListOfAsciiString (IGESCAFControl_ConfigurationNode::*)() const) static_cast<TColStd_ListOfAsciiString (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::GetExtensions),
             R"#(Gets list of supported file extensions)#" 
          )
        .def("CheckContent",
             (bool (IGESCAFControl_ConfigurationNode::*)( const opencascade::handle<NCollection_Buffer> &  ) const) static_cast<bool (IGESCAFControl_ConfigurationNode::*)( const opencascade::handle<NCollection_Buffer> &  ) const>(&IGESCAFControl_ConfigurationNode::CheckContent),
             R"#(Checks the file content to verify a format)#"  , py::arg("theBuffer")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&IGESCAFControl_ConfigurationNode::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&IGESCAFControl_ConfigurationNode::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (IGESCAFControl_ConfigurationNode::*)() const) static_cast<const opencascade::handle<Standard_Type> & (IGESCAFControl_ConfigurationNode::*)() const>(&IGESCAFControl_ConfigurationNode::DynamicType),
             R"#(None)#"
             
         )
;

    // Class IGESCAFControl_Provider from ./opencascade/IGESCAFControl_Provider.hxx
    klass = m.attr("IGESCAFControl_Provider");


    // nested enums

    static_cast<py::class_<IGESCAFControl_Provider ,opencascade::handle<IGESCAFControl_Provider>  , DE_Provider >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<DE_ConfigurationNode> & >()  , py::arg("theNode") )
    // custom constructors
    // methods
        .def("Read",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theDocument"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  opencascade::handle<XSControl_WorkSession> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theWS"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Read",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Read),
             R"#(Reads a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Write",
             (bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) ) static_cast<bool (IGESCAFControl_Provider::*)( const TCollection_AsciiString & ,  const TopoDS_Shape & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Provider::Write),
             R"#(Writes a CAD file, according internal configuration)#"  , py::arg("thePath"),  py::arg("theShape"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("GetFormat",
             (TCollection_AsciiString (IGESCAFControl_Provider::*)() const) static_cast<TCollection_AsciiString (IGESCAFControl_Provider::*)() const>(&IGESCAFControl_Provider::GetFormat),
             R"#(Gets CAD format name of associated provider)#" 
          )
        .def("GetVendor",
             (TCollection_AsciiString (IGESCAFControl_Provider::*)() const) static_cast<TCollection_AsciiString (IGESCAFControl_Provider::*)() const>(&IGESCAFControl_Provider::GetVendor),
             R"#(Gets provider's vendor name of associated provider)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&IGESCAFControl_Provider::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&IGESCAFControl_Provider::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (IGESCAFControl_Provider::*)() const) static_cast<const opencascade::handle<Standard_Type> & (IGESCAFControl_Provider::*)() const>(&IGESCAFControl_Provider::DynamicType),
             R"#(None)#"
             
         )
;

    // Class IGESCAFControl_Reader from ./opencascade/IGESCAFControl_Reader.hxx
    klass = m.attr("IGESCAFControl_Reader");


    // nested enums

    static_cast<py::class_<IGESCAFControl_Reader , shared_ptr<IGESCAFControl_Reader>  , IGESControl_Reader >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<XSControl_WorkSession> &,const Standard_Boolean >()  , py::arg("theWS"),  py::arg("FromScratch")=static_cast<const Standard_Boolean>(Standard_True) )
    // custom constructors
    // methods
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Reader::*)( const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)( const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Reader::Transfer),
             R"#(Translates currently loaded IGES file into the document Returns True if succeeded, and False in case of fail)#"  , py::arg("theDoc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Reader::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)( const TCollection_AsciiString & ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Reader::Perform),
             R"#(None)#"  , py::arg("theFileName"),  py::arg("theDoc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Reader::*)( const Standard_CString ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)( const Standard_CString ,  const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Reader::Perform),
             R"#(Translate IGES file given by filename into the document Return True if succeeded, and False in case of fail)#"  , py::arg("theFileName"),  py::arg("theDoc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("SetColorMode",
             (void (IGESCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Reader::*)( const Standard_Boolean  ) >(&IGESCAFControl_Reader::SetColorMode),
             R"#(Set ColorMode for indicate read Colors or not.)#"  , py::arg("theMode")
          )
        .def("GetColorMode",
             (Standard_Boolean (IGESCAFControl_Reader::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)() const>(&IGESCAFControl_Reader::GetColorMode),
             R"#(None)#" 
          )
        .def("SetNameMode",
             (void (IGESCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Reader::*)( const Standard_Boolean  ) >(&IGESCAFControl_Reader::SetNameMode),
             R"#(Set NameMode for indicate read Name or not.)#"  , py::arg("theMode")
          )
        .def("GetNameMode",
             (Standard_Boolean (IGESCAFControl_Reader::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)() const>(&IGESCAFControl_Reader::GetNameMode),
             R"#(None)#" 
          )
        .def("SetLayerMode",
             (void (IGESCAFControl_Reader::*)( const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Reader::*)( const Standard_Boolean  ) >(&IGESCAFControl_Reader::SetLayerMode),
             R"#(Set LayerMode for indicate read Layers or not.)#"  , py::arg("theMode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (IGESCAFControl_Reader::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Reader::*)() const>(&IGESCAFControl_Reader::GetLayerMode),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class IGESCAFControl_Writer from ./opencascade/IGESCAFControl_Writer.hxx
    klass = m.attr("IGESCAFControl_Writer");


    // nested enums

    static_cast<py::class_<IGESCAFControl_Writer , shared_ptr<IGESCAFControl_Writer>  , IGESControl_Writer >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<XSControl_WorkSession> &,const Standard_Boolean >()  , py::arg("WS"),  py::arg("scratch")=static_cast<const Standard_Boolean>(Standard_True) )
    // custom constructors
    // methods
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Transfer),
             R"#(Transfers a document to a IGES model Returns True if translation is OK)#"  , py::arg("doc"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Writer::*)(  const NCollection_Sequence<TDF_Label> & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)(  const NCollection_Sequence<TDF_Label> & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Transfer),
             R"#(Transfers labels to a IGES model Returns True if translation is OK)#"  , py::arg("labels"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Transfer",
             (Standard_Boolean (IGESCAFControl_Writer::*)( const TDF_Label & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)( const TDF_Label & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Transfer),
             R"#(Transfers label to a IGES model Returns True if translation is OK)#"  , py::arg("label"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const TCollection_AsciiString & ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Perform),
             R"#(None)#"  , py::arg("doc"),  py::arg("filename"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("Perform",
             (Standard_Boolean (IGESCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const Message_ProgressRange &  ) ) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)( const opencascade::handle<TDocStd_Document> & ,  const Standard_CString ,  const Message_ProgressRange &  ) >(&IGESCAFControl_Writer::Perform),
             R"#(Transfers a document and writes it to a IGES file Returns True if translation is OK)#"  , py::arg("doc"),  py::arg("filename"),  py::arg("theProgress")=static_cast<const Message_ProgressRange &>(Message_ProgressRange ( ))
          )
        .def("SetColorMode",
             (void (IGESCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Writer::*)( const Standard_Boolean  ) >(&IGESCAFControl_Writer::SetColorMode),
             R"#(Set ColorMode for indicate write Colors or not.)#"  , py::arg("colormode")
          )
        .def("GetColorMode",
             (Standard_Boolean (IGESCAFControl_Writer::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)() const>(&IGESCAFControl_Writer::GetColorMode),
             R"#(None)#" 
          )
        .def("SetNameMode",
             (void (IGESCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Writer::*)( const Standard_Boolean  ) >(&IGESCAFControl_Writer::SetNameMode),
             R"#(Set NameMode for indicate write Name or not.)#"  , py::arg("namemode")
          )
        .def("GetNameMode",
             (Standard_Boolean (IGESCAFControl_Writer::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)() const>(&IGESCAFControl_Writer::GetNameMode),
             R"#(None)#" 
          )
        .def("SetLayerMode",
             (void (IGESCAFControl_Writer::*)( const Standard_Boolean  ) ) static_cast<void (IGESCAFControl_Writer::*)( const Standard_Boolean  ) >(&IGESCAFControl_Writer::SetLayerMode),
             R"#(Set LayerMode for indicate write Layers or not.)#"  , py::arg("layermode")
          )
        .def("GetLayerMode",
             (Standard_Boolean (IGESCAFControl_Writer::*)() const) static_cast<Standard_Boolean (IGESCAFControl_Writer::*)() const>(&IGESCAFControl_Writer::GetLayerMode),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

// functions
// ./opencascade/IGESCAFControl.hxx
// ./opencascade/IGESCAFControl_ConfigurationNode.hxx
// ./opencascade/IGESCAFControl_Provider.hxx
// ./opencascade/IGESCAFControl_Reader.hxx
// ./opencascade/IGESCAFControl_Writer.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
