/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.utils;

import java.util.regex.Pattern;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprBooleanValue;
import org.opensearch.sql.data.model.ExprIntegerValue;
import org.opensearch.sql.data.model.ExprValue;

public final class OperatorUtils {
    private static final char DEFAULT_ESCAPE = '\\';

    public static ExprBooleanValue matches(ExprValue text, ExprValue pattern) {
        return ExprBooleanValue.of(Pattern.compile(OperatorUtils.patternToRegex(pattern.stringValue()), 2).matcher(text.stringValue()).matches());
    }

    public static ExprIntegerValue matchesRegexp(ExprValue text, ExprValue pattern) {
        return new ExprIntegerValue(Pattern.compile(pattern.stringValue()).matcher(text.stringValue()).matches() ? 1 : 0);
    }

    private static String patternToRegex(String patternString) {
        StringBuilder regex = new StringBuilder(patternString.length() * 2);
        regex.append('^');
        boolean escaped = false;
        block7: for (char currentChar : patternString.toCharArray()) {
            if (!escaped && currentChar == '\\') {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case '%': {
                    if (escaped) {
                        regex.append("%");
                    } else {
                        regex.append(".*");
                    }
                    escaped = false;
                    continue block7;
                }
                case '_': {
                    if (escaped) {
                        regex.append("_");
                    } else {
                        regex.append('.');
                    }
                    escaped = false;
                    continue block7;
                }
                default: {
                    switch (currentChar) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '|': {
                            regex.append('\\');
                            break;
                        }
                    }
                    regex.append(currentChar);
                    escaped = false;
                }
            }
        }
        regex.append('$');
        return regex.toString();
    }

    @Generated
    private OperatorUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

