/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.data.columnar.processors.field;

import com.oracle.labs.mlrg.olcut.config.Config;
import com.oracle.labs.mlrg.olcut.config.Configurable;
import com.oracle.labs.mlrg.olcut.provenance.ConfiguredObjectProvenance;
import com.oracle.labs.mlrg.olcut.provenance.impl.ConfiguredObjectProvenanceImpl;
import java.util.Collections;
import java.util.List;
import org.tribuo.data.columnar.ColumnarFeature;
import org.tribuo.data.columnar.FieldProcessor;

public class IdentityProcessor
implements FieldProcessor {
    public static final double FEATURE_VALUE = 1.0;
    @Config(mandatory=true, description="The field name to read.")
    private String fieldName;

    public IdentityProcessor(String fieldName) {
        this.fieldName = fieldName;
    }

    private IdentityProcessor() {
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public List<ColumnarFeature> process(String value) {
        return Collections.singletonList(new ColumnarFeature(this.fieldName, value, 1.0));
    }

    @Override
    public FieldProcessor.GeneratedFeatureType getFeatureType() {
        return FieldProcessor.GeneratedFeatureType.BINARISED_CATEGORICAL;
    }

    @Override
    public IdentityProcessor copy(String newFieldName) {
        return new IdentityProcessor(newFieldName);
    }

    public String toString() {
        return "IdentityProcessor(fieldName=" + this.getFieldName() + ")";
    }

    public ConfiguredObjectProvenance getProvenance() {
        return new ConfiguredObjectProvenanceImpl((Configurable)this, "FieldProcessor");
    }
}

