"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPARK_TIMESTAMP_DATATYPE = exports.SPARK_STRING_DATATYPE = exports.SPARK_PARTITION_INFO = exports.SPARK_HIVE_TABLE_REGEX = exports.SKIPPING_INDEX_ACCELERATION_METHODS = exports.SECURITY_DASHBOARDS_LOGOUT_URL = exports.SANITIZE_QUERY_REGEX = exports.S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_DISPLAY_NAME = exports.QUERY_LANGUAGE = exports.OLLY_QUESTION_URL_PARAM_KEY = exports.OBS_S3_DATA_SOURCE = exports.OBS_DEFAULT_CLUSTER = exports.INDEX_URL_PARAM_KEY = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_NAME = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPES = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = exports.CATALOG_CACHE_VERSION = exports.ASYNC_QUERY_SESSION_ID = exports.ASYNC_POLLING_INTERVAL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACC_CHECKPOINT_DOCUMENTATION_URL = exports.ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_REFRESH_TIME_INTERVAL = exports.ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_ADD_FIELDS_TEXT = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const ASYNC_QUERY_SESSION_ID = exports.ASYNC_QUERY_SESSION_ID = 'async-query-session-id';
const DATA_SOURCE_NAME_URL_PARAM_KEY = exports.DATA_SOURCE_NAME_URL_PARAM_KEY = 'datasourceName';
const DATA_SOURCE_TYPE_URL_PARAM_KEY = exports.DATA_SOURCE_TYPE_URL_PARAM_KEY = 'datasourceType';
const OLLY_QUESTION_URL_PARAM_KEY = exports.OLLY_QUESTION_URL_PARAM_KEY = 'olly_q';
const INDEX_URL_PARAM_KEY = exports.INDEX_URL_PARAM_KEY = 'indexPattern';
const DEFAULT_DATA_SOURCE_TYPE = exports.DEFAULT_DATA_SOURCE_TYPE = 'DEFAULT_INDEX_PATTERNS';
const DEFAULT_DATA_SOURCE_NAME = exports.DEFAULT_DATA_SOURCE_NAME = 'Default cluster';
const DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = exports.DEFAULT_DATA_SOURCE_OBSERVABILITY_DISPLAY_NAME = 'OpenSearch';
const DEFAULT_DATA_SOURCE_TYPE_NAME = exports.DEFAULT_DATA_SOURCE_TYPE_NAME = 'Default Group';
let QUERY_LANGUAGE = exports.QUERY_LANGUAGE = /*#__PURE__*/function (QUERY_LANGUAGE) {
  QUERY_LANGUAGE["PPL"] = "PPL";
  QUERY_LANGUAGE["SQL"] = "SQL";
  QUERY_LANGUAGE["DQL"] = "DQL";
  return QUERY_LANGUAGE;
}({});
let DATA_SOURCE_TYPES = exports.DATA_SOURCE_TYPES = /*#__PURE__*/function (DATA_SOURCE_TYPES) {
  DATA_SOURCE_TYPES["DEFAULT_CLUSTER_TYPE"] = "DEFAULT_INDEX_PATTERNS";
  DATA_SOURCE_TYPES["SPARK"] = "spark";
  DATA_SOURCE_TYPES["S3Glue"] = "s3glue";
  return DATA_SOURCE_TYPES;
}({});
const ASYNC_POLLING_INTERVAL = exports.ASYNC_POLLING_INTERVAL = 2000;
const CATALOG_CACHE_VERSION = exports.CATALOG_CACHE_VERSION = '1.0';
const ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = exports.ACCELERATION_DEFUALT_SKIPPING_INDEX_NAME = 'skipping';
const ACCELERATION_TIME_INTERVAL = exports.ACCELERATION_TIME_INTERVAL = [{
  text: 'millisecond(s)',
  value: 'millisecond'
}, {
  text: 'second(s)',
  value: 'second'
}, {
  text: 'minutes(s)',
  value: 'minute'
}, {
  text: 'hour(s)',
  value: 'hour'
}, {
  text: 'day(s)',
  value: 'day'
}, {
  text: 'week(s)',
  value: 'week'
}];
const ACCELERATION_REFRESH_TIME_INTERVAL = exports.ACCELERATION_REFRESH_TIME_INTERVAL = [{
  text: 'minutes(s)',
  value: 'minute'
}, {
  text: 'hour(s)',
  value: 'hour'
}, {
  text: 'day(s)',
  value: 'day'
}, {
  text: 'week(s)',
  value: 'week'
}];
const ACCELERATION_ADD_FIELDS_TEXT = exports.ACCELERATION_ADD_FIELDS_TEXT = '(add fields here)';
const ACCELERATION_INDEX_NAME_REGEX = exports.ACCELERATION_INDEX_NAME_REGEX = /^[a-z0-9_]+$/;
const ACCELERATION_S3_URL_REGEX = exports.ACCELERATION_S3_URL_REGEX = /^(s3|s3a):\/\/[a-zA-Z0-9.\-]+/;
const SPARK_HIVE_TABLE_REGEX = exports.SPARK_HIVE_TABLE_REGEX = /Provider:\s*hive/;
const SANITIZE_QUERY_REGEX = exports.SANITIZE_QUERY_REGEX = /\s+/g;
const SPARK_TIMESTAMP_DATATYPE = exports.SPARK_TIMESTAMP_DATATYPE = 'timestamp';
const SPARK_STRING_DATATYPE = exports.SPARK_STRING_DATATYPE = 'string';
const ACCELERATION_INDEX_TYPES = exports.ACCELERATION_INDEX_TYPES = [{
  label: 'Skipping Index',
  value: 'skipping'
}, {
  label: 'Covering Index',
  value: 'covering'
}, {
  label: 'Materialized View',
  value: 'materialized'
}];
const ACC_INDEX_TYPE_DOCUMENTATION_URL = exports.ACC_INDEX_TYPE_DOCUMENTATION_URL = 'https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md';
const ACC_CHECKPOINT_DOCUMENTATION_URL = exports.ACC_CHECKPOINT_DOCUMENTATION_URL = 'https://github.com/opensearch-project/opensearch-spark/blob/main/docs/index.md#create-index-options';
const ACCELERATION_INDEX_NAME_INFO = exports.ACCELERATION_INDEX_NAME_INFO = `All OpenSearch acceleration indices have a naming format of pattern: \`prefix_<index name>_suffix\`. They share a common prefix structure, which is \`flint_<data source name>_<database name>_<table name>_\`. Additionally, they may have a suffix that varies based on the index type. 
##### Skipping Index
- For 'Skipping' indices, a fixed index name 'skipping' is used, and this name cannot be modified by the user. The suffix added to this type is \`_index\`.
  - An example of a 'Skipping' index name would be: \`flint_mydatasource_mydb_mytable_skipping_index\`.
##### Covering Index
- 'Covering' indices allow users to specify their index name. The suffix added to this type is \`_index\`.
  - For instance, a 'Covering' index name could be: \`flint_mydatasource_mydb_mytable_myindexname_index\`.
##### Materialized View Index
- 'Materialized View' indices also enable users to define their index name, but they do not have a suffix.
  - An example of a 'Materialized View' index name might look like: \`flint_mydatasource_mydb_mytable_myindexname\`.
##### Note:
- All user given index names must be in lowercase letters, numbers and underscore. Spaces, commas, and characters -, :, ", *, +, /, \, |, ?, #, >, or < are not allowed.  
  `;
const SKIPPING_INDEX_ACCELERATION_METHODS = exports.SKIPPING_INDEX_ACCELERATION_METHODS = [{
  value: 'PARTITION',
  text: 'Partition'
}, {
  value: 'VALUE_SET',
  text: 'Value Set'
}, {
  value: 'MIN_MAX',
  text: 'Min Max'
}, {
  value: 'BLOOM_FILTER',
  text: 'Bloom Filter'
}];
const ACCELERATION_AGGREGRATION_FUNCTIONS = exports.ACCELERATION_AGGREGRATION_FUNCTIONS = [{
  label: 'window.start'
}, {
  label: 'count'
}, {
  label: 'sum'
}, {
  label: 'avg'
}, {
  label: 'max'
}, {
  label: 'min'
}];
const SPARK_PARTITION_INFO = exports.SPARK_PARTITION_INFO = `# Partition Information`;
const OBS_DEFAULT_CLUSTER = exports.OBS_DEFAULT_CLUSTER = 'observability-default'; // prefix key for generating data source id for default cluster in data selector
const OBS_S3_DATA_SOURCE = exports.OBS_S3_DATA_SOURCE = 'observability-s3'; // prefix key for generating data source id for s3 data sources in data selector
const S3_DATA_SOURCE_GROUP_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_DISPLAY_NAME = 'Amazon S3'; // display group name for Amazon-managed-s3 data sources in data selector
const S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = exports.S3_DATA_SOURCE_GROUP_SPARK_DISPLAY_NAME = 'Spark'; // display group name for OpenSearch-spark-s3 data sources in data selector
const SECURITY_DASHBOARDS_LOGOUT_URL = exports.SECURITY_DASHBOARDS_LOGOUT_URL = '/logout';