/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolEntry;
import com.dickimawbooks.texparserlib.latex.datatool.DataToolSty;
import java.io.IOException;
import java.util.Vector;

public class DataToolEntryRow
extends Vector<DataToolEntry>
implements TeXObject {
    private DataToolSty sty;
    int rowIndex;

    public DataToolEntryRow(DataToolSty dataToolSty) {
        this(1, dataToolSty);
    }

    public DataToolEntryRow(int n, DataToolSty dataToolSty) {
        this.sty = dataToolSty;
        this.setRowIndex(n);
    }

    public DataToolEntryRow(int n, DataToolSty dataToolSty, int n2) {
        super(n2);
        this.sty = dataToolSty;
        this.setRowIndex(n);
    }

    @Override
    public Object clone() {
        DataToolEntryRow dataToolEntryRow = new DataToolEntryRow(this.rowIndex, this.sty, this.capacity());
        for (DataToolEntry dataToolEntry : this) {
            dataToolEntryRow.add((DataToolEntry)dataToolEntry.clone());
        }
        return dataToolEntryRow;
    }

    @Override
    public boolean isSingleToken() {
        return false;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Invalid row index " + n);
        }
        this.rowIndex = n;
    }

    public static DataToolEntryRow toEntryRow(TeXParser teXParser, TeXObjectList teXObjectList, DataToolSty dataToolSty) throws IOException {
        DataToolEntry dataToolEntry;
        if (teXObjectList.peekStack(TeXObjectList.POP_IGNORE_LEADING_SPACE) instanceof DataToolEntryRow) {
            return (DataToolEntryRow)teXObjectList.popToken(TeXObjectList.POP_IGNORE_LEADING_SPACE);
        }
        if (!teXObjectList.popCsMarker(teXParser, "db@row@elt@w", TeXObjectList.POP_IGNORE_LEADING_SPACE)) {
            return null;
        }
        if (!teXObjectList.popCsMarker(teXParser, "db@row@id@w", TeXObjectList.POP_IGNORE_LEADING_SPACE)) {
            return null;
        }
        Numerical numerical = teXObjectList.popNumerical(teXParser);
        int n = numerical.number(teXParser);
        teXObjectList.popCsMarker(teXParser, "db@row@id@end@");
        DataToolEntryRow dataToolEntryRow = new DataToolEntryRow(dataToolSty);
        while ((dataToolEntry = DataToolEntry.toEntry(teXParser, teXObjectList, dataToolSty)) != null) {
            dataToolEntryRow.add(dataToolEntry);
        }
        teXObjectList.popCsMarker(teXParser, "db@row@id@w");
        numerical = teXObjectList.popNumerical(teXParser);
        int n2 = numerical.number(teXParser);
        teXObjectList.popCsMarker(teXParser, "db@row@id@end@");
        if (n != n2) {
            throw new LaTeXSyntaxException(teXParser, "datatool.mismatched", String.format("\\db@col@id@w %d\\db@col@id@end@", n), String.format("\\db@col@id@w %d\\db@col@id@end@", n2));
        }
        teXObjectList.popCsMarker(teXParser, "db@row@elt@end@");
        dataToolEntryRow.setRowIndex(n);
        return dataToolEntryRow;
    }

    public DataToolEntry getEntry(int n) {
        for (DataToolEntry dataToolEntry : this) {
            if (dataToolEntry.getColumnIndex() != n) continue;
            return dataToolEntry;
        }
        return null;
    }

    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        TeXObjectList teXObjectList = new TeXObjectList();
        for (DataToolEntry dataToolEntry : this) {
            teXObjectList.addAll(dataToolEntry.expandonce(teXParser));
        }
        return teXObjectList;
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        teXParser.addAll(0, this.expandonce(teXParser));
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.process(teXParser);
    }

    @Override
    public String toString(TeXParser teXParser) {
        try {
            return this.expandonce(teXParser).toString(teXParser);
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return this.expandonce(teXParser).string(teXParser);
    }

    @Override
    public String format() {
        try {
            return this.expandonce(this.sty.getListener().getParser()).format();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public String purified() {
        try {
            return this.expandonce(this.sty.getListener().getParser()).purified();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    @Override
    public boolean isPar() {
        return false;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public boolean isExpansionBlocker() {
        return false;
    }

    @Override
    public boolean isDataObject() {
        return true;
    }
}

