/**
 * ./src/classes/families/archlinux.ts
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
/**
 * Archlinux
 * @remarks all the utilities
 */
export default class Archlinux {
    static packs4calamares: string[];
    /**
     * Archlinux: calamaresInstall
     */
    static calamaresInstall(verbose?: boolean): Promise<void>;
    /**
     *
     * calamaresPolicies
     */
    static calamaresPolicies(verbose?: boolean): Promise<void>;
    /**
     * Archlinux: calamaresRemove
     */
    static calamaresRemove(verbose?: boolean): Promise<boolean>;
    /**
     * Archlinux: isInstalledWayland
     * @returns true if wayland is installed
     */
    static isInstalledWayland(): boolean;
    /**
     * Archlinux: isInstalledXorg
     * @returns true if xorg is installed
     */
    static isInstalledXorg(): boolean;
    /**
     * Archlinux: packageInstall
     * Install the package packageName
     * @param packageName {string} Pacchetto Debian da installare
     * @returns {boolean} True if success
     */
    static packageInstall(packageName: string): Promise<boolean>;
    /**
     * Archlinux: packageIsInstalled
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packageIsInstalled(packageName: string): boolean;
    /**
     * Archlinux: packagePacmanAvailable
     * restuisce VERO se il pacchetto è installato
     * @param packageName
     */
    static packagePacmanAvailable(packageName: string): Promise<boolean>;
    /**
     * Archlinux: packagePacmanLast
     * @param packageName
     * @returns
     */
    static packagePacmanLast(packageName: string): Promise<string>;
}
