/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.io.File;
import java.util.Vector;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.Queue;
import org.knopflerfish.framework.Resolver;
import org.knopflerfish.framework.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.startlevel.BundleStartLevel;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.startlevel.dto.BundleStartLevelDTO;
import org.osgi.framework.startlevel.dto.FrameworkStartLevelDTO;
import org.osgi.service.startlevel.StartLevel;

public class StartLevelController
implements Runnable,
ServiceFactory<StartLevel> {
    public static final String SPEC_VERSION = "1.1";
    public static final String API_SPEC_VERSION = "1.0";
    static final int START_MIN = 0;
    static final int START_MAX = Integer.MAX_VALUE;
    static final String INITIAL_LEVEL_FILE = "initiallevel";
    Thread wc;
    boolean bRun = false;
    Queue<Runnable> jobQueue = new Queue(0);
    int currentLevel = 0;
    int initStartLevel = 1;
    int targetStartLevel = this.currentLevel;
    final FrameworkContext fwCtx;
    FileTree storage;
    final boolean bCompat;
    private final boolean readOnly;
    Object lock = new Object();
    static final Util.Comparator<BundleImpl, BundleImpl> BSComparator = new Util.Comparator<BundleImpl, BundleImpl>(){

        @Override
        public int compare(BundleImpl b1, BundleImpl b2) {
            int res = b1.getStartLevel() - b2.getStartLevel();
            if (res == 0) {
                res = (int)(b1.getBundleId() - b2.getBundleId());
            }
            return res;
        }
    };

    StartLevelController(FrameworkContext fwCtx) {
        this.fwCtx = fwCtx;
        this.bCompat = fwCtx.props.getBooleanProperty("org.knopflerfish.framework.startlevel.compat");
        this.readOnly = fwCtx.props.getBooleanProperty("org.knopflerfish.framework.readonly");
        this.storage = Util.getFileStorage(fwCtx, "startlevel", !this.readOnly);
        this.setStartLevel0(-1, false, new FrameworkListener[0]);
        this.restoreState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: open");
        }
        Runnable beginJob = (Runnable)this.jobQueue.firstElement();
        this.wc = new Thread(this.fwCtx.threadGroup, this, "startlevel job");
        Runnable runnable = beginJob;
        synchronized (runnable) {
            this.bRun = true;
            this.wc.start();
            try {
                beginJob.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void restoreState() {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: restoreState");
        }
        if (this.storage != null) {
            try {
                String s = Util.getContent(new File(this.storage, INITIAL_LEVEL_FILE));
                if (s != null) {
                    this.setInitialBundleStartLevel0(Integer.parseInt(s), false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        Thread thread = this.wc;
        synchronized (thread) {
            this.setStartLevel0(0, false, new FrameworkListener[0]);
            while (this.bRun) {
                try {
                    this.wc.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("*** closed startlevel service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.bRun) {
            try {
                Runnable job = this.jobQueue.remove();
                if (job == null) continue;
                job.run();
                Runnable runnable = job;
                synchronized (runnable) {
                    if (this.currentLevel == 0) {
                        this.bRun = false;
                        this.jobQueue.close();
                    }
                    job.notifyAll();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    int getStartLevel() {
        return this.currentLevel;
    }

    void setStartLevel(int startLevel) {
        this.setStartLevel(startLevel, null);
    }

    void setStartLevel(int startLevel, FrameworkListener ... listeners) {
        if (!this.bRun) {
            throw new IllegalStateException("StartLevelService isn't running yet");
        }
        this.fwCtx.perm.checkStartLevelAdminPerm();
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        this.setStartLevel0(startLevel, true, listeners);
    }

    private void setStartLevel0(final int startLevel, final boolean notifyFw, final FrameworkListener ... listeners) {
        if (this.fwCtx.debug.startlevel) {
            this.fwCtx.debug.println("startlevel: setStartLevel " + startLevel);
        }
        this.jobQueue.insert(new Runnable(){

            @Override
            public void run() {
                int sl;
                int n = sl = StartLevelController.this.bCompat ? 1 : startLevel;
                if (sl == -1) {
                    String sBeginningLevel = StartLevelController.this.fwCtx.props.getProperty("org.osgi.framework.startlevel.beginning");
                    try {
                        StartLevelController.this.targetStartLevel = Integer.parseInt(sBeginningLevel);
                    }
                    catch (NumberFormatException nfe) {
                        StartLevelController.this.fwCtx.debug.printStackTrace("Invalid number '" + sBeginningLevel + "' in value of property named '" + "org.osgi.framework.startlevel.beginning" + "'.", nfe);
                        StartLevelController.this.targetStartLevel = 1;
                    }
                    if (StartLevelController.this.fwCtx.debug.startlevel) {
                        StartLevelController.this.fwCtx.debug.println("startlevel: beginning level " + StartLevelController.this.targetStartLevel);
                    }
                } else {
                    StartLevelController.this.targetStartLevel = sl;
                }
                while (StartLevelController.this.targetStartLevel > StartLevelController.this.currentLevel) {
                    StartLevelController.this.increaseStartLevel();
                }
                while (StartLevelController.this.targetStartLevel < StartLevelController.this.currentLevel) {
                    StartLevelController.this.decreaseStartLevel();
                }
                if (notifyFw) {
                    FrameworkEvent event = new FrameworkEvent(8, StartLevelController.this.fwCtx.systemBundle, null);
                    StartLevelController.this.fwCtx.listeners.frameworkEvent(event, listeners);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            BundleArchive archive;
            ++this.currentLevel;
            if (this.fwCtx.debug.startlevel) {
                this.fwCtx.debug.println("startlevel: increaseStartLevel currentLevel=" + this.currentLevel);
            }
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            for (BundleImpl bs : this.fwCtx.bundles.getBundles()) {
                archive = bs.current().archive;
                if (archive == null || bs.getStartLevel() != this.currentLevel || bs.current().archive.getAutostartSetting() == -1) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, false);
            for (int i = 0; i < set.size(); ++i) {
                BundleImpl bs;
                bs = (BundleImpl)set.elementAt(i);
                archive = bs.current().archive;
                if (archive == null) continue;
                try {
                    if (bs.current().archive.getAutostartSetting() == -1) continue;
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println("startlevel: start " + bs);
                    }
                    int startOptions = 1;
                    if (this.isBundleActivationPolicyUsed(bs.current().archive)) {
                        startOptions |= 2;
                    }
                    bs.start(startOptions);
                    continue;
                }
                catch (IllegalStateException ignore) {
                    continue;
                }
                catch (Exception e) {
                    this.fwCtx.frameworkError(bs, (Throwable)e, new FrameworkListener[0]);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decreaseStartLevel() {
        Object object = this.lock;
        synchronized (object) {
            --this.currentLevel;
            Vector<BundleImpl> set = new Vector<BundleImpl>();
            for (BundleImpl bs : this.fwCtx.bundles.getBundles()) {
                if (bs.getState() != 32 && (bs.getState() != 8 || !bs.current().lazyActivation) || bs.getStartLevel() != this.currentLevel + 1) continue;
                set.addElement(bs);
            }
            Util.sort(set, BSComparator, true);
            Resolver resolver = this.fwCtx.resolver;
            synchronized (resolver) {
                for (int i = 0; i < set.size(); ++i) {
                    BundleImpl bs = (BundleImpl)set.elementAt(i);
                    if (bs.getState() != 32 && (bs.getState() != 8 || !bs.current().lazyActivation)) continue;
                    if (this.fwCtx.debug.startlevel) {
                        this.fwCtx.debug.println("startlevel: stop " + bs);
                    }
                    try {
                        bs.stop(1);
                        continue;
                    }
                    catch (Throwable t) {
                        this.fwCtx.frameworkError(bs, t, new FrameworkListener[0]);
                    }
                }
            }
        }
    }

    boolean canStart(BundleImpl b) {
        return b.getState() != 1;
    }

    int getBundleStartLevel(BundleImpl bundle) {
        if (bundle.getBundleId() == 0L) {
            return 0;
        }
        return bundle.getStartLevel();
    }

    void setBundleStartLevel(final BundleImpl bundle, int startLevel) {
        this.fwCtx.perm.checkExecuteAdminPerm(bundle);
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        if (bundle.getBundleId() == 0L) {
            throw new IllegalArgumentException("System bundle start level cannot be changed");
        }
        this.fwCtx.perm.callSetStartLevel(bundle, this.bCompat ? 1 : startLevel);
        if (this.bRun) {
            this.jobQueue.insert(new Runnable(){

                @Override
                public void run() {
                    StartLevelController.this.syncStartLevel(bundle);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncStartLevel(BundleImpl bs) {
        try {
            if (this.fwCtx.debug.startlevel) {
                this.fwCtx.debug.println("syncstartlevel: " + bs);
            }
            Object object = this.lock;
            synchronized (object) {
                Resolver resolver = this.fwCtx.resolver;
                synchronized (resolver) {
                    if (bs.getStartLevel() <= this.currentLevel) {
                        BundleGeneration current = bs.current();
                        if ((bs.getState() & 0x16) != 0 && current.archive.getAutostartSetting() != -1) {
                            if (this.fwCtx.debug.startlevel) {
                                this.fwCtx.debug.println("startlevel: start " + bs);
                            }
                            int startOptions = 1;
                            if (this.isBundleActivationPolicyUsed(current.archive)) {
                                startOptions |= 2;
                            }
                            bs.start(startOptions);
                        }
                    } else if ((bs.getState() & 0x28) != 0) {
                        if (this.fwCtx.debug.startlevel) {
                            this.fwCtx.debug.println("startlevel: stop " + bs);
                        }
                        bs.stop(1);
                    }
                }
            }
        }
        catch (Throwable t) {
            this.fwCtx.frameworkError(bs, t, new FrameworkListener[0]);
        }
    }

    int getInitialBundleStartLevel() {
        return this.initStartLevel;
    }

    void setInitialBundleStartLevel(int startLevel) {
        this.fwCtx.perm.checkStartLevelAdminPerm();
        this.fwCtx.perm.callSetInitialBundleStartLevel0(this, startLevel);
    }

    void setInitialBundleStartLevel0(int startLevel, boolean save) {
        if (startLevel <= 0) {
            throw new IllegalArgumentException("Initial start level must be > 0, is " + startLevel);
        }
        int n = this.initStartLevel = this.bCompat ? 1 : startLevel;
        if (this.storage != null && !this.readOnly && save) {
            try {
                Util.putContent(new File(this.storage, INITIAL_LEVEL_FILE), Integer.toString(this.initStartLevel));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    boolean isBundlePersistentlyStarted(BundleArchive archive) {
        return archive == null || archive.getAutostartSetting() != -1;
    }

    boolean isBundleActivationPolicyUsed(BundleArchive archive) {
        return archive != null && archive.getAutostartSetting() == 2;
    }

    @Override
    public StartLevel getService(Bundle bundle, ServiceRegistration<StartLevel> registration) {
        return new StartLevelImpl(this);
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<StartLevel> registration, StartLevel service) {
    }

    BundleStartLevelImpl bundleStartLevel(BundleImpl bi) {
        return new BundleStartLevelImpl(this, bi);
    }

    FrameworkStartLevelImpl frameworkStartLevel() {
        return new FrameworkStartLevelImpl(this, this.fwCtx.systemBundle);
    }

    static class FrameworkStartLevelImpl
    implements FrameworkStartLevel {
        final StartLevelController st;
        final BundleImpl bi;

        public FrameworkStartLevelImpl(StartLevelController startLevelController, BundleImpl bi) {
            this.st = startLevelController;
            this.bi = bi;
        }

        @Override
        public Bundle getBundle() {
            return this.bi;
        }

        @Override
        public int getStartLevel() {
            return this.st.getStartLevel();
        }

        @Override
        public void setStartLevel(int startlevel, FrameworkListener ... listeners) {
            this.st.setStartLevel(startlevel, listeners);
        }

        @Override
        public int getInitialBundleStartLevel() {
            return this.st.getInitialBundleStartLevel();
        }

        @Override
        public void setInitialBundleStartLevel(int startlevel) {
            this.st.setInitialBundleStartLevel(startlevel);
        }

        FrameworkStartLevelDTO getDTO() {
            FrameworkStartLevelDTO res = new FrameworkStartLevelDTO();
            res.startLevel = this.getStartLevel();
            res.initialBundleStartLevel = this.getInitialBundleStartLevel();
            return res;
        }
    }

    static class BundleStartLevelImpl
    implements BundleStartLevel {
        final StartLevelController st;
        final BundleImpl bi;

        BundleStartLevelImpl(StartLevelController st, BundleImpl bi) {
            this.st = st;
            this.bi = bi;
        }

        @Override
        public Bundle getBundle() {
            return this.bi;
        }

        @Override
        public int getStartLevel() {
            return this.st.getBundleStartLevel(this.bi);
        }

        @Override
        public void setStartLevel(int startlevel) {
            this.st.setBundleStartLevel(this.bi, startlevel);
        }

        @Override
        public boolean isPersistentlyStarted() {
            return this.st.isBundlePersistentlyStarted(this.getBundleArchive());
        }

        @Override
        public boolean isActivationPolicyUsed() {
            return this.st.isBundleActivationPolicyUsed(this.getBundleArchive());
        }

        BundleStartLevelDTO getDTO() {
            BundleStartLevelDTO res = new BundleStartLevelDTO();
            res.bundle = this.bi.id;
            res.startLevel = this.getStartLevel();
            res.activationPolicyUsed = this.isActivationPolicyUsed();
            res.persistentlyStarted = this.isPersistentlyStarted();
            return res;
        }

        private BundleArchive getBundleArchive() {
            BundleArchive res = this.bi.current().archive;
            if (res == null && this.bi.id != 0L) {
                throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
            }
            return res;
        }
    }

    public static class StartLevelImpl
    implements StartLevel {
        private final StartLevelController st;

        StartLevelImpl(StartLevelController st) {
            this.st = st;
        }

        @Override
        public int getBundleStartLevel(Bundle bundle) {
            return this.st.getBundleStartLevel(this.checkBundle(bundle));
        }

        @Override
        public int getInitialBundleStartLevel() {
            return this.st.getInitialBundleStartLevel();
        }

        @Override
        public int getStartLevel() {
            return this.st.getStartLevel();
        }

        @Override
        public boolean isBundleActivationPolicyUsed(Bundle bundle) {
            return this.st.isBundleActivationPolicyUsed(this.getBundleArchive(bundle));
        }

        @Override
        public boolean isBundlePersistentlyStarted(Bundle bundle) {
            return this.st.isBundlePersistentlyStarted(this.getBundleArchive(bundle));
        }

        @Override
        public void setBundleStartLevel(Bundle bundle, int startlevel) {
            this.st.setBundleStartLevel(this.checkBundle(bundle), startlevel);
        }

        @Override
        public void setInitialBundleStartLevel(int startlevel) {
            this.st.setInitialBundleStartLevel(startlevel);
        }

        @Override
        public void setStartLevel(int startlevel) {
            this.st.setStartLevel(startlevel);
        }

        private BundleImpl checkBundle(Bundle b) {
            if (b instanceof BundleImpl) {
                BundleImpl res = (BundleImpl)b;
                if (res.fwCtx == this.st.fwCtx) {
                    if (res.state != 1) {
                        return res;
                    }
                    throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
                }
            }
            throw new IllegalArgumentException("Bundle doesn't belong to the same framework as the StartLevel service");
        }

        private BundleArchive getBundleArchive(Bundle b) {
            BundleImpl bi = this.checkBundle(b);
            BundleArchive res = bi.current().archive;
            if (res == null && bi.id != 0L) {
                throw new IllegalArgumentException("Bundle is in UNINSTALLED state");
            }
            return res;
        }
    }
}

