/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.archunit;

import com.google.gson.Gson;
import com.tngtech.archunit.freeplane.extension.ArchitectureViolations;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.zip.GZIPInputStream;
import org.freeplane.core.resources.IFreeplanePropertyListener;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.LogUtils;

public class ArchUnitServer
implements IFreeplanePropertyListener {
    public static final String ARCHUNIT_SERVER_ENABLED_PROPERTY = "code.archunit.server.enabled";
    public static final String ARCHUNIT_SERVER_PORT_PROPERTY = "code.archunit.server.port";
    private volatile ServerSocket serverSocket;
    private final LinkedList<ArchitectureViolations> submittedTestResults;
    private final ExecutorService clientExecutor;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private Consumer<ArchitectureViolations> callback = result -> {};

    public ArchUnitServer() {
        this.submittedTestResults = new LinkedList();
        this.clientExecutor = Executors.newCachedThreadPool();
        Runtime.getRuntime().addShutdownHook(new Thread(this::cleanup));
    }

    private void start() {
        int port = ResourceController.getResourceController().getIntProperty(ARCHUNIT_SERVER_PORT_PROPERTY, 6297);
        this.start(port);
    }

    private void start(int port) {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.serverSocket = new ServerSocket(port);
                LogUtils.info((String)("ArchUnit Server started on port " + port));
                new Thread(() -> {
                    while (this.running.get()) {
                        try {
                            Socket clientSocket = this.serverSocket.accept();
                            this.clientExecutor.submit(new ClientHandler(clientSocket));
                        }
                        catch (IOException e) {
                            if (!this.running.get()) continue;
                            e.printStackTrace();
                        }
                    }
                }).start();
            }
            catch (BindException e) {
                this.running.set(false);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.running.set(false);
            }
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            try {
                if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                    this.serverSocket.close();
                }
                LogUtils.info((String)"ArchUnit Server stopped.");
            }
            catch (IOException e) {
                LogUtils.severe((String)("Error closing the ArchUnit server: " + e.getMessage()));
            }
        }
    }

    private void cleanup() {
        this.stop();
        this.clientExecutor.shutdown();
        try {
            if (!this.clientExecutor.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.clientExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.clientExecutor.shutdownNow();
        }
    }

    public List<ArchitectureViolations> getSubmittedTestResults() {
        return this.submittedTestResults;
    }

    public Consumer<ArchitectureViolations> getCallback() {
        return this.callback;
    }

    public void setCallback(Consumer<ArchitectureViolations> callback) {
        this.callback = callback;
    }

    public void propertyChanged(String propertyName, String newValue, String oldValue) {
        if (propertyName.equals(ARCHUNIT_SERVER_ENABLED_PROPERTY)) {
            if (Boolean.parseBoolean(newValue)) {
                this.start();
            } else {
                this.stop();
            }
        }
    }

    private class ClientHandler
    implements Runnable {
        private final Socket clientSocket;

        public ClientHandler(Socket socket) {
            this.clientSocket = socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (InputStream inputStream = this.clientSocket.getInputStream();
                 GZIPInputStream gzipInputStream = new GZIPInputStream(inputStream);
                 InputStreamReader reader = new InputStreamReader((InputStream)gzipInputStream, StandardCharsets.UTF_8);){
                ArchitectureViolations dto = (ArchitectureViolations)new Gson().fromJson((Reader)reader, ArchitectureViolations.class);
                EventQueue.invokeLater(() -> this.addTestResult(dto));
            }
            catch (IOException e) {
                LogUtils.severe((String)("ArchUnit Client handler exception: " + e.getMessage()));
            }
            finally {
                try {
                    this.clientSocket.close();
                }
                catch (IOException e) {
                    LogUtils.severe((String)("Error closing ArchUnit client socket: " + e.getMessage()));
                }
            }
        }

        private void addTestResult(ArchitectureViolations dto) {
            ArchUnitServer.this.submittedTestResults.add(dto);
            ArchUnitServer.this.callback.accept(dto);
        }
    }
}

