/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.map;

import java.util.Set;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ICondition;
import org.freeplane.features.map.NodeModel;

class DependencySnapshotCondition
extends ASelectableCondition {
    private static final String NAME = "dependencies_snapshot";
    private final String description;
    private final Set<String> dependentNodeIDs;
    private final ICondition baseCondition;

    public DependencySnapshotCondition(Set<String> dependentNodeIDs, String description) {
        this(dependentNodeIDs, null, description);
    }

    public DependencySnapshotCondition(Set<String> dependentNodeIDs, ICondition baseCondition, String description) {
        this.baseCondition = baseCondition;
        this.dependentNodeIDs = dependentNodeIDs;
        this.description = description;
    }

    public boolean checkNode(NodeModel node) {
        return this.dependentNodeIDs.contains(node.getID()) || this.baseCondition != null && this.baseCondition.checkNode(node);
    }

    protected String createDescription() {
        return this.description;
    }

    protected String getName() {
        return NAME;
    }

    public boolean canBePersisted() {
        return false;
    }
}

