/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.lang.conditions;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.DescribedPredicate;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.lang.ArchCondition;
import com.tngtech.archunit.lang.ConditionEvent;
import com.tngtech.archunit.lang.ConditionEvents;
import com.tngtech.archunit.lang.SimpleConditionEvent;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class TransitiveDependencyCondition
extends ArchCondition<JavaClass> {
    private final DescribedPredicate<? super JavaClass> conditionPredicate;
    private final TransitiveDependencyPath transitiveDependencyPath = new TransitiveDependencyPath();
    private Collection<JavaClass> allClasses;

    public TransitiveDependencyCondition(DescribedPredicate<? super JavaClass> conditionPredicate) {
        super("transitively depend on classes that " + conditionPredicate.getDescription(), new Object[0]);
        this.conditionPredicate = Preconditions.checkNotNull(conditionPredicate);
    }

    @Override
    public void init(Collection<JavaClass> allObjectsToTest) {
        this.allClasses = allObjectsToTest;
    }

    @Override
    public void check(JavaClass javaClass, ConditionEvents events) {
        boolean hasTransitiveDependency = false;
        for (JavaClass target : this.getDirectDependencyTargetsOutsideOfAnalyzedClasses(javaClass)) {
            List<JavaClass> dependencyPath = this.transitiveDependencyPath.findPathTo(target);
            if (dependencyPath.isEmpty()) continue;
            events.add(TransitiveDependencyCondition.newTransitiveDependencyPathFoundEvent(javaClass, dependencyPath));
            hasTransitiveDependency = true;
        }
        if (!hasTransitiveDependency) {
            events.add(TransitiveDependencyCondition.newNoTransitiveDependencyPathFoundEvent(javaClass));
        }
    }

    private static ConditionEvent newTransitiveDependencyPathFoundEvent(JavaClass javaClass, List<JavaClass> transitiveDependencyPath) {
        String message = String.format("%sdepends on <%s>", transitiveDependencyPath.size() > 1 ? "transitively " : "", Iterables.getLast(transitiveDependencyPath).getFullName());
        if (transitiveDependencyPath.size() > 1) {
            message = message + " by [" + transitiveDependencyPath.stream().map(JavaClass::getName).collect(Collectors.joining("->")) + "]";
        }
        return SimpleConditionEvent.satisfied(javaClass, ConditionEvent.createMessage(javaClass, message));
    }

    private static ConditionEvent newNoTransitiveDependencyPathFoundEvent(JavaClass javaClass) {
        return SimpleConditionEvent.violated(javaClass, ConditionEvent.createMessage(javaClass, "does not transitively depend on any matching class"));
    }

    private Set<JavaClass> getDirectDependencyTargetsOutsideOfAnalyzedClasses(JavaClass item) {
        return item.getDirectDependenciesFromSelf().stream().map(dependency -> dependency.getTargetClass().getBaseComponentType()).filter(targetClass -> !this.allClasses.contains(targetClass)).collect(Collectors.toSet());
    }

    private class TransitiveDependencyPath {
        private TransitiveDependencyPath() {
        }

        List<JavaClass> findPathTo(JavaClass clazz) {
            ImmutableList.Builder<JavaClass> transitivePath = ImmutableList.builder();
            this.addDependenciesToPathFrom(clazz, transitivePath, new HashSet<JavaClass>());
            return ((ImmutableList)transitivePath.build()).reverse();
        }

        private boolean addDependenciesToPathFrom(JavaClass clazz, ImmutableList.Builder<JavaClass> dependencyPath, Set<JavaClass> analyzedClasses) {
            if (TransitiveDependencyCondition.this.conditionPredicate.test(clazz)) {
                dependencyPath.add((Object)clazz);
                return true;
            }
            analyzedClasses.add(clazz);
            for (JavaClass directDependency : TransitiveDependencyCondition.this.getDirectDependencyTargetsOutsideOfAnalyzedClasses(clazz)) {
                if (analyzedClasses.contains(directDependency) || !this.addDependenciesToPathFrom(directDependency, dependencyPath, analyzedClasses)) continue;
                dependencyPath.add((Object)clazz);
                return true;
            }
            return false;
        }
    }
}

