/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.AliasCondition;
import org.freeplane.features.filter.StringMatchingStrategy;

class AliasStartsWithCondition
extends AliasCondition {
    static final String NAME = "alias_starts_with";
    private final StringMatchingStrategy stringMatchingStrategy;

    AliasStartsWithCondition(String alias, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(alias, matchCase, matchApproximately, ignoreDiacritics);
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkAlias(String alias) {
        String searchedAlias = this.getAlias();
        int searchedLength = searchedAlias.length();
        return alias.length() >= searchedLength && this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(alias.substring(0, searchedLength)), StringMatchingStrategy.Type.ALL);
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("filter_alias");
        String simpleCondition = TextUtils.getText("filter_starts_with");
        return this.createDescription(condition, simpleCondition, this.getAlias());
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

