/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.filter;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.ui.IMapViewManager;

public class NextPresentationItemAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;
    private final MapController.Direction direction;

    public static NextPresentationItemAction createFoldingAction() {
        return new NextPresentationItemAction(MapController.Direction.FORWARD_N_FOLD, "NextPresentationItemAction");
    }

    public static NextPresentationItemAction createNotFoldingAction() {
        return new NextPresentationItemAction(MapController.Direction.FORWARD, "NotFoldingNextPresentationItemAction");
    }

    private NextPresentationItemAction(MapController.Direction direction, String key) {
        super(key);
        this.direction = direction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FilterController filterController = FilterController.getCurrentFilterController();
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        NodeModel start = selection.getSelected();
        IMapViewManager mapViewManager = controller.getMapViewManager();
        Filter filter = selection.getFilter();
        NodeModel next = filterController.findNext(start, null, this.direction, null, filter);
        if (next != null) {
            MapController mapController = Controller.getCurrentModeController().getMapController();
            if (!next.hasVisibleContent(filter)) {
                filter.getFilterInfo(next).reset();
                mapController.nodeRefresh(next);
            }
            NodeModel[] path = next.getPathToRoot();
            for (int i = 1; i < path.length; ++i) {
                NodeModel nodeOnPath = path[i];
                NodeModel parentNode = nodeOnPath.getParentNode();
                if (parentNode.isFolded()) {
                    mapController.showNextChild(parentNode);
                    continue;
                }
                if (!mapViewManager.isChildHidden(nodeOnPath)) continue;
                mapController.showNextChild(parentNode);
            }
            Controller.getCurrentController().getSelection().selectAsTheOnlyOneSelected(next);
        }
    }
}

