/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.capsule.util.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<E>
implements Iterator<E> {
    final E[] values;
    final int end;
    int currentIndex;

    public ArrayIterator(E[] values, int start, int end) {
        assert (start <= end && end <= values.length);
        this.values = values;
        this.end = end;
        this.currentIndex = start;
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.end;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.values[this.currentIndex++];
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public static <E> Iterator<E> of(E ... array) {
        return new ArrayIterator<E>(array, 0, array.length);
    }

    public static <E> Iterator<E> of(E[] array, int start, int length) {
        return new ArrayIterator<E>(array, start, start + length);
    }
}

