/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import org.gradle.execution.plan.ExecutionNodeAccessHierarchy;
import org.gradle.internal.file.Stat;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.internal.snapshot.CaseSensitivity;

@ServiceScope(value=Scopes.Build.class)
public class ExecutionNodeAccessHierarchies {
    private final ExecutionNodeAccessHierarchy outputHierarchy;
    private final ExecutionNodeAccessHierarchy destroyableHierarchy;
    private final CaseSensitivity caseSensitivity;
    private final Stat stat;

    public ExecutionNodeAccessHierarchies(CaseSensitivity caseSensitivity, Stat stat) {
        this.caseSensitivity = caseSensitivity;
        this.stat = stat;
        this.outputHierarchy = new ExecutionNodeAccessHierarchy(caseSensitivity, stat);
        this.destroyableHierarchy = new ExecutionNodeAccessHierarchy(caseSensitivity, stat);
    }

    public InputNodeAccessHierarchy createInputHierarchy() {
        return new InputNodeAccessHierarchy(this.caseSensitivity, this.stat);
    }

    public ExecutionNodeAccessHierarchy getOutputHierarchy() {
        return this.outputHierarchy;
    }

    public ExecutionNodeAccessHierarchy getDestroyableHierarchy() {
        return this.destroyableHierarchy;
    }

    public static class InputNodeAccessHierarchy
    extends ExecutionNodeAccessHierarchy {
        public InputNodeAccessHierarchy(CaseSensitivity caseSensitivity, Stat stat) {
            super(caseSensitivity, stat);
        }
    }
}

