/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.VarargLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0014\u0010\u001e\u001a\u00020\u001a2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001a0 J\u000e\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u001aJ\u000e\u0010#\u001a\u0004\u0018\u00010\t*\u00020\u0005H\u0002R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\rR\u0011\u0010\u0017\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\r\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/InlineClassArrayInfo;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "elementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "arrayType", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "arrayInlineClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getArrayInlineClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getArrayType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getElementType", "inlined", "", "getInlined", "()Z", "primitiveArrayType", "getPrimitiveArrayType", "primitiveElementType", "getPrimitiveElementType", "boxArrayIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "array", "getInlineClassUnderlyingType", "irClass", "toPrimitiveArrayLiteral", "elements", "", "unboxElementIfNeeded", "element", "getInlinedClass", "backend.js"})
public final class InlineClassArrayInfo {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrType elementType;
    @NotNull
    private final IrType arrayType;
    @Nullable
    private final IrClass arrayInlineClass;
    private final boolean inlined;
    @NotNull
    private final IrType primitiveElementType;
    @NotNull
    private final IrType primitiveArrayType;

    public InlineClassArrayInfo(@NotNull JsIrBackendContext context, @NotNull IrType elementType, @NotNull IrType arrayType) {
        IrType irType;
        IrType irType2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        this.context = context;
        this.elementType = elementType;
        this.arrayType = arrayType;
        this.arrayInlineClass = this.getInlinedClass(this.arrayType);
        boolean bl = this.inlined = this.arrayInlineClass != null;
        if (this.inlined) {
            IrClass irClass2 = this.getInlinedClass(this.elementType);
            if (irClass2 == null) {
                CompilationExceptionKt.compilationException("Could not get inlined class", this.elementType);
                throw null;
            }
            irType2 = this.getInlineClassUnderlyingType(irClass2);
        } else {
            irType2 = this.primitiveElementType = this.elementType;
        }
        if (this.inlined) {
            IrClass irClass3 = this.arrayInlineClass;
            Intrinsics.checkNotNull((Object)irClass3);
            irType = this.getInlineClassUnderlyingType(irClass3);
        } else {
            irType = this.arrayType;
        }
        this.primitiveArrayType = irType;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrType getElementType() {
        return this.elementType;
    }

    @NotNull
    public final IrType getArrayType() {
        return this.arrayType;
    }

    private final IrClass getInlinedClass(IrType $this$getInlinedClass) {
        return this.context.getInlineClassesUtils().getInlinedClass($this$getInlinedClass);
    }

    private final IrType getInlineClassUnderlyingType(IrClass irClass2) {
        return this.context.getInlineClassesUtils().getInlineClassUnderlyingType(irClass2);
    }

    @Nullable
    public final IrClass getArrayInlineClass() {
        return this.arrayInlineClass;
    }

    public final boolean getInlined() {
        return this.inlined;
    }

    @NotNull
    public final IrType getPrimitiveElementType() {
        return this.primitiveElementType;
    }

    @NotNull
    public final IrType getPrimitiveArrayType() {
        return this.primitiveArrayType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression boxArrayIfNeeded(@NotNull IrExpression array2) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)array2, (String)"array");
        if (this.arrayInlineClass == null) {
            irExpression = array2;
        } else {
            void $this$single$iv;
            IrExpression $this$boxArrayIfNeeded_u24lambda_u2d2 = array2;
            boolean bl = false;
            Object object = IrUtilsKt.getConstructors(this.arrayInlineClass);
            IrType irType = IrUtilsKt.getDefaultType(this.arrayInlineClass);
            int n = $this$boxArrayIfNeeded_u24lambda_u2d2.getEndOffset();
            int n2 = $this$boxArrayIfNeeded_u24lambda_u2d2.getStartOffset();
            IrConstructorCallImpl.Companion companion = IrConstructorCallImpl.Companion;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl2 = false;
                if (!it.isPrimary()) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Object var16_18 = single$iv;
            Object it = object = IrConstructorCallImpl.Companion.fromSymbolOwner$default(companion, n2, n, irType, ((IrConstructor)var16_18).getSymbol(), this.arrayInlineClass.getTypeParameters().size(), null, 32, null);
            boolean bl3 = false;
            ((IrMemberAccessExpression)it).putValueArgument(0, array2);
            irExpression = (IrExpression)object;
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression unboxElementIfNeeded(@NotNull IrExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.arrayInlineClass == null) {
            return element;
        }
        IrExpression $this$unboxElementIfNeeded_u24lambda_u2d3 = element;
        boolean bl = false;
        IrClass irClass2 = this.getInlinedClass($this$unboxElementIfNeeded_u24lambda_u2d3.getType());
        if (irClass2 == null) {
            return element;
        }
        IrClass inlinedClass = irClass2;
        IrField field2 = InlineClassesKt.getInlineClassBackingField(inlinedClass);
        return new IrGetFieldImpl($this$unboxElementIfNeeded_u24lambda_u2d3.getStartOffset(), $this$unboxElementIfNeeded_u24lambda_u2d3.getEndOffset(), field2.getSymbol(), field2.getType(), $this$unboxElementIfNeeded_u24lambda_u2d3, null, null, 96, null);
    }

    @NotNull
    public final IrExpression toPrimitiveArrayLiteral(@NotNull List<? extends IrExpression> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return VarargLoweringKt.access$toArrayLiteral(elements, this.context, this.primitiveArrayType, this.primitiveElementType);
    }
}

