/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.AbstractFakeOverrideSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.AbstractSuperCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SuperAsExtensionReceiver;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CheckSuperExpressionCallPart;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "()V", "process", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "workIndex", "", "resolution"})
public final class CheckSuperExpressionCallPart
extends ResolutionPart {
    @NotNull
    public static final CheckSuperExpressionCallPart INSTANCE = new CheckSuperExpressionCallPart();

    private CheckSuperExpressionCallPart() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        SimpleKotlinCallArgument extensionReceiver;
        Intrinsics.checkNotNullParameter((Object)$this$process, (String)"<this>");
        CallableDescriptor candidateDescriptor = $this$process.getResolvedCall().getCandidateDescriptor();
        if ($this$process.getCallComponents().getStatelessCallbacks().isSuperExpression($this$process.getResolvedCall().getDispatchReceiverArgument()) && candidateDescriptor instanceof CallableMemberDescriptor) {
            if (((CallableMemberDescriptor)candidateDescriptor).getModality() == Modality.ABSTRACT) {
                SimpleKotlinCallArgument simpleKotlinCallArgument = $this$process.getResolvedCall().getDispatchReceiverArgument();
                Intrinsics.checkNotNull((Object)simpleKotlinCallArgument);
                $this$process.addDiagnostic(new AbstractSuperCall(simpleKotlinCallArgument));
            } else if (((CallableMemberDescriptor)candidateDescriptor).getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE && ((CallableMemberDescriptor)candidateDescriptor).getOverriddenDescriptors().size() > 1) {
                Object v2;
                block7: {
                    Collection<? extends CallableMemberDescriptor> collection = ((CallableMemberDescriptor)candidateDescriptor).getOverriddenDescriptors();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"candidateDescriptor.overriddenDescriptors");
                    Iterable $this$firstOrNull$iv = collection;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        CallableMemberDescriptor it = (CallableMemberDescriptor)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        if (!(!DescriptorUtilsKt.isInsideInterface(it))) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                CallableMemberDescriptor callableMemberDescriptor = v2;
                if ((callableMemberDescriptor != null ? callableMemberDescriptor.getModality() : null) == Modality.ABSTRACT) {
                    $this$process.addDiagnostic(AbstractFakeOverrideSuperCall.INSTANCE);
                }
            }
        }
        if ((extensionReceiver = $this$process.getResolvedCall().getExtensionReceiverArgument()) != null && $this$process.getCallComponents().getStatelessCallbacks().isSuperExpression(extensionReceiver)) {
            $this$process.addDiagnostic(new SuperAsExtensionReceiver(extensionReceiver));
        }
    }
}

