/*!
 * The following copyright notice may not be removed under any circumstances.
 * 
 * Copyright:
 * Copyright (c) 2011 by Daniel Midgley. All rights reserved.
 * 
 * Trademark:
 * Please refer to the Copyright section for the font trademark attribution
 * notices.
 * 
 * Full name:
 * Daniel-Bold
 * 
 * Description:
 * Daniel Bold is a font by Daniel Midgley.
 * 
 * Designer:
 * Daniel Midgley
 * 
 * Vendor URL:
 * http://goodreasonblog.blogspot.com/p/fontery.html
 * 
 * License information:
 * http://creativecommons.org/licenses/by-nd/3.0/
 */
if (typeof Raphael != 'undefined') {
Raphael.registerFont({
    "w": 235,
    "face": {
        "font-family": "Daniel Black",
        "font-weight": 900,
        "font-stretch": "normal",
        "units-per-em": "360",
        "panose-1": "2 11 10 0 0 0 0 0 0 0",
        "ascent": "288",
        "descent": "-72",
        "bbox": "-66.1107 -333.777 693.812 191.58",
        "underline-thickness": "3.51562",
        "underline-position": "-21.6211",
        "unicode-range": "U+0009-U+F002"
    },
    "glyphs": {
        " ": {
            "w": 189
        },
        "\t": {
            "w": 189
        },
        "!": {
            "d": "71,-328v13,2,21,18,22,33r-32,166v6,9,-7,40,-12,30v-7,3,-6,-7,-11,0v-1,-10,-12,-6,-8,-20v-2,-2,-3,-6,-4,0v1,-74,12,-138,28,-197v2,1,14,-13,17,-12xm43,10v-9,4,-15,-5,-14,-17v-15,-1,3,-20,-2,-26v12,-10,10,-13,26,-7v12,10,22,37,7,53v1,5,-3,6,-7,3v-1,-9,-7,6,-10,-6",
            "w": 115
        },
        "\"": {
            "d": "19,-294v18,-28,39,6,43,27v-2,27,4,62,-7,80v-14,0,-13,3,-30,-2v-12,-20,-15,-75,-6,-105xm88,-302v40,-7,39,56,35,103v-8,18,-17,17,-35,10v-13,-21,-19,-91,0,-113",
            "w": 140
        },
        "#": {
            "d": "112,-122v-29,3,-71,3,-55,-36v9,-23,48,-26,78,-27v18,-33,31,-73,52,-109v1,-3,6,-9,14,-10v8,-2,17,18,16,26v-5,37,-18,51,-31,89v15,8,46,1,67,3v27,-52,35,-76,74,-128v8,-9,36,-23,37,1v4,11,5,8,3,23v-24,37,-43,62,-58,105v15,7,36,6,49,18v-2,10,12,24,-8,29v-9,13,-46,11,-60,9v-3,12,-8,21,-10,34v15,3,32,5,48,10v0,10,0,17,2,20v-8,6,-10,9,-25,13v0,1,2,2,5,3r-41,11v0,1,0,1,1,1v-6,-1,-7,10,-5,16v-8,16,-18,27,-39,28v-12,-7,-7,-28,-13,-37v-27,6,-64,4,-88,13v-4,12,-13,58,-31,40v-3,11,-10,5,-16,-2v-3,-13,0,-23,0,-36v-19,-7,-70,1,-67,-26v-19,-23,14,-56,51,-44v7,8,20,7,33,7v5,-15,14,-27,17,-44xm236,-131v-20,-2,-50,4,-71,5r-16,44v27,0,47,-6,74,-6",
            "w": 364
        },
        "$": {
            "d": "203,-325v22,18,26,46,8,72v23,4,48,29,30,55v-22,7,-43,-13,-57,5v-7,15,-11,23,-11,24v23,28,64,58,57,108v-6,46,-49,64,-94,66v-46,2,-8,86,-54,97v-7,-10,-18,-11,-17,-33v2,-20,8,-41,7,-60v-21,-3,-64,-2,-80,-26v-4,-24,8,-43,34,-33v0,0,-2,3,0,3v19,-3,38,2,59,1r28,-103v-27,-20,-27,-20,-65,-52v8,-8,0,-25,12,-36v28,-7,59,-9,94,-13v18,-14,20,-66,49,-75xm190,-74v-2,-13,-18,-40,-36,-40v-3,20,-20,42,-16,61v22,-5,40,-12,52,-21",
            "w": 244
        },
        "%": {
            "d": "14,-292v22,-27,100,-49,138,-21v0,0,-1,1,-1,2r34,21v46,-6,106,-15,106,42v-6,26,-20,35,-33,54v-2,3,-9,0,-6,7v-8,11,-25,20,-28,33v-10,6,-15,10,-23,18v2,2,3,2,3,2v-15,1,-4,15,-18,20v-7,7,-11,20,-25,19v1,7,-12,8,-5,13v-8,-2,-10,4,-9,12v11,-5,28,-8,30,-20v16,-19,22,-30,47,-41v65,-29,168,-20,154,70v-6,5,-12,25,-25,26v-15,21,-46,36,-74,40v-51,9,-89,-2,-105,-48v-6,-1,-2,-15,-6,-18r-45,32v1,0,2,1,3,1v-4,1,-7,1,-8,1v-16,18,-50,43,-74,33v-8,2,-7,2,-15,-3v-4,-41,22,-58,44,-78v49,-44,132,-118,166,-175v-14,-8,-33,-2,-50,-1v-5,22,-24,31,-35,47v-20,4,-29,23,-49,24v-1,3,-4,5,-10,6v1,-8,-6,-2,-21,-2v-28,0,-69,-12,-72,-34v7,-2,-4,-12,-3,-17v4,-22,15,-43,15,-65xm135,-286v-15,-11,-45,-7,-62,1v17,7,42,1,62,-1xm303,-105v-33,4,-68,13,-91,38v10,38,79,37,104,8v6,-1,18,-12,18,-19v-2,-5,-15,-9,-8,-13v3,0,5,4,10,2v-9,-3,-20,-17,-33,-16xm151,-251v-13,5,-29,-1,-39,6v-12,-6,-30,4,-47,-1r1,3v-18,1,-27,-2,-23,15v30,35,93,2,108,-23xm169,-62r0,-4v0,1,-2,4,0,4",
            "w": 386
        },
        "&": {
            "d": "226,-62v8,13,10,45,-18,36v-5,6,-13,-2,-20,-3v-40,24,-89,57,-152,36v-16,-16,-30,-42,-21,-69v26,-36,45,-47,68,-73v-48,-76,-3,-120,43,-150v27,-18,86,-41,104,3v26,63,-39,125,-75,165v5,8,9,17,21,20v22,-15,33,-38,63,-46v2,2,3,10,9,7v-1,8,9,9,3,17v8,17,-17,41,-25,57xm184,-254v-17,0,-94,46,-67,89r4,0v25,-25,48,-53,63,-89xm140,-72v0,-6,-15,-13,-19,-15v-13,10,-35,26,-44,43v27,-5,43,-13,63,-28",
            "w": 261
        },
        "'": {
            "d": "27,-320v41,-7,39,56,35,103v-8,19,-16,17,-35,10v-17,-25,-17,-88,0,-113",
            "w": 76
        },
        "(": {
            "d": "53,-219v29,-33,53,-90,108,-106v11,-3,23,14,23,28v0,37,-52,43,-69,71v-26,43,-62,77,-66,143v-3,44,54,70,106,90v-3,5,18,12,9,21v-8,56,-89,11,-111,-4v1,-12,-10,1,-8,-10v-26,-14,-38,-52,-40,-89v-2,-37,20,-101,47,-138v1,-3,1,-6,1,-6",
            "w": 176
        },
        ")": {
            "d": "48,-285v-2,-40,43,-61,56,-21v55,57,105,200,35,281v-39,46,-78,60,-128,89v-30,-12,-17,-32,-3,-60v34,-38,130,-60,115,-146v-11,-62,-41,-104,-75,-143",
            "w": 187
        },
        "*": {
            "d": "79,-324v20,-13,20,4,29,19v16,-5,36,-36,50,-14v-1,10,5,12,3,22r-40,35v22,15,47,34,31,71v-19,3,-35,-17,-53,-22v-6,12,-8,40,-17,36v-9,2,-16,-17,-16,-32r-35,40v-34,-16,4,-52,9,-75v-9,-10,-26,-30,-25,-35v6,0,4,-31,18,-26v12,5,21,12,34,15",
            "w": 172
        },
        "+": {
            "d": "144,-105v-38,1,-20,58,-27,89v-11,7,-9,1,-32,-7v-1,-4,-10,-13,-12,-2r-11,-9v-3,-27,6,-51,2,-73v-10,0,-23,7,-29,0v-3,4,-5,3,-11,3v-4,-10,-1,-9,-9,-11r-12,-21v2,-37,40,-21,71,-25v11,-17,-3,-82,32,-72v25,7,31,37,30,69v23,-2,39,4,56,8v10,13,31,35,2,41v-20,4,-34,0,-50,10",
            "w": 219
        },
        ",": {
            "d": "25,60v-36,-24,48,-78,40,-110v18,-23,47,16,45,32v-6,48,-43,74,-74,90v-5,-2,-11,-5,-11,-12",
            "w": 118
        },
        "-": {
            "d": "53,-65v-36,9,-54,-41,-29,-58r96,3r83,-7v20,7,31,19,37,42v-28,30,-121,9,-173,22v-3,-2,-11,-2,-6,1v-4,2,-6,0,-8,-3xm81,-63v-1,1,-1,1,-2,1",
            "w": 246
        },
        ".": {
            "d": "35,-55v18,8,34,17,36,40v-2,10,-11,10,-24,15v3,-1,3,1,3,4v-19,-1,-52,-49,-15,-59",
            "w": 79
        },
        "\/": {
            "d": "2,83v18,-79,39,-94,84,-176v36,-67,82,-128,114,-211v3,-6,9,-15,20,-28v30,1,37,34,26,52v6,11,-9,13,-7,24v-4,-2,-4,3,-9,11v2,3,1,0,-1,8v-12,2,-5,20,-15,20v-7,16,-23,35,-27,53v-13,11,-9,28,-24,40v3,12,-9,10,-8,22v-7,5,-9,8,-9,16v-8,15,-16,17,-16,30v-17,10,-11,32,-26,41v-6,31,-33,47,-35,78v-6,15,-3,26,-22,37v1,0,3,1,6,2v-2,-1,-15,17,-25,10v-2,5,-12,11,-11,-2v-3,-6,-19,-4,-9,-15v0,-3,-2,-7,-6,-12",
            "w": 263
        },
        "0": {
            "d": "50,-38v-79,-90,-32,-266,84,-289v35,-7,78,-2,112,-1v8,7,24,5,34,10r-2,2v7,5,18,2,23,9v-4,-1,-3,-2,-5,0v9,5,18,17,27,18r-18,-15v58,21,72,127,38,192v-15,28,-31,52,-61,85v-8,2,-9,15,-20,15v-48,30,-97,56,-161,25v-24,-12,-38,-27,-51,-51xm333,-277v0,-1,-1,-1,-2,-2v0,1,1,1,2,2xm144,-32v104,17,188,-63,188,-154v0,-85,-92,-114,-180,-93v1,-2,-1,-3,-3,-3v-27,7,-43,25,-62,40v1,6,-12,10,-17,5v-16,22,-31,56,-21,90v18,58,39,90,95,115",
            "w": 378
        },
        "1": {
            "d": "15,-19v-3,-39,15,-68,12,-98v17,-51,11,-116,16,-178v0,-12,8,-17,16,-18v48,17,19,97,24,146v-6,59,-12,118,-26,169v-8,-2,-12,-1,-16,5v-17,-1,-16,-16,-26,-19v1,-1,0,-2,0,-3v2,2,4,2,5,0v-1,-2,-2,-3,-5,-4",
            "w": 101
        },
        "2": {
            "d": "236,-275v-1,101,-65,156,-121,217v66,2,160,-39,220,0r1,23v-63,24,-156,13,-221,37v-43,3,-108,24,-103,-36v40,-50,89,-73,126,-126v31,-44,43,-57,46,-105v3,-39,-46,-9,-62,-12r-77,45v-20,4,-26,-15,-24,-36v41,-26,80,-64,144,-64v34,0,71,26,71,57",
            "w": 342
        },
        "3": {
            "d": "27,-2v-16,-1,-17,-40,0,-43r83,1v58,-3,110,-4,148,-32v-31,-53,-117,-75,-188,-81v-11,-12,-15,-24,-12,-41v6,-3,10,-11,17,-9v35,-4,90,-27,99,-63v-43,-29,-98,2,-134,23v-14,2,-24,-4,-22,-16v-7,-3,-6,-11,-15,-10v0,-5,2,-4,-2,-8v37,-19,71,-46,131,-49v56,-3,126,43,85,99v-12,16,-31,26,-42,43v62,26,125,61,146,126v-2,11,-8,18,-13,28v-71,39,-165,42,-269,41v-9,-3,-7,-3,-12,-9",
            "w": 330
        },
        "4": {
            "d": "297,-319v3,12,24,31,4,46v-13,29,-23,76,-33,108v23,4,48,0,56,30v-2,10,-8,18,-18,22v-16,1,-37,-4,-50,1v-10,22,-21,73,-16,115v-4,1,-4,3,-4,7v-16,7,-31,10,-42,-7v1,0,4,-5,-2,-4v-18,-29,2,-78,4,-111v-42,5,-90,4,-129,12v-7,-4,-22,7,-29,-2v-13,4,-22,-20,-33,-25v4,-42,34,-65,44,-102r50,-99v20,-5,16,4,32,20v8,37,-45,111,-60,156v50,-1,96,-5,142,-11v14,-38,28,-123,70,-159xm55,-102v-6,0,-5,1,-1,2",
            "w": 345
        },
        "5": {
            "d": "140,-325v53,9,116,-17,137,11v1,11,17,20,-5,36v-38,0,-79,10,-113,1v-15,4,-36,1,-59,0v-15,18,-14,18,-25,40v3,3,7,6,10,6v89,18,141,24,182,77v77,99,-80,139,-182,156v-14,2,-52,21,-57,6v-13,1,-5,-11,-16,-11v2,-6,7,-9,7,-17v50,-51,143,-34,198,-79v27,-12,12,-38,-9,-41v-1,-8,-10,-10,-17,-11v-11,-12,-35,-12,-51,-17r1,-1v-38,-10,-78,-11,-112,-27v-3,-10,-16,-20,-16,-35v-1,-19,11,-21,17,-42v13,-24,18,-53,49,-59",
            "w": 319
        },
        "6": {
            "d": "78,-181v-4,12,-20,37,-25,58v1,3,4,2,1,6v5,-6,12,-11,14,-22v10,-9,22,-14,35,-22v-4,-4,1,-4,4,-5r47,-13v-2,3,0,5,4,4v18,-14,47,-5,73,-9v47,4,98,29,98,83v0,15,6,26,-11,31v-10,13,-7,11,-17,21v0,-2,-3,-5,-4,0v-8,34,-87,51,-130,60v-52,-1,-102,-14,-129,-49v3,-5,-11,-6,-6,-10v-29,-41,-25,-109,2,-143v5,-20,16,-29,36,-49v10,-17,50,-56,70,-63v12,-17,55,-41,71,-12v2,7,0,17,-12,20v4,3,1,2,-4,7v-12,0,-21,15,-32,20v-2,11,-24,11,-25,26xm58,-79v40,77,213,36,232,-33v-2,-27,-38,-24,-60,-34v-17,4,-46,-1,-64,6v-4,8,-24,2,-28,9v-1,-1,-2,-2,-3,-2v-1,9,-25,15,-33,25v-6,-8,-13,11,-21,8v-5,7,-12,27,-18,18v-1,0,-2,1,-5,3xm123,-127r-2,2xm68,-82v0,-1,-2,-3,-3,-1v1,1,2,1,3,1",
            "w": 345
        },
        "7": {
            "d": "107,-273r0,0r0,0xm23,-273v-19,-5,-13,-45,-1,-48v76,5,144,-18,215,-7v49,37,-6,82,-22,114v-13,12,-23,42,-40,58v-2,11,-16,20,-13,34v-4,5,-8,9,-5,15v-2,-1,-1,-1,-2,0v-1,13,-18,16,-19,31v-4,10,-14,25,-13,38v-1,-1,-2,-1,-3,0v0,10,-5,12,-6,23v-3,-2,-6,-1,-5,4v3,-2,3,0,3,4v-4,2,-6,14,-15,17r0,-6v-9,13,-31,4,-40,-4v14,-109,81,-186,126,-272r-39,-2r6,3v-15,1,-29,4,-46,3r1,-1v-9,5,-7,2,-20,5v-8,-5,-34,6,-47,2v1,-2,5,-3,3,-5v-8,2,-12,-6,-18,-6xm133,-273v2,-1,1,-2,0,-3r0,3",
            "w": 270
        },
        "8": {
            "d": "305,-196v9,12,34,12,38,27v22,17,46,40,37,61v-4,44,-20,44,-56,73v-82,38,-234,63,-300,-4v-42,-66,12,-125,75,-142v-20,-18,-40,-48,-20,-84v16,-28,33,-36,67,-29v22,-16,66,-27,102,-21v8,-8,32,6,36,4v20,4,74,41,49,82v-1,10,-17,25,-28,33xm121,-238v38,38,133,17,178,-8v-5,-31,-69,-24,-97,-25v-30,8,-63,14,-81,33xm49,-93v34,51,153,49,223,24v23,-2,40,-13,58,-21v7,-3,11,-9,11,-14v-37,-79,-226,-55,-283,-7v-6,6,-8,12,-9,18",
            "w": 397
        },
        "9": {
            "d": "149,-150v-55,13,-111,-25,-129,-71v-22,-58,34,-92,83,-103v42,-9,96,16,103,57v6,5,9,21,9,48v-2,93,-72,165,-138,217v-7,12,-33,21,-39,7v-11,0,2,-8,-7,-11v10,-62,96,-85,118,-144xm165,-189v13,-50,-8,-89,-66,-78v-8,1,-67,19,-30,37v18,16,41,31,76,29v9,0,14,6,20,12",
            "w": 234
        },
        ":": {
            "d": "30,-143v25,3,39,47,8,52v-19,-4,-21,-18,-23,-27v0,-11,5,-26,15,-25xm52,-27v3,30,-26,32,-39,18v-4,-17,-6,-46,17,-40v7,6,14,13,22,22",
            "w": 66
        },
        ";": {
            "d": "40,-156v1,-7,6,-26,20,-21v4,3,10,8,18,13v11,19,8,35,-9,39v-6,1,-32,-15,-29,-31xm61,-59v11,-5,35,25,33,38v-7,42,-46,62,-79,88v-25,-2,-31,-35,-15,-53v18,-21,39,-37,50,-64v2,-5,7,-9,11,-9",
            "w": 101
        },
        "<": {
            "d": "84,-104v53,45,138,64,182,117v8,11,6,39,-10,37v-14,7,-24,-1,-38,-15v-18,-19,-36,-28,-50,-33v-2,-4,-2,-6,-10,-5v-20,-15,-49,-19,-64,-37v-23,-9,-40,-21,-58,-32v0,-3,1,-7,-4,-6v-9,-12,-29,-33,-16,-54r84,-83v31,-21,69,-74,106,-98v19,6,39,21,34,51v-16,15,-28,27,-43,45v-32,21,-45,52,-79,72v4,4,-10,6,-7,13v-14,2,-9,15,-23,19v1,5,-4,5,-4,9",
            "w": 250
        },
        "=": {
            "d": "127,-173v41,-7,93,-15,97,31v-24,28,-79,16,-122,22v-6,7,-5,2,-13,-2v-41,15,-86,-14,-64,-54v10,-8,23,-1,36,0xm61,-49v-37,8,-53,-40,-29,-59v48,-2,97,11,138,-2v10,4,28,-2,41,-2v20,8,30,17,37,42v-27,31,-124,8,-173,23v-3,0,-6,-3,-8,-1v0,1,0,1,1,1v-3,3,-6,2,-7,-2xm89,-48v-1,1,-1,1,-2,1v1,0,1,-1,2,-1",
            "w": 259
        },
        ">": {
            "d": "80,-189v-18,-33,-101,-88,-44,-122v46,22,51,62,89,102v20,21,38,43,64,58v4,15,23,18,15,39v-1,23,-27,34,-40,53v-19,15,-36,35,-55,48r-35,42v-10,5,-19,4,-31,7v-17,-2,-26,-18,-27,-40v30,-59,72,-68,119,-129",
            "w": 219
        },
        "?": {
            "d": "21,-292v55,-36,206,-73,241,6v6,36,-3,51,-25,87v-11,7,-19,24,-37,27v-11,15,-30,18,-46,34v-20,7,-30,14,-55,30v-6,-3,-12,1,-5,3v-17,4,-11,17,-31,34v-5,12,-7,18,-13,9v-7,10,-13,-7,-23,-11v-10,-86,69,-103,122,-140v25,-17,50,-25,66,-52v-48,-31,-138,-4,-172,23v-6,-8,-21,5,-22,-9v-13,-4,-5,-30,0,-41xm55,24v-30,-2,-17,-62,4,-62v21,0,37,28,27,55v-12,2,-10,23,-18,8v-7,0,-19,5,-13,-1",
            "w": 275
        },
        "@": {
            "d": "175,8v-50,5,-104,-5,-132,-37v-41,-21,-41,-123,-11,-160v30,-84,223,-116,276,-28v32,30,24,103,-5,128v-9,8,-31,10,-21,25v9,8,-1,22,-1,34v-10,6,-11,11,-15,8v-18,23,-57,23,-89,30v1,2,1,2,-2,2r-3,0xm157,-134v3,14,49,-4,35,-10v-14,1,-23,7,-35,10xm248,-122v27,-5,51,-28,41,-62v-9,-17,-45,-49,-80,-38v-31,0,-59,4,-88,19v-35,19,-61,54,-61,106v0,68,127,52,185,31v-8,-1,-20,-9,-36,-22v-20,5,-42,15,-65,11v-20,-4,-58,-53,-35,-89v32,-21,69,-41,100,-20v30,7,15,53,39,64",
            "w": 335
        },
        "A": {
            "d": "217,-206v24,31,33,146,64,188v-7,1,-2,12,-6,18v1,-4,-3,-8,-5,-3v5,6,-4,10,-7,17r-18,0r-17,-22v-12,-51,-38,-81,-87,-92v-8,-2,-27,-8,-36,1v-1,-5,-12,-5,-14,0v2,1,4,1,5,2v-16,3,-18,10,-34,7v-9,15,-13,29,-20,44v-11,-1,-6,1,-14,2v-10,-10,-19,-20,-17,-41v49,-56,62,-131,104,-199v4,-12,10,-28,18,-45v15,-7,37,9,40,21v9,10,31,62,46,99v0,2,-1,2,-2,3xm83,-87v-2,2,-3,3,-5,4v0,-1,2,-7,5,-4xm91,-149v45,-3,74,6,102,19v-6,-47,-23,-98,-43,-132v-3,3,-15,16,-12,26v-3,-8,-7,9,-7,-2",
            "w": 290
        },
        "B": {
            "d": "231,-282v-1,50,-17,61,-50,94v0,0,0,2,1,3v41,14,82,39,89,82v-3,4,-4,20,-9,16v-7,25,-30,42,-55,49v-4,4,-3,11,-12,9r-80,34v-15,-2,-31,8,-50,5v2,-9,-5,-8,-12,-12v0,-16,-6,-20,1,-34v-26,-33,-30,-104,-23,-160v2,-16,-10,-11,-13,-21v-8,14,-10,-4,-21,-6v1,-2,3,-7,1,-10v-1,1,-1,1,-3,1r1,-26v9,-6,22,-15,38,-29v4,-20,14,-26,27,-14v52,-13,156,-57,170,19xm175,-269v-51,6,-109,6,-96,71v45,-20,77,-41,96,-62r0,-9xm206,-112v-13,-11,-40,-16,-63,-23r-67,5v1,21,3,46,14,64v-3,2,-6,8,-2,11v47,-15,63,-20,113,-49v3,-4,5,-6,5,-8",
            "w": 279
        },
        "C": {
            "d": "244,-262v-70,22,-131,54,-171,114v6,7,-11,10,-8,18v-6,13,-12,41,7,43v34,26,124,12,173,10v13,-5,26,-8,44,-9v0,7,16,-2,15,7v12,2,-10,14,5,12v-1,2,-5,7,1,8v-1,2,-12,4,-12,13v-13,3,-32,14,-46,16v-1,1,8,6,2,5r-19,-2v1,5,-2,5,-5,6v7,0,10,-1,8,3v-20,-1,-36,2,-54,5v0,0,15,5,21,-1r-1,1v7,0,7,2,19,2v-9,3,-19,1,-25,4v3,1,6,2,10,2r-13,1v0,0,0,-1,1,-2r-6,0v2,1,1,4,-2,4v-13,-1,-30,2,-40,-2r1,2v-35,2,-57,-5,-82,-13v2,-3,6,2,10,-2v-10,-5,-30,-1,-31,-12v-26,-10,-39,-41,-39,-78v0,-46,27,-94,81,-143v28,-10,31,-30,65,-37v20,-15,46,-23,80,-24v10,10,2,28,13,37v-4,0,-5,7,-9,10v2,1,2,0,7,2xm223,-24v0,0,6,-4,1,-3v0,1,0,2,-1,3",
            "w": 312
        },
        "D": {
            "d": "94,-328v109,-13,207,27,212,127v1,25,-21,69,-53,97v0,2,0,5,-1,8v-32,26,-52,44,-92,66v-10,-2,-26,15,-38,19v-6,16,-34,6,-43,18v-10,-3,-12,2,-16,5v1,-2,1,-4,-1,-4v-8,3,-9,-2,-18,-1r2,-1v-16,-6,-24,-25,-14,-47v-32,-42,-10,-136,-15,-205v-4,1,-13,7,-26,18v0,-3,-6,-8,-8,-3v-16,-9,-21,-38,-10,-52v52,-28,92,-41,121,-45xm173,-273v-48,1,-87,-14,-110,21r3,186v-3,2,-6,7,-1,9v63,-23,89,-31,145,-77v55,-45,56,-83,13,-120v-10,-2,-32,-14,-50,-19",
            "w": 299
        },
        "E": {
            "d": "170,-237r-2,-1v1,0,2,1,2,1xm44,-281v18,3,36,-5,48,-18v41,17,88,-22,128,-12v10,-6,28,-11,43,-6v1,-2,7,-8,8,-2v-2,2,-11,3,-2,4r11,-3v-3,13,21,6,27,12v-12,8,-5,14,-20,20v3,1,9,2,1,5v-2,-5,-8,2,-15,0v1,1,1,1,2,1v-13,4,-17,11,-32,12v-5,13,-35,7,-38,16v-17,-3,-20,10,-33,4v-2,2,-1,9,0,7v0,-2,-3,-2,-5,-2v-3,9,-21,1,-22,9r-24,11v-1,8,-12,18,-7,30r118,-7r0,6r-1,-1v6,-2,18,2,10,6v18,6,-4,7,1,21v-1,2,-8,2,-4,6v-20,7,-36,12,-58,16v-5,8,-22,12,-35,8r-49,19v-5,10,-12,22,-12,39v66,-1,140,-16,195,3v2,3,22,17,12,30r2,3v-13,0,-1,14,-20,11v-5,15,-22,-4,-32,6r3,2v-8,2,-4,-3,-10,-3r1,3v-43,1,-85,5,-120,10v-12,8,-53,14,-81,13v-11,-18,-27,-25,-22,-55v6,-36,27,-63,20,-104v2,-1,7,-21,15,-19v2,-10,12,-23,7,-33v-26,-12,-29,-37,-20,-61",
            "w": 299
        },
        "F": {
            "d": "85,-300v79,-3,190,-36,230,24v0,8,-9,11,-2,17v-16,6,-15,1,-30,2v-7,6,-29,0,-49,3v1,-3,-2,-3,-5,-3v-7,9,-20,-1,-32,5v1,-5,-5,-4,-5,-1v0,1,2,1,-1,2v-4,2,-2,-6,-9,-1v0,1,2,1,3,1v-5,1,-9,1,-14,0v1,0,1,1,2,1v-28,4,-40,3,-75,10v-10,10,-10,28,-13,45v43,13,105,-23,151,-8v17,-4,36,10,22,21v-1,4,8,3,3,6v-4,-3,-8,1,-3,3v-18,8,-25,9,-45,16v2,1,3,1,5,1v-45,8,-89,30,-140,26v-1,2,-5,10,-6,24r-4,88v-2,5,-17,6,-6,15v-7,2,-12,6,-12,-4v-8,-2,1,18,-13,7v-8,7,-12,-7,-22,-8v-23,-71,10,-164,18,-232v-8,1,-12,-28,-13,-27v0,-4,3,-11,10,-23xm209,-155v4,-2,4,-4,-1,-3v0,0,0,2,1,3",
            "w": 272
        },
        "G": {
            "d": "246,-120v-27,-7,-65,12,-86,2v2,-11,-16,-11,-10,-24v-13,-6,6,-25,-2,-33v5,-4,11,-12,18,-10v96,-1,194,-23,227,62v2,13,-14,21,-11,24v-4,9,-12,16,-25,24v0,-5,-2,-4,-5,0v0,19,-42,33,-55,40r8,-2v-2,3,-4,7,-10,5v-42,21,-87,36,-139,49v-20,-5,-27,5,-46,-4v-17,-8,-35,-20,-52,-23v-70,-52,-58,-166,6,-229v48,-47,102,-77,181,-89v10,1,50,15,41,30v12,16,3,44,-13,44v-12,8,-45,-5,-56,9v-2,-3,-6,-6,-6,0v-22,7,-46,20,-68,28v-5,10,-14,9,-25,23v-9,-4,-15,25,-26,27v-7,21,-21,39,-21,65v0,60,92,47,137,37v34,-16,76,-25,101,-50v-8,-13,-34,-1,-47,-10v-1,7,-17,-1,-16,5xm201,-243v5,-2,7,-2,1,-4v-1,1,-1,3,-1,4",
            "w": 399
        },
        "H": {
            "d": "315,-281v-1,12,6,14,7,27v-21,31,-25,95,-35,141v-9,41,-6,91,-23,123v-3,-9,-12,9,-19,1v-48,4,-19,-96,-22,-143v-8,0,-13,4,-19,3v-8,9,-35,1,-46,11v-8,-2,-21,4,-37,2v-4,6,-16,0,-17,9v0,-4,-3,-9,-9,-6v3,4,0,2,-5,6v-9,0,-12,1,-20,3v-6,12,-3,31,-5,47v-11,7,-34,23,-46,5v-36,-56,7,-163,20,-215v0,-4,10,-26,26,-30v9,5,17,9,21,26v11,6,2,23,4,33r-16,68v50,4,111,-2,158,-9v16,-54,32,-107,66,-112xm90,-113v-4,1,-6,3,-6,3v3,0,5,-1,6,-3",
            "w": 312
        },
        "I": {
            "d": "52,-312v56,27,13,118,23,186v-5,31,-8,81,-3,115v-17,9,-33,22,-53,-1v-8,-81,5,-177,11,-259v0,-10,11,-38,22,-41",
            "w": 96
        },
        "J": {
            "d": "213,-327v44,57,36,196,14,273v-16,57,-116,73,-183,43v-9,-11,-50,-18,-40,-51v4,-6,15,-31,27,-17v45,21,133,39,148,-21v15,-62,3,-133,2,-196v0,-15,9,-32,32,-31",
            "w": 258
        },
        "K": {
            "d": "253,-317v28,-28,44,4,42,28v-45,59,-99,108,-146,164v40,25,128,16,151,60v0,5,-1,7,-6,8v1,2,3,5,5,10v-67,26,-157,-7,-210,-34v-1,0,-6,-6,-15,-16r-4,2r0,92v-3,2,-13,0,-12,7v-42,24,-52,-32,-48,-83r18,-208v7,-12,16,-32,33,-26v9,8,13,19,20,38r-6,149v34,-38,45,-58,88,-96v21,-29,60,-66,90,-95",
            "w": 310
        },
        "L": {
            "d": "59,-325v20,0,17,26,29,31r-19,230v81,-2,152,-30,239,-26v5,0,15,6,23,6v0,0,-1,1,-2,3v10,3,1,12,4,22v-57,32,-149,28,-215,48v1,3,5,2,8,4v-41,-3,-75,24,-106,5v-13,0,-17,-13,-15,-28r21,-197v5,-29,-2,-88,33,-98",
            "w": 340
        },
        "M": {
            "d": "307,-314v25,-25,49,6,49,45v0,27,4,51,1,79r3,4r-14,160v-16,9,-14,6,-27,16v-7,-5,-14,-11,-19,-8v-29,-54,10,-139,-3,-210v-1,2,-3,5,-5,10v-18,17,-38,45,-47,74r-4,1v-10,26,-33,56,-49,79v0,1,1,3,2,4v-15,9,-12,43,-32,37v-9,13,-42,5,-46,-10v-5,-15,-8,-67,-11,-96r-58,120v4,25,-34,41,-54,24v-11,-36,16,-43,23,-73v31,-64,79,-132,95,-206v2,-5,12,-19,25,-19v16,0,19,24,28,30v2,45,-6,99,3,138v44,-51,87,-134,132,-188v4,-4,2,-10,8,-11",
            "w": 368
        },
        "N": {
            "d": "245,-80v22,-37,60,-166,65,-227v11,-12,19,-29,34,-9v4,-8,4,4,11,3v-3,8,0,11,4,18r-4,24v-1,-1,-2,-3,-3,0v0,6,-4,10,-1,15v-5,-2,-4,7,-6,13v7,6,-8,8,-1,17v-6,12,-15,34,-12,48v-7,9,-10,17,-8,28v-2,0,-5,3,-4,7v4,-1,4,1,2,3v-3,22,-10,40,-16,59v1,-1,2,-3,2,0v0,4,0,8,-5,7r-11,63v-11,-1,-6,24,-23,14v-10,9,-21,7,-34,-3v-36,-26,-68,-84,-94,-131v-12,-22,-25,-67,-45,-85v-15,28,-9,63,-31,94v0,1,-2,8,-7,21v0,24,-2,18,-24,42v-7,4,-11,0,-20,0v-5,-10,-17,-10,-15,-30v26,-48,51,-125,67,-192v1,-4,7,-10,16,-19v21,-5,32,8,43,18v52,45,73,154,120,202",
            "w": 362
        },
        "O": {
            "w": 394
        },
        "P": {
            "d": "114,-313r0,0r0,0xm239,-139r1,-2v0,0,0,1,-1,2xm-4,-234v0,-54,68,-56,106,-77v-1,0,-1,1,-1,2r107,-21v3,7,19,-6,34,-1v24,0,48,7,71,20v19,16,18,41,20,71v-9,14,-10,39,-27,46v0,1,-4,5,-3,9v-5,5,-21,10,-19,14v1,0,1,0,1,-1v-3,8,-6,12,-11,12r-1,-5r-25,18r2,2v-13,2,-24,9,-33,17v-2,-2,-4,-3,-4,2v-33,11,-66,30,-100,36v-14,3,-26,14,-41,10r3,72v-3,1,-6,3,-3,8v-11,3,-16,6,-29,11v-46,-28,-29,-124,-13,-176r24,-79v-6,4,-17,6,-9,22v-4,3,-11,1,-10,9v-9,2,-7,7,-15,5r0,5v-10,-6,-24,-14,-24,-31xm277,-168v-1,0,-3,1,-1,1v0,0,0,-1,1,-1xm264,-227v17,-18,23,-52,-14,-51v-58,-11,-88,-2,-145,13v-16,4,-3,14,-5,26r-20,112v46,-35,135,-48,184,-100xm234,-280v-3,0,-6,-1,-8,-1v5,0,7,1,8,1",
            "w": 317
        },
        "Q": {
            "d": "11,-98v-35,-148,105,-199,217,-215v36,-5,72,-1,96,15r0,-2v5,1,6,2,2,5v4,0,11,13,18,9v0,10,5,8,12,16v25,24,46,109,16,143v-12,22,-39,49,-60,65v7,12,25,37,4,47v-25,4,-28,-13,-48,-20v-37,22,-77,34,-125,42v-1,-5,-7,-3,-11,0v-37,-7,-69,-20,-98,-47v3,-6,-2,-10,-7,-13xm316,-138v29,-11,49,-74,18,-101v3,-5,-2,-10,-5,-6v-14,-16,-48,-31,-77,-21v-38,0,-63,5,-102,26v-12,-1,-14,11,-20,9v-21,8,-36,33,-33,64v-7,4,-4,19,-10,21v-2,-5,-5,-11,-11,-12v-4,-10,-1,-22,-13,-23v-24,21,-24,102,13,115v47,17,116,11,153,-14v-13,-25,-10,-21,-10,-44v4,-5,8,-9,11,-11v19,10,19,11,39,32v13,-2,16,-16,29,-18v5,-11,17,-7,18,-17",
            "w": 390
        },
        "R": {
            "d": "57,21v-24,2,-48,-10,-47,-42r8,-195v-7,-16,-14,-22,3,-47v52,-43,74,-41,126,-62v34,-6,74,-10,92,18v18,8,33,58,13,76v-29,60,-73,88,-128,127v0,2,1,3,1,3v61,28,178,26,213,71v-4,10,4,24,-8,25v-89,11,-195,-21,-261,-54v-10,15,5,40,1,61xm63,-128v46,-38,121,-84,141,-138v-44,-10,-81,12,-119,26v-22,8,-17,16,-18,38",
            "w": 345
        },
        "S": {
            "d": "228,-257v-48,-3,-81,-8,-129,14v25,25,147,41,162,90v23,32,0,83,-33,96v-17,11,-63,35,-91,35v-29,11,-69,25,-110,17v-10,-11,-19,-21,-14,-39v1,-24,35,-11,55,-26r9,1v26,-16,109,-28,133,-56v-33,-32,-149,-55,-187,-104v3,-5,-4,-20,-5,-18v-3,-61,93,-50,135,-64v36,-1,55,0,76,19v1,11,13,26,-1,35",
            "w": 282
        },
        "T": {
            "d": "156,-20v0,18,-25,18,-31,5v-16,-5,-13,-40,-10,-62r16,-101v2,-17,13,-28,6,-46v-48,5,-92,19,-142,18v-22,-6,-23,-33,-14,-54v25,-13,50,-14,109,-21v113,-14,214,-35,338,-35v15,17,19,45,1,61v2,11,-17,5,-29,5v-25,2,-43,1,-64,5v-9,-8,-27,10,-40,2v-13,10,-43,-5,-54,9v-16,-7,-33,7,-50,8v-14,35,-31,170,-32,205v-1,1,-2,1,-4,1",
            "w": 225
        },
        "U": {
            "d": "54,-183v-1,68,13,128,76,113v69,-17,158,-87,190,-175v3,-31,-8,-44,16,-66v6,1,7,-2,11,-3v3,6,3,10,11,9v32,65,-42,172,-68,194v-32,46,-83,70,-128,104v-24,5,-60,19,-88,-1v-60,-44,-84,-121,-57,-219v13,-47,16,-51,44,-71v15,2,20,19,24,32v-11,32,-30,40,-31,83",
            "w": 371
        },
        "V": {
            "d": "266,-325v7,-11,12,3,21,3v13,58,-37,101,-57,143v-17,37,-35,73,-57,105v-7,30,-32,50,-40,76v-8,10,-21,16,-38,7v-48,-63,-63,-166,-86,-255v3,-21,12,-55,34,-24v14,21,18,56,28,84r41,116v62,-80,88,-157,154,-255",
            "w": 307
        },
        "W": {
            "d": "493,-330v42,10,6,74,-5,92v-20,32,-59,74,-75,109v-15,17,-38,52,-48,78v-8,8,-18,24,-17,34v-4,2,-5,3,-9,3v-1,17,-17,5,-29,4v-35,-35,-47,-133,-66,-191r-68,129v-9,12,-15,22,-18,29v-16,16,-24,26,-21,42v-12,19,-41,17,-50,-3v-35,-77,-39,-180,-80,-282v-1,-31,19,-60,38,-26v34,60,46,163,73,234v61,-63,56,-83,114,-201v5,-5,12,-17,23,-18v51,48,36,120,75,203r80,-114v25,-25,45,-58,69,-104v6,-5,10,-11,14,-18",
            "w": 520
        },
        "X": {
            "d": "216,-42v-37,-6,-54,-57,-81,-80v-20,9,-37,45,-52,69v-3,4,-17,85,-46,54v-17,-19,-4,-68,7,-87r50,-82r-87,-77v4,-3,-1,-6,0,-15v9,-14,11,-39,36,-34v23,13,71,58,97,81v31,-19,85,-64,129,-78v18,1,26,2,20,13v10,6,6,38,-8,40v2,17,-34,12,-41,26v-23,11,-41,27,-60,42v16,25,39,48,58,71v20,25,-12,55,-22,57",
            "w": 299
        },
        "Y": {
            "d": "119,37v-57,7,-37,-84,-20,-118v-4,-8,15,-23,-5,-22v-18,-3,-21,-16,-37,-39v-19,-51,-54,-97,-49,-164v5,-2,5,-11,15,-9v37,34,43,104,73,144v32,-21,55,-64,82,-91v4,-12,16,-16,23,-25v2,-16,19,-22,36,-43v2,1,15,-6,13,3v44,40,-21,94,-34,130v-20,55,-92,129,-85,215v-3,4,-7,13,-12,19",
            "w": 265
        },
        "Z": {
            "d": "245,-267v-59,-11,-135,29,-166,-10v1,-26,6,-42,38,-45r102,-8v52,1,111,-7,104,57v-37,48,-86,101,-138,145v-20,29,-49,42,-64,67v84,-8,186,4,266,-4v25,-2,43,14,37,36v1,8,0,21,-12,23v4,4,-4,6,-6,7v-35,0,-77,-2,-109,-2r-157,2v-35,2,-65,7,-97,14v-8,-6,-25,2,-26,-13v-12,-9,-9,-26,-5,-41v67,-76,165,-149,233,-228",
            "w": 429
        },
        "[": {
            "d": "48,-316v39,-6,101,-32,99,23v-7,20,-43,20,-64,28v-13,84,-12,200,-8,297v29,2,69,-8,68,23v-1,32,-75,41,-102,47v-23,-7,-50,-23,-34,-50v9,-115,-4,-274,30,-360v3,-2,6,-4,11,-8",
            "w": 120
        },
        "\\": {
            "d": "165,98v-30,-44,-66,-114,-90,-168v-4,-6,-12,-34,-21,-40v6,-10,-12,-18,-9,-29r-66,-149v-8,-37,22,-56,45,-30v68,126,111,281,200,388v3,6,17,24,11,39v-24,10,-19,0,-37,21v-18,-3,-27,-16,-33,-32",
            "w": 211
        },
        "]": {
            "d": "-5,-272v-27,-17,-27,-50,5,-59v28,2,57,12,84,5v22,6,58,-9,69,11r5,0v21,31,18,66,13,113r-25,241v6,26,2,62,-28,64v-54,3,-140,16,-140,-33v0,-16,53,-16,59,-18r37,-4v9,-104,30,-196,31,-309v-35,-6,-71,-2,-110,-11",
            "w": 180
        },
        "^": {
            "d": "175,-234v-24,-15,-37,-18,-68,-47r-3,0r-35,49v-2,-2,-3,0,-4,3v2,8,-14,3,-13,12v-18,9,-22,2,-38,-15r65,-94v39,-11,73,34,102,51v3,1,26,11,18,23v13,2,-4,6,-1,16v-9,-4,-12,4,-23,2",
            "w": 213
        },
        "_": {
            "d": "304,9v33,-3,75,-13,83,26v10,9,-2,26,-21,24v-91,11,-210,1,-299,14v-3,0,-6,-3,-8,-1v0,0,1,1,2,1v-3,3,-7,2,-8,-2v-35,9,-54,-40,-29,-58v50,-2,100,4,150,2xm81,72v0,1,-1,1,-2,1v1,0,1,0,2,-1",
            "w": 396
        },
        "`": {
            "d": "13,-289v-15,-8,-8,-38,7,-35v45,10,72,54,119,62v9,14,19,20,12,35v-28,20,-76,-27,-112,-43v-7,-4,-16,-10,-26,-19",
            "w": 163
        },
        "a": {
            "d": "22,-87v26,-24,59,-41,105,-54v27,0,31,7,40,28v24,0,29,26,39,40v9,13,14,26,17,36v-6,5,-8,18,-19,15v-1,8,-8,1,-11,1v-13,-2,-25,-18,-35,-36r-47,35v4,12,-38,18,-52,24v-18,0,-32,-7,-43,-21v-13,-36,-10,-28,6,-68xm136,-90v-28,2,-60,12,-75,35v35,1,54,-19,75,-35",
            "w": 231
        },
        "b": {
            "d": "77,-180v82,-9,179,0,189,71r-19,37v-37,29,-77,55,-144,65v-7,-8,-14,-2,-17,-12v-4,10,-17,22,-30,11v-30,-7,-27,-62,-29,-99v-19,-5,-25,-41,-2,-52r1,-90v2,-19,0,-83,31,-71v24,27,15,92,20,140xm86,-44v36,-27,88,-28,121,-65v-22,-31,-89,-27,-130,-12",
            "w": 272
        },
        "c": {
            "d": "130,-156v9,-2,40,-12,55,-10v4,12,14,27,1,35v1,9,-15,7,-50,26v-14,15,-59,17,-62,42v35,22,101,-18,134,7r0,14v-32,34,-94,48,-154,40v-25,-3,-44,-30,-43,-47v7,-67,62,-76,119,-107",
            "w": 217
        },
        "d": {
            "d": "233,-81v-43,12,-105,2,-138,23v55,3,107,-3,153,-7v3,7,-2,10,8,12v-2,3,-17,10,-9,18v-49,38,-155,54,-221,20v-22,-12,-23,-49,-2,-67v34,-29,94,-38,156,-52v5,-60,1,-125,12,-179v17,-35,49,-16,45,20v8,56,0,128,2,190",
            "w": 262
        },
        "e": {
            "d": "39,-17v-75,-63,29,-180,119,-140v-3,6,8,3,9,10v8,22,3,50,-10,64r-38,27v17,10,77,-5,86,17v-3,6,-7,9,-16,12v9,4,12,5,1,13v-6,4,-27,3,-29,14v-44,9,-96,4,-122,-17xm84,-98v16,-1,36,-12,36,-23v-18,7,-29,13,-36,23",
            "w": 211
        },
        "f": {
            "d": "182,-322v34,-3,112,30,112,78v-1,2,-7,7,-6,11v-2,2,-16,7,-21,6v-25,-29,-72,-58,-122,-45v-36,21,-30,98,-28,151v27,11,74,-13,93,13v2,32,-43,30,-66,42v7,9,18,35,17,45v-8,2,-10,11,-22,10v-2,6,-10,2,-15,4v-13,-14,-33,-26,-44,-49v-24,2,-67,11,-68,-20v-1,-6,13,-38,32,-32r16,-3v-13,-78,7,-196,66,-208v20,-4,34,-13,56,-3",
            "w": 221
        },
        "g": {
            "d": "188,-93v14,42,34,173,-3,220v-41,52,-187,90,-240,24v-13,-29,-11,-23,-11,-52v9,-14,13,-21,30,-30v5,2,-2,9,2,9v1,-4,4,-5,10,-6v1,9,-6,7,-1,16v3,-1,5,-2,6,-2v-5,7,-9,26,-1,38v42,33,123,5,153,-20v39,-21,27,-92,16,-136v-38,9,-71,24,-111,-1v-58,-36,-9,-100,42,-104v20,-2,93,-14,99,15v9,2,9,14,15,22v-8,0,3,9,-6,7xm-32,71v0,0,-2,-1,0,-1r0,1xm62,-77v29,17,75,1,86,-17v-38,-2,-56,-2,-86,17",
            "w": 222
        },
        "h": {
            "d": "132,-161v59,-34,111,11,111,77v0,36,-4,71,-3,104v-6,1,-8,7,-15,8v-41,-17,-34,-74,-29,-125v1,-15,-10,-20,-24,-18v-27,4,-61,26,-101,72v-3,4,-18,9,-27,16v-3,-6,-10,2,-10,-8v-7,3,-11,4,-14,-2v-18,-58,1,-121,-1,-179v0,-8,2,-34,7,-80v9,-20,34,2,40,14v13,55,-11,107,0,165v23,-12,34,-26,66,-44",
            "w": 251
        },
        "i": {
            "d": "40,-220v16,-17,44,17,37,29v6,21,-18,13,-32,10v-9,-18,-7,-21,-5,-39xm26,-111v18,-28,39,6,44,27v-3,27,3,62,-8,80v-14,1,-13,3,-29,-3v-13,-18,-16,-74,-7,-104",
            "w": 86
        },
        "j": {
            "d": "40,-202v4,-7,14,-1,21,0v1,4,3,6,8,7v3,8,13,33,-10,32v-9,2,-13,-9,-19,-13r0,-26xm98,-132v10,19,31,46,26,85v6,42,2,91,2,137v-6,20,-6,100,-42,100v-57,0,-110,-40,-110,-105v21,8,56,48,89,39v27,-64,12,-158,10,-239v4,0,9,-26,25,-17",
            "w": 151
        },
        "k": {
            "d": "75,-137r159,-80v18,6,31,33,18,52r-141,74v6,2,33,12,31,6v19,10,69,9,96,37v1,13,6,22,-9,31v-59,8,-122,-7,-166,-27v-7,14,3,52,-24,45v-5,9,-14,-15,-20,-3v-11,-13,-6,-25,-8,-49r28,-235v5,-25,4,-36,16,-45v62,24,15,128,20,194",
            "w": 248
        },
        "l": {
            "d": "55,-330v25,2,34,31,31,59r-32,278v-14,2,-21,6,-32,-5v-1,0,-2,1,-4,3v-16,-55,2,-108,8,-165v5,-42,4,-131,29,-170",
            "w": 94
        },
        "m": {
            "d": "289,-170v49,14,54,92,38,152v-5,0,-5,4,-7,7v-14,0,-30,-9,-30,-30v0,-27,3,-57,-10,-72v-49,13,-69,49,-101,105v-7,0,-22,10,-24,-2v-5,-4,-14,0,-16,-7v-6,-34,10,-70,1,-99v-39,17,-66,58,-87,96v0,2,3,5,1,5r-21,0v-10,-13,-27,-11,-18,-34v-9,-15,11,-70,19,-94v16,-17,26,10,35,20v29,-24,50,-43,84,-53v18,6,34,41,37,70v25,-19,60,-62,99,-64",
            "w": 343
        },
        "n": {
            "d": "159,-163v45,15,39,122,22,170v-23,12,-38,-12,-38,-44v0,-22,6,-49,1,-67v-31,11,-40,30,-60,50v-16,15,-25,31,-33,45v-10,3,-15,1,-26,2v0,-7,-5,-11,-10,-5v-12,-45,3,-85,15,-128v6,-2,9,-6,17,-3v7,14,16,18,17,39v41,-23,47,-51,95,-59",
            "w": 206
        },
        "o": {
            "d": "193,-149v24,9,46,63,23,94v-6,9,-6,9,-19,23v-54,57,-203,50,-182,-57v-14,-93,110,-114,178,-63r0,3xm56,-73v32,39,121,10,130,-28v-11,-16,-17,-26,-31,-22v-17,-13,-58,-1,-81,3v-3,7,-2,16,-2,23v-7,2,-14,17,-16,24"
        },
        "p": {
            "d": "8,-152v45,-9,76,-46,141,-37v17,-4,40,7,55,7v40,2,96,81,56,121v-42,42,-109,57,-175,68r-17,-7v-8,54,-11,110,-12,169v-17,15,-38,-1,-40,-20v-10,-112,-3,-126,22,-251v6,-31,37,-1,37,11v0,18,-4,36,-2,53v44,-24,119,-29,153,-70v-31,-44,-127,-34,-174,-14v-9,4,-50,17,-34,34v-7,8,-18,17,-26,6v-10,2,-14,-19,-13,-35v2,-16,18,-24,29,-35",
            "w": 281
        },
        "q": {
            "d": "119,-124v34,-10,69,23,43,43r4,4v-19,0,-43,-2,-51,8v-17,3,-34,5,-43,15v36,8,83,-15,123,-23v37,42,28,144,24,218r-9,32v-12,5,-12,5,-25,-2v-19,-49,1,-133,-13,-191v-39,9,-68,25,-110,25v-15,0,-54,-19,-53,-36v4,-58,44,-90,110,-93",
            "w": 231
        },
        "r": {
            "d": "135,-157v36,-15,105,-26,114,30v-4,0,-7,7,-1,8v-22,13,-46,-9,-73,2v-50,21,-123,23,-118,93v-1,4,-4,9,0,11v-10,6,-20,17,-31,4v-28,-12,-21,-108,10,-110v3,2,4,5,8,5v26,-11,46,-24,91,-43",
            "w": 253
        },
        "s": {
            "d": "19,-118v-7,-45,4,-55,72,-53v24,1,94,17,72,48v-8,11,-9,6,-33,1v-28,-6,-30,-2,-52,1v46,26,100,51,93,82v1,31,-53,44,-83,37v-24,0,-78,2,-73,-31v0,-3,-1,-6,-2,-8v26,-12,62,-3,91,-14v-30,-16,-81,-38,-85,-63",
            "w": 180
        },
        "t": {
            "d": "179,-155v44,1,87,-12,124,9v-2,7,2,13,9,14v-9,-3,-7,9,-13,8v-27,24,-89,7,-128,28v-11,56,-5,52,-13,93v-4,2,-12,6,-21,10v-32,-12,-21,-61,-22,-98r-82,14v-20,-2,-35,-49,-12,-55v38,-2,75,-6,106,-15v7,-46,12,-103,29,-137v13,-13,13,-16,34,0v11,48,-13,78,-11,129",
            "w": 295
        },
        "u": {
            "d": "163,-156v58,18,10,114,-15,137v-17,16,-35,21,-60,25v-32,5,-85,-51,-70,-109v49,-34,20,73,82,48v46,-19,38,-58,63,-101",
            "w": 201
        },
        "v": {
            "d": "222,-219v21,2,33,27,17,50r-86,124v-3,8,-16,23,-20,38v-6,8,-35,17,-45,3v-14,-12,-83,-70,-83,-116v-1,-8,7,-20,15,-19v31,11,51,66,79,78r62,-80v19,-31,40,-57,61,-78",
            "w": 219
        },
        "w": {
            "d": "74,-72v18,-13,45,-49,56,-73v8,-4,17,-7,28,0v17,12,33,37,50,75v2,2,5,4,9,9v31,-30,37,-59,75,-88v-1,5,-2,5,0,6v5,-8,14,-6,13,5v3,0,5,3,4,8v-8,50,-49,110,-80,139v-45,5,-56,-60,-78,-92v0,0,0,1,-3,0r-47,69v-12,8,-23,12,-34,13v-32,-22,-56,-88,-55,-132v0,-3,5,-13,16,-16v30,12,29,39,46,77",
            "w": 317
        },
        "x": {
            "d": "89,-121v9,-1,91,-55,102,-42v14,4,27,25,14,36v1,9,-8,6,-17,10v-14,7,-38,21,-52,31v24,22,31,29,42,62v-2,12,-17,29,-31,16v-27,-26,-34,-36,-56,-49v-27,7,-37,51,-61,61v-15,-5,-19,-22,-19,-41v6,-24,11,-27,31,-53r-19,-12v-9,-15,-14,-45,9,-48v8,-1,49,23,57,29",
            "w": 217
        },
        "y": {
            "d": "68,-64v22,-1,62,-38,74,-56v10,-3,19,-4,25,9v10,2,11,15,12,24v-7,49,-22,94,-50,170v0,1,2,1,3,1r-3,0v-13,31,-24,64,-35,97v-14,16,-27,14,-41,-7v-13,-40,8,-72,17,-102v9,-28,27,-54,32,-83v-59,29,-86,-42,-88,-94v1,-12,3,-26,16,-29v23,-6,29,73,38,70",
            "w": 186
        },
        "z": {
            "d": "52,-158v50,2,122,-19,124,36v0,19,-26,27,-38,38r-42,37v36,8,71,-8,102,4v9,-3,8,1,10,11v10,1,-1,6,0,12v-6,1,-6,2,-1,5v-8,-3,-18,0,-18,8v-51,6,-125,24,-172,0v-5,-6,-8,-25,-8,-38v15,-30,50,-30,82,-63v-20,-5,-62,13,-62,-26v0,-13,8,-25,23,-24",
            "w": 221
        },
        "{": {
            "d": "78,68v33,10,85,-4,67,49v-37,16,-46,17,-97,0v-25,-18,-52,-47,-31,-97v3,-30,31,-49,39,-85v-8,-10,-35,-5,-49,-11v-15,-16,-8,-53,20,-51v17,-3,35,-24,33,-44v-5,-46,-34,-115,7,-143v20,-8,75,-22,101,-6v14,17,9,43,-15,43v-28,0,-65,-13,-61,24v6,48,38,105,4,145v6,7,23,19,20,39v5,59,-59,86,-38,137",
            "w": 152
        },
        "|": {
            "d": "28,-328v28,2,37,30,37,56r-6,309v-2,8,-2,20,-6,25v-15,0,-21,4,-31,-6v-1,0,-2,1,-4,3v-17,-112,2,-215,-1,-348v3,-13,3,-31,11,-39",
            "w": 90
        },
        "}": {
            "d": "45,-270v-24,6,-45,-28,-26,-45v46,-41,131,1,124,68v-5,38,-15,70,-27,100r34,26v2,20,-1,35,-19,38v-37,25,12,72,5,121v6,54,-51,76,-91,84v-12,0,-23,-16,-34,-14v-19,-58,84,-29,59,-106v-12,-36,-27,-79,-1,-109v-1,-7,-17,-25,-17,-35v0,-35,29,-78,31,-116v0,-19,-22,-17,-38,-12",
            "w": 157
        },
        "~": {
            "d": "290,-305v-30,36,-98,106,-148,43v-21,-27,-34,-11,-56,-4v-19,12,-30,33,-56,38v-26,-9,-17,-28,0,-43v20,-18,48,-46,83,-44v18,-3,65,29,72,36v23,-6,40,-26,76,-50v13,-3,15,4,26,7v-1,5,5,8,3,17",
            "w": 298
        },
        "\u00c4": {
            "d": "176,-166v16,16,25,106,44,134v0,2,2,7,7,17v-5,2,-1,21,-7,10v1,9,-7,19,-22,16v-12,-11,-15,-32,-25,-45v-3,-27,-38,-39,-62,-49v-6,6,-20,-8,-26,3v-1,-3,-9,-4,-11,-1v2,1,3,2,4,3v-13,2,-14,8,-28,5v-7,12,-10,24,-16,36v-30,5,-29,-35,-14,-46v35,-56,57,-116,88,-183v12,-6,30,5,32,17v6,9,32,51,36,83xm67,-70v-2,2,-3,2,-4,3v0,-1,2,-5,4,-3xm73,-120v35,-4,61,4,83,15v-4,-38,-18,-80,-35,-107v-2,3,-13,13,-9,21v-3,-5,-5,5,-6,-1xm65,-315v20,-7,32,4,42,17v4,22,-39,23,-49,9v-6,-10,2,-11,7,-22v-2,1,-5,-1,-5,-2r6,1xm174,-279v-20,7,-51,-8,-39,-29v25,-15,63,0,40,25v1,-2,4,0,4,1r-6,0"
        },
        "\u00c5": {
            "d": "176,-166v16,16,25,106,44,134v0,2,2,7,7,17v-5,2,-1,21,-7,10v1,9,-7,19,-22,16v-12,-11,-15,-32,-25,-45v-3,-27,-38,-39,-62,-49v-6,6,-20,-8,-26,3v-1,-3,-9,-4,-11,-1v2,1,3,2,4,3v-13,2,-14,8,-28,5v-7,12,-10,24,-16,36v-30,5,-29,-35,-14,-46v35,-56,57,-116,88,-183v12,-6,30,5,32,17v6,9,32,51,36,83xm67,-70v-2,2,-3,2,-4,3v0,-1,2,-5,4,-3xm73,-120v35,-4,61,4,83,15v-4,-38,-18,-80,-35,-107v-2,3,-13,13,-9,21v-3,-5,-5,5,-6,-1xm83,-311v2,-27,51,-21,61,1v11,24,19,28,7,46v-33,19,-80,-1,-78,-37v0,-5,3,-10,10,-10xm107,-292v1,7,23,4,26,-1v1,-10,-12,-6,-22,-7v-3,4,-4,7,-4,8"
        },
        "\u00c7": {
            "d": "244,-262v-70,22,-131,54,-171,114v6,7,-11,10,-8,18v-6,13,-12,41,7,43v34,26,124,12,173,10v13,-5,26,-8,44,-9v0,7,16,-2,15,7v12,2,-10,14,5,12v-1,2,-5,7,1,8v-1,2,-12,4,-12,13v-13,3,-32,14,-46,16v-1,1,8,6,2,5r-19,-2v1,5,-2,5,-5,6v7,0,10,-1,8,3v-20,-1,-36,2,-54,5v0,0,15,5,21,-1r-1,1v7,0,7,2,19,2v-9,3,-19,1,-25,4v3,1,6,2,10,2r-13,1v0,0,0,-1,1,-2r-6,0v2,1,1,4,-2,4v-13,-1,-30,2,-40,-2r1,2v-35,2,-57,-5,-82,-13v2,-3,6,2,10,-2v-10,-5,-30,-1,-31,-12v-26,-10,-39,-41,-39,-78v0,-46,27,-94,81,-143v28,-10,31,-30,65,-37v20,-15,46,-23,80,-24v10,10,2,28,13,37v-4,0,-5,7,-9,10v2,1,2,0,7,2xm223,-24v0,0,6,-4,1,-3v0,1,0,2,-1,3xm178,15v24,19,64,47,46,88v-14,31,-50,35,-76,53v-14,-1,-31,2,-43,-1v-5,-12,-12,-20,-8,-37v6,-27,38,-22,60,-44v-10,-6,-32,-14,-32,-40v0,-14,5,-32,16,-56v22,-10,43,22,37,37xm119,155r0,0r0,0",
            "w": 312
        },
        "\u00c9": {
            "d": "137,-192v0,-1,-1,-1,-1,-1v1,0,1,1,1,1xm214,-256v4,3,16,-6,14,5v5,1,19,0,21,3v-8,6,-10,12,-15,17v2,-1,3,0,3,2v-4,0,-5,0,-10,1v-23,7,-25,14,-46,18v-14,2,-28,10,-42,9v-1,2,-1,4,0,6v1,-3,-2,-2,-4,-2v-10,7,-23,8,-37,16v-1,6,-9,15,-6,25r96,-6v-3,8,15,0,7,9v14,4,-2,8,1,17v-17,13,-49,18,-73,26v-25,1,-57,10,-55,45v59,1,137,-21,171,15v1,15,-5,12,-9,23v-10,4,-23,3,-35,5r2,2v-4,-1,-6,0,-4,-3r-4,0v0,1,1,1,1,2v-38,0,-68,5,-97,9v-10,7,-43,11,-65,10v-10,-15,-23,-20,-19,-45v5,-28,21,-50,17,-83v2,0,6,-18,12,-16v2,-9,9,-17,6,-27v-25,-8,-27,-45,-8,-55v12,3,31,-4,39,-14v31,13,71,-17,103,-10v11,-6,32,-7,41,-6v-2,1,-3,1,-5,2xm179,-328v10,-11,22,6,29,9v-27,30,-78,41,-109,65v-10,7,-26,0,-38,-1v4,-6,-2,-13,7,-17v42,-20,61,-35,111,-56",
            "w": 242
        },
        "\u00d1": {
            "d": "199,-65v16,-30,49,-136,52,-184v9,-9,15,-23,27,-7v3,-5,5,1,9,3v0,11,4,22,0,34v-1,-2,-1,-2,-2,0v0,5,-4,7,-1,12v-4,-2,-3,4,-5,10v7,4,-5,7,0,14v-11,17,-10,46,-19,56v6,3,-6,11,3,12v-7,7,-3,24,-12,34v5,7,-2,8,-3,16v1,0,2,-3,2,-1v-15,23,-5,55,-25,70v-8,-3,-12,4,-20,4v-64,-29,-85,-125,-127,-183v-11,28,-13,58,-31,93v3,18,-10,26,-25,36v-24,-1,-26,-30,-13,-48v25,-33,28,-114,57,-149v7,-1,10,-1,11,-1v66,26,72,129,122,179xm262,-325v10,-8,33,-3,28,14v-18,19,-55,66,-89,49v-9,1,-35,-31,-44,-29v-26,5,-40,31,-66,39v-33,-21,17,-42,27,-56v32,-26,74,1,92,17v17,-6,24,-12,52,-34",
            "w": 293
        },
        "\u00d6": {
            "d": "287,-75r0,0r0,0xm200,-259v13,-5,27,4,39,7v0,1,-1,2,-2,3v12,-2,24,12,35,12v6,6,13,15,18,12v27,35,31,91,8,133v-7,13,-21,19,-27,34v-6,-1,-17,9,-19,18v-15,-3,-24,24,-45,26v-101,54,-240,-14,-189,-139v13,-32,38,-54,70,-66v29,-27,49,-37,101,-42v2,2,3,4,6,2v0,0,-1,0,-1,-2v4,0,5,2,1,3v6,3,11,4,16,2v-4,-1,-4,-1,-11,-3xm62,-146v-27,38,4,102,48,100v66,15,127,-29,155,-69v15,-22,17,-71,-8,-82v-19,-17,-82,-30,-109,-13v-5,-5,-8,8,-18,7v-7,2,-19,16,-26,22v-6,12,-7,29,-16,38v-5,-8,-6,9,-12,-1v-1,2,-1,3,-2,0v1,-9,-12,-11,-13,-4v0,0,1,1,1,2xm123,-314v21,-8,51,11,37,32v-27,13,-61,-5,-37,-28v-2,1,-5,0,-5,-1r6,1xm233,-278v-17,7,-41,0,-43,-22v16,-25,70,-8,43,18v2,-2,5,2,5,2v0,0,-2,-1,-6,-1",
            "w": 319
        },
        "\u00dc": {
            "d": "229,-143v11,-14,38,-47,29,-83v-2,-8,10,-25,23,-29v44,47,-24,149,-46,165v-26,37,-68,56,-104,85v-20,3,-47,15,-71,-2v-37,-26,-58,-67,-55,-128v1,-26,18,-129,57,-100r7,20v-14,30,-32,52,-25,100v8,48,21,66,61,58v42,-8,85,-36,124,-86xm109,-303v22,-9,51,12,37,32v-27,13,-61,-6,-37,-28v-1,1,-5,0,-5,-1r6,1xm218,-266v-18,6,-31,-2,-42,-15v-1,-28,50,-28,51,-4v-2,3,-4,7,-8,14v2,-2,5,2,5,2v0,0,-2,-1,-6,-1r0,4",
            "w": 300
        },
        "\u00e1": {
            "d": "22,-87v26,-24,59,-41,105,-54v27,0,31,7,40,28v24,0,29,26,39,40v9,13,14,26,17,36v-6,5,-8,18,-19,15v-1,8,-8,1,-11,1v-13,-2,-25,-18,-35,-36r-47,35v4,12,-38,18,-52,24v-18,0,-32,-7,-43,-21v-13,-36,-10,-28,6,-68xm136,-90v-28,2,-60,12,-75,35v35,1,54,-19,75,-35xm154,-247v12,-16,20,10,30,9v2,25,-35,36,-53,49v-25,19,-46,40,-78,52v-8,-2,-15,-7,-26,-6v5,-7,-3,-18,8,-25v45,-29,66,-50,119,-79",
            "w": 231
        },
        "\u00e0": {
            "d": "22,-87v26,-24,59,-41,105,-54v27,0,31,7,40,28v24,0,29,26,39,40v9,13,14,26,17,36v-6,5,-8,18,-19,15v-1,8,-8,1,-11,1v-13,-2,-25,-18,-35,-36r-47,35v4,12,-38,18,-52,24v-18,0,-32,-7,-43,-21v-13,-36,-10,-28,6,-68xm136,-90v-28,2,-60,12,-75,35v35,1,54,-19,75,-35xm46,-223v-15,-8,-8,-38,7,-35v45,10,72,54,119,62v9,14,19,20,12,35v-28,20,-76,-27,-112,-43v-7,-4,-16,-10,-26,-19",
            "w": 231
        },
        "\u00e2": {
            "d": "22,-87v26,-24,59,-41,105,-54v27,0,31,7,40,28v24,0,29,26,39,40v9,13,14,26,17,36v-6,5,-8,18,-19,15v-1,8,-8,1,-11,1v-13,-2,-25,-18,-35,-36r-47,35v4,12,-38,18,-52,24v-18,0,-32,-7,-43,-21v-13,-36,-10,-28,6,-68xm136,-90v-28,2,-60,12,-75,35v35,1,54,-19,75,-35xm169,-152v-15,-16,-27,-29,-54,-50v-27,18,-33,39,-54,60v-24,4,-35,-19,-24,-33v28,-15,44,-55,76,-72v29,3,59,54,76,64v2,5,2,5,7,14v-6,12,-13,17,-27,17",
            "w": 231
        },
        "\u00e4": {
            "d": "22,-87v26,-24,59,-41,105,-54v27,0,31,7,40,28v24,0,29,26,39,40v9,13,14,26,17,36v-6,5,-8,18,-19,15v-1,8,-8,1,-11,1v-13,-2,-25,-18,-35,-36r-47,35v4,12,-38,18,-52,24v-18,0,-32,-7,-43,-21v-13,-36,-10,-28,6,-68xm136,-90v-28,2,-60,12,-75,35v35,1,54,-19,75,-35xm55,-195v20,-7,32,4,42,17v4,22,-39,23,-49,9v-5,-9,2,-12,6,-23v-1,3,-4,0,-4,-1r6,1xm164,-159v-18,6,-33,-2,-43,-15v0,-24,39,-26,49,-12v6,8,0,13,-5,23v1,-2,4,0,4,1r-6,0",
            "w": 231
        },
        "\u00e3": {
            "d": "22,-87v26,-24,59,-41,105,-54v27,0,31,7,40,28v24,0,29,26,39,40v9,13,14,26,17,36v-6,5,-8,18,-19,15v-1,8,-8,1,-11,1v-13,-2,-25,-18,-35,-36r-47,35v4,12,-38,18,-52,24v-18,0,-32,-7,-43,-21v-13,-36,-10,-28,6,-68xm136,-90v-29,2,-58,13,-75,35v35,1,54,-19,75,-35xm217,-209v-20,18,-56,65,-90,49v-15,0,-36,-42,-54,-25v-27,7,-29,29,-56,35v-34,-19,17,-44,27,-57v32,-24,74,1,92,18v17,-5,33,-28,65,-40v7,3,18,7,16,20",
            "w": 231
        },
        "\u00e5": {
            "d": "22,-87v26,-24,59,-41,105,-54v27,0,31,7,40,28v24,0,29,26,39,40v9,13,14,26,17,36v-6,5,-8,18,-19,15v-1,8,-8,1,-11,1v-13,-2,-25,-18,-35,-36r-47,35v4,12,-38,18,-52,24v-18,0,-32,-7,-43,-21v-13,-36,-10,-28,6,-68xm136,-90v-28,2,-60,12,-75,35v35,1,54,-19,75,-35xm45,-217v2,-17,32,-38,59,-21v28,17,74,79,22,94v-53,15,-95,-15,-95,-59v0,-7,4,-14,14,-14xm79,-190v1,9,34,5,37,-2v0,-10,-11,-9,-20,-10v-13,-3,-16,10,-17,12",
            "w": 231
        },
        "\u00e7": {
            "d": "130,-156v9,-2,40,-12,55,-10v4,12,14,27,1,35v1,9,-15,7,-50,26v-14,15,-59,17,-62,42v35,22,101,-18,134,7r0,14v-32,34,-94,48,-154,40v-25,-3,-44,-30,-43,-47v7,-67,62,-76,119,-107xm101,66v-32,-9,-24,-46,-8,-79v19,-10,39,18,33,32v20,18,56,42,39,76v-13,27,-42,32,-66,46r-37,0v-2,-11,-9,-17,-7,-33v8,-22,33,-21,53,-38v0,-1,-3,-1,-7,-2r0,-2",
            "w": 217
        },
        "\u00e9": {
            "d": "39,-17v-75,-63,29,-180,119,-140v-3,6,8,3,9,10v8,22,3,50,-10,64r-38,27v17,10,77,-5,86,17v-3,6,-7,9,-16,12v9,4,12,5,1,13v-6,4,-27,3,-29,14v-44,9,-96,4,-122,-17xm84,-98v16,-1,36,-12,36,-23v-18,7,-29,13,-36,23xm143,-269v12,-16,20,10,30,9v2,25,-35,36,-53,49v-25,19,-46,40,-78,52v-8,-2,-15,-7,-26,-6v5,-7,-3,-18,8,-25v45,-29,66,-50,119,-79",
            "w": 211
        },
        "\u00e8": {
            "d": "39,-17v-75,-63,29,-180,119,-140v-3,6,8,3,9,10v8,22,3,50,-10,64r-38,27v17,10,77,-5,86,17v-3,6,-7,9,-16,12v9,4,12,5,1,13v-6,4,-27,3,-29,14v-44,9,-96,4,-122,-17xm84,-98v16,-1,36,-12,36,-23v-18,7,-29,13,-36,23xm40,-245v-15,-8,-8,-38,7,-35v45,10,72,54,119,62v9,14,19,20,12,35v-28,20,-76,-27,-112,-43v-7,-4,-16,-10,-26,-19",
            "w": 211
        },
        "\u00ea": {
            "d": "39,-17v-75,-63,29,-180,119,-140v-3,6,8,3,9,10v8,22,3,50,-10,64r-38,27v17,10,77,-5,86,17v-3,6,-7,9,-16,12v9,4,12,5,1,13v-6,4,-27,3,-29,14v-44,9,-96,4,-122,-17xm84,-98v16,-1,36,-12,36,-23v-18,7,-29,13,-36,23xm167,-176v-15,-16,-27,-29,-54,-50v-27,18,-33,39,-54,60v-24,4,-35,-19,-24,-33v28,-15,44,-55,76,-72v29,3,59,54,76,64v2,5,2,5,7,14v-6,12,-13,17,-27,17",
            "w": 211
        },
        "\u00eb": {
            "d": "39,-17v-75,-63,29,-180,119,-140v-3,6,8,3,9,10v8,22,3,50,-10,64r-38,27v17,10,77,-5,86,17v-3,6,-7,9,-16,12v9,4,12,5,1,13v-6,4,-27,3,-29,14v-44,9,-96,4,-122,-17xm84,-98v16,-1,36,-12,36,-23v-18,7,-29,13,-36,23xm54,-221v20,-7,32,4,42,17v4,22,-39,23,-49,9v-5,-9,2,-12,6,-23v-1,3,-4,0,-4,-1r6,1xm163,-185v-18,6,-33,-2,-43,-15v0,-24,39,-26,49,-12v6,8,0,13,-5,23v1,-2,4,0,4,1r-6,0",
            "w": 211
        },
        "\u00ed": {
            "d": "75,-111v17,-27,40,5,43,27v-2,27,4,62,-7,80v-14,1,-13,3,-29,-3v-13,-18,-16,-74,-7,-104xm136,-221v12,-16,20,10,30,9v2,25,-35,36,-53,49v-25,19,-46,40,-78,52v-8,-2,-15,-7,-26,-6v5,-7,-3,-18,8,-25v45,-29,66,-50,119,-79",
            "w": 179
        },
        "\u00ec": {
            "d": "51,-111v17,-27,40,5,43,27v-2,27,4,62,-7,80v-14,1,-13,3,-29,-3v-13,-18,-16,-74,-7,-104xm13,-195v-15,-8,-8,-38,7,-35v45,10,72,54,119,62v9,14,19,20,12,35v-28,20,-76,-27,-112,-43v-7,-4,-16,-10,-26,-19",
            "w": 162
        },
        "\u00ee": {
            "d": "67,-111v17,-27,40,5,43,27v-2,27,4,62,-7,80v-14,1,-13,3,-29,-3v-13,-18,-16,-74,-7,-104xm144,-113v-15,-16,-27,-29,-54,-50v-27,18,-33,39,-54,60v-24,4,-35,-19,-24,-33v28,-15,44,-55,76,-72v29,3,59,54,76,64v2,5,2,5,7,14v-6,12,-13,17,-27,17",
            "w": 178
        },
        "\u00ef": {
            "d": "47,-109v17,-27,40,5,43,27v-2,27,4,62,-7,80v-14,1,-13,3,-29,-3v-13,-18,-16,-74,-7,-104xm15,-170v20,-7,32,4,42,17v4,22,-39,23,-49,9v-5,-9,2,-12,6,-23v-1,3,-4,0,-4,-1r6,1xm124,-134v-18,6,-33,-2,-43,-15v0,-24,39,-26,49,-12v6,8,0,13,-5,23v1,-2,4,0,4,1r-6,0",
            "w": 141
        },
        "\u00f1": {
            "d": "159,-163v45,15,39,122,22,170v-52,16,-35,-59,-34,-108v-29,-2,-44,29,-63,47v-16,15,-25,31,-33,45v-10,3,-15,1,-26,2v0,-7,-5,-11,-10,-5v-12,-45,3,-85,15,-128v6,-2,9,-6,17,-3v7,14,16,18,17,39v41,-23,47,-51,95,-59xm203,-237v-11,36,-68,74,-101,36v-29,-33,-47,19,-77,24v-29,-18,15,-39,24,-51v29,-21,66,0,82,15v15,-3,31,-23,58,-35v7,3,11,6,14,11",
            "w": 206
        },
        "\u00f3": {
            "d": "193,-149v24,9,46,63,23,94v-6,9,-6,9,-19,23v-54,57,-203,50,-182,-57v-14,-93,110,-114,178,-63r0,3xm56,-73v32,39,121,10,130,-28v-11,-16,-17,-26,-31,-22v-17,-13,-58,-1,-81,3v-3,7,-2,16,-2,23v-7,2,-14,17,-16,24xm148,-296v12,-16,20,10,30,9v2,25,-35,36,-53,49v-25,19,-46,40,-78,52v-8,-2,-15,-7,-26,-6v5,-7,-3,-18,8,-25v45,-29,66,-50,119,-79"
        },
        "\u00f2": {
            "d": "193,-149v24,9,46,63,23,94v-6,9,-6,9,-19,23v-54,57,-203,50,-182,-57v-14,-93,110,-114,178,-63r0,3xm56,-73v32,39,121,10,130,-28v-11,-16,-17,-26,-31,-22v-17,-13,-58,-1,-81,3v-3,7,-2,16,-2,23v-7,2,-14,17,-16,24xm51,-257v-15,-8,-8,-38,7,-35v45,10,72,54,119,62v9,14,19,20,12,35v-28,20,-76,-27,-112,-43v-7,-4,-16,-10,-26,-19"
        },
        "\u00f4": {
            "d": "193,-149v24,9,46,63,23,94v-6,9,-6,9,-19,23v-54,57,-203,50,-182,-57v-14,-93,110,-114,178,-63r0,3xm56,-73v32,39,121,10,130,-28v-11,-16,-17,-26,-31,-22v-17,-13,-58,-1,-81,3v-3,7,-2,16,-2,23v-7,2,-14,17,-16,24xm174,-193v-15,-16,-27,-29,-54,-50v-27,18,-33,39,-54,60v-24,4,-35,-19,-24,-33v28,-15,44,-55,76,-72v29,3,59,54,76,64v2,5,2,5,7,14v-6,12,-13,17,-27,17"
        },
        "\u00f6": {
            "d": "193,-149v24,9,46,63,23,94v-6,9,-6,9,-19,23v-54,57,-203,50,-182,-57v-14,-93,110,-114,178,-63r0,3xm56,-73v32,39,121,10,130,-28v-11,-16,-17,-26,-31,-22v-17,-13,-58,-1,-81,3v-3,7,-2,16,-2,23v-7,2,-14,17,-16,24xm57,-235v20,-7,32,4,42,17v4,22,-39,23,-49,9v-5,-9,2,-12,6,-23v-1,3,-4,0,-4,-1r6,1xm166,-199v-18,6,-33,-2,-43,-15v0,-24,39,-26,49,-12v6,8,0,13,-5,23v1,-2,4,0,4,1r-6,0"
        },
        "\u00f5": {
            "d": "193,-149v23,10,46,62,24,94v-32,49,-137,89,-190,31v-22,-45,-23,-134,35,-145v49,-9,89,-16,131,17r0,3xm56,-73v27,39,100,6,122,-10v20,-15,-8,-47,-23,-40v-17,-13,-58,-1,-81,3v-3,7,-2,16,-2,23v-7,2,-14,17,-16,24xm226,-246v-25,28,-76,81,-115,33v-18,-21,-25,-8,-44,-4v-15,14,-45,45,-57,17v12,-25,43,-53,78,-55v15,-1,49,24,56,29v17,-5,34,-28,66,-40v8,3,19,6,16,20"
        },
        "\u00fa": {
            "d": "163,-156v58,18,10,114,-15,137v-17,16,-35,21,-60,25v-32,5,-85,-51,-70,-109v49,-34,20,73,82,48v46,-19,38,-58,63,-101xm141,-241v12,-16,20,10,30,9v2,25,-35,36,-53,49v-25,19,-46,40,-78,52v-8,-2,-15,-7,-26,-6v5,-7,-3,-18,8,-25v45,-29,66,-50,119,-79",
            "w": 201
        },
        "\u00f9": {
            "d": "163,-156v58,18,10,114,-15,137v-17,16,-35,21,-60,25v-32,5,-85,-51,-70,-109v49,-34,20,73,82,48v46,-19,38,-58,63,-101xm35,-240v-15,-8,-8,-38,7,-35v45,10,72,54,119,62v9,14,19,20,12,35v-28,20,-76,-27,-112,-43v-7,-4,-16,-10,-26,-19",
            "w": 201
        },
        "\u00fb": {
            "d": "163,-156v58,18,10,114,-15,137v-17,16,-35,21,-60,25v-32,5,-85,-51,-70,-109v49,-34,20,73,82,48v46,-19,38,-58,63,-101xm153,-172v-15,-16,-27,-29,-54,-50v-27,18,-33,39,-54,60v-24,4,-35,-19,-24,-33v28,-15,44,-55,76,-72v29,3,59,54,76,64v2,5,2,5,7,14v-6,12,-13,17,-27,17",
            "w": 201
        },
        "\u00fc": {
            "d": "163,-156v58,18,10,114,-15,137v-17,16,-35,21,-60,25v-32,5,-85,-51,-70,-109v49,-34,20,73,82,48v46,-19,38,-58,63,-101xm35,-200v20,-7,32,4,42,17v4,22,-39,23,-49,9v-5,-9,2,-12,6,-23v-1,3,-4,0,-4,-1r6,1xm144,-164v-18,6,-33,-2,-43,-15v0,-24,39,-26,49,-12v6,8,0,13,-5,23v1,-2,4,0,4,1r-6,0",
            "w": 201
        },
        "\u2020": {
            "d": "45,-259v-23,15,-52,-13,-26,-31v14,1,25,-2,37,-3r8,-39v21,-5,18,22,22,38v14,2,35,5,34,20v-10,9,-21,9,-38,14r-4,107v1,9,-11,16,-25,14v-14,-31,10,-87,0,-119v-2,0,-5,-1,-8,-1",
            "w": 130
        },
        "\u00b0": {
            "d": "32,-220v-11,-10,-38,-56,-7,-61v3,-17,35,-41,59,-20v27,9,74,80,22,94v-31,9,-58,0,-74,-13xm59,-254v2,10,39,8,37,-5v-4,-8,-20,-5,-32,-6v1,4,-7,11,-5,11",
            "w": 136
        },
        "\u00a2": {
            "d": "72,-25v-37,-11,-77,-46,-64,-96v9,-32,51,-63,86,-72v37,-24,14,-72,55,-99v36,5,20,53,13,79v11,6,51,4,39,37v-1,9,-9,22,-20,21r12,4v-17,-3,-32,2,-44,2v-12,14,-22,44,-23,71v8,5,41,12,58,12v16,41,-23,42,-59,45v-3,-5,-3,-3,-8,0v1,1,2,1,3,1v-16,9,-16,34,-29,47v-15,-11,-16,-24,-19,-52xm78,-88v2,-11,9,-21,7,-34v-11,6,-22,8,-25,20",
            "w": 210
        },
        "\u00a3": {
            "d": "140,-207v31,4,82,-15,96,17v-3,2,-3,3,-2,8v-1,1,-13,2,-9,7v-14,9,-81,9,-74,18v-2,0,-5,1,-10,2r-3,68v14,8,55,50,84,33v8,2,42,-29,46,-11v14,4,5,13,13,19v0,8,-21,16,-10,21v-13,10,-48,21,-63,20v-35,-4,-40,-13,-78,-36v-8,34,-45,82,-92,57v-13,2,-24,-30,-24,-50v2,-43,29,-78,74,-76v1,-16,6,-33,2,-49r-28,-3r2,-2v-11,-3,-14,-17,-16,-27v-3,-15,34,-10,44,-13v-2,-63,16,-125,80,-120v36,3,93,44,54,79v-8,-3,-16,-10,-17,-22v-13,-21,-63,-20,-65,15v-1,15,-6,28,-4,45xm59,-32v11,6,18,-18,20,-32v-9,-2,-19,14,-16,22v-4,-1,-5,5,-4,10",
            "w": 285
        },
        "\u00a7": {
            "d": "193,-91v0,11,-16,30,-12,37v24,28,12,84,-10,105v-19,19,-17,26,-49,43v-24,13,-11,33,-43,33v0,0,2,1,3,1v-26,12,-31,-16,-41,-33v-1,-29,50,-49,54,-63v30,-31,61,-59,20,-81v-44,-24,-136,-81,-88,-156v-19,-30,-26,-46,-11,-79v25,-24,109,-72,150,-32v13,36,-45,23,-70,39v-21,13,-41,13,-40,38v13,22,35,30,77,42v45,25,57,57,60,106xm70,-169v-5,-2,-6,11,-7,12v0,21,50,49,77,59v31,-43,-54,-64,-70,-71",
            "w": 200
        },
        "\u2022": {
            "d": "53,-165v23,-32,74,3,77,25v31,38,-7,82,-61,78v-25,-1,-70,-34,-50,-74v8,-16,20,-25,34,-29xm70,-115v12,3,31,-8,17,-11v-5,4,-14,4,-17,11",
            "w": 150
        },
        "\u00b6": {
            "d": "100,-97v-50,2,-96,-32,-90,-85v3,-22,6,-38,16,-48v20,-35,52,-62,89,-81v18,-24,55,-14,93,-20v9,-2,13,9,21,13v19,108,-12,223,-8,342v-4,22,-20,16,-32,25v-2,-7,-18,2,-17,-12v-18,-83,14,-190,10,-288v5,-18,-11,-24,-18,-15v-6,41,-13,98,-6,136v-10,47,-10,106,-13,161v-3,10,-13,12,-19,21v-7,-4,-21,-7,-22,5v-6,-10,-13,-14,-13,-27",
            "w": 250
        },
        "\u00df": {
            "d": "266,-256v9,44,-12,59,-26,88v-11,9,-28,25,-32,43v47,34,118,86,80,166v-22,45,-80,72,-103,109v0,-1,0,-2,-1,-3v-7,5,-20,14,-25,24v-8,-4,-10,-5,-15,0v-5,-8,-21,-15,-12,-32v9,-60,65,-77,97,-124v15,-67,-78,-65,-89,-126v7,-45,32,-74,59,-103v13,-14,9,-32,-7,-40v-15,-22,-45,-4,-66,-6v0,0,-9,2,-28,7v-18,10,-36,15,-35,45r7,236v-9,16,15,47,-3,58v-6,4,-1,4,-8,3v-5,11,-9,10,-16,6v0,-10,-1,-7,-7,-16r-15,-143r-9,-178v0,-21,14,-51,29,-58v57,-27,91,-33,162,-28v34,17,59,52,63,72",
            "w": 312
        },
        "\u00ae": {
            "d": "284,-144v-25,68,-96,117,-186,84v-47,-17,-76,-42,-84,-70v-31,-101,16,-152,81,-189v23,-13,57,-18,89,-11v1,2,2,6,5,8v58,21,128,90,95,178xm156,-277v-5,-2,-11,4,-3,3xm197,-259v1,26,11,45,-6,75v16,10,28,24,26,46v28,-34,29,-36,25,-80v-16,-24,-31,-38,-45,-41xm146,-274v-13,0,-22,9,-33,13v13,5,22,-9,33,-13xm199,-126v-24,-4,-52,-17,-63,-32r-6,41v29,5,47,3,69,-9xm83,-137v2,-36,10,-73,9,-108v-29,28,-45,51,-33,89v5,5,13,11,24,19",
            "w": 296
        },
        "\u00a9": {
            "d": "131,-282v8,-16,58,-13,70,-3v2,1,2,0,18,14v43,37,66,108,45,171v-14,16,-10,32,-27,38v-31,41,-117,54,-169,16v-36,-26,-57,-60,-63,-113v9,-66,44,-102,105,-120v1,-6,16,-5,21,-3xm165,-99v-63,6,-104,-26,-91,-88v-14,14,-24,41,-13,60v35,59,163,55,163,-25v0,-44,-21,-89,-74,-72v-31,-8,-45,13,-66,24v28,-4,60,-37,93,-15v4,8,18,33,3,42v-21,4,-51,6,-56,21v29,2,79,29,41,53",
            "w": 279
        },
        "\u2122": {
            "d": "165,-235v-7,19,-10,84,-43,54v-14,-3,-4,-20,-11,-29r9,-57v-13,-3,-28,-1,-24,18v-4,23,-4,49,-17,63r0,5v-36,7,-27,-37,-30,-75v-12,-9,-33,-2,-38,-19v-6,-18,-7,-37,14,-43v44,-11,85,-3,125,-15v35,10,45,58,66,83v20,-20,35,-31,47,-60v40,-19,44,39,42,87v-2,22,-2,51,-27,52v-4,-4,-8,-8,-13,-10v-8,-15,-3,-25,-8,-39r-25,35v-39,20,-46,-30,-67,-50",
            "w": 319
        },
        "\u00b4": {
            "d": "136,-319v12,-16,20,10,30,9v2,25,-35,36,-53,49v-25,19,-46,40,-78,52v-8,-2,-15,-7,-26,-6v5,-7,-3,-18,8,-25v45,-29,66,-50,119,-79",
            "w": 177
        },
        "\u00a8": {
            "d": "20,-295v20,-7,32,4,42,17v4,22,-39,23,-49,9v-5,-9,2,-12,6,-23v-1,3,-4,0,-4,-1r6,1xm129,-259v-18,6,-33,-2,-43,-15v0,-24,39,-26,49,-12v6,8,0,13,-5,23v1,-2,4,0,4,1r-6,0",
            "w": 144
        },
        "\u2260": {
            "d": "5,-152v2,-12,10,-26,28,-26r112,-2v6,-6,12,-12,18,-20v18,-16,34,-31,61,-47v5,5,19,-1,13,11v16,21,-6,25,-27,55r85,0v12,3,6,28,17,36v-4,2,-4,3,-5,7v-25,11,-86,17,-103,11v-15,13,-43,-10,-49,16r105,-2v17,-1,11,26,20,35v-27,19,-106,20,-162,19v-10,9,-33,58,-43,79v-4,-2,-9,4,-13,6r-17,-8v-1,-5,-7,-16,-6,-29v5,-15,17,-32,19,-47v-41,11,-71,-33,-33,-53v21,3,39,2,66,1v2,-2,11,-14,2,-15v-39,-5,-80,14,-88,-27",
            "w": 316
        },
        "\u00c6": {
            "d": "12,-4v-21,-39,14,-69,28,-101v-7,-18,26,-33,31,-52r47,-58v0,-14,22,-22,22,-37v11,-15,30,-51,41,-72v24,-6,58,1,88,-4v27,4,60,-4,90,1v24,4,56,-5,62,17v7,4,12,28,1,33v-6,-4,-9,-1,-14,2v-31,-10,-78,-10,-114,-5v-16,-8,-49,-3,-68,2v4,34,4,72,12,102v51,1,109,-8,152,3v25,0,61,3,63,32v-11,5,-6,16,-20,12v-52,9,-123,-8,-187,3v-4,15,3,48,14,76v29,1,59,1,86,1v52,0,124,-17,123,45v-9,10,-31,9,-50,9r-123,3v-17,-4,-74,-2,-78,-25r-18,-104v-31,3,-62,14,-94,10v-20,23,-37,46,-53,90v-4,10,-11,22,-27,22v0,-5,-11,-3,-14,-5xm187,-234v-11,11,-26,29,-30,44v-7,5,-16,14,-14,24v17,1,37,-3,52,-7",
            "w": 484
        },
        "\u00d8": {
            "d": "392,-312v20,-11,75,-33,74,11v-6,3,-15,6,-8,10v-29,15,-56,32,-83,49v23,29,23,55,29,96v-12,110,-75,135,-157,180v-45,13,-87,11,-126,2v-25,-6,-24,-5,-48,-25r-75,70v-7,-1,-22,1,-13,-5v-3,-4,-11,-3,-17,-2v0,-11,-7,-23,-5,-38r73,-79v-12,-109,20,-203,93,-236v16,-19,20,-17,61,-32r-1,-3v1,0,5,-1,10,-2v-4,6,6,3,6,3v2,-6,5,-3,13,-5r-1,1v19,7,31,-14,58,1v27,4,44,22,68,31v14,-12,33,-18,49,-27xm298,-261v-18,-10,-55,-22,-64,4v-59,2,-129,46,-143,97v1,1,-17,52,-11,73v68,-63,142,-120,218,-174xm311,-203v-62,53,-149,107,-203,172v57,26,134,15,190,-31v55,-24,88,-105,41,-157v-10,5,-17,16,-28,16",
            "w": 432
        },
        "\u221e": {
            "d": "493,-136v-22,65,-109,108,-182,72v-24,3,-43,-20,-72,-19v-2,4,-4,7,-8,8v1,0,1,-3,0,-4v-5,0,-10,9,-14,13v-43,13,-87,45,-136,35v-1,5,-4,2,-9,2v-36,-21,-77,-77,-50,-140v10,-22,49,-41,73,-63v18,-9,27,-4,44,-3v37,21,50,53,104,78v49,-26,101,-72,186,-72v16,0,47,32,54,45xm386,-172v-5,4,-29,5,-12,10v1,-6,6,-7,12,-10xm371,-158r-6,0v1,1,3,2,6,0xm367,-165v-6,0,-16,4,-12,7v4,-3,4,-2,12,-7xm311,-123v44,16,121,19,135,-24v-8,-19,-43,-13,-58,-18v-2,5,-9,-1,-16,5v4,-1,2,-1,5,1v-9,3,-20,12,-29,12v0,-1,8,-3,2,-3v-10,11,-28,18,-39,27xm340,-150v3,0,7,-1,6,-6v-3,1,-2,5,-6,6xm423,-67v-15,4,-36,9,-59,11v21,6,42,-3,59,-11xm216,-72v0,3,-11,3,-2,5v1,-2,2,-3,2,-5xm76,-142v-26,31,3,57,31,46v28,-10,60,-11,81,-30r-63,-59v-9,4,-14,6,-17,13v2,-1,4,-1,5,1v-14,5,-25,15,-37,29xm200,-68v-2,0,-3,1,-5,3v1,-1,3,-1,5,-3",
            "w": 502
        },
        "\u00b1": {
            "d": "105,-188v14,-15,0,-54,25,-57v1,0,8,8,19,22v4,9,-2,30,10,30v25,1,49,-1,57,18v5,11,4,17,9,22v-6,3,-8,5,-14,9v3,-2,8,0,8,3v-18,-6,-26,12,-49,7v-11,1,-18,6,-27,10v-8,7,4,61,-16,52v-4,7,-6,6,-11,-3v-22,1,-22,-20,-21,-43v-11,-5,-32,8,-40,-5r-9,3v3,-9,-25,-16,-12,-30v-9,-21,10,-39,41,-33xm239,-19v-11,1,-11,12,-10,24v-47,13,-100,3,-148,15r4,2v-27,-2,-35,8,-58,0v-2,-8,-19,-14,-10,-28v-10,-71,123,-34,196,-52v2,6,6,4,13,7v4,10,13,18,8,29v1,0,3,1,5,3",
            "w": 246
        },
        "\u2264": {
            "d": "232,-26v13,7,23,15,34,24v-3,13,7,17,-5,22v1,7,-3,7,-9,6v2,3,-2,2,-9,7v2,1,3,3,2,4v-58,7,-130,0,-186,9v-18,-1,-21,-5,-35,-10v-11,-12,-28,-47,1,-53v62,-12,131,1,188,-10v-57,-25,-141,-54,-186,-98v-22,-51,27,-61,46,-85v31,-25,69,-38,94,-70v6,-4,12,-1,22,-3v17,16,32,41,9,58v0,13,-20,23,-29,22v2,7,-7,11,-12,8v-12,8,-13,16,-30,20v-9,11,-22,17,-29,30v41,28,76,38,124,54v6,6,35,19,34,32v10,15,-21,19,-8,29v-2,0,-21,-10,-15,1v-1,2,-1,3,-1,3",
            "w": 277
        },
        "\u2265": {
            "d": "179,-102v-30,19,-61,50,-87,73r171,-1v7,4,14,3,16,8v4,16,23,14,21,39v-5,0,-10,10,-18,10v0,4,1,5,3,8v-7,1,-3,-7,-14,-5v-1,5,4,4,0,9v-68,-10,-157,-5,-220,9v-20,-3,-44,-13,-44,-41v0,-30,26,-23,54,-33v-12,-12,-31,-30,-17,-55v20,-18,49,-41,81,-59v9,-5,15,-10,17,-15v-46,-35,-59,-45,-106,-89v-10,-20,-4,-66,26,-49v36,20,63,60,119,92v16,25,60,21,54,58v7,10,-13,13,-5,24v-4,1,-10,7,-8,-2v-11,4,-21,13,-32,13v-1,3,-3,9,-11,6",
            "w": 307
        },
        "\u00a5": {
            "d": "254,-291v18,-11,38,-1,35,21v5,4,9,7,3,14v-29,36,-66,68,-87,111v-11,8,-18,31,-30,48v9,9,119,4,97,36v-7,32,-78,6,-114,19v-5,32,-15,69,-29,109v-17,17,-50,3,-47,-20v4,-31,17,-63,19,-92v-29,-2,-65,8,-65,-25v0,-30,42,-23,66,-30v2,2,11,4,10,-2v-38,-52,-56,-108,-95,-167v-3,-19,1,-39,26,-39v14,9,17,8,27,27v13,25,47,90,72,128r4,2",
            "w": 299
        },
        "\u00b5": {
            "d": "297,-259v18,-45,100,-76,141,-28v14,16,31,64,13,93v-12,65,-68,74,-107,106v-6,1,-14,4,-25,9v36,14,108,-16,127,23v-4,4,-5,7,-5,14v-6,3,-10,7,-14,13v-24,7,-61,10,-101,14v-9,12,2,36,-18,42v0,3,-1,4,-4,4v-3,-5,-6,-4,-7,0v-19,-7,-22,-23,-31,-41v-33,5,-81,3,-59,-41v-15,-3,-42,-1,-59,7v1,23,22,52,-2,62v-6,6,-8,9,-20,5v-16,-16,-26,-44,-40,-66v-27,-2,-70,11,-78,-13v-5,-3,-8,-8,-7,-17v8,-40,37,-22,73,-29v-5,-99,0,-174,61,-221v69,-26,133,10,162,64xm316,-118v11,7,19,-9,28,-5v-3,0,-2,-1,-2,-2v54,-6,125,-58,87,-115v-9,2,-13,-16,-25,-9v-82,-25,-82,62,-98,129v0,4,8,6,10,2xm170,-277v-61,12,-51,111,-44,175v29,1,65,-6,90,-1v12,-5,26,-3,39,-7v6,-51,15,-91,27,-119v-5,-14,-15,-19,-23,-29v-29,-8,-52,-23,-90,-21v0,1,0,1,1,2",
            "w": 465
        },
        "\u2202": {
            "d": "65,-48v28,25,112,6,148,2v22,-8,56,-16,83,-28v-31,-94,106,-158,145,-66v7,16,-2,29,-6,42v-16,7,-18,27,-34,34v11,8,30,4,47,4v26,0,61,0,57,-37v-8,-74,37,-103,92,-120v23,-7,59,1,74,7v0,0,-2,1,-3,2v14,3,12,13,25,16v5,14,-15,8,-8,20v-29,8,-74,0,-102,23v-40,18,-31,64,-35,113v-10,21,-72,35,-97,29v-50,8,-84,-8,-121,-21v-34,13,-75,24,-113,33v-17,-1,-46,9,-61,6v-74,7,-150,-7,-145,-76v5,-66,83,-81,131,-102v23,-5,48,-8,77,-7r5,-94v5,-23,2,-83,34,-54v31,15,12,62,12,98v0,30,5,65,0,92v-12,9,-26,-2,-42,6v-58,-24,-153,38,-163,69r0,9xm344,-93v13,-6,49,-22,57,-45v-32,-12,-65,19,-57,45",
            "w": 687
        },
        "\u2211": {
            "d": "341,-181v-2,10,1,14,8,18v-8,4,-10,6,-14,14v-28,6,-53,9,-73,20v-2,22,15,49,-1,70v-32,42,-121,64,-191,55v-24,-9,-62,-36,-59,-75v4,-65,72,-101,124,-111v12,0,18,6,28,9v12,13,27,36,15,54v-13,38,-64,59,-106,50v-3,-3,-20,-21,-18,-1v2,29,61,36,94,28v22,-6,54,-15,76,-31v5,-27,-19,-57,0,-76v10,-31,83,-42,117,-24xm81,-120v27,3,50,-12,64,-25v-20,-23,-49,13,-64,25",
            "w": 358
        },
        "\u220f": {
            "d": "348,-242v-12,-23,17,-52,40,-24v3,14,3,18,-1,34v-5,0,-11,9,-21,8v-4,-12,-9,-11,-19,-14v0,-1,0,-2,1,-4xm148,-172v74,8,217,-29,176,75v-4,12,-8,69,-33,81v-17,-5,-36,-14,-31,-42r12,-64v-2,-2,-3,-4,-3,-4v-45,4,-94,-3,-132,9v-24,39,-5,102,-41,132v-5,-3,-12,-11,-17,-4v-35,-18,-5,-86,-5,-122v-16,2,-32,8,-48,7v2,-2,4,-9,-4,-7v-13,3,-18,-14,-15,-31v21,-20,39,-16,81,-21v17,-59,14,-63,38,-131v6,-19,16,-28,27,-28v15,0,22,12,24,29",
            "w": 354
        },
        "\u03c0": {
            "d": "245,-269v4,-2,5,-2,2,3v-1,-1,-2,-3,-2,-3xm76,-238v-25,17,-72,37,-92,15v-7,-3,-2,-2,-1,-9v-5,-3,-6,-16,-4,-23v87,-43,208,-63,321,-77v15,4,24,12,28,31v-11,4,-6,20,-17,16v-4,11,-14,-4,-19,3v-5,4,-23,10,-30,3v0,12,-16,2,-21,11v-12,-4,-20,0,-22,10v-2,-9,-15,0,-20,1v1,0,2,3,2,1v-20,4,-41,12,-56,25v-5,23,-16,40,-17,67v55,-15,127,-30,171,13v43,43,10,95,1,149v-7,12,-8,26,-18,39v0,-1,0,-3,-1,-5v-5,10,-26,15,-31,-3v-13,-40,16,-87,21,-128v-10,-37,-81,-31,-115,-19v0,11,-11,-6,-11,5v-44,7,-43,84,-53,134v-8,-5,-14,0,-17,9v-11,-7,-17,-5,-14,-16v-11,-3,-10,-17,-8,-30r23,-133v5,-30,20,-63,19,-92v-8,-1,-12,9,-19,3xm250,-277v0,1,9,4,5,1v-1,0,-3,-1,-5,-1xm76,26v0,-1,-6,-8,-4,0r4,0",
            "w": 336
        },
        "\u222b": {
            "d": "100,-309v21,-39,101,-29,110,15v4,2,5,15,-2,15v-18,-1,-29,-13,-45,-11r1,-2v-50,0,-37,68,-46,125r18,211r3,0r4,64v-2,57,-51,82,-106,58v-10,-8,-26,-42,-10,-62v23,-3,28,11,48,13v17,-129,-38,-312,25,-426",
            "w": 229
        },
        "\u00aa": {
            "d": "135,-292v-12,37,53,71,28,104v-25,0,-34,-18,-47,-30v-16,18,-56,26,-79,7v-37,-46,2,-104,56,-99v15,1,31,0,42,18xm68,-240v12,-2,28,-17,20,-29v-8,2,-27,19,-20,29",
            "w": 180
        },
        "\u00ba": {
            "d": "74,-321v45,1,64,31,69,70v-2,7,-8,23,-17,35v-39,20,-110,10,-110,-37v0,-15,5,-27,15,-36v5,-21,19,-32,43,-32xm102,-262v0,-13,-25,-7,-33,-9v-2,5,-13,13,-5,18v13,-6,23,3,38,-9",
            "w": 159
        },
        "\u2126": {
            "d": "306,-130v54,-32,162,-38,184,32v18,57,-46,91,-100,87v-12,4,-24,-1,-33,-2v1,0,2,1,4,2v-42,2,-70,-43,-56,-91v-9,-4,-24,-2,-34,-1v1,1,5,4,0,3v-6,0,-15,-9,-21,-2v-1,9,-17,-1,-22,3v1,-1,1,-2,-1,-2v-5,5,-15,1,-28,4r0,3v-13,5,-32,3,-39,14v-10,-3,-15,12,-16,24v9,27,22,53,24,81v-5,1,-9,-5,-14,0v2,4,9,6,1,9v-2,-1,-4,-3,-7,-5v0,9,-11,16,-17,8v-22,-28,-31,-69,-48,-102r-36,13v1,0,2,1,2,1v-7,4,-34,11,-38,0v9,-4,-9,-17,0,-26v-2,-28,43,-19,67,-37v-13,-100,6,-211,111,-209v44,2,88,21,92,71v-14,6,-33,20,-40,0v-9,-2,-6,-12,-19,-14v1,2,-2,1,-2,1v-13,-17,-47,-14,-60,1v-31,11,-37,83,-32,135v37,9,70,-13,99,-4v8,-12,27,2,40,-4v-1,4,2,5,2,1v15,-2,21,6,34,1v1,0,1,2,3,5xm345,-74v24,26,72,19,97,-2v-2,-33,-52,-36,-79,-27v-6,10,-15,16,-18,29xm445,-23v3,1,7,-3,2,-2xm436,-21r-4,1v2,0,3,0,4,-1xm350,-15r-4,-1v2,0,3,1,4,1",
            "w": 534
        },
        "\u00e6": {
            "d": "130,-182v30,-54,163,-31,156,36v-3,2,-10,4,-5,7v-5,28,-42,40,-82,52v28,25,82,16,111,34v4,10,15,18,9,31v-38,27,-111,6,-141,-15v-4,0,-9,-1,-17,-3v-15,12,-26,28,-43,38v2,1,2,2,2,2v-20,2,-44,18,-62,0v-30,-6,-55,-43,-40,-77v16,-37,59,-40,98,-53v-15,-25,-58,-22,-86,-8v-26,-2,-33,-23,-24,-42v28,-25,91,-31,124,-2xm232,-156v-17,-10,-60,-6,-55,14v10,5,43,-3,55,-14xm103,-62v3,-5,12,-8,10,-14v-16,4,-27,13,-42,18v-1,2,-8,10,1,8v1,0,12,-5,31,-12",
            "w": 317
        },
        "\u00f8": {
            "d": "315,-301v8,10,19,17,23,31v-11,25,-36,25,-56,47v6,12,14,20,23,24v33,112,-44,173,-122,205v-2,-4,-18,0,-12,2v-1,0,-1,0,-2,1v2,0,5,1,8,2v-11,-1,-19,1,-27,3r-58,-20v-20,19,-32,61,-48,87v-4,-6,-6,0,-10,5v-2,-8,-9,-9,-15,-3v-9,-4,-14,-15,-17,-25v-1,3,-3,4,-4,1v1,-42,24,-72,40,-106v-21,-32,-45,-55,-21,-103v28,-58,38,-65,98,-97v29,-16,67,-24,113,-4v26,-15,43,-53,87,-50xm161,-99v-16,11,-22,26,-35,43v40,9,36,-4,83,-25v21,-20,47,-40,46,-83v0,-11,-17,-23,-25,-10v-9,15,-37,31,-48,49v-6,9,-18,13,-21,26xm166,-199v-20,2,-42,10,-50,26v-17,13,-33,43,-36,68",
            "w": 328
        },
        "\u00bf": {
            "d": "186,-273v-22,-7,-12,-49,8,-49v29,0,41,56,9,56v-10,0,-9,1,-17,-7xm88,30v49,4,84,-11,122,-14v2,-7,14,0,23,-4v-2,11,9,21,-6,28v0,22,-25,24,-35,28v-5,5,-15,7,-29,10v-21,5,-48,13,-71,4v-4,4,-18,3,-17,4v2,0,2,-1,2,-3v-60,-15,-85,-77,-28,-118v25,-18,84,-45,114,-52v8,-44,1,-103,15,-141v4,-8,14,-11,23,-7v30,41,7,134,5,197v-59,3,-99,28,-133,56v-4,9,3,12,15,12",
            "w": 259
        },
        "\u00a1": {
            "d": "45,-301v5,-27,40,-21,46,7v6,29,-31,38,-42,14v-8,-6,-2,-11,-4,-21xm68,67v-10,29,-52,20,-53,-9v-4,-82,12,-130,17,-224v0,-2,2,-9,5,-20v5,-4,7,-5,7,-9v25,-12,45,11,41,38v-9,59,-17,133,-17,224",
            "w": 111
        },
        "\u00ac": {
            "d": "315,-176v26,-12,45,4,60,20v4,38,-2,87,0,131v-7,-14,-12,10,-22,8v2,11,-4,1,-11,6v-11,-5,-26,1,-27,-14v-21,-12,0,-71,-8,-95v-32,-1,-69,-1,-97,-2r-151,-6v-35,-1,-51,-54,-11,-60v82,10,176,10,267,12",
            "w": 394
        },
        "\u221a": {
            "w": 379
        },
        "\u0192": {
            "d": "20,-71v-7,-15,-10,-46,11,-46r6,-6v-8,-89,-27,-218,85,-202v16,3,23,16,34,20r6,21v-11,18,-37,8,-55,2v-62,9,-26,107,-24,161v17,1,41,-6,43,13v20,26,-26,26,-37,36r3,155v1,10,-17,54,-15,67v-21,6,-52,19,-73,7v-10,-12,-37,-50,-17,-72v21,1,42,44,55,14v3,-47,1,-117,-1,-166v-5,-4,-14,-3,-21,-4",
            "w": 147
        },
        "\u2248": {
            "d": "336,-194v32,9,68,-31,108,-38v12,12,22,44,3,57v-31,20,-67,49,-102,50v-68,3,-88,-74,-163,-65v-57,7,-82,26,-132,59v-29,0,-39,-24,-27,-52v40,-29,61,-50,102,-59v37,-8,61,-11,73,-11v50,0,100,49,138,59xm55,-27v-26,10,-41,-10,-37,-41v11,-31,39,-32,79,-61v43,-31,130,-27,172,15v22,22,90,37,118,3v1,0,20,-18,36,-15v-1,5,2,9,6,10v5,14,6,28,3,40v-64,81,-127,67,-213,0v-19,-15,-85,-11,-100,6",
            "w": 466
        },
        "\u2206": {
            "d": "265,-101v0,20,22,38,25,62v14,10,16,50,-14,44r-172,36v-30,5,-52,12,-79,7v-11,-14,-25,-47,2,-56v37,-80,97,-133,127,-224v-1,-17,29,-29,41,-7v34,37,46,90,70,138xm229,-53r-48,-114v-32,40,-59,100,-84,149",
            "w": 314
        },
        "\u00ab": {
            "d": "202,-99v24,25,51,41,66,76v-1,9,-4,20,-13,23v-9,-2,-16,-2,-25,-2v-30,-17,-108,-68,-99,-129r-48,39r0,3r83,63v8,14,20,35,2,47v-8,-4,-21,-1,-32,-2v-38,-28,-99,-65,-124,-98v-8,-21,-3,-42,13,-47v37,-23,63,-59,106,-83v5,3,13,10,21,18v17,28,11,32,-4,45r1,3r84,-57v19,5,34,25,35,47v-7,20,-46,32,-66,54",
            "w": 279
        },
        "\u00bb": {
            "d": "165,-93v1,-4,19,-15,18,-22v-22,-14,-117,-60,-61,-105v54,17,61,40,115,66v13,14,25,23,25,52v-26,37,-76,83,-104,141v-10,11,-24,5,-41,3v-5,-12,-15,-33,-8,-50v8,-19,24,-33,31,-54v-24,16,-42,37,-57,62v-6,10,-36,12,-45,0v-17,-43,-8,-46,35,-99r-51,-33v-28,-32,0,-78,34,-48v20,18,59,32,86,42v10,13,19,27,23,45",
            "w": 276
        },
        "\u2026": {
            "d": "36,2v-18,-5,-33,-43,-7,-48v22,4,47,41,10,46v4,-1,3,4,2,4v0,-2,-4,-7,-5,-2xm146,2v-15,-6,-23,-22,-20,-40v13,-17,45,3,43,26v-1,8,-9,9,-20,12v3,-1,3,1,3,4v-1,-2,-4,-7,-6,-2xm261,1v-14,5,-34,-30,-17,-43v19,-4,35,11,38,30v-3,11,-6,7,-20,13v2,1,4,3,2,4v-1,-1,-1,-2,-3,-4",
            "w": 291
        },
        "\u00a0": {
            "w": 189
        },
        "\u00c0": {
            "d": "176,-166v16,16,25,106,44,134v0,2,2,7,7,17v-5,2,-1,21,-7,10v1,9,-7,19,-22,16v-12,-11,-15,-32,-25,-45v-3,-27,-38,-39,-62,-49v-6,6,-20,-8,-26,3v-1,-3,-9,-4,-11,-1v2,1,3,2,4,3v-13,2,-14,8,-28,5v-7,12,-10,24,-16,36v-30,5,-29,-35,-14,-46v35,-56,57,-116,88,-183v12,-6,30,5,32,17v6,9,32,51,36,83xm67,-70v-2,2,-3,2,-4,3v0,-1,2,-5,4,-3xm73,-120v35,-4,61,4,83,15v-4,-38,-18,-80,-35,-107v-2,3,-13,13,-9,21v-3,-5,-5,5,-6,-1xm62,-308v-12,-5,-8,-26,6,-23v38,7,64,35,103,41v8,9,16,13,11,24v-35,12,-85,-26,-120,-42"
        },
        "\u00c3": {
            "d": "176,-166v16,16,25,106,44,134v0,2,2,7,7,17v-5,2,-1,21,-7,10v1,9,-7,19,-22,16v-12,-11,-15,-32,-25,-45v-3,-27,-38,-39,-62,-49v-6,6,-20,-8,-26,3v-1,-3,-9,-4,-11,-1v2,1,3,2,4,3v-13,2,-14,8,-28,5v-7,12,-10,24,-16,36v-30,5,-29,-35,-14,-46v35,-56,57,-116,88,-183v12,-6,30,5,32,17v6,9,32,51,36,83xm67,-70v-2,2,-3,2,-4,3v0,-1,2,-5,4,-3xm73,-120v35,-4,61,4,83,15v-4,-38,-18,-80,-35,-107v-2,3,-13,13,-9,21v-3,-5,-5,5,-6,-1xm193,-329v11,29,-49,66,-76,35v-25,-29,-38,20,-66,17v-14,-16,16,-29,24,-39v23,-17,52,1,65,12v12,-3,25,-19,46,-28v2,1,3,1,7,3"
        },
        "\u00d5": {
            "d": "287,-75r0,0r0,0xm200,-259v13,-5,27,4,39,7v0,1,-1,2,-2,3v12,-2,24,12,35,12v6,6,13,15,18,12v27,35,31,91,8,133v-7,13,-21,19,-27,34v-6,-1,-17,9,-19,18v-15,-3,-24,24,-45,26v-101,54,-240,-14,-189,-139v13,-32,38,-54,70,-66v29,-27,49,-37,101,-42v2,2,3,4,6,2v0,0,-1,0,-1,-2v4,0,5,2,1,3v6,3,11,4,16,2v-4,-1,-4,-1,-11,-3xm62,-146v-27,38,4,102,48,100v66,15,127,-29,155,-69v15,-22,17,-71,-8,-82v-19,-17,-82,-30,-109,-13v-5,-5,-8,8,-18,7v-7,2,-19,16,-26,22v-6,12,-7,29,-16,38v-5,-8,-6,9,-12,-1v-1,2,-1,3,-2,0v1,-9,-12,-11,-13,-4v0,0,1,1,1,2xm248,-329v11,-2,21,5,18,16v-12,14,-41,43,-63,45v-20,1,-35,-24,-51,-28v-19,6,-35,20,-49,32v-19,3,-24,-18,-8,-27v13,-12,32,-30,55,-29v13,-2,42,19,47,24v15,-5,26,-18,51,-33",
            "w": 319
        },
        "\u0152": {
            "d": "496,-172v42,-3,98,-11,107,31v-4,28,-46,15,-76,20v-33,6,-72,16,-102,14v-23,5,-51,-5,-55,20v-4,-3,-1,2,-3,4r-22,27v17,3,39,-8,54,-3v70,-5,140,-21,211,-10v3,2,7,5,13,8v14,17,10,45,-17,46r-65,4v1,-5,2,-4,-4,-4v-1,1,-1,2,0,3v-39,-4,-77,13,-111,8v-19,5,-36,12,-61,11v-7,8,-28,2,-41,4v1,-1,2,-2,0,-3v-17,0,-20,-17,-27,-29v-20,12,-42,23,-71,30v1,1,2,0,4,0v-30,4,-62,3,-94,1v-6,-11,-26,-13,-40,-17v-54,-30,-80,-60,-92,-120v2,-113,92,-156,175,-203v90,6,194,-5,290,3r86,0v8,2,47,5,46,26v10,2,0,13,4,19v-33,31,-92,-6,-138,8v-33,-7,-75,-7,-114,-7v-7,0,-10,4,-14,8v18,18,59,47,61,71v1,13,-2,29,1,40",
            "w": 618
        },
        "\u0153": {
            "d": "8,-68v-10,-95,116,-147,194,-103r14,14v11,-15,49,-38,75,-36v47,4,97,31,87,93v-26,15,-91,21,-124,26v11,27,77,18,114,22v3,6,7,11,10,14v1,3,-11,18,-9,25v-44,32,-133,7,-165,-24v-21,14,-63,44,-106,37v-44,-7,-72,-25,-90,-68xm326,-133v-1,-2,-5,-4,-12,-9v-27,-4,-34,0,-51,15v17,6,42,-4,63,-6xm114,-47v42,-2,110,-66,53,-96v-48,-12,-98,22,-106,58v-4,19,34,38,53,38",
            "w": 388
        },
        "\u2013": {
            "d": "234,-108v20,8,30,17,37,42v-34,32,-136,10,-197,24v-2,0,-6,-3,-7,-1v1,3,0,3,-4,3v-2,-5,-14,-4,-22,-4v-16,-7,-35,-45,-10,-58r96,3xm88,-43v0,1,-1,2,-2,2v1,0,1,-1,2,-2",
            "w": 294
        },
        "\u2014": {
            "d": "59,-44v-36,8,-55,-41,-28,-58v33,-2,64,4,95,3r218,-10v10,4,27,-3,40,-3v20,7,31,20,38,42v-11,20,-59,17,-89,18r-222,6v-27,0,-34,4,-45,3v0,0,0,1,1,2v-3,2,-7,1,-8,-3xm87,-43v0,1,-1,1,-1,1",
            "w": 439
        },
        "\u201c": {
            "d": "68,-321v33,-9,41,42,47,71v-2,9,-11,23,-26,16v-17,-2,-32,-57,-32,-65v0,-2,4,-10,11,-22xm14,-323v52,-1,28,59,54,88v1,20,-27,25,-41,12v-19,-18,-19,-52,-25,-82v3,-4,8,-15,12,-18",
            "w": 122
        },
        "\u201d": {
            "d": "116,-319v19,-6,26,19,33,26v-1,34,-26,40,-34,72v-4,-2,-7,11,-16,13v-24,-1,-27,-33,-20,-56r-39,62v-11,5,-19,2,-27,-5v-19,-43,15,-68,28,-96v18,-38,40,-30,50,0v0,5,-2,12,0,15",
            "w": 154
        },
        "\u2018": {
            "d": "71,-196v-32,-19,-68,-66,-58,-111v23,-20,42,5,51,26v6,15,15,39,22,73v-1,5,-13,9,-15,12",
            "w": 91
        },
        "\u2019": {
            "d": "39,-319v21,-33,54,-5,54,28v-13,34,-14,28,-44,69v-4,2,-8,4,-15,7r-16,-11v-7,-14,-10,-24,-10,-29v-5,-8,31,-60,31,-64",
            "w": 98
        },
        "\u00f7": {
            "d": "195,-219v29,-2,36,51,9,61v-9,8,-22,9,-26,-6v-8,3,-8,-9,-9,-18v5,-4,9,-27,26,-37xm12,-96v-10,-23,19,-33,48,-27r141,-12v50,-1,97,-5,139,-14v13,3,24,19,20,41v-1,2,-9,3,-8,9v-12,0,-23,6,-29,9v-86,-1,-159,15,-240,15v-12,5,-15,-1,-29,6v0,1,1,4,-1,4v-9,-3,-24,1,-35,1v2,2,3,4,7,3v-3,2,-6,2,-10,1v6,-9,0,-6,2,-17v-5,-3,-20,-10,-5,-19xm164,-1v-25,-28,27,-90,48,-45v14,28,-9,51,-41,52v-2,-1,-3,-10,-7,-7xm9,-67v1,1,2,2,2,3v0,0,-1,-2,-2,-3",
            "w": 371
        },
        "\u25ca": {
            "d": "145,69v-34,-17,-40,-41,-73,-62v-17,-31,-80,-52,-53,-100v19,-15,93,-86,110,-121v15,0,29,2,34,12v12,-2,10,10,23,8v23,23,49,79,86,92v7,15,-2,27,-6,41v-21,15,-33,42,-49,65v1,1,4,4,-1,3v-12,7,-13,24,-27,31v-1,9,-7,9,-10,22v-9,0,-19,8,-34,9xm83,-77r65,64r54,-69v-14,-20,-38,-51,-56,-67v-21,23,-45,44,-63,72",
            "w": 287
        },
        "\u00ff": {
            "d": "68,-64v22,-1,62,-38,74,-56v10,-3,19,-4,25,9v10,2,11,15,12,24v-7,49,-22,94,-50,170v0,1,2,1,3,1r-3,0v-13,31,-24,64,-35,97v-14,16,-27,14,-41,-7v-13,-40,8,-72,17,-102v9,-28,27,-54,32,-83v-59,29,-86,-42,-88,-94v1,-12,3,-26,16,-29v23,-6,29,73,38,70xm47,-201v20,-7,32,4,42,17v4,22,-39,23,-49,9v-5,-9,2,-12,6,-23v-1,3,-4,0,-4,-1r6,1xm156,-165v-18,6,-33,-2,-43,-15v0,-24,39,-26,49,-12v6,8,0,13,-5,23v1,-2,4,0,4,1r-6,0",
            "w": 186
        },
        "\u0178": {
            "d": "96,30v-53,4,-24,-82,-11,-110v-9,-6,-13,-3,-22,-9v-24,-42,-58,-94,-57,-159v44,-18,41,83,74,110v5,-6,12,-13,22,-21v20,-25,37,-52,60,-73v6,-12,17,-29,39,-37v7,13,21,23,12,41r-39,68v-16,45,-73,106,-68,174v-3,5,-5,12,-10,16xm58,-312v20,-6,32,4,42,17v0,24,-39,22,-49,9v-5,-9,2,-12,6,-23v-1,3,-5,0,-4,-1r6,1xm167,-277v-13,5,-30,5,-37,-10v-8,-3,-6,-11,-2,-18v25,-14,62,-2,40,25v1,-2,4,0,4,1r-6,0",
            "w": 215
        },
        "\u2044": {
            "d": "-58,103v19,-77,68,-139,103,-205v2,-8,88,-140,105,-201v3,-5,10,-15,21,-28v28,1,38,35,25,52v6,10,-9,18,-7,25v0,0,0,-1,-1,-2r-8,14v1,0,2,-1,2,-1v0,6,-14,11,-10,20v-3,2,-4,3,-2,6v-5,2,-15,11,-13,18v-20,23,-26,54,-44,74v3,19,-25,38,-26,59v-9,16,-14,15,-17,29v-15,9,-11,33,-26,42v-9,28,-27,46,-36,73v1,17,-2,30,-21,42v0,0,2,0,6,2v-2,-2,-14,18,-24,10v-2,6,-14,10,-12,-3v-18,-3,-3,-15,-15,-26",
            "w": 139
        },
        "\u00a4": {
            "d": "202,-5v-61,2,-127,-46,-116,-118v-42,2,-89,-5,-75,-54v21,-13,20,-15,40,-10v28,-3,67,8,76,-15v25,-32,84,-80,130,-83v24,-15,112,-14,94,32v5,7,-1,9,-11,9v-34,-3,-60,3,-91,15r-45,34v49,6,113,-2,160,15v1,1,5,5,13,12v-3,2,-1,6,2,7v-2,3,-13,6,-12,14v5,3,10,4,13,5v-31,-8,-59,6,-87,-3v-27,6,-64,-1,-90,7v2,3,5,0,9,2v-23,9,-36,-1,-57,10v-31,78,88,77,172,72v28,-2,87,-10,80,26v4,7,-6,4,-3,13v-8,4,-13,6,-22,6r0,3v-52,1,-106,4,-157,4v-9,0,-23,4,-23,-3xm203,-138v-1,0,-6,-1,-14,-1v0,5,1,4,2,1r12,0",
            "w": 422
        },
        "\u20ac": {
            "d": "202,-5v-61,2,-127,-46,-116,-118v-42,2,-89,-5,-75,-54v21,-13,20,-15,40,-10v28,-3,67,8,76,-15v25,-32,84,-80,130,-83v24,-15,112,-14,94,32v5,7,-1,9,-11,9v-34,-3,-60,3,-91,15r-45,34v49,6,113,-2,160,15v1,1,5,5,13,12v-3,2,-1,6,2,7v-2,3,-13,6,-12,14v5,3,10,4,13,5v-31,-8,-59,6,-87,-3v-27,6,-64,-1,-90,7v2,3,5,0,9,2v-23,9,-36,-1,-57,10v-31,78,88,77,172,72v28,-2,87,-10,80,26v4,7,-6,4,-3,13v-8,4,-13,6,-22,6r0,3v-52,1,-106,4,-157,4v-9,0,-23,4,-23,-3xm203,-138v-1,0,-6,-1,-14,-1v0,5,1,4,2,1r12,0",
            "w": 422
        },
        "\u2039": {
            "d": "154,-44v5,8,6,19,7,32v-9,13,-29,30,-47,16v-9,4,-24,-9,-70,-33v-40,-20,-42,-44,-12,-82r69,-87v10,-5,18,-1,26,4r8,30v-8,25,-40,51,-52,78v19,20,43,22,71,42",
            "w": 173
        },
        "\u203a": {
            "d": "12,-155v-14,-24,12,-53,38,-45v31,24,49,46,83,72v28,42,-27,80,-36,120v-3,2,-19,9,-25,17v-17,-2,-24,-12,-35,-20v-5,-44,24,-54,32,-85v-16,-16,-48,-42,-57,-59",
            "w": 154
        },
        "\uf001": {
            "d": "265,-189v-37,1,-19,-43,-2,-56v28,-8,42,43,21,49v-5,11,-10,2,-17,12v-2,0,-4,-4,-2,-5xm86,-163v2,6,-3,19,9,18v60,-4,119,-11,180,-6v27,20,26,152,-11,143v-4,4,-12,11,-21,8v-14,-23,-1,-65,-6,-100v-27,-9,-66,-2,-90,5v-14,-5,-46,-5,-47,16v7,22,22,45,17,71v-2,0,-15,8,-6,12v-1,4,-13,10,-14,1v-1,1,-2,2,-2,4v-23,-24,-35,-41,-48,-91v-6,-12,-20,9,-30,-4v-26,-3,-16,-41,-3,-49v8,1,22,-2,28,-5v-1,-55,4,-111,36,-151v29,-36,113,-51,150,-8v5,15,7,33,1,43v-11,-1,-14,4,-19,-10v-20,-24,-75,-17,-95,6v2,4,10,-9,9,1v-26,12,-37,58,-38,96",
            "w": 304
        },
        "\uf002": {
            "d": "61,-107v-43,14,-82,-26,-52,-60v14,-10,40,5,51,-5v3,-59,6,-92,38,-130v19,-13,92,-45,123,-12v35,-18,47,30,49,61r8,123v-2,43,4,94,-3,132v-7,3,-18,15,-30,3v-5,4,-16,-5,-12,-12v-22,-36,8,-95,-5,-147v0,-38,-5,-71,-7,-107v1,-4,-10,-21,-22,-18v-64,-1,-83,47,-85,107v27,8,81,-9,87,25v8,4,5,11,0,22v-29,18,-44,6,-80,14v-11,13,5,60,12,76v1,0,1,-1,1,-2v5,22,-11,41,-32,33v-11,9,-19,-9,-24,-19v-6,-27,-8,-59,-17,-84",
            "w": 288
        },
        "\u2021": {
            "d": "160,-250v0,20,-37,21,-60,25r0,40v23,2,69,-9,64,17v7,28,-39,23,-62,31v0,20,9,43,-11,49v0,0,0,2,-1,3v-14,0,-21,-22,-21,-45v0,-21,-58,11,-54,-29v-1,-6,2,-26,16,-22v12,-2,29,1,38,-4r0,-39v-29,2,-59,-4,-48,-33v1,-20,34,-3,49,-11v3,-21,-8,-56,10,-63v19,3,26,35,22,64v25,-1,58,-8,58,17",
            "w": 173
        },
        "\u2219": {
            "d": "35,-91v-16,5,-32,-31,-17,-43v25,-9,59,39,18,43v2,0,2,2,2,4v-1,-1,-1,-2,-3,-4",
            "w": 68
        },
        "\u201a": {
            "d": "25,60v-36,-24,48,-78,40,-110v18,-23,47,16,45,32v-6,48,-43,74,-74,90v-5,-2,-11,-5,-11,-12",
            "w": 118
        },
        "\u201e": {
            "d": "25,60v-36,-24,48,-78,40,-110v18,-23,47,16,45,32v-6,48,-43,74,-74,90v-5,-2,-11,-5,-11,-12xm112,63v-35,-24,49,-77,41,-109v18,-25,46,14,44,31v-5,50,-44,71,-73,91v-4,-4,-14,-7,-12,-13",
            "w": 215
        },
        "\u2030": {
            "d": "45,-287v12,-35,106,-53,137,-25v0,0,0,1,-1,2r34,20v49,-5,106,-13,106,43v-8,27,-15,33,-33,53r-35,37v4,8,-11,4,-8,12v-7,0,-16,10,-11,12v-14,3,-4,14,-18,20v-7,7,-11,19,-25,19v1,7,-12,7,-5,12v-8,0,-9,5,-8,13v2,-1,27,-4,24,-14v14,-36,52,-54,94,-56v54,-3,75,77,41,112v-14,14,-31,34,-58,40v-46,11,-67,-11,-82,-51v0,-6,1,-13,-2,-16r-42,25v0,1,2,1,3,1v-4,1,-7,1,-8,1v-16,18,-49,44,-73,34v-8,2,-9,2,-16,-3r0,-23r1,1v29,-63,86,-86,134,-139v32,-36,58,-62,76,-92v-16,-8,-35,-4,-50,-1v-6,20,-24,31,-35,47v-21,3,-30,22,-49,24v0,3,-7,7,-11,5v0,0,2,-3,0,-3v-33,8,-86,-6,-93,-32v7,-2,-5,-12,-2,-17xm165,-285v-12,-12,-44,-7,-61,0v15,6,42,3,61,0xm319,-79v3,-7,-23,-27,-36,-14v-19,3,-46,13,-55,38v9,32,66,31,78,3v11,-4,17,-21,5,-29v3,-2,5,-1,8,2xm181,-250v-29,1,-58,7,-86,5r1,3v-16,-1,-28,-1,-23,15v30,35,94,1,108,-23xm195,-56r0,-2r0,2xm454,0v-47,19,-90,11,-101,-41v-7,-34,10,-72,38,-88v57,-33,131,-7,115,70v-3,16,-23,28,-29,43v-3,0,-10,6,-23,16xm382,-61v5,10,7,11,17,22v36,12,60,-11,74,-37v-2,-5,-10,-9,-6,-13v1,1,6,4,7,2v-21,-29,-79,-9,-92,26xm349,-62r0,-3r0,3",
            "w": 514
        },
        "\u00c2": {
            "d": "176,-166v16,16,25,106,44,134v0,2,2,7,7,17v-5,2,-1,21,-7,10v1,9,-7,19,-22,16v-12,-11,-15,-32,-25,-45v-3,-27,-38,-39,-62,-49v-6,6,-20,-8,-26,3v-1,-3,-9,-4,-11,-1v2,1,3,2,4,3v-13,2,-14,8,-28,5v-7,12,-10,24,-16,36v-30,5,-29,-35,-14,-46v35,-56,57,-116,88,-183v12,-6,30,5,32,17v6,9,32,51,36,83xm67,-70v-2,2,-3,2,-4,3v0,-1,2,-5,4,-3xm73,-120v35,-4,61,4,83,15v-4,-38,-18,-80,-35,-107v-2,3,-13,13,-9,21v-3,-5,-5,5,-6,-1xm57,-272v22,-8,33,-44,63,-59v27,7,42,35,63,52v1,3,3,7,6,12v-4,10,-12,13,-23,14v-12,-13,-21,-30,-48,-41v-16,17,-26,33,-41,49v-19,4,-28,-12,-20,-27"
        },
        "\u00ca": {
            "d": "137,-192v0,-1,-1,-1,-1,-1v1,0,1,1,1,1xm214,-256v4,3,16,-6,14,5v5,1,19,0,21,3v-8,6,-10,12,-15,17v2,-1,3,0,3,2v-4,0,-5,0,-10,1v-23,7,-25,14,-46,18v-14,2,-28,10,-42,9v-1,2,-1,4,0,6v1,-3,-2,-2,-4,-2v-10,7,-23,8,-37,16v-1,6,-9,15,-6,25r96,-6v-3,8,15,0,7,9v14,4,-2,8,1,17v-17,13,-49,18,-73,26v-25,1,-57,10,-55,45v59,1,137,-21,171,15v1,15,-5,12,-9,23v-10,4,-23,3,-35,5r2,2v-4,-1,-6,0,-4,-3r-4,0v0,1,1,1,1,2v-38,0,-68,5,-97,9v-10,7,-43,11,-65,10v-10,-15,-23,-20,-19,-45v5,-28,21,-50,17,-83v2,0,6,-18,12,-16v2,-9,9,-17,6,-27v-25,-8,-27,-45,-8,-55v12,3,31,-4,39,-14v31,13,71,-17,103,-10v11,-6,32,-7,41,-6v-2,1,-3,1,-5,2xm76,-275v23,-4,36,-65,72,-50v15,14,39,33,50,54v-4,9,-10,12,-21,13v-12,-12,-19,-23,-41,-38v-17,12,-27,32,-41,46v-18,1,-25,-11,-19,-25",
            "w": 242
        },
        "\u00c1": {
            "d": "176,-166v16,16,25,106,44,134v0,2,2,7,7,17v-5,2,-1,21,-7,10v1,9,-7,19,-22,16v-12,-11,-15,-32,-25,-45v-3,-27,-38,-39,-62,-49v-6,6,-20,-8,-26,3v-1,-3,-9,-4,-11,-1v2,1,3,2,4,3v-13,2,-14,8,-28,5v-7,12,-10,24,-16,36v-30,5,-29,-35,-14,-46v35,-56,57,-116,88,-183v12,-6,30,5,32,17v6,9,32,51,36,83xm67,-70v-2,2,-3,2,-4,3v0,-1,2,-5,4,-3xm73,-120v35,-4,61,4,83,15v-4,-38,-18,-80,-35,-107v-2,3,-13,13,-9,21v-3,-5,-5,5,-6,-1xm118,-311v10,-3,49,-32,61,-8v-19,21,-69,35,-93,56v-9,7,-22,-2,-32,0v4,-4,-2,-11,6,-16"
        },
        "\u00cb": {
            "d": "137,-192v0,-1,-1,-1,-1,-1v1,0,1,1,1,1xm214,-256v4,3,16,-6,14,5v5,1,19,0,21,3v-8,6,-10,12,-15,17v2,-1,3,0,3,2v-4,0,-5,0,-10,1v-23,7,-25,14,-46,18v-14,2,-28,10,-42,9v-1,2,-1,4,0,6v1,-3,-2,-2,-4,-2v-10,7,-23,8,-37,16v-1,6,-9,15,-6,25r96,-6v-3,8,15,0,7,9v14,4,-2,8,1,17v-17,13,-49,18,-73,26v-25,1,-57,10,-55,45v59,1,137,-21,171,15v1,15,-5,12,-9,23v-10,4,-23,3,-35,5r2,2v-4,-1,-6,0,-4,-3r-4,0v0,1,1,1,1,2v-38,0,-68,5,-97,9v-10,7,-43,11,-65,10v-10,-15,-23,-20,-19,-45v5,-28,21,-50,17,-83v2,0,6,-18,12,-16v2,-9,9,-17,6,-27v-25,-8,-27,-45,-8,-55v12,3,31,-4,39,-14v31,13,71,-17,103,-10v11,-6,32,-7,41,-6v-2,1,-3,1,-5,2xm77,-312v19,-6,31,5,42,17v4,22,-38,23,-49,10v-7,-10,1,-12,6,-23v-2,2,-5,-2,-5,-2v3,0,7,3,6,-2xm144,-298v8,-17,37,-16,48,-5v5,8,0,13,-5,23v1,-2,4,0,4,1r-6,0r1,3v-18,5,-41,-1,-43,-23",
            "w": 242
        },
        "\u00c8": {
            "d": "137,-192v0,-1,-1,-1,-1,-1v1,0,1,1,1,1xm214,-256v4,3,16,-6,14,5v5,1,19,0,21,3v-8,6,-10,12,-15,17v2,-1,3,0,3,2v-4,0,-5,0,-10,1v-23,7,-25,14,-46,18v-14,2,-28,10,-42,9v-1,2,-1,4,0,6v1,-3,-2,-2,-4,-2v-10,7,-23,8,-37,16v-1,6,-9,15,-6,25r96,-6v-3,8,15,0,7,9v14,4,-2,8,1,17v-17,13,-49,18,-73,26v-25,1,-57,10,-55,45v59,1,137,-21,171,15v1,15,-5,12,-9,23v-10,4,-23,3,-35,5r2,2v-4,-1,-6,0,-4,-3r-4,0v0,1,1,1,1,2v-38,0,-68,5,-97,9v-10,7,-43,11,-65,10v-10,-15,-23,-20,-19,-45v5,-28,21,-50,17,-83v2,0,6,-18,12,-16v2,-9,9,-17,6,-27v-25,-8,-27,-45,-8,-55v12,3,31,-4,39,-14v31,13,71,-17,103,-10v11,-6,32,-7,41,-6v-2,1,-3,1,-5,2xm69,-307v-12,-5,-7,-25,6,-22v37,8,69,33,106,41v4,8,10,9,5,18v-42,9,-81,-22,-117,-37",
            "w": 242
        },
        "\u00cd": {
            "d": "83,-253v43,23,11,96,19,151v-4,23,-7,67,-3,93v-2,1,-17,4,-12,9v-16,6,-19,-1,-31,-10v-6,-66,5,-142,9,-209v0,-7,9,-31,18,-34xm125,-324v10,-12,19,5,30,8v-14,23,-80,40,-110,63v-10,7,-26,0,-38,-1v5,-1,-1,-11,1,-12v29,-19,68,-37,117,-58",
            "w": 161
        },
        "\u00ce": {
            "d": "71,-205v0,-18,7,-40,20,-48v45,22,10,96,19,151v-6,24,-3,60,-5,90v2,1,4,3,-1,5v-5,-3,-10,3,-9,7v-16,6,-18,-2,-30,-10v-9,-60,5,-131,6,-195xm144,-235v-15,-16,-27,-29,-54,-50v-27,18,-33,39,-54,60v-24,4,-35,-19,-24,-33v28,-15,44,-55,76,-72v29,3,59,54,76,64v2,5,2,5,7,14v-6,12,-13,17,-27,17",
            "w": 176
        },
        "\u00cf": {
            "d": "61,-253v45,22,10,96,19,151v-6,24,-3,60,-5,90v2,1,4,3,-1,5v-5,-3,-10,3,-9,7v-16,6,-19,-2,-31,-10v-6,-66,5,-142,9,-209v0,-7,10,-30,18,-34xm13,-304v20,-7,31,5,42,17v1,27,-50,25,-52,3v1,-6,5,-7,9,-16v-1,1,-4,0,-5,-2v3,1,7,4,6,-2xm122,-268v-17,8,-32,-2,-43,-14v-2,-28,49,-28,51,-5v-1,3,-3,8,-7,15v2,-2,5,2,4,2v0,0,-2,-1,-6,-1",
            "w": 138
        },
        "\u00cc": {
            "d": "39,-205v0,-18,7,-40,20,-48v45,22,10,96,19,151v-6,24,-3,60,-5,90v2,1,4,3,-1,5v-5,-3,-10,3,-9,7v-16,6,-18,-2,-30,-10v-9,-60,5,-131,6,-195xm12,-295v-11,-6,-10,-32,5,-29v37,9,58,45,97,51v6,9,19,17,10,24v-6,13,-11,10,-30,4v-29,-17,-55,-29,-82,-50",
            "w": 134
        },
        "\u00d3": {
            "d": "287,-75r0,0r0,0xm200,-259v13,-5,27,4,39,7v0,1,-1,2,-2,3v12,-2,24,12,35,12v6,6,13,15,18,12v27,35,31,91,8,133v-7,13,-21,19,-27,34v-6,-1,-17,9,-19,18v-15,-3,-24,24,-45,26v-101,54,-240,-14,-189,-139v13,-32,38,-54,70,-66v29,-27,49,-37,101,-42v2,2,3,4,6,2v0,0,-1,0,-1,-2v4,0,5,2,1,3v6,3,11,4,16,2v-4,-1,-4,-1,-11,-3xm62,-146v-27,38,4,102,48,100v66,15,127,-29,155,-69v15,-22,17,-71,-8,-82v-19,-17,-82,-30,-109,-13v-5,-5,-8,8,-18,7v-7,2,-19,16,-26,22v-6,12,-7,29,-16,38v-5,-8,-6,9,-12,-1v-1,2,-1,3,-2,0v1,-9,-12,-11,-13,-4v0,0,1,1,1,2xm207,-324v11,-12,25,5,34,8v-16,23,-91,39,-124,62v-12,8,-31,-2,-44,0v6,-3,0,-4,0,-9v40,-28,76,-38,134,-61",
            "w": 319
        },
        "\u00d4": {
            "d": "287,-75r0,0r0,0xm200,-259v13,-5,27,4,39,7v0,1,-1,2,-2,3v12,-2,24,12,35,12v6,6,13,15,18,12v27,35,31,91,8,133v-7,13,-21,19,-27,34v-6,-1,-17,9,-19,18v-15,-3,-24,24,-45,26v-101,54,-240,-14,-189,-139v13,-32,38,-54,70,-66v29,-27,49,-37,101,-42v2,2,3,4,6,2v0,0,-1,0,-1,-2v4,0,5,2,1,3v6,3,11,4,16,2v-4,-1,-4,-1,-11,-3xm62,-146v-27,38,4,102,48,100v66,15,127,-29,155,-69v15,-22,17,-71,-8,-82v-19,-17,-82,-30,-109,-13v-5,-5,-8,8,-18,7v-7,2,-19,16,-26,22v-6,12,-7,29,-16,38v-5,-8,-6,9,-12,-1v-1,2,-1,3,-2,0v1,-9,-12,-11,-13,-4v0,0,1,1,1,2xm228,-266v-14,-11,-24,-24,-53,-33v-6,5,-14,8,-13,14v-18,7,-26,32,-49,26v0,0,1,-1,1,-2v-7,-3,-16,-13,-6,-20v30,-7,47,-59,85,-45v20,17,46,26,60,49v-5,9,-12,12,-25,11",
            "w": 319
        },
        "\uf000": {
            "d": "184,-282v16,-3,20,28,16,36v1,22,-31,54,-50,66v0,4,0,6,-3,7v-21,-8,-14,-61,2,-78v6,-16,25,-19,35,-31xm225,-139v-14,1,-56,42,-19,50v9,6,21,6,19,23v6,4,5,11,7,18v-12,28,-31,29,-64,41v-72,1,-145,-13,-160,-85v3,-71,72,-101,142,-78v14,4,36,-23,56,-9r20,12v4,10,7,20,-1,28",
            "w": 248
        },
        "\u00d2": {
            "d": "287,-75r0,0r0,0xm200,-259v13,-5,27,4,39,7v0,1,-1,2,-2,3v12,-2,24,12,35,12v6,6,13,15,18,12v27,35,31,91,8,133v-7,13,-21,19,-27,34v-6,-1,-17,9,-19,18v-15,-3,-24,24,-45,26v-101,54,-240,-14,-189,-139v13,-32,38,-54,70,-66v29,-27,49,-37,101,-42v2,2,3,4,6,2v0,0,-1,0,-1,-2v4,0,5,2,1,3v6,3,11,4,16,2v-4,-1,-4,-1,-11,-3xm62,-146v-27,38,4,102,48,100v66,15,127,-29,155,-69v15,-22,17,-71,-8,-82v-19,-17,-82,-30,-109,-13v-5,-5,-8,8,-18,7v-7,2,-19,16,-26,22v-6,12,-7,29,-16,38v-5,-8,-6,9,-12,-1v-1,2,-1,3,-2,0v1,-9,-12,-11,-13,-4v0,0,1,1,1,2xm159,-295v-9,-2,-48,-23,-20,-34v40,7,72,34,111,42v4,6,15,10,6,15v-8,10,-15,10,-33,3",
            "w": 319
        },
        "\u00da": {
            "d": "229,-143v11,-14,38,-47,29,-83v-2,-8,10,-25,23,-29v44,47,-24,149,-46,165v-26,37,-68,56,-104,85v-20,3,-47,15,-71,-2v-37,-26,-58,-67,-55,-128v1,-26,18,-129,57,-100r7,20v-14,30,-32,52,-25,100v8,48,21,66,61,58v42,-8,85,-36,124,-86xm134,-295v20,-4,77,-51,105,-25v2,-2,3,1,6,2v-33,28,-89,40,-125,63v-11,7,-29,0,-43,-1v3,-4,-3,-13,8,-17",
            "w": 300
        },
        "\u00db": {
            "d": "229,-143v11,-14,38,-47,29,-83v-2,-8,10,-25,23,-29v44,47,-24,149,-46,165v-26,37,-68,56,-104,85v-20,3,-47,15,-71,-2v-37,-26,-58,-67,-55,-128v1,-26,18,-129,57,-100r7,20v-14,30,-32,52,-25,100v8,48,21,66,61,58v42,-8,85,-36,124,-86xm220,-235v-16,-16,-27,-29,-54,-50v-26,17,-34,40,-55,60v-25,6,-39,-28,-17,-35v24,-23,41,-52,70,-70v29,3,59,54,76,64v3,5,2,5,7,14v-6,12,-13,17,-27,17",
            "w": 300
        },
        "\u00d9": {
            "d": "229,-143v11,-14,38,-47,29,-83v-2,-8,10,-25,23,-29v44,47,-24,149,-46,165v-26,37,-68,56,-104,85v-20,3,-47,15,-71,-2v-37,-26,-58,-67,-55,-128v1,-26,18,-129,57,-100r7,20v-14,30,-32,52,-25,100v8,48,21,66,61,58v42,-8,85,-36,124,-86xm94,-295v-14,-8,-12,-35,7,-35v44,12,71,54,118,62v7,9,22,21,12,29r1,6v-42,17,-79,-30,-112,-44v-7,-3,-16,-9,-26,-18",
            "w": 300
        },
        "\u0131": {
            "d": "26,-111v17,-27,40,5,43,27v-2,27,4,62,-7,80v-14,1,-13,3,-29,-3v-13,-18,-16,-74,-7,-104",
            "w": 76
        },
        "\u02c6": {
            "d": "144,-235v-15,-16,-27,-29,-54,-50v-27,18,-33,39,-54,60v-24,4,-35,-19,-24,-33v28,-15,44,-55,76,-72v29,3,59,54,76,64v2,5,2,5,7,14v-6,12,-13,17,-27,17",
            "w": 176
        },
        "\u02dc": {
            "d": "290,-302v-24,25,-71,86,-117,64v-12,0,-45,-40,-58,-37v-32,7,-51,30,-73,48v-6,-2,-7,1,-12,2v-45,-25,21,-58,34,-74v42,-32,100,3,121,23v21,-7,40,-26,76,-50v12,-3,17,3,26,7v-1,5,5,8,3,17",
            "w": 300
        },
        "\u00af": {
            "d": "50,-269v-36,8,-54,-40,-29,-58v47,-5,96,10,138,-2v11,4,28,-3,41,-3v20,8,30,17,37,42v-27,31,-124,8,-173,23v-3,0,-6,-3,-8,-1v1,3,1,3,-3,3v0,-1,-2,-3,-3,-4xm78,-268v0,1,-1,2,-2,2",
            "w": 243
        },
        "\u02d8": {
            "d": "210,-323v24,1,28,1,44,13v-2,5,-4,8,1,14v-3,0,-6,3,-7,8v-46,25,-76,67,-134,81r-95,-79v-2,-16,-18,-30,6,-37v42,9,60,49,96,66v28,-21,67,-40,89,-66",
            "w": 266
        },
        "\u02d9": {
            "d": "54,-314v7,15,5,27,-15,30v2,-1,2,1,2,3v-4,-4,-10,-2,-19,-9v-6,-14,-14,-38,6,-40v10,4,19,10,26,16",
            "w": 68
        },
        "\u02da": {
            "d": "25,-301v2,-17,32,-38,59,-21v28,17,74,79,22,94v-53,15,-95,-15,-95,-59v0,-7,4,-14,14,-14xm59,-274v1,9,34,5,37,-2v0,-10,-11,-9,-20,-10v-13,-3,-16,10,-17,12",
            "w": 137
        },
        "\u00b8": {
            "d": "98,-5v24,19,64,47,46,88v-14,31,-50,35,-76,53v-14,-1,-31,2,-43,-1v-5,-12,-12,-20,-8,-37v6,-27,38,-22,60,-44v-10,-6,-32,-14,-32,-40v0,-14,5,-32,16,-56v22,-10,43,22,37,37xm39,135r0,0r0,0",
            "w": 163
        },
        "\u02dd": {
            "d": "39,-317v22,-32,55,-5,54,28v-9,28,-29,46,-44,69v-3,2,-8,4,-15,7r-16,-11v-7,-14,-10,-23,-10,-28v-5,-8,30,-62,31,-65xm126,-318v21,-33,55,-5,54,28v-9,28,-22,37,-44,69v-3,2,-8,4,-15,7v-12,-4,-27,-30,-26,-39v-5,-8,30,-62,31,-65",
            "w": 188
        },
        "\u02db": {
            "d": "113,57v12,14,15,22,12,41v-54,61,-127,-3,-98,-86v5,-14,-1,-50,22,-48v34,12,12,66,17,98v12,10,31,-5,47,-5",
            "w": 133
        },
        "\u02c7": {
            "d": "135,-329v11,1,19,8,19,23v-17,56,-131,69,-141,-5v-2,-5,11,-13,17,-11v24,9,7,40,49,34v37,-5,33,-20,56,-41",
            "w": 166
        },
        "\r": {
            "w": 189
        }
    }
});
}