#!/bin/bash

# (C) 2017 Intel Corporation. All rights reserved.
# Your use of Intel Corporation's design tools, logic functions and other
# software and tools, and its AMPP partner logic functions, and any output
# files any of the foregoing (including device programming or simulation
# files), and any associated documentation or information are expressly subject
# to the terms and conditions of the Intel Program License Subscription
# Agreement, Intel MegaCore Function License Agreement, or other applicable
# license agreement, including, without limitation, that your use is for the
# sole purpose of programming logic devices manufactured by Intel and sold by
# Intel or its authorized distributors.  Please refer to the applicable
# agreement for further details.

# this script is used to automatically configure the attached card boards
# the script is used with the init_opencl.sh. Cannot be used individually

if [ -n "$PAC_BSP_ENV_DEBUG_SCRIPT" ]; then
  set -x
fi


# the arrary used to store every devices after diagnostic
devices_array=()

# run the diagnose for all the device info
device_diagnostic() {
	TEMPFILE=$(mktemp)
	aocl diagnose > "$TEMPFILE"

	logical_name=""
	physical_name=""
	num_total_devices=0
	num_pac_devices=0

	bsp_loaded="BSP_LOADED"
	diagnose_result=""
	is_board=0

	while read -r LINE; do

	    if [[ $LINE =~ "Device Name" ]]; then
		num_total_devices=${num_total_devices}+1
		is_board=1
		elif [[ $LINE =~ "acl" ]]; then
			if [[ $is_board == 1 ]]; then
				# find the logical device name
				IFS=' ' read -ra tokens <<< "$LINE"
				logical_name="${tokens[0]}"
				is_board=0
			fi
		elif [[ $LINE =~ "pac_" ]]; then
			# find the physical device
			IFS=' ' read -ra tokens <<< "$LINE"
			physical_name="${tokens[0]}"
			if [[ $physical_name =~ "pac" ]]; then
				num_pac_devices=${num_pac_devices}+1
			fi
			if [[ $LINE =~ "Uninitialized" ]]; then
				# BSP is unloaded
				bsp_loaded="BSP_UNLOADED"
			else
				# BSP is loaded
				bsp_loaded="BSP_LOADED"
			fi
		elif [[ $LINE =~ "DIAGNOSTIC" ]]; then
			# the board is valid for OpenCL application
			if [[ $LINE =~ "PASSED" ]]; then
				diagnose_result="PASSED"
			else
				diagnose_result="FAILED"
			fi
			# append the device info to the device array
			device_info="$logical_name:$physical_name|${bsp_loaded}|${diagnose_result}"
			devices_array+=($device_info)

			logical_name="Unknown"
			physical_name="Unknown"
			bsp_loaded="Unknown"
			diagnose_result=""
	    fi

	done < "$TEMPFILE"

	# remove the tempfile
	rm "$TEMPFILE"
}


device_try_reprogram() {
	# populate the devices and try to program them if the BSP is not loaded
	# a user could use the environment variable ACL_SKIP_BSP_CONF to skip the program
	if [[ -z "${ACL_SKIP_BSP_CONF}" ]]; then

		if ! ls /dev/intel-fpga-port.* &> /dev/null; then
			echo "Warning: Intel PAC device is not found."
			echo "Please install the Intel PAC card to execute your program on an FPGA device."
			exit 1
		fi

		device_diagnostic

		# the default configuration flow
		# program the unconfigured devices
		for device in "${devices_array[@]}";
		do
			logical_name=${device%%:*}
			device_info=${device#*:}
			if [[ $device_info =~ "pac" && $device_info =~ "UNLOADED" && $device_info =~ "PASSED" ]]; then
				# program the device
				program_cmd="aocl initialize $logical_name"
				result=$($program_cmd)
				if [[ ! $result =~ "Program succeed" || $? != 0 ]]; then
					echo "Failed to configure device ${devices_array[dev_idx]}"
				fi
			fi
		done
	fi
}


device_try_reprogram
