# create the namespace                                                                                             
namespace eval ::aocl_empty_flow {

  # initialization
  variable package_root "$::env(INTELFPGAOCLSDKROOT)/ip/bsp"
  variable empty_flow

}

# Helper function for empty flow tcl script
# read contents of file into return value
proc ::aocl_empty_flow::empty_flow_read_file {file_name} {
  if {[file exists $file_name]} {
    set fh [open $file_name "r"]
    set contents [read $fh]
    close $fh
    return $contents
  } else {
    return ""
  }
}

# Parse through empty_kernel_partitions.txt generated by system integrator, and set kernel partitions to empty
proc ::aocl_empty_flow::set_empty_setting {project_name revision_name top_path} {
  variable empty_flow
  
  # File name must match file generated in acl/sysgen/system_integrator/custom_ic_impl.cpp
  set empty_flow_file "empty_kernel_partition.txt"
  set empty_flow [file exists $empty_flow_file]
  set count 0
  set partition_prefix "kernel_system_partition"
  
  if {$empty_flow eq 1} {
    project_open $project_name -revision $revision_name
    set data [::aocl_empty_flow::empty_flow_read_file $empty_flow_file]
    set lines [split $data "\n"]
    foreach line $lines {
      if {[string length $line]} {
        set partition [concat $partition_prefix$count]
        incr count
        set_instance_assignment -name PARTITION $partition -to "$top_path|$line"
        set_instance_assignment -name EMPTY ON -to "$top_path|$line"
      }
    }
    project_close
  }
}
