/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import org.jmol.i18n.GT;
import org.jmol.minimize.MMConstraint;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.MinimizationThread;
import org.jmol.minimize.forcefield.ForceField;
import org.jmol.minimize.forcefield.ForceFieldMMFF;
import org.jmol.minimize.forcefield.ForceFieldUFF;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.ModelSet;
import org.jmol.thread.JmolThread;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.JmolAsyncException;
import org.jmol.viewer.Viewer;

public class Minimizer {
    public static int staticID = 0;
    public int id;
    public Viewer vwr;
    public Atom[] atoms;
    public Bond[] bonds;
    public int rawBondCount;
    public BS bsAtoms;
    public Lst<MMConstraint> constraints;
    public MinAtom[] minAtoms;
    public MinBond[] minBonds;
    public MinAngle[] minAngles;
    public MinTorsion[] minTorsions;
    public BS bsMinFixed;
    private int ac;
    private int bondCount;
    private int[] atomMap;
    private int steps = 50;
    private double crit = 0.001;
    public String units = "kJ/mol";
    private ForceField pFF;
    private String ff = "UFF";
    private BS bsTaint;
    private BS bsSelected;
    private BS bsFixedDefault;
    private BS bsFixed;
    private boolean modelkitMinimizing;
    private BS bsBasis;
    private boolean isSilent;
    private Map<String, MMConstraint> constraintMap;
    private int elemnoMax;
    private boolean isQuick;
    private boolean minimizing;
    private MinimizationThread minimizationThread;
    private double trustRadius = 0.3;
    double[][] coordSaved;
    private P3 p = new P3();

    public Minimizer() {
        this.id = ++staticID * 100;
    }

    public Minimizer setProperty(String propertyName, Object value) {
        switch ("ff        cancel    clear     constraintfixed     stop      vwr    ".indexOf(propertyName)) {
            case 0: {
                if (this.ff.equals(value)) break;
                this.setProperty("clear", null);
                this.ff = (String)value;
                break;
            }
            case 10: {
                this.stopMinimization(false);
                break;
            }
            case 20: {
                if (this.minAtoms == null) break;
                this.stopMinimization(false);
                this.clear();
                break;
            }
            case 30: {
                this.addConstraint((Object[])value);
                break;
            }
            case 40: {
                this.bsFixedDefault = (BS)value;
                if (this.bsFixedDefault == null || this.bsFixedDefault.cardinality() != 0) break;
                this.bsFixedDefault = null;
                break;
            }
            case 50: {
                this.stopMinimization(true);
                break;
            }
            case 60: {
                this.vwr = (Viewer)value;
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean minimize(int steps, double crit, BS bsSelected, BS bsFixed, BS bsBasis, int flags, String ff) throws JmolAsyncException {
        Object val;
        BS bsXx;
        ++this.id;
        this.isSilent = (flags & 1) == 1;
        this.isQuick = ff.indexOf("2D") >= 0 || (flags & 8) == 8;
        boolean bl = this.modelkitMinimizing = bsBasis != null && this.vwr.getModelkitPropertySafely("minimizing") == Boolean.TRUE;
        if (bsBasis != null) {
            if (bsFixed == null) {
                bsFixed = new BS();
            }
            bsFixed.or(this.vwr.getMotionFixedAtoms(bsBasis.nextSetBit(0)));
            bsBasis.andNot(bsFixed);
            bsFixed.or(bsSelected);
            bsFixed.andNot(bsBasis);
            if (bsBasis.isEmpty()) {
                this.report(" symmetry-based minimization failed -- all atoms are fully constrained", false);
                return false;
            }
            int n = bsBasis.cardinality();
            this.report(" symmetry-based minimization for " + n + " atom" + (n == 1 ? "" : "s"), false);
        }
        this.bsBasis = bsBasis;
        this.trustRadius = bsBasis == null ? 0.3 : 0.01;
        boolean haveFixed = (flags & 4) == 4;
        BS bS = bsXx = (flags & 0x80) == 128 ? new BS() : null;
        if (crit <= 0.0 && (val = this.vwr.getP("minimizationCriterion")) != null && val instanceof Float) {
            crit = ((Float)val).floatValue();
        }
        this.crit = Math.max(crit, 1.0E-4);
        if (steps == Integer.MAX_VALUE && (val = this.vwr.getP("minimizationSteps")) != null && val instanceof Integer) {
            steps = (Integer)val;
        }
        this.steps = steps;
        try {
            boolean isSame;
            this.setEnergyUnits();
            if (!haveFixed && this.bsFixedDefault != null) {
                bsFixed.and(this.bsFixedDefault);
            }
            if (this.minimizing) {
                boolean bl2 = false;
                return bl2;
            }
            ForceField pFF0 = this.pFF;
            this.getForceField(ff);
            if (this.pFF == null) {
                Logger.error(GT.o(GT.$("Could not get class for force field {0}"), ff));
                boolean i = false;
                return i;
            }
            Logger.info("minimize: " + this.id + " initializing " + this.pFF.name + " (steps = " + steps + " criterion = " + crit + ") silent=" + this.isSilent + " quick=" + this.isQuick + " fixed=" + haveFixed + " bsSelected=" + bsSelected + " bsFixed=" + bsFixed + " bsFixedDefault=" + this.bsFixedDefault + " Xx=" + (bsXx != null) + " ...");
            if (bsSelected.nextSetBit(0) < 0) {
                Logger.error(GT.$("No atoms selected -- nothing to do!"));
                boolean i = false;
                return i;
            }
            this.atoms = this.vwr.ms.at;
            this.bsAtoms = BSUtil.copy(bsSelected);
            int i = this.bsAtoms.nextSetBit(0);
            while (i >= 0) {
                if (this.atoms[i].getElementNumber() == 0) {
                    if (bsXx == null) {
                        this.bsAtoms.clear(i);
                        Logger.info("minimize: " + this.id + " Ignoring Xx for atomIndex=" + i);
                    } else {
                        bsXx.set(i);
                        Logger.info("minimize: " + this.id + " Setting Xx to fluorine for atomIndex=" + i);
                        this.atoms[i].setAtomicAndIsotopeNumber(9);
                    }
                }
                i = this.bsAtoms.nextSetBit(i + 1);
            }
            if (bsFixed != null) {
                this.bsAtoms.or(bsFixed);
            }
            this.ac = this.bsAtoms.cardinality();
            boolean sameAtoms = BSUtil.areEqual(bsSelected, this.bsSelected);
            this.bsSelected = bsSelected;
            if (pFF0 != null && this.pFF != pFF0) {
                sameAtoms = false;
            }
            if (!sameAtoms) {
                this.pFF.clear();
            }
            boolean bl3 = isSame = sameAtoms && BSUtil.areEqual(bsFixed, this.bsFixed);
            if (!this.setupMinimization(bsFixed, isSame)) {
                this.clear();
                boolean bl4 = false;
                return bl4;
            }
            if (steps > 0) {
                this.bsTaint = BSUtil.copy(this.bsAtoms);
                BSUtil.andNot(this.bsTaint, bsFixed);
                this.vwr.ms.setTaintedAtoms(this.bsTaint, 2);
            }
            if (this.constraints != null) {
                int i2 = this.constraints.size();
                while (--i2 >= 0) {
                    ((MMConstraint)this.constraints.get(i2)).set(steps, this.bsAtoms, this.atomMap);
                }
            }
            this.pFF.setConstraints(this);
            if (steps <= 0) {
                this.getEnergyOnly();
            } else if (this.isSilent || !this.vwr.useMinimizationThread()) {
                this.minimizeWithoutThread();
            } else {
                this.setMinimizationOn(true);
            }
        }
        finally {
            if (bsXx != null && !bsXx.isEmpty()) {
                int i = bsXx.nextSetBit(0);
                while (i >= 0) {
                    this.atoms[i].setAtomicAndIsotopeNumber(0);
                    i = bsXx.nextSetBit(i + 1);
                }
            }
        }
        return true;
    }

    public Object getProperty(String propertyName, int param) {
        if (propertyName.equals("log")) {
            return this.pFF == null ? "" : this.pFF.getLogData();
        }
        if (propertyName.equals("fixed")) {
            return this.bsFixedDefault;
        }
        return null;
    }

    private void addConstraint(Object[] o) {
        String id;
        MMConstraint c;
        if (o == null) {
            return;
        }
        int[] indexes = (int[])o[0];
        int nAtoms = indexes[0];
        if (nAtoms == 0) {
            this.constraints = null;
            return;
        }
        double value = ((Float)o[1]).doubleValue();
        if (this.constraints == null) {
            this.constraints = new Lst();
            this.constraintMap = new Hashtable<String, MMConstraint>();
        }
        if (indexes[1] > indexes[nAtoms]) {
            AU.swapInt(indexes, 1, nAtoms);
            if (nAtoms == 4) {
                AU.swapInt(indexes, 2, 3);
            }
        }
        if ((c = this.constraintMap.get(id = Escape.eAI(indexes))) != null) {
            c.value = value;
            return;
        }
        c = new MMConstraint(indexes, value);
        this.constraintMap.put(id, c);
        this.constraints.addLast(c);
    }

    private void clear() {
        this.setMinimizationOn(false);
        this.ac = 0;
        this.bondCount = 0;
        this.atoms = null;
        this.bonds = null;
        this.rawBondCount = 0;
        this.minAtoms = null;
        this.minBonds = null;
        this.minAngles = null;
        this.minTorsions = null;
        this.coordSaved = null;
        this.atomMap = null;
        this.bsTaint = null;
        this.bsAtoms = null;
        this.bsFixed = null;
        this.bsFixedDefault = null;
        this.bsMinFixed = null;
        this.bsSelected = null;
        this.constraints = null;
        this.constraintMap = null;
        this.pFF = null;
    }

    private void setEnergyUnits() {
        String s = this.vwr.g.energyUnits;
        this.units = s.equalsIgnoreCase("kcal") ? "kcal" : "kJ";
    }

    private boolean setupMinimization(BS bsFixed, boolean isSame) throws JmolAsyncException {
        if (isSame) {
            this.setAtomPositions();
            return true;
        }
        this.coordSaved = null;
        this.atomMap = new int[this.atoms.length];
        this.minAtoms = new MinAtom[this.ac];
        this.elemnoMax = 0;
        BS bsElements = new BS();
        int i = this.bsAtoms.nextSetBit(0);
        int pt = 0;
        while (i >= 0) {
            Atom atom = this.atoms[i];
            this.atomMap[i] = pt;
            int atomicNo = this.atoms[i].getElementNumber();
            this.elemnoMax = Math.max(this.elemnoMax, atomicNo);
            bsElements.set(atomicNo);
            this.minAtoms[pt] = new MinAtom(pt, atom, new double[]{atom.x, atom.y, atom.z}, this.ac);
            this.minAtoms[pt].sType = atom.getAtomName();
            i = this.bsAtoms.nextSetBit(i + 1);
            ++pt;
        }
        if (bsFixed != null) {
            this.bsFixed = bsFixed;
        }
        Logger.info(GT.i(GT.$("{0} atoms will be minimized."), this.ac));
        Logger.info("minimize:  " + this.id + " getting bonds...");
        this.bonds = this.vwr.ms.bo;
        this.rawBondCount = this.vwr.ms.bondCount;
        this.getBonds();
        Logger.info("minimize:  " + this.id + " getting angles...");
        this.getAngles();
        Logger.info("minimize:  " + this.id + " getting torsions...");
        this.getTorsions(this.ff.startsWith("MMFF"));
        return this.setModel(bsElements);
    }

    private boolean setModel(BS bsElements) throws JmolAsyncException {
        if (!this.pFF.setModel(bsElements, this.elemnoMax)) {
            Logger.error(GT.o(GT.$("could not setup force field {0}"), this.ff));
            if (this.ff.startsWith("MMFF")) {
                this.report(" MMFF not applicable", false);
                this.getForceField("UFF");
                return this.setModel(bsElements);
            }
            return false;
        }
        return true;
    }

    private void setAtomPositions() {
        int i;
        for (i = 0; i < this.ac; ++i) {
            this.minAtoms[i].set();
        }
        if (this.bsFixed == null || this.bsFixed.cardinality() == 0) {
            this.bsMinFixed = null;
        } else {
            this.bsMinFixed = new BS();
            for (i = 0; i < this.ac; ++i) {
                if (!this.bsFixed.get(this.minAtoms[i].atom.i)) continue;
                this.bsMinFixed.set(i);
            }
        }
    }

    private void getBonds() {
        Object bond;
        int i;
        Lst<MinBond> bondInfo = new Lst<MinBond>();
        this.bondCount = 0;
        block5: for (i = 0; i < this.rawBondCount; ++i) {
            int i2;
            bond = this.bonds[i];
            int i1 = ((Bond)bond).atom1.i;
            if (!this.bsAtoms.get(i1) || !this.bsAtoms.get(i2 = ((Bond)bond).atom2.i)) continue;
            if (i2 < i1) {
                int ii = i1;
                i1 = i2;
                i2 = ii;
            }
            int bondOrder = ((Bond)bond).isPartial() ? 0 : ((Bond)bond).getCovalentOrder();
            switch (bondOrder) {
                case 0: {
                    continue block5;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                case 515: {
                    bondOrder = 5;
                    break;
                }
                default: {
                    bondOrder = 1;
                }
            }
            bondInfo.addLast(new MinBond(i, this.bondCount++, this.atomMap[i1], this.atomMap[i2], bondOrder, 0, null));
        }
        this.minBonds = new MinBond[this.bondCount];
        for (i = 0; i < this.bondCount; ++i) {
            this.minBonds[i] = (MinBond)bondInfo.get(i);
            bond = this.minBonds[i];
            int atom1 = ((MinBond)bond).data[0];
            int atom2 = ((MinBond)bond).data[1];
            this.minAtoms[atom1].addBond((MinBond)bond, atom2);
            this.minAtoms[atom2].addBond((MinBond)bond, atom1);
        }
        for (i = 0; i < this.ac; ++i) {
            this.minAtoms[i].getBondedAtomIndexes();
        }
    }

    public void getAngles() {
        Lst<MinAngle> vAngles = new Lst<MinAngle>();
        for (int i = 0; i < this.bondCount; ++i) {
            int ic;
            int j;
            int[] atomList;
            MinBond bond = this.minBonds[i];
            int ia = bond.data[0];
            int ib = bond.data[1];
            if (this.minAtoms[ib].nBonds > 1) {
                atomList = this.minAtoms[ib].getBondedAtomIndexes();
                j = atomList.length;
                while (--j >= 0) {
                    ic = atomList[j];
                    if (ic <= ia) continue;
                    vAngles.addLast(new MinAngle(new int[]{ia, ib, ic, i, this.minAtoms[ib].getBondIndex(j)}));
                    this.minAtoms[ia].bsVdw.clear(ic);
                }
            }
            if (this.minAtoms[ia].nBonds <= 1) continue;
            atomList = this.minAtoms[ia].getBondedAtomIndexes();
            j = atomList.length;
            while (--j >= 0) {
                ic = atomList[j];
                if (ic >= ib || ic <= ia) continue;
                vAngles.addLast(new MinAngle(new int[]{ic, ia, ib, this.minAtoms[ia].getBondIndex(j), i}));
                this.minAtoms[ic].bsVdw.clear(ib);
            }
        }
        this.minAngles = vAngles.toArray(new MinAngle[vAngles.size()]);
        Logger.info(this.minAngles.length + " angles");
    }

    public void getTorsions(boolean isMMFF) {
        Lst<MinTorsion> vTorsions = new Lst<MinTorsion>();
        int i = this.minAngles.length;
        while (--i >= 0) {
            int id;
            int j;
            int[] atomList;
            int[] angle = this.minAngles[i].data;
            int ia = angle[0];
            int ic = angle[2];
            int ib = angle[1];
            if (ic > ib && this.minAtoms[ic].nBonds > 1) {
                atomList = this.minAtoms[ic].getBondedAtomIndexes();
                for (j = 0; j < atomList.length; ++j) {
                    id = atomList[j];
                    if (id == ia || id == ib) continue;
                    vTorsions.addLast(new MinTorsion(new int[]{ia, ib, ic, id, angle[3], angle[4], this.minAtoms[ic].getBondIndex(j)}));
                    if (!isMMFF) continue;
                    this.minAtoms[Math.min((int)ia, (int)id)].bs14.set(Math.max(ia, id));
                }
            }
            if (ia <= ib || this.minAtoms[ia].nBonds == 1) continue;
            atomList = this.minAtoms[ia].getBondedAtomIndexes();
            for (j = 0; j < atomList.length; ++j) {
                id = atomList[j];
                if (id == ic || id == ib) continue;
                vTorsions.addLast(new MinTorsion(new int[]{ic, ib, ia, id, angle[4], angle[3], this.minAtoms[ia].getBondIndex(j)}));
                if (!isMMFF) continue;
                this.minAtoms[Math.min((int)ic, (int)id)].bs14.set(Math.max(ic, id));
            }
        }
        this.minTorsions = vTorsions.toArray(new MinTorsion[vTorsions.size()]);
        Logger.info(this.minTorsions.length + " torsions");
    }

    public ForceField getForceField(String ff) throws JmolAsyncException {
        if (ff.startsWith("MMFF")) {
            ff = "MMFF";
        }
        if (this.pFF == null || !ff.equals(this.ff) || this.pFF.name.indexOf("2D") >= 0 != this.isQuick) {
            if (ff.equals("MMFF")) {
                this.pFF = new ForceFieldMMFF(this, this.isQuick);
            } else {
                this.pFF = new ForceFieldUFF(this, this.isQuick);
                ff = "UFF";
            }
            this.ff = ff;
            if (!this.isQuick) {
                this.vwr.setStringProperty("_minimizationForceField", ff);
            }
        }
        this.report(" forcefield is " + ff, false);
        this.pFF.setNth(this.vwr.getInt(553648150));
        return this.pFF;
    }

    public boolean minimizationOn() {
        return this.minimizing;
    }

    public JmolThread getThread() {
        return this.minimizationThread;
    }

    private void setMinimizationOn(boolean minimizationOn) {
        this.minimizing = minimizationOn;
        if (!minimizationOn) {
            if (this.minimizationThread != null) {
                this.minimizationThread = null;
            }
            return;
        }
        if (this.minimizationThread == null) {
            this.minimizationThread = new MinimizationThread();
            this.minimizationThread.setManager(this, this.vwr, null);
            this.minimizationThread.start();
        }
    }

    private void getEnergyOnly() {
        if (this.pFF == null || this.vwr == null) {
            return;
        }
        this.pFF.steepestDescentInitialize(this.steps, this.crit, this.trustRadius);
        this.vwr.setFloatProperty("_minimizationEnergyDiff", 0.0f);
        this.reportEnergy();
        this.vwr.setStringProperty("_minimizationStatus", "calculate");
        this.vwr.notifyMinimizationStatus();
        if (this.bsBasis != null) {
            this.vwr.getModelkit(false).minimizeEnd(null, true);
        }
    }

    private void reportEnergy() {
        this.vwr.setFloatProperty("_minimizationEnergy", this.pFF.toUserUnits(this.pFF.getEnergy()));
    }

    public boolean startMinimization() {
        try {
            Logger.info("minimize:  " + this.id + " startMinimization");
            this.vwr.setIntProperty("_minimizationStep", 0);
            this.vwr.setStringProperty("_minimizationStatus", "starting");
            this.vwr.setFloatProperty("_minimizationEnergy", 0.0f);
            this.vwr.setFloatProperty("_minimizationEnergyDiff", 0.0f);
            this.vwr.notifyMinimizationStatus();
            this.vwr.stm.saveCoordinates("minimize", this.bsTaint);
            this.pFF.steepestDescentInitialize(this.steps, this.crit, this.trustRadius);
            this.reportEnergy();
            this.saveCoordinates();
        }
        catch (Exception e) {
            Logger.error("minimization error vwr=" + this.vwr + " pFF = " + this.pFF);
            return false;
        }
        this.minimizing = true;
        return true;
    }

    public boolean stepMinimization() {
        if (!this.minimizing) {
            return false;
        }
        boolean doRefresh = !this.isSilent && this.vwr.getBooleanProperty("minimizationRefresh");
        this.vwr.setStringProperty("_minimizationStatus", "running");
        boolean going = this.pFF.steepestDescentTakeNSteps(1, this.bsBasis != null);
        int currentStep = this.pFF.getCurrentStep();
        this.vwr.setIntProperty("_minimizationStep", currentStep);
        if (doRefresh) {
            this.vwr.refresh(3, "minimization step " + currentStep);
        }
        this.reportEnergy();
        this.vwr.setFloatProperty("_minimizationEnergyDiff", this.pFF.toUserUnits(this.pFF.getEnergyDiff()));
        this.vwr.notifyMinimizationStatus();
        if (doRefresh) {
            if (!this.modelkitMinimizing) {
                this.updateAtomXYZ(false);
            }
            this.vwr.refresh(3, "minimization step " + currentStep);
        }
        return going;
    }

    public void endMinimization(boolean normalFinish) {
        System.out.println("minimization: " + this.id + " end minimizing=" + this.minimizing + " normal=" + normalFinish);
        if (!this.minimizing) {
            return;
        }
        this.setMinimizationOn(false);
        if (this.pFF == null) {
            System.out.println("pFF was null");
        } else {
            boolean failed = this.pFF.detectExplosion();
            if (failed) {
                this.restoreCoordinates();
            } else {
                this.updateAtomXYZ(true);
            }
            this.vwr.setIntProperty("_minimizationStep", this.pFF.getCurrentStep());
            this.reportEnergy();
            this.vwr.setStringProperty("_minimizationStatus", failed ? "failed" : (normalFinish ? "done" : "stopped"));
            this.vwr.notifyMinimizationStatus();
            this.vwr.refresh(3, "minimize:done" + (failed ? " EXPLODED" : "OK"));
        }
        Logger.info("minimize:  " + this.id + " endMinimization complete");
    }

    private void saveCoordinates() {
        if (this.coordSaved == null) {
            this.coordSaved = new double[this.ac][3];
        }
        for (int i = 0; i < this.ac; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.coordSaved[i][j] = this.minAtoms[i].coord[j];
            }
        }
    }

    private void restoreCoordinates() {
        if (this.coordSaved == null) {
            return;
        }
        for (int i = 0; i < this.ac; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.minAtoms[i].coord[j] = this.coordSaved[i][j];
            }
        }
        this.updateAtomXYZ(true);
    }

    public void stopMinimization(boolean coordAreOK) {
        if (!this.minimizing) {
            return;
        }
        if (coordAreOK) {
            this.endMinimization(false);
        } else {
            this.restoreCoordinates();
        }
        this.setMinimizationOn(false);
    }

    public void updateAtomXYZ(boolean isEnd) {
        if (this.steps <= 0 || this.pFF != null && this.pFF.getCurrentStep() == 0) {
            return;
        }
        if (!this.modelkitMinimizing) {
            for (int i = 0; i < this.ac; ++i) {
                MinAtom minAtom = this.minAtoms[i];
                if (this.bsFixed != null && this.bsFixed.get(minAtom.atom.i)) continue;
                minAtom.atom.set((float)minAtom.coord[0], (float)minAtom.coord[1], (float)minAtom.coord[2]);
            }
            isEnd = true;
        } else {
            Atom a;
            int i;
            boolean doUpdateMinAtoms = false;
            MinAtom minAtom = this.minAtoms[0];
            for (i = 0; i < this.ac; ++i) {
                minAtom = this.minAtoms[i];
                if (this.bsMinFixed != null && this.bsMinFixed.get(i)) continue;
                a = minAtom.atom;
                this.p.set((float)minAtom.coord[0], (float)minAtom.coord[1], (float)minAtom.coord[2]);
                if (this.vwr.getModelkit(false).moveMinConstrained(a.i, this.p, this.bsAtoms) <= 0) continue;
                doUpdateMinAtoms = true;
            }
            if (doUpdateMinAtoms) {
                for (i = 0; i < this.ac; ++i) {
                    minAtom = this.minAtoms[i];
                    a = minAtom.atom;
                    minAtom.coord[0] = a.x;
                    minAtom.coord[1] = a.y;
                    minAtom.coord[2] = a.z;
                }
            }
            this.vwr.getModelkit(false).minimizeEnd(this.bsBasis, isEnd);
        }
        if (isEnd) {
            this.vwr.refreshMeasures(false);
        }
    }

    private void minimizeWithoutThread() {
        if (!this.startMinimization()) {
            return;
        }
        while (this.stepMinimization()) {
        }
        this.endMinimization(true);
    }

    public void report(String msg, boolean isEcho) {
        if (this.isSilent) {
            Logger.info(msg);
        } else if (isEcho) {
            this.vwr.showString(msg, false);
        } else {
            this.vwr.scriptEcho(msg);
        }
    }

    public void calculatePartialCharges(ModelSet ms, BS bsAtoms, BS bsReport) throws JmolAsyncException {
        ForceFieldMMFF ff = new ForceFieldMMFF(this, false);
        ff.setArrays(ms.at, bsAtoms, ms.bo, ms.bondCount, true, true);
        this.vwr.setAtomProperty(bsAtoms, 1086326785, 0, 0.0f, null, null, ff.getAtomTypeDescriptions());
        this.vwr.setAtomProperty(bsReport == null ? bsAtoms : bsReport, 1111492619, 0, 0.0f, null, ff.getPartialCharges(), null);
    }

    public String getForceFieldUsed() {
        return this.pFF == null ? null : this.pFF.name;
    }

    public Boolean isLoggable(int[] iData, int n) {
        if (this.bsBasis == null) {
            return Boolean.TRUE;
        }
        if (iData == null) {
            return this.bsBasis.get(this.minAtoms[n].atom.i) ? Boolean.TRUE : Boolean.FALSE;
        }
        for (int i = 0; i < n; ++i) {
            if (!this.bsBasis.get(this.minAtoms[iData[i]].atom.i)) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public String toString() {
        return "[minimizer " + this.id + " step " + (this.pFF == null ? 0 : this.pFF.getCurrentStep()) + " atoms=" + this.ac + "]";
    }
}

