/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Properties;
import javajs.util.SB;
import org.jmol.api.Translator;

public abstract class PopupResource {
    protected Properties structure = new Properties();
    protected Properties words = new Properties();

    public abstract String getMenuName();

    protected PopupResource(String menuStructure, Properties menuText) {
        this.buildStructure(menuStructure);
        this.localize(menuStructure != null, menuText);
    }

    protected abstract String[] getWordContents();

    protected abstract void buildStructure(String var1);

    String getStructure(String key) {
        return this.structure.getProperty(key);
    }

    String getWord(String key) {
        String str = this.words.getProperty(key);
        return str == null ? key : str;
    }

    protected void setStructure(String slist, Translator gt) {
        BufferedReader br = new BufferedReader(new StringReader(slist));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                int pt = line.indexOf("=");
                if (pt < 0) {
                    pt = line.length();
                    line = line + "=";
                }
                String name = line.substring(0, pt).trim();
                String value = line.substring(pt + 1).trim();
                String label = null;
                pt = name.indexOf("|");
                if (pt >= 0) {
                    label = name.substring(pt + 1).trim();
                    name = name.substring(0, pt).trim();
                }
                if (name.length() == 0) continue;
                if (value.length() > 0) {
                    this.structure.setProperty(name, value);
                }
                if (label == null || label.length() <= 0) continue;
                this.words.setProperty(name, gt == null ? label : gt.translate(label));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addItems(String[][] itemPairs) {
        String previous = "";
        for (int i = 0; i < itemPairs.length; ++i) {
            String[] pair = itemPairs[i];
            String str = pair[1];
            if (str == null) {
                str = previous;
            }
            previous = str;
            this.structure.setProperty(pair[0], str);
        }
    }

    private void localize(boolean haveUserMenu, Properties menuText) {
        String[] wordContents = this.getWordContents();
        for (int i = 0; i < wordContents.length; ++i) {
            String item;
            String word;
            if ((word = this.words.getProperty(item = wordContents[i++])) == null) {
                word = wordContents[i];
            }
            this.words.setProperty(item, word);
            if (menuText == null || item.indexOf("Text") < 0) continue;
            menuText.setProperty(item, word);
        }
    }

    public abstract String getMenuAsText(String var1);

    protected String getStuctureAsText(String title, String[][] menuContents, String[][] structureContents) {
        return "# " + this.getMenuName() + ".mnu " + title + "\n\n# Part I -- Menu Structure\n# ------------------------\n\n" + this.dumpStructure(menuContents) + "\n\n# Part II -- Key Definitions\n# --------------------------\n\n" + this.dumpStructure(structureContents) + "\n\n# Part III -- Word Translations\n# -----------------------------\n\n" + this.dumpWords();
    }

    private String dumpWords() {
        String[] wordContents = this.getWordContents();
        SB s = new SB();
        for (int i = 0; i < wordContents.length; ++i) {
            String key;
            if (this.structure.getProperty(key = wordContents[i++]) != null) continue;
            s.append(key).append(" | ").append(wordContents[i]).appendC('\n');
        }
        return s.toString();
    }

    private String dumpStructure(String[][] items) {
        String previous = "";
        SB s = new SB();
        for (int i = 0; i < items.length; ++i) {
            String key = items[i][0];
            String label = this.words.getProperty(key);
            if (label != null) {
                key = key + " | " + label;
            }
            s.append(key).append(" = ").append(items[i][1] == null ? previous : items[i][1]).appendC('\n');
        }
        return s.toString();
    }
}

