/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.Interface;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.Rdr;
import javajs.util.SB;
import jspecview.api.JSVZipReader;
import jspecview.api.SourceReader;
import jspecview.common.Coordinate;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PeakInfo;
import jspecview.common.Spectrum;
import jspecview.exception.JSVException;
import jspecview.source.BrukerReader;
import jspecview.source.JDXDataObject;
import jspecview.source.JDXDecompressor;
import jspecview.source.JDXHeader;
import jspecview.source.JDXSource;
import jspecview.source.JDXSourceStreamTokenizer;
import org.jmol.api.GenericFileInterface;
import org.jmol.api.JmolJDXMOLParser;
import org.jmol.api.JmolJDXMOLReader;
import org.jmol.util.Logger;

public class JDXReader
implements JmolJDXMOLReader {
    private static final String[] VAR_LIST_TABLE = new String[]{"PEAKTABLE   XYDATA      XYPOINTS", " (XY..XY)    (X++(Y..Y)) (XY..XY)    "};
    static final String ERROR_SEPARATOR = "=====================\n";
    private float nmrMaxY = Float.NaN;
    private JDXSource source;
    private JDXSourceStreamTokenizer t;
    private SB errorLog;
    private boolean obscure;
    private boolean done;
    private boolean isZipFile;
    private String filePath;
    private boolean loadImaginary = true;
    private boolean isSimulation;
    private boolean ignoreShiftReference;
    private boolean ignorePeakTables;
    String lastErrPath = null;
    private boolean isTabularData;
    private int firstSpec = 0;
    private int lastSpec = 0;
    private int nSpec = 0;
    private double blockID;
    private JmolJDXMOLParser mpr;
    private BufferedReader reader;
    private Spectrum modelSpectrum;
    private Lst<String[]> acdAssignments;
    private String acdMolFile;
    private Lst<PeakInfo> peakData;

    public static String getVarList(String dataClass) {
        int index = VAR_LIST_TABLE[0].indexOf(dataClass);
        return VAR_LIST_TABLE[1].substring(index + 1, index + 12).trim();
    }

    private JDXReader(String filePath, boolean obscure, boolean loadImaginary, int iSpecFirst, int iSpecLast, float nmrNormalization) {
        filePath = PT.trimQuotes(filePath);
        boolean bl = this.isSimulation = filePath != null && filePath.startsWith("http://SIMULATION/");
        if (this.isSimulation) {
            this.nmrMaxY = Float.isNaN(nmrNormalization) ? 10000.0f : nmrNormalization;
        }
        this.filePath = filePath;
        this.obscure = obscure;
        this.firstSpec = iSpecFirst;
        this.lastSpec = iSpecLast;
        this.loadImaginary = loadImaginary;
    }

    public static JDXSource createJDXSourceFromStream(InputStream in, boolean obscure, boolean loadImaginary, float nmrMaxY) throws Exception {
        return JDXReader.createJDXSource(null, in, "stream", obscure, loadImaginary, -1, -1, nmrMaxY);
    }

    public static Map<String, String> getHeaderMap(InputStream in, Map<String, String> map) throws Exception {
        return JDXReader.getHeaderMapS(in, map, null);
    }

    public static Map<String, String> getHeaderMapS(InputStream in, Map<String, String> map, String suffix) throws Exception {
        if (map == null) {
            map = new LinkedHashMap<String, String>();
        }
        Lst hlist = JDXReader.createJDXSource(null, (Object)in, null, (boolean)false, (boolean)false, (int)0, (int)-1, (float)0.0f).getJDXSpectrum((int)0).headerTable;
        int n = hlist.size();
        for (int i = 0; i < n; ++i) {
            String[] h = (String[])hlist.get(i);
            map.put(suffix == null ? h[2] : h[2] + suffix, h[1]);
        }
        return map;
    }

    public static JDXSource createJDXSource(GenericFileInterface file, Object in, String filePath, boolean obscure, boolean loadImaginary, int iSpecFirst, int iSpecLast, float nmrMaxY) throws Exception {
        BufferedReader br;
        boolean isHeaderOnly = iSpecLast < iSpecFirst;
        String data = null;
        byte[] bytes = null;
        if (AU.isAB(in) && Rdr.isZipB(bytes = (byte[])in)) {
            return JDXReader.readBrukerFileZip(bytes, file == null ? filePath : file.getFullPath());
        }
        if (in instanceof String || bytes != null) {
            if (in instanceof String) {
                data = (String)in;
            }
            br = JSVFileManager.getBufferedReaderForStringOrBytes(in);
        } else {
            br = in instanceof InputStream ? JSVFileManager.getBufferedReaderForInputStream((InputStream)in) : (BufferedReader)in;
        }
        String header = null;
        JDXSource source = null;
        try {
            if (br == null) {
                if (file != null && file.isDirectory()) {
                    return JDXReader.readBrukerFileDir(file.getFullPath());
                }
                br = JSVFileManager.getBufferedReaderFromName(filePath);
            }
            if (!isHeaderOnly) {
                br.mark(400);
                char[] chs = new char[400];
                br.read(chs, 0, 400);
                br.reset();
                header = new String(chs);
                if (header.startsWith("PK")) {
                    br.close();
                    return JDXReader.readBrukerFileZip(null, file.getFullPath());
                }
                if (header.indexOf(0) >= 0 || header.indexOf("##TITLE= Parameter file") == 0 || header.indexOf("##TITLE= Audit trail") == 0) {
                    br.close();
                    return JDXReader.readBrukerFileDir(file.getParentAsFile().getFullPath());
                }
                int pt1 = header.indexOf(35);
                int pt2 = header.indexOf(60);
                if (pt1 < 0 || pt2 >= 0 && pt2 < pt1) {
                    String xmlType = header.toLowerCase();
                    String string = xmlType.contains("<animl") || xmlType.contains("<!doctype technique") ? "AnIML" : (xmlType.contains("xml-cml") ? "CML" : (xmlType = xmlType.contains("<nmrml") ? "NMRML" : null));
                    if (xmlType == null) {
                        return JDXReader.readBrukerFileDir(file.getFullPath());
                    }
                    source = ((SourceReader)JSViewer.getInterface("jspecview.source." + xmlType + "Reader")).getSource(filePath, br);
                    br.close();
                    if (source == null) {
                        Logger.error(header + "...");
                        throw new JSVException("File type not recognized");
                    }
                }
            }
            if (source == null) {
                source = new JDXReader(filePath, obscure, loadImaginary, iSpecFirst, iSpecLast, nmrMaxY).getJDXSource(br, isHeaderOnly);
            }
            if (data != null) {
                source.setInlineData(data);
            }
            return source;
        }
        catch (Exception e) {
            if (!JSViewer.isJS) {
                e.printStackTrace();
            }
            if (br != null) {
                br.close();
            }
            if (header != null) {
                Logger.error(header + "...");
            }
            String s = e.getMessage();
            throw new JSVException("Error reading data: " + s);
        }
    }

    private static JDXSource readBrukerFileDir(String filePath) throws FileNotFoundException, Exception {
        return ((BrukerReader)Interface.getInterface("jspecview.source.BrukerReader")).readBrukerDir(filePath);
    }

    private static JDXSource readBrukerFileZip(byte[] bytes, String filePath) throws FileNotFoundException, Exception {
        return ((BrukerReader)Interface.getInterface("jspecview.source.BrukerReader")).readBrukerZip(bytes, filePath);
    }

    private JDXSource getJDXSource(Object reader, boolean isHeaderOnly) throws JSVException {
        this.source = new JDXSource(0, this.filePath);
        this.isZipFile = reader instanceof JSVZipReader;
        this.t = new JDXSourceStreamTokenizer((BufferedReader)reader);
        this.errorLog = new SB();
        String label = null;
        String value = null;
        boolean isOK = false;
        while (!this.done && "##TITLE".equals(this.t.peakLabel())) {
            isOK = true;
            if (label != null && !this.isZipFile) {
                this.logError("Warning - file is a concatenation without LINK record -- does not conform to JCAMP-DX standard 6.1.3!");
            }
            Spectrum spectrum = new Spectrum();
            Lst<String[]> dataLDRTable = new Lst<String[]>();
            if (isHeaderOnly) {
                spectrum.setHeaderTable(dataLDRTable);
            }
            while (!this.done && (label = this.t.getLabel()) != null && (value = this.getValue(label)) != null) {
                if (this.isTabularData) {
                    this.processTabularData(spectrum, dataLDRTable, label, isHeaderOnly);
                    this.addSpectrum(spectrum, false);
                    if (this.isSimulation && spectrum.getXUnits().equals("PPM")) {
                        spectrum.setHZtoPPM(true);
                    }
                    spectrum = null;
                    if (!isHeaderOnly) continue;
                    JDXReader.addHeader(dataLDRTable, this.t.rawLabel, "<data>");
                    break;
                }
                if (!isHeaderOnly) {
                    if (label.equals("##DATATYPE") && value.toUpperCase().equals("LINK")) {
                        this.getBlockSpectra(dataLDRTable);
                        spectrum = null;
                        continue;
                    }
                    if (label.equals("##NTUPLES") || label.equals("##VARNAME")) {
                        this.getNTupleSpectra(dataLDRTable, spectrum, label);
                        spectrum = null;
                        continue;
                    }
                }
                if (label.equals("##JCAMPDX")) {
                    this.setVenderSpecificValues(this.t.rawLine);
                }
                if (spectrum == null) {
                    spectrum = new Spectrum();
                }
                this.processLabel(spectrum, dataLDRTable, label, value, isHeaderOnly);
            }
            if (!isHeaderOnly || spectrum == null) continue;
            this.addSpectrum(spectrum, false);
        }
        if (!isOK) {
            throw new JSVException("##TITLE record not found");
        }
        this.source.setErrorLog(this.errorLog.toString());
        return this.source;
    }

    private void processLabel(Spectrum spectrum, Lst<String[]> dataLDRTable, String label, String value, boolean isHeaderOnly) throws JSVException {
        if (!this.readDataLabel(spectrum, label, value, this.errorLog, this.obscure, isHeaderOnly) && !isHeaderOnly) {
            return;
        }
        JDXReader.addHeader(dataLDRTable, this.t.rawLabel, value);
        if (!isHeaderOnly) {
            this.checkCustomTags(spectrum, label, value);
        }
    }

    private void logError(String err) {
        this.errorLog.append(this.filePath == null || this.filePath.equals(this.lastErrPath) ? "" : this.filePath).append("\n").append(err).append("\n");
        this.lastErrPath = this.filePath;
    }

    private void setVenderSpecificValues(String rawLine) {
        if (rawLine.indexOf("JEOL") >= 0) {
            System.out.println("Skipping ##SHIFTREFERENCE for JEOL " + rawLine);
            this.ignoreShiftReference = true;
        }
        if (rawLine.indexOf("MestReNova") >= 0) {
            this.ignorePeakTables = true;
        }
    }

    private String getValue(String label) {
        String value = this.isTabularDataLabel(label) ? "" : this.t.getValue();
        return "##END".equals(label) ? null : value;
    }

    private boolean isTabularDataLabel(String label) {
        this.isTabularData = "##DATATABLE##PEAKTABLE##XYDATA##XYPOINTS#".indexOf(label + "#") >= 0;
        return this.isTabularData;
    }

    private boolean addSpectrum(Spectrum spectrum, boolean forceSub) {
        if (!this.loadImaginary && spectrum.isImaginary()) {
            Logger.info("FileReader skipping imaginary spectrum -- use LOADIMAGINARY TRUE to load this spectrum.");
            return true;
        }
        if (this.acdAssignments != null) {
            if (!spectrum.dataType.equals("MASS SPECTRUM") && !spectrum.isContinuous()) {
                Logger.info("Skipping ACD Labs line spectrum for " + spectrum);
                return true;
            }
            if (this.acdAssignments.size() > 0) {
                try {
                    this.mpr.setACDAssignments(spectrum.title, spectrum.getTypeLabel(), this.source.peakCount, this.acdAssignments, this.acdMolFile);
                }
                catch (Exception e) {
                    Logger.info("Failed to create peak data: " + e);
                }
            }
            if (this.acdMolFile != null) {
                JSVFileManager.cachePut("mol", this.acdMolFile);
            }
        }
        if (!Float.isNaN(this.nmrMaxY)) {
            spectrum.normalizeSimulation(this.nmrMaxY);
        } else if (spectrum.getMaxY() >= 10000.0) {
            spectrum.normalizeSimulation(1000.0);
        }
        if (this.isSimulation) {
            spectrum.setSimulated(this.filePath);
        }
        ++this.nSpec;
        if (this.firstSpec > 0 && this.nSpec < this.firstSpec) {
            return true;
        }
        if (this.lastSpec > 0 && this.nSpec > this.lastSpec) {
            this.done = true;
            return !true;
        }
        spectrum.setBlockID(this.blockID);
        this.source.addJDXSpectrum(null, spectrum, forceSub);
        return true;
    }

    private JDXSource getBlockSpectra(Lst<String[]> sourceLDRTable) throws JSVException {
        Logger.debug("--JDX block start--");
        String label = "";
        String value = null;
        boolean isNew = this.source.type == 0;
        boolean forceSub = false;
        while ((label = this.t.getLabel()) != null && !label.equals("##TITLE")) {
            int nBlocks;
            value = this.getValue(label);
            if (isNew && !JDXReader.readHeaderLabel(this.source, label, value, this.errorLog, this.obscure)) {
                JDXReader.addHeader(sourceLDRTable, this.t.rawLabel, value);
            }
            if (!label.equals("##BLOCKS") || (nBlocks = PT.parseInt(value)) <= 100 || this.firstSpec > 0) continue;
            forceSub = true;
        }
        value = this.getValue(label);
        if (!"##TITLE".equals(label)) {
            throw new JSVException("Unable to read block source");
        }
        if (isNew) {
            this.source.setHeaderTable(sourceLDRTable);
        }
        this.source.type = 1;
        this.source.isCompoundSource = true;
        Spectrum spectrum = new Spectrum();
        Lst<Object> dataLDRTable = new Lst<String[]>();
        this.readDataLabel(spectrum, label, value, this.errorLog, this.obscure, false);
        try {
            String tmp;
            while ((tmp = this.t.getLabel()) != null) {
                value = this.getValue(tmp);
                if (value == null && "##END".equals(label)) {
                    Logger.debug("##END= " + this.t.getValue());
                } else {
                    label = tmp;
                    if (this.isTabularData) {
                        this.processTabularData(spectrum, dataLDRTable, label, false);
                        continue;
                    }
                    if (label.equals("##DATATYPE")) {
                        if (value.toUpperCase().equals("LINK")) {
                            this.getBlockSpectra(dataLDRTable);
                            spectrum = null;
                            label = null;
                        } else if (value.toUpperCase().startsWith("NMR PEAK") && this.ignorePeakTables) {
                            this.done = true;
                            return this.source;
                        }
                    } else if (label.equals("##NTUPLES") || label.equals("##VARNAME")) {
                        this.getNTupleSpectra(dataLDRTable, spectrum, label);
                        spectrum = null;
                        label = "";
                    }
                    if (!this.done) {
                        if (spectrum == null) {
                            spectrum = new Spectrum();
                            dataLDRTable = new Lst();
                            if (label == "") continue;
                            if (label == null) {
                                label = "##END";
                                continue;
                            }
                        }
                        if (value == null) {
                            if (spectrum.getXYCoords().length > 0 && !this.addSpectrum(spectrum, forceSub)) {
                                return this.source;
                            }
                            spectrum = new Spectrum();
                            dataLDRTable = new Lst();
                            continue;
                        }
                        this.processLabel(spectrum, dataLDRTable, label, value, false);
                        continue;
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            if (!JSViewer.isJS) {
                e.printStackTrace();
            }
            throw new JSVException(e.getMessage());
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.debug("--JDX block end--");
        return this.source;
    }

    private void addErrorLogSeparator() {
        if (this.errorLog.length() > 0 && this.errorLog.lastIndexOf(ERROR_SEPARATOR) != this.errorLog.length() - ERROR_SEPARATOR.length()) {
            this.logError(ERROR_SEPARATOR);
        }
    }

    private JDXSource getNTupleSpectra(Lst<String[]> sourceLDRTable, JDXDataObject spectrum0, String label) throws JSVException {
        boolean isNew;
        boolean isVARNAME;
        double[] minMaxY = new double[]{Double.MAX_VALUE, Double.MIN_VALUE};
        this.blockID = Math.random();
        boolean isOK = true;
        if (this.firstSpec > 0) {
            spectrum0.setNumDim(1);
        }
        if (!(isVARNAME = label.equals("##VARNAME"))) {
            label = "";
        }
        Hashtable<String, Lst<String>> nTupleTable = new Hashtable<String, Lst<String>>();
        String[] plotSymbols = new String[2];
        boolean bl = isNew = this.source.type == 0;
        if (isNew) {
            this.source.type = 2;
            this.source.isCompoundSource = true;
            this.source.setHeaderTable(sourceLDRTable);
        }
        while (!(label = isVARNAME ? label : this.t.getLabel()).equals("##PAGE")) {
            isVARNAME = false;
            StringTokenizer st = new StringTokenizer(this.t.getValue(), ",");
            Lst<String> attrList = new Lst<String>();
            while (st.hasMoreTokens()) {
                attrList.addLast(st.nextToken().trim());
            }
            nTupleTable.put(label, attrList);
        }
        Lst symbols = (Lst)nTupleTable.get("##SYMBOL");
        if (!label.equals("##PAGE")) {
            throw new JSVException("Error Reading NTuple Source");
        }
        String page = this.t.getValue();
        Spectrum spectrum = null;
        boolean isFirst = true;
        while (!this.done) {
            int i;
            label = this.t.getLabel();
            if (label.equals("##ENDNTUPLES")) {
                this.t.getValue();
                break;
            }
            if (label.equals("##PAGE")) {
                page = this.t.getValue();
                continue;
            }
            if (spectrum == null) {
                int pt;
                spectrum = new Spectrum();
                spectrum0.copyTo(spectrum);
                spectrum.setTitle(spectrum0.getTitle());
                if (!spectrum.is1D() && (pt = page.indexOf(61)) >= 0) {
                    try {
                        spectrum.setY2D(this.parseAFFN(page.substring(0, pt), page.substring(pt + 1).trim()));
                        String y2dUnits = page.substring(0, pt).trim();
                        int i2 = symbols.indexOf(y2dUnits);
                        if (i2 >= 0) {
                            spectrum.setY2DUnits((String)((Lst)nTupleTable.get("##UNITS")).get(i2));
                        }
                    }
                    catch (Exception y2dUnits) {
                        // empty catch block
                    }
                }
            }
            Lst<String[]> dataLDRTable = new Lst<String[]>();
            spectrum.setHeaderTable(dataLDRTable);
            while (!label.equals("##DATATABLE")) {
                JDXReader.addHeader(dataLDRTable, this.t.rawLabel, this.t.getValue());
                label = this.t.getLabel();
            }
            boolean continuous = true;
            String line = this.t.flushLine();
            if (line.trim().indexOf("PEAKS") > 0) {
                continuous = false;
            }
            int index1 = line.indexOf(40);
            int index2 = line.lastIndexOf(41);
            if (index1 == -1 || index2 == -1) {
                throw new JSVException("Variable List not Found");
            }
            String varList = line.substring(index1, index2 + 1);
            int countSyms = 0;
            for (i = 0; i < symbols.size(); ++i) {
                String sym = ((String)symbols.get(i)).trim();
                if (varList.indexOf(sym) != -1) {
                    plotSymbols[countSyms++] = sym;
                }
                if (countSyms == 2) break;
            }
            this.setTabularDataType(spectrum, "##" + (continuous ? "XYDATA" : "PEAKTABLE"));
            if (!this.readNTUPLECoords(spectrum, nTupleTable, plotSymbols, minMaxY)) {
                throw new JSVException("Unable to read Ntuple Source");
            }
            if (!spectrum.nucleusX.equals("?")) {
                spectrum0.nucleusX = spectrum.nucleusX;
            }
            spectrum0.nucleusY = spectrum.nucleusY;
            spectrum0.freq2dX = spectrum.freq2dX;
            spectrum0.freq2dY = spectrum.freq2dY;
            spectrum0.y2DUnits = spectrum.y2DUnits;
            for (i = 0; i < sourceLDRTable.size(); ++i) {
                String[] entry = (String[])sourceLDRTable.get(i);
                String key = JDXSourceStreamTokenizer.cleanLabel(entry[0]);
                if (key.equals("##TITLE") || key.equals("##DATACLASS") || key.equals("##NTUPLES")) continue;
                dataLDRTable.addLast(entry);
            }
            if (isOK) {
                this.addSpectrum(spectrum, !isFirst);
            }
            isFirst = false;
            spectrum = null;
        }
        this.addErrorLogSeparator();
        this.source.setErrorLog(this.errorLog.toString());
        Logger.info("NTUPLE MIN/MAX Y = " + minMaxY[0] + " " + minMaxY[1]);
        return this.source;
    }

    private boolean readDataLabel(JDXDataObject spectrum, String label, String value, SB errorLog, boolean obscure, boolean isHeaderOnly) {
        if (!JDXReader.readHeaderLabel(spectrum, label, value, errorLog, obscure)) {
            return false;
        }
        if ("##MINX ##MINY ##MAXX ##MAXY ##FIRSTY ##DELTAX ##DATACLASS ".indexOf(label = label + " ") >= 0) {
            return false;
        }
        switch ("##FIRSTX  ##LASTX   ##NPOINTS ##XFACTOR ##YFACTOR ##XUNITS  ##YUNITS  ##XLABEL  ##YLABEL  ##NUMDIM  ##OFFSET  ".indexOf(label)) {
            case 0: {
                spectrum.fileFirstX = this.parseAFFN(label, value);
                return false;
            }
            case 10: {
                spectrum.fileLastX = this.parseAFFN(label, value);
                return false;
            }
            case 20: {
                spectrum.fileNPoints = Integer.parseInt(value);
                return false;
            }
            case 30: {
                spectrum.setXFactor(this.parseAFFN(label, value));
                return false;
            }
            case 40: {
                spectrum.yFactor = this.parseAFFN(label, value);
                return false;
            }
            case 50: {
                spectrum.setXUnits(value);
                return false;
            }
            case 60: {
                spectrum.setYUnits(value);
                return false;
            }
            case 70: {
                spectrum.setXLabel(value);
                return true;
            }
            case 80: {
                spectrum.setYLabel(value);
                return true;
            }
            case 90: {
                spectrum.setNumDim(Integer.parseInt(value));
                return false;
            }
            case 100: {
                if (!spectrum.isShiftTypeSpecified()) {
                    spectrum.setShiftReference(this.parseAFFN(label, value), 1, 1);
                }
                return false;
            }
        }
        if (label.length() < 17) {
            return true;
        }
        if (label.equals("##.OBSERVEFREQUENCY ")) {
            spectrum.setObservedFreq(this.parseAFFN(label, value));
            return false;
        }
        if (label.equals("##.OBSERVENUCLEUS ")) {
            spectrum.setObservedNucleus(value);
            return false;
        }
        if (label.equals("##$REFERENCEPOINT ") && !spectrum.isShiftTypeSpecified()) {
            int pt = value.indexOf(" ");
            if (pt > 0) {
                value = value.substring(0, pt);
            }
            spectrum.setShiftReference(this.parseAFFN(label, value), 1, 2);
            return false;
        }
        if (label.equals("##.SHIFTREFERENCE ")) {
            if (this.ignoreShiftReference || !spectrum.dataType.toUpperCase().contains("SPECTRUM")) {
                return false;
            }
            StringTokenizer srt = new StringTokenizer(value = PT.replaceAllCharacters(value, ")(", ""), ",");
            if (srt.countTokens() != 4) {
                return false;
            }
            try {
                srt.nextToken();
                srt.nextToken();
                int pt = (int)Float.parseFloat(srt.nextToken().trim());
                double shift = this.parseAFFN(label, srt.nextToken().trim());
                spectrum.setShiftReference(shift, pt, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private static boolean readHeaderLabel(JDXHeader jdxHeader, String label, String value, SB errorLog, boolean obscure) {
        switch ("##TITLE#####JCAMPDX###ORIGIN####OWNER#####DATATYPE##LONGDATE##DATE######TIME####".indexOf(label + "#")) {
            case 0: {
                jdxHeader.setTitle(obscure || value == null || value.equals("") ? "Unknown" : value);
                return false;
            }
            case 10: {
                jdxHeader.jcampdx = value;
                float version = PT.parseFloat(value);
                if ((version >= 6.0f || Float.isNaN(version)) && errorLog != null) {
                    errorLog.append("Warning: JCAMP-DX version may not be fully supported: " + value);
                }
                return false;
            }
            case 20: {
                jdxHeader.origin = value != null && !value.equals("") ? value : "Unknown";
                return false;
            }
            case 30: {
                jdxHeader.owner = value != null && !value.equals("") ? value : "Unknown";
                return false;
            }
            case 40: {
                jdxHeader.dataType = value;
                return false;
            }
            case 50: {
                jdxHeader.longDate = value;
                return false;
            }
            case 60: {
                jdxHeader.date = value;
                return false;
            }
            case 70: {
                jdxHeader.time = value;
                return false;
            }
        }
        return true;
    }

    private void setTabularDataType(JDXDataObject spectrum, String label) {
        if (label.equals("##PEAKASSIGNMENTS")) {
            spectrum.setDataClass("PEAKASSIGNMENTS");
        } else if (label.equals("##PEAKTABLE")) {
            spectrum.setDataClass("PEAKTABLE");
        } else if (label.equals("##XYDATA")) {
            spectrum.setDataClass("XYDATA");
        } else if (label.equals("##XYPOINTS")) {
            spectrum.setDataClass("XYPOINTS");
        }
    }

    private void processTabularData(JDXDataObject spec, Lst<String[]> table, String label, boolean isHeaderOnly) throws JSVException {
        this.setTabularDataType(spec, label);
        spec.setHeaderTable(table);
        if (spec.dataClass.equals("XYDATA")) {
            spec.checkJDXRequiredTokens();
            if (!isHeaderOnly) {
                this.decompressData(spec, null);
            }
            return;
        }
        if (spec.dataClass.equals("PEAKTABLE") || spec.dataClass.equals("XYPOINTS")) {
            Coordinate[] xyCoords;
            spec.setContinuous(spec.dataClass.equals("XYPOINTS"));
            try {
                this.t.readLineTrimmed();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (spec.xFactor != Double.MAX_VALUE && spec.yFactor != Double.MAX_VALUE) {
                String data = this.t.getValue();
                xyCoords = Coordinate.parseDSV(data, spec.xFactor, spec.yFactor);
            } else {
                xyCoords = Coordinate.parseDSV(this.t.getValue(), 1.0, 1.0);
            }
            spec.setXYCoords(xyCoords);
            double fileDeltaX = Coordinate.deltaX(xyCoords[xyCoords.length - 1].getXVal(), xyCoords[0].getXVal(), xyCoords.length);
            spec.setIncreasing(fileDeltaX > 0.0);
            return;
        }
        throw new JSVException("Unable to read JDX file tabular data for line " + this.t.labelLineNo);
    }

    private boolean readNTUPLECoords(JDXDataObject spec, Map<String, Lst<String>> nTupleTable, String[] plotSymbols, double[] minMaxY) {
        if (spec.dataClass.equals("XYDATA")) {
            Lst<String> list = nTupleTable.get("##SYMBOL");
            int index1 = list.indexOf(plotSymbols[0]);
            int index2 = list.indexOf(plotSymbols[1]);
            list = nTupleTable.get("##VARNAME");
            spec.setVarName(((String)list.get(index2)).toUpperCase());
            String label = "##FACTOR";
            list = nTupleTable.get("##FACTOR");
            spec.setXFactor(this.parseAFFN(label, (String)list.get(index1)));
            spec.setYFactor(this.parseAFFN(label, (String)list.get(index2)));
            label = "##LAST";
            list = nTupleTable.get("##LAST");
            spec.fileLastX = this.parseAFFN(label, (String)list.get(index1));
            label = "##FIRST";
            list = nTupleTable.get("##FIRST");
            spec.fileFirstX = this.parseAFFN(label, (String)list.get(index1));
            list = nTupleTable.get("##VARDIM");
            spec.fileNPoints = Integer.parseInt((String)list.get(index1));
            list = nTupleTable.get("##UNITS");
            spec.setXUnits((String)list.get(index1));
            spec.setYUnits((String)list.get(index2));
            if (spec.nucleusX == null && (list = nTupleTable.get("##.NUCLEUS")) != null) {
                spec.setNucleusAndFreq((String)list.get(0), false);
                spec.setNucleusAndFreq((String)list.get(index1), true);
            } else if (spec.nucleusX == null) {
                spec.nucleusX = "?";
            }
            this.decompressData(spec, minMaxY);
            return true;
        }
        if (spec.dataClass.equals("PEAKTABLE") || spec.dataClass.equals("XYPOINTS")) {
            spec.setContinuous(spec.dataClass.equals("XYPOINTS"));
            Lst<String> list = nTupleTable.get("##SYMBOL");
            int index1 = list.indexOf(plotSymbols[0]);
            int index2 = list.indexOf(plotSymbols[1]);
            list = nTupleTable.get("##UNITS");
            spec.setXUnits((String)list.get(index1));
            spec.setYUnits((String)list.get(index2));
            spec.setXYCoords(Coordinate.parseDSV(this.t.getValue(), spec.xFactor, spec.yFactor));
            return true;
        }
        return false;
    }

    private double parseAFFN(String label, String val) {
        int pt = val.indexOf("E");
        if (pt > 0) {
            int len = val.length();
            switch (len - pt) {
                case 2: 
                case 3: {
                    this.logError("Warning - " + label + " value " + val + " is not of the format xxxE[+/-]nn or xxxE[+/-]nnn (spec. 4.5.3) -- warning only; accepted");
                    break;
                }
                case 4: 
                case 5: {
                    char ch = val.charAt(pt + 1);
                    if (ch == '+' || ch == '-') break;
                }
                default: {
                    this.logError("Error - " + label + " value " + val + " is not of the format xxxE[+/-]nn or xxxE[+/-]nnn (spec. 4.5.3) -- " + val.substring(pt) + " ignored!");
                    val = val.substring(0, pt);
                }
            }
        }
        return Double.parseDouble(val);
    }

    private void decompressData(JDXDataObject spec, double[] minMaxY) {
        int errPt = this.errorLog.length();
        spec.setIncreasing(spec.fileLastX > spec.fileFirstX);
        spec.setContinuous(true);
        JDXDecompressor decompressor = new JDXDecompressor(this.t, spec.fileFirstX, spec.fileLastX, spec.xFactor, spec.yFactor, spec.fileNPoints);
        long t = System.currentTimeMillis();
        Coordinate[] xyCoords = decompressor.decompressData(this.errorLog);
        if (Logger.debugging) {
            Logger.debug("decompression time = " + (System.currentTimeMillis() - t) + " ms");
        }
        spec.setXYCoords(xyCoords);
        double d = decompressor.getMinY();
        if (minMaxY != null) {
            if (d < minMaxY[0]) {
                minMaxY[0] = d;
            }
            if ((d = decompressor.getMaxY()) > minMaxY[1]) {
                minMaxY[1] = d;
            }
        }
        spec.finalizeCoordinates();
        if (this.errorLog.length() != errPt) {
            double fileDeltaX = Coordinate.deltaX(spec.fileLastX, spec.fileFirstX, spec.fileNPoints);
            this.logError(spec.getTitle());
            this.logError("firstX from Header " + spec.fileFirstX);
            this.logError("lastX from Header " + spec.fileLastX + " Found " + decompressor.lastX);
            this.logError("deltaX from Header " + fileDeltaX);
            this.logError("Number of points in Header " + spec.fileNPoints + " Found " + decompressor.getNPointsFound());
        }
        if (Logger.debugging) {
            System.err.println(this.errorLog.toString());
        }
    }

    public static void addHeader(Lst<String[]> table, String label, String value) {
        String[] entry = null;
        for (int i = 0; i < table.size(); ++i) {
            entry = (String[])table.get(i);
            if (!entry[0].equals(label)) continue;
            entry[1] = value;
            return;
        }
        table.addLast(new String[]{label, value, JDXSourceStreamTokenizer.cleanLabel(label)});
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkCustomTags(Spectrum spectrum, String label, String value) throws JSVException {
        if (label.length() > 10) {
            label = label.substring(0, 10);
        }
        if (spectrum == null) {
            System.out.println(label);
        } else {
            this.modelSpectrum = spectrum;
        }
        int pt = "##$MODELS ##$PEAKS  ##$SIGNALS##$MOLFILE##PEAKASSI##$UVIRASS##$MSFRAGM".indexOf(label);
        if (pt < 0) {
            return false;
        }
        this.getMpr().set(this, this.filePath, null);
        try {
            this.reader = new BufferedReader(new StringReader(value));
            switch (pt) {
                case 0: {
                    this.mpr.readModels();
                    return true;
                }
                case 10: 
                case 20: {
                    this.peakData = new Lst();
                    this.source.peakCount = this.source.peakCount + this.mpr.readPeaks(pt == 20, this.source.peakCount);
                    return true;
                }
                case 30: {
                    this.acdAssignments = new Lst();
                    this.acdMolFile = PT.rep(value, "$$ Empty String", "");
                    return true;
                }
                case 40: 
                case 50: 
                case 60: {
                    this.acdAssignments = this.mpr.readACDAssignments(spectrum.fileNPoints, pt == 40);
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new JSVException(e.getMessage());
        }
        finally {
            this.reader = null;
        }
    }

    private JmolJDXMOLParser getMpr() {
        return this.mpr == null ? (this.mpr = (JmolJDXMOLParser)JSViewer.getInterface("org.jmol.jsv.JDXMOLParser")) : this.mpr;
    }

    @Override
    public String rd() throws Exception {
        return this.reader.readLine();
    }

    @Override
    public void setSpectrumPeaks(int nH, String peakXLabel, String peakYlabel) {
        this.modelSpectrum.setPeakList(this.peakData, peakXLabel, peakYlabel);
        if (this.modelSpectrum.isNMR()) {
            this.modelSpectrum.setHydrogenCount(nH);
        }
    }

    @Override
    public void addPeakData(String info) {
        if (this.peakData == null) {
            this.peakData = new Lst();
        }
        this.peakData.addLast(new PeakInfo(info));
    }

    @Override
    public void processModelData(String id, String data, String type, String base, String last, float modelScale, float vibScale, boolean isFirst) throws Exception {
    }

    @Override
    public String discardLinesUntilContains(String containsMatch) throws Exception {
        String line;
        while ((line = this.rd()) != null && line.indexOf(containsMatch) < 0) {
        }
        return line;
    }

    @Override
    public String discardLinesUntilContains2(String s1, String s2) throws Exception {
        String line;
        while ((line = this.rd()) != null && line.indexOf(s1) < 0 && line.indexOf(s2) < 0) {
        }
        return line;
    }

    @Override
    public String discardLinesUntilNonBlank() throws Exception {
        String line;
        while ((line = this.rd()) != null && line.trim().length() == 0) {
        }
        return line;
    }
}

