/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.contracts.ExperimentalContracts;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.Attributes;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.InconsistentKotlinMetadataException;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmAnnotation;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmClassifier;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmConstantValue;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmConstructor;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmContract;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmEffect;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmEffectExpression;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmEffectInvocationKind;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmEffectType;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmFlexibleTypeUpperBound;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmFunction;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmProperty;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmType;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmTypeAlias;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmTypeParameter;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmTypeProjection;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmValueParameter;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmVariance;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmVersion;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmVersionRequirement;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmVersionRequirementLevel;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.KmVersionRequirementVersionKind;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.WriteContext;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.WriteUtilsKt;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.extensions.MetadataExtensions;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.ProtoBuf;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.deserialization.VersionRequirement;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.metadata.serialization.MutableVersionRequirementTable;
import org.jetbrains.kotlin.jvm.abi.kotlinx.metadata.internal.protobuf.GeneratedMessageLite;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0096\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0003\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0003\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0003\u001a\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0012\u0010\u0015\u001a\u00020\u0016*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u00022\u0006\u0010\u001f\u001a\u00020 H\u0002\u001a\u0014\u0010!\u001a\u00020\"*\u00020\u00022\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0014\u0010%\u001a\u00020&*\u00020\u00022\u0006\u0010'\u001a\u00020(H\u0002\u001a\u0014\u0010)\u001a\u00020**\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0002\u001a\u0014\u0010-\u001a\u00020.*\u00020\u00022\u0006\u0010/\u001a\u000200H\u0002\u00a8\u00061"}, d2={"writeConstructor", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Constructor$Builder;", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/WriteContext;", "kmConstructor", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmConstructor;", "writeContract", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Contract;", "contract", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmContract;", "writeEffect", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Effect;", "effect", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmEffect;", "writeEffectExpression", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Expression;", "effectExpression", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmEffectExpression;", "writeFunction", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Function$Builder;", "kmFunction", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmFunction;", "writeProperty", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Property$Builder;", "kmProperty", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmProperty;", "writeType", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Type$Builder;", "kmType", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmType;", "writeTypeAlias", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$TypeAlias$Builder;", "typeAlias", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmTypeAlias;", "writeTypeParameter", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$TypeParameter$Builder;", "kmTypeParameter", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmTypeParameter;", "writeTypeProjection", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$Type$Argument$Builder;", "argument", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmTypeProjection;", "writeValueParameter", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/internal/metadata/ProtoBuf$ValueParameter$Builder;", "kmValueParameter", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmValueParameter;", "writeVersionRequirement", "", "kmVersionRequirement", "Lorg/jetbrains/kotlin/jvm/abi/kotlinx/metadata/KmVersionRequirement;", "kotlinx-metadata"})
@SourceDebugExtension(value={"SMAP\nWriters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Writers.kt\nkotlinx/metadata/internal/WritersKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n1855#2,2:387\n1855#2,2:389\n1855#2,2:391\n1855#2,2:394\n1855#2,2:396\n1855#2,2:398\n1855#2,2:400\n1549#2:402\n1620#2,3:403\n1549#2:406\n1620#2,3:407\n1549#2:410\n1620#2,3:411\n1549#2:414\n1620#2,3:415\n1855#2,2:418\n1855#2,2:420\n1549#2:422\n1620#2,3:423\n1549#2:426\n1620#2,3:427\n1855#2,2:430\n1855#2,2:432\n1549#2:434\n1620#2,3:435\n1549#2:438\n1620#2,3:439\n1549#2:442\n1620#2,3:443\n1855#2,2:446\n1549#2:448\n1620#2,3:449\n1549#2:452\n1620#2,3:453\n1549#2:456\n1620#2,3:457\n1549#2:460\n1620#2,3:461\n1#3:393\n*S KotlinDebug\n*F\n+ 1 Writers.kt\nkotlinx/metadata/internal/WritersKt\n*L\n37#1:387,2\n40#1:389,2\n83#1:391,2\n95#1:394,2\n110#1:396,2\n113#1:398,2\n114#1:400,2\n125#1:402\n125#1:403,3\n129#1:406\n129#1:407,3\n130#1:410\n130#1:411,3\n132#1:414\n132#1:415,3\n137#1:418,2\n150#1:420,2\n156#1:422\n156#1:423,3\n159#1:426\n159#1:427,3\n161#1:430,2\n179#1:432,2\n191#1:434\n191#1:435,3\n194#1:438\n194#1:439,3\n195#1:442\n195#1:443,3\n196#1:446,2\n248#1:448\n248#1:449,3\n258#1:452\n258#1:453,3\n293#1:456\n293#1:457,3\n294#1:460\n294#1:461,3\n*E\n"})
public final class WritersKt {
    private static final ProtoBuf.TypeParameter.Builder writeTypeParameter(WriteContext $this$writeTypeParameter, KmTypeParameter kmTypeParameter) {
        ProtoBuf.TypeParameter.Builder t = ProtoBuf.TypeParameter.newBuilder();
        Iterable $this$forEach$iv = kmTypeParameter.getUpperBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KmType ub = (KmType)element$iv;
            boolean bl = false;
            t.addUpperBound(WritersKt.writeType($this$writeTypeParameter, ub).build());
        }
        $this$forEach$iv = $this$writeTypeParameter.getExtensions$kotlinx_metadata();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataExtensions it = (MetadataExtensions)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)t);
            it.writeTypeParameterExtensions(kmTypeParameter, t, $this$writeTypeParameter);
        }
        t.setName($this$writeTypeParameter.get(kmTypeParameter.getName()));
        t.setId(kmTypeParameter.getId());
        boolean reified = Attributes.isReified(kmTypeParameter);
        if (reified != ProtoBuf.TypeParameter.getDefaultInstance().getReified()) {
            t.setReified(reified);
        }
        if (kmTypeParameter.getVariance() == KmVariance.IN) {
            t.setVariance(ProtoBuf.TypeParameter.Variance.IN);
        } else if (kmTypeParameter.getVariance() == KmVariance.OUT) {
            t.setVariance(ProtoBuf.TypeParameter.Variance.OUT);
        }
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    private static final ProtoBuf.Type.Argument.Builder writeTypeProjection(WriteContext $this$writeTypeProjection, KmTypeProjection argument) {
        ProtoBuf.Type.Argument.Builder t = ProtoBuf.Type.Argument.newBuilder();
        if (Intrinsics.areEqual((Object)argument, (Object)KmTypeProjection.STAR)) {
            t.setProjection(ProtoBuf.Type.Argument.Projection.STAR);
        } else {
            KmVariance variance = argument.component1();
            KmType argType = argument.component2();
            if (variance == null || argType == null) {
                throw new InconsistentKotlinMetadataException("Variance and type must be set for non-star type projection", null, 2, null);
            }
            if (variance == KmVariance.IN) {
                t.setProjection(ProtoBuf.Type.Argument.Projection.IN);
            } else if (variance == KmVariance.OUT) {
                t.setProjection(ProtoBuf.Type.Argument.Projection.OUT);
            }
            t.setType(WritersKt.writeType($this$writeTypeProjection, argType).build());
        }
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    private static final ProtoBuf.Type.Builder writeType(WriteContext $this$writeType, KmType kmType) {
        int flagsToWrite;
        KmType it;
        ProtoBuf.Type.Builder t = ProtoBuf.Type.newBuilder();
        KmClassifier cls = kmType.getClassifier();
        if (cls instanceof KmClassifier.Class) {
            t.setClassName($this$writeType.getClassName$kotlinx_metadata(((KmClassifier.Class)cls).getName()));
        } else if (cls instanceof KmClassifier.TypeAlias) {
            t.setTypeAliasName($this$writeType.getClassName$kotlinx_metadata(((KmClassifier.TypeAlias)cls).getName()));
        } else if (cls instanceof KmClassifier.TypeParameter) {
            t.setTypeParameter(((KmClassifier.TypeParameter)cls).getId());
        }
        Iterable $this$forEach$iv = kmType.getArguments();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KmTypeProjection argument = (KmTypeProjection)element$iv;
            boolean bl = false;
            t.addArgument(WritersKt.writeTypeProjection($this$writeType, argument));
        }
        KmType kmType2 = kmType.getAbbreviatedType();
        if (kmType2 != null) {
            it = kmType2;
            boolean bl = false;
            t.setAbbreviatedType(WritersKt.writeType($this$writeType, it).build());
        }
        KmType kmType3 = kmType.getOuterType();
        if (kmType3 != null) {
            it = kmType3;
            boolean bl = false;
            t.setOuterType(WritersKt.writeType($this$writeType, it).build());
        }
        KmFlexibleTypeUpperBound kmFlexibleTypeUpperBound = kmType.getFlexibleTypeUpperBound();
        if (kmFlexibleTypeUpperBound != null) {
            KmFlexibleTypeUpperBound fub = kmFlexibleTypeUpperBound;
            boolean bl = false;
            ProtoBuf.Type.Builder fubType = WritersKt.writeType($this$writeType, fub.getType());
            String string = fub.getTypeFlexibilityId();
            if (string != null) {
                String it2 = string;
                boolean bl2 = false;
                t.setFlexibleTypeCapabilitiesId($this$writeType.get(it2));
            }
            t.setFlexibleUpperBound(fubType.build());
        }
        $this$forEach$iv = $this$writeType.getExtensions$kotlinx_metadata();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataExtensions it3 = (MetadataExtensions)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)t);
            it3.writeTypeExtensions(kmType, t, $this$writeType);
        }
        if (Attributes.isNullable(kmType)) {
            t.setNullable(true);
        }
        if ((flagsToWrite = kmType.getFlags() >> 1) != ProtoBuf.Type.getDefaultInstance().getFlags()) {
            t.setFlags(flagsToWrite);
        }
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    private static final ProtoBuf.Constructor.Builder writeConstructor(WriteContext $this$writeConstructor, KmConstructor kmConstructor) {
        Object it;
        ProtoBuf.Constructor.Builder t = ProtoBuf.Constructor.newBuilder();
        Iterable $this$forEach$iv = kmConstructor.getValueParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KmValueParameter)element$iv;
            boolean bl = false;
            t.addValueParameter(WritersKt.writeValueParameter($this$writeConstructor, (KmValueParameter)it).build());
        }
        $this$forEach$iv = kmConstructor.getVersionRequirements();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (KmVersionRequirement)element$iv;
            boolean bl = false;
            t.addVersionRequirement(WritersKt.writeVersionRequirement($this$writeConstructor, (KmVersionRequirement)it));
        }
        $this$forEach$iv = $this$writeConstructor.getExtensions$kotlinx_metadata();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (MetadataExtensions)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)t);
            it.writeConstructorExtensions(kmConstructor, t, $this$writeConstructor);
        }
        if (kmConstructor.getFlags() != ProtoBuf.Constructor.getDefaultInstance().getFlags()) {
            t.setFlags(kmConstructor.getFlags());
        }
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProtoBuf.Function.Builder writeFunction(WriteContext $this$writeFunction, KmFunction kmFunction) {
        Object it;
        Object it2;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ProtoBuf.Function.Builder t = ProtoBuf.Function.newBuilder();
        Iterable iterable = kmFunction.getTypeParameters();
        ProtoBuf.Function.Builder builder = t;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KmTypeParameter kmTypeParameter = (KmTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeTypeParameter($this$writeFunction, (KmTypeParameter)it2).build());
        }
        builder.addAllTypeParameter((List)destination$iv$iv);
        KmType kmType = kmFunction.getReceiverParameterType();
        if (kmType != null) {
            it = kmType;
            boolean bl = false;
            t.setReceiverType(WritersKt.writeType($this$writeFunction, (KmType)it).build());
        }
        $this$map$iv = kmFunction.getContextReceiverTypes();
        builder = t;
        $i$f$map = false;
        it = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (KmType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeType($this$writeFunction, (KmType)it2).build());
        }
        builder.addAllContextReceiverType((List)destination$iv$iv);
        $this$map$iv = kmFunction.getValueParameters();
        builder = t;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (KmValueParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeValueParameter($this$writeFunction, (KmValueParameter)it2).build());
        }
        builder.addAllValueParameter((List)destination$iv$iv);
        t.setReturnType(WritersKt.writeType($this$writeFunction, kmFunction.getReturnType()).build());
        $this$map$iv = kmFunction.getVersionRequirements();
        builder = t;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it2 = (KmVersionRequirement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeVersionRequirement($this$writeFunction, (KmVersionRequirement)p0));
        }
        builder.addAllVersionRequirement((List)destination$iv$iv);
        KmContract kmContract = kmFunction.getContract();
        if (kmContract != null) {
            it = kmContract;
            boolean bl = false;
            t.setContract(WritersKt.writeContract($this$writeFunction, (KmContract)it));
        }
        Iterable $this$forEach$iv = $this$writeFunction.getExtensions$kotlinx_metadata();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataExtensions it3 = (MetadataExtensions)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)t);
            it3.writeFunctionExtensions(kmFunction, t, $this$writeFunction);
        }
        t.setName($this$writeFunction.get(kmFunction.getName()));
        if (kmFunction.getFlags() != ProtoBuf.Function.getDefaultInstance().getFlags()) {
            t.setFlags(kmFunction.getFlags());
        }
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ProtoBuf.Property.Builder writeProperty(@NotNull WriteContext $this$writeProperty, @NotNull KmProperty kmProperty) {
        KmVersionRequirement it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object it2;
        Intrinsics.checkNotNullParameter((Object)$this$writeProperty, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)kmProperty, (String)"kmProperty");
        ProtoBuf.Property.Builder t = ProtoBuf.Property.newBuilder();
        Iterable $this$forEach$iv = kmProperty.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KmTypeParameter tp = (KmTypeParameter)element$iv;
            boolean bl = false;
            t.addTypeParameter(WritersKt.writeTypeParameter($this$writeProperty, tp).build());
        }
        KmType kmType = kmProperty.getReceiverParameterType();
        if (kmType != null) {
            it2 = kmType;
            boolean bl = false;
            t.setReceiverType(WritersKt.writeType($this$writeProperty, (KmType)it2).build());
        }
        $this$forEach$iv = kmProperty.getContextReceiverTypes();
        ProtoBuf.Property.Builder builder = t;
        boolean $i$f$map = false;
        it2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KmType kmType2 = (KmType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeType($this$writeProperty, (KmType)((Object)it)).build());
        }
        builder.addAllContextReceiverType((List)destination$iv$iv);
        KmValueParameter kmValueParameter = kmProperty.getSetterParameter();
        if (kmValueParameter != null) {
            it2 = kmValueParameter;
            boolean bl = false;
            t.setSetterValueParameter(WritersKt.writeValueParameter($this$writeProperty, (KmValueParameter)it2).build());
        }
        t.setReturnType(WritersKt.writeType($this$writeProperty, kmProperty.getReturnType()).build());
        $this$map$iv = kmProperty.getVersionRequirements();
        builder = t;
        $i$f$map = false;
        it2 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KmVersionRequirement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeVersionRequirement($this$writeProperty, it));
        }
        builder.addAllVersionRequirement((List)destination$iv$iv);
        $this$forEach$iv = $this$writeProperty.getExtensions$kotlinx_metadata();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataExtensions it3 = (MetadataExtensions)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)t);
            it3.writePropertyExtensions(kmProperty, t, $this$writeProperty);
        }
        t.setName($this$writeProperty.get(kmProperty.getName()));
        if (kmProperty.getFlags() != ProtoBuf.Property.getDefaultInstance().getFlags()) {
            t.setFlags(kmProperty.getFlags());
        }
        if (Attributes.getHasGetter(kmProperty)) {
            t.setGetterFlags(kmProperty.getGetterFlags());
        }
        if (Attributes.getHasSetter(kmProperty)) {
            t.setSetterFlags(kmProperty.getSetterFlags());
        }
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    private static final ProtoBuf.ValueParameter.Builder writeValueParameter(WriteContext $this$writeValueParameter, KmValueParameter kmValueParameter) {
        ProtoBuf.ValueParameter.Builder t = ProtoBuf.ValueParameter.newBuilder();
        t.setType(WritersKt.writeType($this$writeValueParameter, kmValueParameter.getType()).build());
        KmType kmType = kmValueParameter.getVarargElementType();
        if (kmType != null) {
            KmType it = kmType;
            boolean bl = false;
            t.setVarargElementType(WritersKt.writeType($this$writeValueParameter, it).build());
        }
        Iterable $this$forEach$iv = $this$writeValueParameter.getExtensions$kotlinx_metadata();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataExtensions it = (MetadataExtensions)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)t);
            it.writeValueParameterExtensions(kmValueParameter, t, $this$writeValueParameter);
        }
        if (kmValueParameter.getFlags() != ProtoBuf.ValueParameter.getDefaultInstance().getFlags()) {
            t.setFlags(kmValueParameter.getFlags());
        }
        t.setName($this$writeValueParameter.get(kmValueParameter.getName()));
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private static final ProtoBuf.TypeAlias.Builder writeTypeAlias(WriteContext $this$writeTypeAlias, KmTypeAlias typeAlias) {
        Object it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        ProtoBuf.TypeAlias.Builder t = ProtoBuf.TypeAlias.newBuilder();
        Iterable iterable = typeAlias.getTypeParameters();
        ProtoBuf.TypeAlias.Builder builder = t;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KmTypeParameter kmTypeParameter = (KmTypeParameter)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeTypeParameter($this$writeTypeAlias, (KmTypeParameter)it).build());
        }
        builder.addAllTypeParameter((List)destination$iv$iv);
        t.setUnderlyingType(WritersKt.writeType($this$writeTypeAlias, typeAlias.getUnderlyingType()).build());
        t.setExpandedType(WritersKt.writeType($this$writeTypeAlias, typeAlias.getExpandedType()).build());
        $this$map$iv = typeAlias.getAnnotations();
        builder = t;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (KmAnnotation)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WriteUtilsKt.writeAnnotation((KmAnnotation)it, $this$writeTypeAlias.getStrings()).build());
        }
        builder.addAllAnnotation((List)destination$iv$iv);
        $this$map$iv = typeAlias.getVersionRequirements();
        builder = t;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (KmVersionRequirement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeVersionRequirement($this$writeTypeAlias, (KmVersionRequirement)p0));
        }
        builder.addAllVersionRequirement((List)destination$iv$iv);
        Iterable $this$forEach$iv = $this$writeTypeAlias.getExtensions$kotlinx_metadata();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MetadataExtensions it2 = (MetadataExtensions)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)t);
            it2.writeTypeAliasExtensions(typeAlias, t, $this$writeTypeAlias);
        }
        if (typeAlias.getFlags() != ProtoBuf.TypeAlias.getDefaultInstance().getFlags()) {
            t.setFlags(typeAlias.getFlags());
        }
        t.setName($this$writeTypeAlias.get(typeAlias.getName()));
        Intrinsics.checkNotNull((Object)t);
        return t;
    }

    private static final int writeVersionRequirement(WriteContext $this$writeVersionRequirement, KmVersionRequirement kmVersionRequirement) {
        ProtoBuf.VersionRequirement.Level level;
        ProtoBuf.VersionRequirement.VersionKind versionKind;
        KmVersionRequirementVersionKind kind2 = kmVersionRequirement.getKind();
        KmVersionRequirementLevel level2 = kmVersionRequirement.getLevel();
        Integer errorCode = kmVersionRequirement.getErrorCode();
        String message = kmVersionRequirement.getMessage();
        Object object = ProtoBuf.VersionRequirement.newBuilder();
        ProtoBuf.VersionRequirement.Builder $this$writeVersionRequirement_u24lambda_u2429 = object;
        boolean bl = false;
        switch (WhenMappings.$EnumSwitchMapping$0[kind2.ordinal()]) {
            case 1: {
                versionKind = ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION;
                break;
            }
            case 2: {
                versionKind = ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION;
                break;
            }
            case 3: {
                versionKind = ProtoBuf.VersionRequirement.VersionKind.API_VERSION;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ProtoBuf.VersionRequirement.VersionKind versionKind2 = versionKind;
        if (versionKind2 != $this$writeVersionRequirement_u24lambda_u2429.getDefaultInstanceForType().getVersionKind()) {
            $this$writeVersionRequirement_u24lambda_u2429.setVersionKind(versionKind2);
        }
        switch (WhenMappings.$EnumSwitchMapping$1[level2.ordinal()]) {
            case 1: {
                level = ProtoBuf.VersionRequirement.Level.WARNING;
                break;
            }
            case 2: {
                level = ProtoBuf.VersionRequirement.Level.ERROR;
                break;
            }
            case 3: {
                level = ProtoBuf.VersionRequirement.Level.HIDDEN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        ProtoBuf.VersionRequirement.Level requirementLevel = level;
        if (requirementLevel != $this$writeVersionRequirement_u24lambda_u2429.getDefaultInstanceForType().getLevel()) {
            $this$writeVersionRequirement_u24lambda_u2429.setLevel(requirementLevel);
        }
        if (errorCode != null) {
            $this$writeVersionRequirement_u24lambda_u2429.setErrorCode(errorCode);
        }
        if (message != null) {
            $this$writeVersionRequirement_u24lambda_u2429.setMessage($this$writeVersionRequirement.get(message));
        }
        ProtoBuf.VersionRequirement.Builder t = object;
        object = kmVersionRequirement.getVersion();
        int major = ((KmVersion)object).component1();
        int minor = ((KmVersion)object).component2();
        int patch = ((KmVersion)object).component3();
        new VersionRequirement.Version(major, minor, patch).encode((Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(t){
            final /* synthetic */ ProtoBuf.VersionRequirement.Builder $t;
            {
                this.$t = $t;
                super(1);
            }

            public final void invoke(int it) {
                ProtoBuf.VersionRequirement.Builder builder = this.$t;
                Intrinsics.checkNotNull((Object)builder);
                builder.setVersion(it);
            }
        }), (Function1<? super Integer, Unit>)((Function1)new Function1<Integer, Unit>(t){
            final /* synthetic */ ProtoBuf.VersionRequirement.Builder $t;
            {
                this.$t = $t;
                super(1);
            }

            public final void invoke(int it) {
                ProtoBuf.VersionRequirement.Builder builder = this.$t;
                Intrinsics.checkNotNull((Object)builder);
                builder.setVersionFull(it);
            }
        }));
        MutableVersionRequirementTable mutableVersionRequirementTable = $this$writeVersionRequirement.getVersionRequirements$kotlinx_metadata();
        Intrinsics.checkNotNull((Object)t);
        return mutableVersionRequirementTable.get((GeneratedMessageLite.Builder)t);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalContracts
    private static final ProtoBuf.Contract writeContract(WriteContext $this$writeContract, KmContract contract) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ProtoBuf.Contract.Builder t = ProtoBuf.Contract.newBuilder();
        Iterable iterable = contract.getEffects();
        ProtoBuf.Contract.Builder builder = t;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KmEffect kmEffect = (KmEffect)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeEffect($this$writeContract, (KmEffect)p0));
        }
        builder.addAllEffect((List)destination$iv$iv);
        ProtoBuf.Contract contract2 = t.build();
        Intrinsics.checkNotNullExpressionValue((Object)contract2, (String)"build(...)");
        return contract2;
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalContracts
    private static final ProtoBuf.Effect writeEffect(WriteContext $this$writeEffect, KmEffect effect) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ProtoBuf.Effect.Builder t = ProtoBuf.Effect.newBuilder();
        Iterable iterable = effect.getConstructorArguments();
        ProtoBuf.Effect.Builder builder = t;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            KmEffectExpression kmEffectExpression = (KmEffectExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeEffectExpression($this$writeEffect, (KmEffectExpression)p0));
        }
        builder.addAllEffectConstructorArgument((List)destination$iv$iv);
        KmEffectExpression kmEffectExpression = effect.getConclusion();
        if (kmEffectExpression != null) {
            KmEffectExpression it = kmEffectExpression;
            boolean bl = false;
            t.setConclusionOfConditionalEffect(WritersKt.writeEffectExpression($this$writeEffect, it));
        }
        switch (WhenMappings.$EnumSwitchMapping$2[effect.getType().ordinal()]) {
            case 1: {
                t.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                break;
            }
            case 2: {
                t.setEffectType(ProtoBuf.Effect.EffectType.CALLS);
                break;
            }
            case 3: {
                t.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL);
            }
        }
        KmEffectInvocationKind kmEffectInvocationKind = effect.getInvocationKind();
        switch (kmEffectInvocationKind == null ? -1 : WhenMappings.$EnumSwitchMapping$3[kmEffectInvocationKind.ordinal()]) {
            case 1: {
                t.setKind(ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE);
                break;
            }
            case 2: {
                t.setKind(ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE);
                break;
            }
            case 3: {
                t.setKind(ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE);
            }
        }
        ProtoBuf.Effect effect2 = t.build();
        Intrinsics.checkNotNullExpressionValue((Object)effect2, (String)"build(...)");
        return effect2;
    }

    @ExperimentalContracts
    private static final ProtoBuf.Expression writeEffectExpression(WriteContext $this$writeEffectExpression, KmEffectExpression effectExpression) {
        KmEffectExpression p0;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Object value;
        ProtoBuf.Expression.Builder t = ProtoBuf.Expression.newBuilder();
        if (effectExpression.getFlags() != ProtoBuf.Expression.getDefaultInstance().getFlags()) {
            t.setFlags(effectExpression.getFlags());
        }
        Integer n = effectExpression.getParameterIndex();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            t.setValueParameterReference(it);
        }
        KmConstantValue cv = effectExpression.getConstantValue();
        if (cv != null) {
            value = cv.getValue();
            if (Intrinsics.areEqual((Object)value, (Object)true)) {
                t.setConstantValue(ProtoBuf.Expression.ConstantValue.TRUE);
            } else if (Intrinsics.areEqual((Object)value, (Object)false)) {
                t.setConstantValue(ProtoBuf.Expression.ConstantValue.FALSE);
            } else if (value == null) {
                t.setConstantValue(ProtoBuf.Expression.ConstantValue.NULL);
            } else {
                throw new IllegalArgumentException("Only true, false or null constant values are allowed for effects (was=" + value + ')');
            }
        }
        KmType kmType = effectExpression.isInstanceType();
        if (kmType != null) {
            KmType it = kmType;
            boolean bl = false;
            t.setIsInstanceType(WritersKt.writeType($this$writeEffectExpression, it).build());
        }
        value = effectExpression.getAndArguments();
        ProtoBuf.Expression.Builder builder = t;
        boolean $i$f$map = false;
        void it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            KmEffectExpression kmEffectExpression = (KmEffectExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeEffectExpression($this$writeEffectExpression, p0));
        }
        builder.addAllAndArgument((List)destination$iv$iv);
        $this$map$iv = effectExpression.getOrArguments();
        builder = t;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            p0 = (KmEffectExpression)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(WritersKt.writeEffectExpression($this$writeEffectExpression, p0));
        }
        builder.addAllOrArgument((List)destination$iv$iv);
        ProtoBuf.Expression expression = t.build();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"build(...)");
        return expression;
    }

    public static final /* synthetic */ ProtoBuf.TypeParameter.Builder access$writeTypeParameter(WriteContext $receiver, KmTypeParameter kmTypeParameter) {
        return WritersKt.writeTypeParameter($receiver, kmTypeParameter);
    }

    public static final /* synthetic */ ProtoBuf.Type.Builder access$writeType(WriteContext $receiver, KmType kmType) {
        return WritersKt.writeType($receiver, kmType);
    }

    public static final /* synthetic */ ProtoBuf.Constructor.Builder access$writeConstructor(WriteContext $receiver, KmConstructor kmConstructor) {
        return WritersKt.writeConstructor($receiver, kmConstructor);
    }

    public static final /* synthetic */ ProtoBuf.Function.Builder access$writeFunction(WriteContext $receiver, KmFunction kmFunction) {
        return WritersKt.writeFunction($receiver, kmFunction);
    }

    public static final /* synthetic */ ProtoBuf.TypeAlias.Builder access$writeTypeAlias(WriteContext $receiver, KmTypeAlias typeAlias) {
        return WritersKt.writeTypeAlias($receiver, typeAlias);
    }

    public static final /* synthetic */ int access$writeVersionRequirement(WriteContext $receiver, KmVersionRequirement kmVersionRequirement) {
        return WritersKt.writeVersionRequirement($receiver, kmVersionRequirement);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;
        public static final /* synthetic */ int[] $EnumSwitchMapping$3;

        static {
            int[] nArray = new int[KmVersionRequirementVersionKind.values().length];
            try {
                nArray[KmVersionRequirementVersionKind.LANGUAGE_VERSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmVersionRequirementVersionKind.COMPILER_VERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmVersionRequirementVersionKind.API_VERSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KmVersionRequirementLevel.values().length];
            try {
                nArray[KmVersionRequirementLevel.WARNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmVersionRequirementLevel.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmVersionRequirementLevel.HIDDEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[KmEffectType.values().length];
            try {
                nArray[KmEffectType.RETURNS_CONSTANT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmEffectType.CALLS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmEffectType.RETURNS_NOT_NULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
            nArray = new int[KmEffectInvocationKind.values().length];
            try {
                nArray[KmEffectInvocationKind.AT_MOST_ONCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmEffectInvocationKind.EXACTLY_ONCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KmEffectInvocationKind.AT_LEAST_ONCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$3 = nArray;
        }
    }
}

