/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.native.FirNativeErrors;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeHelpersKt;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.NativeForwardDeclarationKind;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeForwardDeclarationTypeOperatorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirTypeOperatorCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.native"})
@SourceDebugExtension(value={"SMAP\nFirNativeForwardDeclarationTypeOperatorChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirNativeForwardDeclarationTypeOperatorChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeForwardDeclarationTypeOperatorChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n48#2:60\n48#2:64\n1747#3,3:61\n*S KotlinDebug\n*F\n+ 1 FirNativeForwardDeclarationTypeOperatorChecker.kt\norg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeForwardDeclarationTypeOperatorChecker\n*L\n27#1:60\n45#1:64\n38#1:61,3\n*E\n"})
public final class FirNativeForwardDeclarationTypeOperatorChecker
extends FirExpressionChecker<FirTypeOperatorCall> {
    @NotNull
    public static final FirNativeForwardDeclarationTypeOperatorChecker INSTANCE = new FirNativeForwardDeclarationTypeOperatorChecker();

    private FirNativeForwardDeclarationTypeOperatorChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull FirTypeOperatorCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        FirTypeRef targetTypeRef = expression2.getConversionTypeRef();
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol(targetTypeRef, context2.getSession());
        if (firRegularClassSymbol == null) {
            return;
        }
        FirRegularClassSymbol declarationToCheck = firRegularClassSymbol;
        NativeForwardDeclarationKind nativeForwardDeclarationKind = FirNativeHelpersKt.forwardDeclarationKindOrNull(declarationToCheck);
        if (nativeForwardDeclarationKind == null) {
            return;
        }
        NativeForwardDeclarationKind fwdKind = nativeForwardDeclarationKind;
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperation().ordinal()]) {
            case 1: 
            case 2: {
                FirCall $this$argument$iv = expression2;
                boolean $i$f$getArgument = false;
                FirTypeRef sourceTypeRef = CollectionsKt.first($this$argument$iv.getArgumentList().getArguments()).getTypeRef();
                FirRegularClassSymbol sourceClass = FirHelpersKt.toRegularClassSymbol(sourceTypeRef, context2.getSession());
                if (sourceClass != null && sourceClass.getClassKind() == fwdKind.getClassKind() && Intrinsics.areEqual(sourceClass.getName(), declarationToCheck.getName())) {
                    boolean bl;
                    List<ConeClassLikeType> supers = SupertypeUtilsKt.lookupSuperTypes(sourceClass, true, true, context2.getSession());
                    Iterable $this$any$iv = supers;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            ConeClassLikeType it = (ConeClassLikeType)element$iv;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(ConeTypeUtilsKt.getClassId(it), fwdKind.getMatchSuperClassId())) continue;
                            return;
                        }
                        bl = false;
                    }
                    if (bl) {
                        return;
                    }
                }
                FirCall $this$argument$iv2 = expression2;
                boolean $i$f$getArgument2 = false;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirNativeErrors.INSTANCE.getUNCHECKED_CAST_TO_FORWARD_DECLARATION(), (Object)FirTypeUtilsKt.getConeType(CollectionsKt.first($this$argument$iv2.getArgumentList().getArguments()).getTypeRef()), (Object)FirTypeUtilsKt.getConeType(sourceTypeRef), (DiagnosticContext)context2, null, 32, null);
                return;
            }
            case 3: 
            case 4: {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)expression2.getSource(), FirNativeErrors.INSTANCE.getCANNOT_CHECK_FOR_FORWARD_DECLARATION(), (Object)FirTypeUtilsKt.getConeType(targetTypeRef), (DiagnosticContext)context2, null, 16, null);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FirOperation.values().length];
            try {
                nArray[FirOperation.AS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.SAFE_AS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.IS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FirOperation.NOT_IS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

