/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/DataClassResolver;", "", "()V", "createComponentName", "Lorg/jetbrains/kotlin/name/Name;", "index", "", "getComponentIndex", "componentName", "", "isComponentLike", "", "name", "isCopy", "frontend.common"})
public final class DataClassResolver {
    @NotNull
    public static final DataClassResolver INSTANCE = new DataClassResolver();

    private DataClassResolver() {
    }

    @NotNull
    public final Name createComponentName(int index2) {
        Name name2 = Name.identifier(StandardNames.DATA_CLASS_COMPONENT_PREFIX + index2);
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        return name2;
    }

    public final int getComponentIndex(@NotNull String componentName) {
        Intrinsics.checkNotNullParameter(componentName, "componentName");
        String string2 = componentName.substring(StandardNames.DATA_CLASS_COMPONENT_PREFIX.length());
        Intrinsics.checkNotNullExpressionValue(string2, "substring(...)");
        return Integer.parseInt(string2);
    }

    public final boolean isComponentLike(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        String string2 = name2.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        return this.isComponentLike(string2);
    }

    public final boolean isComponentLike(@NotNull String name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        if (!StringsKt.startsWith$default(name2, StandardNames.DATA_CLASS_COMPONENT_PREFIX, false, 2, null)) {
            return false;
        }
        try {
            this.getComponentIndex(name2);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public final boolean isCopy(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter(name2, "name");
        return Intrinsics.areEqual(name2, StandardNames.DATA_CLASS_COPY);
    }
}

